/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9IntegerConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.agreement.ECVKOAgreement;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.GOST3411Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithUKM;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.ecgost.BCECGOST3410PublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseAgreementSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECPublicKey;
import d.a;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public class KeyAgreementSpi
extends BaseAgreementSpi {
    private static final X9IntegerConverter converter = new X9IntegerConverter();
    private String kaAlgorithm;
    private ECDomainParameters parameters;
    private ECVKOAgreement agreement;
    private byte[] result;

    public KeyAgreementSpi(String string2, ECVKOAgreement eCVKOAgreement, DerivationFunction derivationFunction) {
        super(string2, derivationFunction);
        this.kaAlgorithm = string2;
        this.agreement = eCVKOAgreement;
    }

    private void initFromKey(Key object, AlgorithmParameterSpec object2) {
        if (object instanceof PrivateKey) {
            object = (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)object);
            this.parameters = ((ECKeyParameters)object).getParameters();
            object2 = object2 instanceof UserKeyingMaterialSpec ? (Object)((UserKeyingMaterialSpec)object2).getUserKeyingMaterial() : null;
            this.ukmParameters = (byte[])object2;
            this.agreement.init(new ParametersWithUKM((CipherParameters)object, (byte[])object2));
            return;
        }
        throw new InvalidKeyException(a.a(new StringBuilder().append(this.kaAlgorithm).append(" key agreement requires "), KeyAgreementSpi.getSimpleName(ECPrivateKey.class), " for initialisation"));
    }

    private static String getSimpleName(Class clazz) {
        String string2 = clazz.getName();
        return string2.substring(string2.lastIndexOf(46) + 1);
    }

    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey publicKey) {
        return publicKey instanceof BCECPublicKey ? ((BCECGOST3410PublicKey)publicKey).engineGetKeyParameters() : ECUtil.generatePublicKeyParameter(publicKey);
    }

    @Override
    public Key engineDoPhase(Key object, boolean bl) {
        if (this.parameters != null) {
            if (bl) {
                if (object instanceof PublicKey) {
                    object = KeyAgreementSpi.generatePublicKeyParameter((PublicKey)object);
                    try {
                        this.result = this.agreement.calculateAgreement((CipherParameters)object);
                        return null;
                    }
                    catch (Exception exception) {
                        throw new InvalidKeyException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, b.a("calculation failed: "))){

                            @Override
                            public Throwable getCause() {
                                return exception;
                            }
                        };
                    }
                }
                throw new InvalidKeyException(a.a(new StringBuilder().append(this.kaAlgorithm).append(" key agreement requires "), KeyAgreementSpi.getSimpleName(ECPublicKey.class), " for doPhase"));
            }
            throw new IllegalStateException(a.a(new StringBuilder(), this.kaAlgorithm, " can only be between two parties."));
        }
        throw new IllegalStateException(a.a(new StringBuilder(), this.kaAlgorithm, " not initialised."));
    }

    @Override
    public void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
        if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
            throw new InvalidAlgorithmParameterException("No algorithm parameters supported");
        }
        this.initFromKey(key, algorithmParameterSpec);
    }

    @Override
    public void engineInit(Key key, SecureRandom secureRandom) {
        this.initFromKey(key, null);
    }

    @Override
    public byte[] calcSecret() {
        return this.result;
    }

    public static class ECVKO
    extends KeyAgreementSpi {
        public ECVKO() {
            GOST3411Digest gOST3411Digest;
            ECVKOAgreement eCVKOAgreement;
            ECVKO eCVKO = eCVKOAgreement2;
            ECVKOAgreement eCVKOAgreement2 = eCVKOAgreement;
            GOST3411Digest gOST3411Digest2 = gOST3411Digest;
            gOST3411Digest = new GOST3411Digest();
            eCVKOAgreement = new ECVKOAgreement(gOST3411Digest2);
            super("ECGOST3410", eCVKOAgreement2, null);
        }
    }
}

