/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.OpenSSHPrivateKeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.BaseKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPublicKeySpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.X509EncodedKeySpec;

public class KeyFactorySpi
extends BaseKeyFactorySpi {
    public static final byte[] x448Prefix = Hex.decode("3042300506032b656f033900");
    public static final byte[] x25519Prefix = Hex.decode("302a300506032b656e032100");
    public static final byte[] Ed448Prefix = Hex.decode("3043300506032b6571033a00");
    public static final byte[] Ed25519Prefix = Hex.decode("302a300506032b6570032100");
    private static final byte x448_type = 111;
    private static final byte x25519_type = 110;
    private static final byte Ed448_type = 113;
    private static final byte Ed25519_type = 112;
    public String algorithm;
    private final boolean isXdh;
    private final int specificBase;

    public KeyFactorySpi(String string2, boolean bl, int n3) {
        this.algorithm = string2;
        this.isXdh = bl;
        this.specificBase = n3;
    }

    @Override
    public Key engineTranslateKey(Key key) {
        throw new InvalidKeyException("key type unknown");
    }

    @Override
    public KeySpec engineGetKeySpec(Key object, Class clazz) {
        Object object2;
        if (clazz.isAssignableFrom(OpenSSHPrivateKeySpec.class) && object instanceof BCEdDSAPrivateKey) {
            ASN1InputStream aSN1InputStream;
            try {
                object2 = (DEROctetString)ASN1Sequence.getInstance(object.getEncoded()).getObjectAt(2);
            }
            catch (IOException iOException) {
                IOException iOException2 = iOException;
                String string2 = iOException2.getMessage();
                throw new InvalidKeySpecException(string2, iOException2.getCause());
            }
            object = aSN1InputStream;
            aSN1InputStream = new ASN1InputStream(((ASN1OctetString)object2).getOctets());
            return new OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new Ed25519PrivateKeyParameters(ASN1OctetString.getInstance(((ASN1InputStream)object).readObject()).getOctets(), 0)));
        }
        if (clazz.isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec.class) && object instanceof BCEdDSAPublicKey) {
            try {
                return new com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new Ed25519PublicKeyParameters(object.getEncoded(), Ed25519Prefix.length)));
            }
            catch (IOException iOException) {
                IOException iOException3 = iOException;
                String string3 = iOException3.getMessage();
                throw new InvalidKeySpecException(string3, iOException3.getCause());
            }
        }
        if (clazz.isAssignableFrom(com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec.class) && object instanceof BCEdDSAPrivateKey) {
            ASN1InputStream aSN1InputStream;
            try {
                object2 = (DEROctetString)ASN1Sequence.getInstance(object.getEncoded()).getObjectAt(2);
            }
            catch (IOException iOException) {
                IOException iOException4 = iOException;
                String string4 = iOException4.getMessage();
                throw new InvalidKeySpecException(string4, iOException4.getCause());
            }
            object = aSN1InputStream;
            aSN1InputStream = new ASN1InputStream(((ASN1OctetString)object2).getOctets());
            return new com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.OpenSSHPrivateKeySpec(OpenSSHPrivateKeyUtil.encodePrivateKey(new Ed25519PrivateKeyParameters(ASN1OctetString.getInstance(((ASN1InputStream)object).readObject()).getOctets(), 0)));
        }
        if (clazz.isAssignableFrom(OpenSSHPublicKeySpec.class) && object instanceof BCEdDSAPublicKey) {
            try {
                return new OpenSSHPublicKeySpec(OpenSSHPublicKeyUtil.encodePublicKey(new Ed25519PublicKeyParameters(object.getEncoded(), Ed25519Prefix.length)));
            }
            catch (IOException iOException) {
                IOException iOException5 = iOException;
                String string5 = iOException5.getMessage();
                throw new InvalidKeySpecException(string5, iOException5.getCause());
            }
        }
        return super.engineGetKeySpec((Key)object, clazz);
    }

    @Override
    public PrivateKey engineGeneratePrivate(KeySpec keySpec) {
        if (keySpec instanceof OpenSSHPrivateKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPrivateKeyUtil.parsePrivateKeyBlob(((OpenSSHPrivateKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof Ed25519PrivateKeyParameters) {
                return new BCEdDSAPrivateKey((Ed25519PrivateKeyParameters)asymmetricKeyParameter);
            }
            throw new IllegalStateException("openssh private key not Ed25519 private key");
        }
        return super.engineGeneratePrivate(keySpec);
    }

    @Override
    public PublicKey engineGeneratePublic(KeySpec keySpec) {
        if (keySpec instanceof X509EncodedKeySpec) {
            Object object = ((X509EncodedKeySpec)keySpec).getEncoded();
            int n3 = ((KeyFactorySpi)((Object)asymmetricKeyParameter)).specificBase;
            if (n3 == 0 || n3 == object[8]) {
                if (object[9] == 5 && object[10] == 0) {
                    object = SubjectPublicKeyInfo.getInstance(object);
                    try {
                        object = new SubjectPublicKeyInfo(new AlgorithmIdentifier(object.getAlgorithm().getAlgorithm()), object.getPublicKeyData().getBytes()).getEncoded("DER");
                    }
                    catch (IOException iOException) {
                        throw new InvalidKeySpecException(b.a(iOException, b.b.a("attempt to reconstruct key failed: ")));
                    }
                }
                switch (object[8]) {
                    default: {
                        return super.engineGeneratePublic(keySpec);
                    }
                    case 113: {
                        return new BCEdDSAPublicKey(Ed448Prefix, (byte[])object);
                    }
                    case 112: {
                        return new BCEdDSAPublicKey(Ed25519Prefix, (byte[])object);
                    }
                    case 111: {
                        return new BCXDHPublicKey(x448Prefix, (byte[])object);
                    }
                    case 110: 
                }
                return new BCXDHPublicKey(x25519Prefix, (byte[])object);
            }
        } else if (keySpec instanceof com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec) {
            AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPublicKeyUtil.parsePublicKey(((com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec)keySpec).getEncoded());
            if (asymmetricKeyParameter instanceof Ed25519PublicKeyParameters) {
                return new BCEdDSAPublicKey(new byte[0], ((Ed25519PublicKeyParameters)asymmetricKeyParameter).getEncoded());
            }
            throw new IllegalStateException("openssh public key not Ed25519 public key");
        }
        return super.engineGeneratePublic(keySpec);
    }

    @Override
    public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm();
        if (this.isXdh) {
            int n3 = this.specificBase;
            if ((n3 == 0 || n3 == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                return new BCXDHPrivateKey(privateKeyInfo);
            }
            int n4 = this.specificBase;
            if ((n4 == 0 || n4 == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BCXDHPrivateKey(privateKeyInfo);
            }
        } else {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = EdECObjectIdentifiers.id_Ed448;
            if (aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                int n5 = this.specificBase;
                if ((n5 == 0 || n5 == 113) && aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2)) {
                    return new BCEdDSAPrivateKey(privateKeyInfo);
                }
                int n6 = this.specificBase;
                if ((n6 == 0 || n6 == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new BCEdDSAPrivateKey(privateKeyInfo);
                }
            }
        }
        throw new IOException(a.a("algorithm identifier ", aSN1ObjectIdentifier, " in key not recognized"));
    }

    @Override
    public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
        if (this.isXdh) {
            int n3 = this.specificBase;
            if ((n3 == 0 || n3 == 111) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X448)) {
                return new BCXDHPublicKey(subjectPublicKeyInfo);
            }
            int n4 = this.specificBase;
            if ((n4 == 0 || n4 == 110) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_X25519)) {
                return new BCXDHPublicKey(subjectPublicKeyInfo);
            }
        } else {
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = EdECObjectIdentifiers.id_Ed448;
            if (aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2) || aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                int n5 = this.specificBase;
                if ((n5 == 0 || n5 == 113) && aSN1ObjectIdentifier.equals(aSN1ObjectIdentifier2)) {
                    return new BCEdDSAPublicKey(subjectPublicKeyInfo);
                }
                int n6 = this.specificBase;
                if ((n6 == 0 || n6 == 112) && aSN1ObjectIdentifier.equals(EdECObjectIdentifiers.id_Ed25519)) {
                    return new BCEdDSAPublicKey(subjectPublicKeyInfo);
                }
            }
        }
        throw new IOException(a.a("algorithm identifier ", aSN1ObjectIdentifier, " in key not recognized"));
    }

    public static class Ed25519
    extends KeyFactorySpi {
        public Ed25519() {
            super("Ed25519", false, 112);
        }
    }

    public static class Ed448
    extends KeyFactorySpi {
        public Ed448() {
            super("Ed448", false, 113);
        }
    }

    public static class EdDSA
    extends KeyFactorySpi {
        public EdDSA() {
            super("EdDSA", false, 0);
        }
    }

    public static class X25519
    extends KeyFactorySpi {
        public X25519() {
            super("X25519", true, 110);
        }
    }

    public static class X448
    extends KeyFactorySpi {
        public X448() {
            super("X448", true, 111);
        }
    }

    public static class XDH
    extends KeyFactorySpi {
        public XDH() {
            super("XDH", true, 0);
        }
    }
}

