/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.Ed25519KeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.Ed448KeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.X448KeyPairGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed25519KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.Ed448KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.X448KeyGenerationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCEdDSAPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPrivateKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.edec.BCXDHPublicKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.EdDSAParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.XDHParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;

public class KeyPairGeneratorSpi
extends java.security.KeyPairGeneratorSpi {
    private static final int EdDSA = -1;
    private static final int XDH = -2;
    private static final int Ed448 = 0;
    private static final int Ed25519 = 1;
    private static final int X448 = 2;
    private static final int X25519 = 3;
    private int algorithm;
    private AsymmetricCipherKeyPairGenerator generator;
    private boolean initialised;
    private SecureRandom secureRandom;

    public KeyPairGeneratorSpi(int n3, AsymmetricCipherKeyPairGenerator asymmetricCipherKeyPairGenerator) {
        this.algorithm = n3;
        this.generator = asymmetricCipherKeyPairGenerator;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void algorithmCheck(int n3) {
        int n4 = this.algorithm;
        if (n4 == n3) return;
        if (n4 == 1 || n4 == 0) throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
        if (n4 == -1 && n3 != 1 && n3 != 0) {
            throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
        }
        if (n4 == 3 || n4 == 2) throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
        if (n4 != -2 || n3 == 3 || n3 == 2) return;
        throw new InvalidAlgorithmParameterException("parameterSpec for wrong curve type");
    }

    private void initializeGenerator(String string2) {
        Object object;
        if (!string2.equalsIgnoreCase("Ed448") && !string2.equals(EdECObjectIdentifiers.id_Ed448.getId())) {
            if (!string2.equalsIgnoreCase("Ed25519") && !string2.equals(EdECObjectIdentifiers.id_Ed25519.getId())) {
                if (!string2.equalsIgnoreCase("X448") && !string2.equals(EdECObjectIdentifiers.id_X448.getId())) {
                    if (string2.equalsIgnoreCase("X25519") || string2.equals(EdECObjectIdentifiers.id_X25519.getId())) {
                        X25519KeyPairGenerator x25519KeyPairGenerator;
                        Object object2 = object;
                        super.algorithmCheck(3);
                        object = x25519KeyPairGenerator;
                        x25519KeyPairGenerator = new X25519KeyPairGenerator();
                        ((KeyPairGeneratorSpi)object2).generator = object;
                        super.setupGenerator(3);
                    }
                } else {
                    X448KeyPairGenerator x448KeyPairGenerator;
                    Object object3 = object;
                    super.algorithmCheck(2);
                    object = x448KeyPairGenerator;
                    x448KeyPairGenerator = new X448KeyPairGenerator();
                    ((KeyPairGeneratorSpi)object3).generator = object;
                    super.setupGenerator(2);
                }
            } else {
                Ed25519KeyPairGenerator ed25519KeyPairGenerator;
                Object object4 = object;
                super.algorithmCheck(1);
                object = ed25519KeyPairGenerator;
                ed25519KeyPairGenerator = new Ed25519KeyPairGenerator();
                ((KeyPairGeneratorSpi)object4).generator = object;
                super.setupGenerator(1);
            }
        } else {
            Ed448KeyPairGenerator ed448KeyPairGenerator;
            KeyPairGeneratorSpi keyPairGeneratorSpi = object;
            keyPairGeneratorSpi.algorithmCheck(0);
            object = ed448KeyPairGenerator;
            ed448KeyPairGenerator = new Ed448KeyPairGenerator();
            keyPairGeneratorSpi.generator = object;
            keyPairGeneratorSpi.setupGenerator(0);
        }
    }

    private void setupGenerator(int n3) {
        this.initialised = true;
        switch (n3) {
            default: {
                break;
            }
            case 2: {
                this.generator.init(new X448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case 0: {
                this.generator.init(new Ed448KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -1: 
            case 1: {
                this.generator.init(new Ed25519KeyGenerationParameters(this.secureRandom));
                break;
            }
            case -2: 
            case 3: {
                this.generator.init(new X25519KeyGenerationParameters(this.secureRandom));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void initialize(int var1_2, SecureRandom var2_3) {
        this.secureRandom = var2_3;
        if (var1_2 == 255 || var1_2 == 256) ** GOTO lbl34
        if (var1_2 != 448) ** GOTO lbl33
        try {
            var1_2 = this.algorithm;
            if (var1_2 == -2) ** GOTO lbl23
            if (var1_2 == -1 || var1_2 == 0) ** GOTO lbl13
            if (var1_2 == 2) ** GOTO lbl23
        }
        catch (InvalidAlgorithmParameterException var0_1) {
            throw new InvalidParameterException(var0_1.getMessage());
        }
        throw new InvalidParameterException("key size not configurable");
lbl13:
        // 1 sources

        v0 = this;
        v1 = v0;
        v2 = v0;
        super.algorithmCheck(0);
        this = v3;
        v3 = new Ed448KeyPairGenerator();
        v2.generator = this;
        super.setupGenerator(0);
        ** GOTO lbl59
lbl23:
        // 2 sources

        v4 = this;
        v5 = v4;
        v6 = v4;
        v4.algorithmCheck(2);
        this = v7;
        v7 = new X448KeyPairGenerator();
        v6.generator = this;
        v5.setupGenerator(2);
        ** GOTO lbl59
lbl33:
        // 1 sources

        throw new InvalidParameterException("unknown key size");
lbl34:
        // 1 sources

        var1_2 = this.algorithm;
        if (var1_2 == -2) ** GOTO lbl50
        if (var1_2 == -1 || var1_2 == 1) ** GOTO lbl40
        if (var1_2 == 3) ** GOTO lbl50
        throw new InvalidParameterException("key size not configurable");
lbl40:
        // 1 sources

        v8 = this;
        v9 = v8;
        v10 = v8;
        v8.algorithmCheck(1);
        this = v11;
        v11 = new Ed25519KeyPairGenerator();
        v10.generator = this;
        v9.setupGenerator(1);
        ** GOTO lbl59
lbl50:
        // 2 sources

        v12 = this;
        v13 = v12;
        v14 = v12;
        v12.algorithmCheck(3);
        this = v15;
        v15 = new X25519KeyPairGenerator();
        v14.generator = this;
        v13.setupGenerator(3);
lbl59:
        // 4 sources

    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom object) {
        block7: {
            block3: {
                block6: {
                    block5: {
                        block4: {
                            block2: {
                                this.secureRandom = object;
                                if (!(algorithmParameterSpec instanceof ECGenParameterSpec)) break block2;
                                this.initializeGenerator(((ECGenParameterSpec)algorithmParameterSpec).getName());
                                break block3;
                            }
                            if (!(algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec)) break block4;
                            this.initializeGenerator(((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName());
                            break block3;
                        }
                        if (!(algorithmParameterSpec instanceof EdDSAParameterSpec)) break block5;
                        this.initializeGenerator(((EdDSAParameterSpec)algorithmParameterSpec).getCurveName());
                        break block3;
                    }
                    if (!(algorithmParameterSpec instanceof XDHParameterSpec)) break block6;
                    this.initializeGenerator(((XDHParameterSpec)algorithmParameterSpec).getCurveName());
                    break block3;
                }
                object = ECUtil.getNameFrom(algorithmParameterSpec);
                if (object == null) break block7;
                this.initializeGenerator((String)object);
            }
            return;
        }
        throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + algorithmParameterSpec);
    }

    @Override
    public KeyPair generateKeyPair() {
        if (((KeyPairGeneratorSpi)((Object)asymmetricCipherKeyPair)).generator != null) {
            BCXDHPrivateKey bCXDHPrivateKey;
            if (!((KeyPairGeneratorSpi)((Object)asymmetricCipherKeyPair)).initialised) {
                KeyPairGeneratorSpi keyPairGeneratorSpi = asymmetricCipherKeyPair;
                keyPairGeneratorSpi.setupGenerator(keyPairGeneratorSpi.algorithm);
            }
            KeyPairGeneratorSpi keyPairGeneratorSpi = asymmetricCipherKeyPair;
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = keyPairGeneratorSpi.generator.generateKeyPair();
            int n3 = keyPairGeneratorSpi.algorithm;
            if (n3 != -2 && n3 != 2 && n3 != 3) {
                BCEdDSAPrivateKey bCEdDSAPrivateKey;
                BCEdDSAPrivateKey bCEdDSAPrivateKey2 = bCEdDSAPrivateKey;
                bCEdDSAPrivateKey = new BCEdDSAPrivateKey(asymmetricCipherKeyPair.getPrivate());
                return new KeyPair(new BCEdDSAPublicKey(asymmetricCipherKeyPair.getPublic()), bCEdDSAPrivateKey2);
            }
            BCXDHPrivateKey bCXDHPrivateKey2 = bCXDHPrivateKey;
            bCXDHPrivateKey = new BCXDHPrivateKey(asymmetricCipherKeyPair.getPrivate());
            return new KeyPair(new BCXDHPublicKey(asymmetricCipherKeyPair.getPublic()), bCXDHPrivateKey2);
        }
        throw new IllegalStateException("generator not correctly initialized");
    }

    public static final class X25519
    extends KeyPairGeneratorSpi {
        public X25519() {
            X25519KeyPairGenerator x25519KeyPairGenerator;
            X25519 x25519 = x25519KeyPairGenerator2;
            X25519KeyPairGenerator x25519KeyPairGenerator2 = x25519KeyPairGenerator;
            x25519KeyPairGenerator = new X25519KeyPairGenerator();
            super(3, x25519KeyPairGenerator2);
        }
    }

    public static final class X448
    extends KeyPairGeneratorSpi {
        public X448() {
            X448KeyPairGenerator x448KeyPairGenerator;
            X448 x448 = x448KeyPairGenerator2;
            X448KeyPairGenerator x448KeyPairGenerator2 = x448KeyPairGenerator;
            x448KeyPairGenerator = new X448KeyPairGenerator();
            super(2, x448KeyPairGenerator2);
        }
    }

    public static final class XDH
    extends KeyPairGeneratorSpi {
        public XDH() {
            super(-2, null);
        }
    }

    public static final class Ed25519
    extends KeyPairGeneratorSpi {
        public Ed25519() {
            Ed25519KeyPairGenerator ed25519KeyPairGenerator;
            Ed25519 ed25519 = ed25519KeyPairGenerator2;
            Ed25519KeyPairGenerator ed25519KeyPairGenerator2 = ed25519KeyPairGenerator;
            ed25519KeyPairGenerator = new Ed25519KeyPairGenerator();
            super(1, ed25519KeyPairGenerator2);
        }
    }

    public static final class Ed448
    extends KeyPairGeneratorSpi {
        public Ed448() {
            Ed448KeyPairGenerator ed448KeyPairGenerator;
            Ed448 ed448 = ed448KeyPairGenerator2;
            Ed448KeyPairGenerator ed448KeyPairGenerator2 = ed448KeyPairGenerator;
            ed448KeyPairGenerator = new Ed448KeyPairGenerator();
            super(0, ed448KeyPairGenerator2);
        }
    }

    public static final class EdDSA
    extends KeyPairGeneratorSpi {
        public EdDSA() {
            super(-1, null);
        }
    }
}

