/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.elgamal;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.ElGamalParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ElGamalParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.DHParameterSpec;

public class AlgorithmParametersSpi
extends BaseAlgorithmParameters {
    public ElGamalParameterSpec currentSpec;

    @Override
    public byte[] engineGetEncoded() {
        try {
            return new ElGamalParameter(this.currentSpec.getP(), this.currentSpec.getG()).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding ElGamalParameters");
        }
    }

    @Override
    public byte[] engineGetEncoded(String string2) {
        if (!this.isASN1FormatString(string2) && !string2.equalsIgnoreCase("X.509")) {
            return null;
        }
        return this.engineGetEncoded();
    }

    @Override
    public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
        if (clazz != ElGamalParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
            if (clazz == DHParameterSpec.class) {
                return new DHParameterSpec(this.currentSpec.getP(), this.currentSpec.getG());
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to ElGamal parameters object.");
        }
        return this.currentSpec;
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
        boolean bl = algorithmParameterSpec instanceof ElGamalParameterSpec;
        if (!bl && !(algorithmParameterSpec instanceof DHParameterSpec)) {
            throw new InvalidParameterSpecException("DHParameterSpec required to initialise a ElGamal algorithm parameters object");
        }
        if (bl) {
            ((AlgorithmParametersSpi)object).currentSpec = (ElGamalParameterSpec)algorithmParameterSpec;
        } else {
            ElGamalParameterSpec elGamalParameterSpec;
            AlgorithmParametersSpi algorithmParametersSpi = object;
            Object object = (DHParameterSpec)algorithmParameterSpec;
            algorithmParameterSpec = elGamalParameterSpec;
            Object object2 = object;
            object = ((DHParameterSpec)object2).getP();
            elGamalParameterSpec = new ElGamalParameterSpec((BigInteger)object, ((DHParameterSpec)object2).getG());
            algorithmParametersSpi.currentSpec = algorithmParameterSpec;
        }
    }

    @Override
    public void engineInit(byte[] byArray) {
        ElGamalParameterSpec elGamalParameterSpec;
        AlgorithmParametersSpi algorithmParametersSpi = object;
        Object object = ElGamalParameter.getInstance(ASN1Primitive.fromByteArray(byArray));
        ElGamalParameterSpec elGamalParameterSpec2 = elGamalParameterSpec;
        ElGamalParameterSpec elGamalParameterSpec3 = elGamalParameterSpec;
        Object object2 = object;
        Object object3 = object2;
        object = ((ElGamalParameter)object2).getP();
        try {
            elGamalParameterSpec2((BigInteger)object, ((ElGamalParameter)object3).getG());
            algorithmParametersSpi.currentSpec = elGamalParameterSpec3;
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Not a valid ElGamal Parameter encoding.");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a valid ElGamal Parameter encoding.");
        }
    }

    @Override
    public void engineInit(byte[] byArray, String string2) {
        if (!this.isASN1FormatString(string2) && !string2.equalsIgnoreCase("X.509")) {
            throw new IOException(i.a("Unknown parameter format ", string2));
        }
        this.engineInit(byArray);
    }

    @Override
    public String engineToString() {
        return "ElGamal Parameters";
    }
}

