/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.gost;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410ParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParametersSpi
extends java.security.AlgorithmParametersSpi {
    public GOST3410ParameterSpec currentSpec;

    public boolean isASN1FormatString(String string2) {
        return string2 == null || string2.equals("ASN.1");
    }

    public AlgorithmParameterSpec engineGetParameterSpec(Class clazz) {
        if (clazz != null) {
            return this.localEngineGetParameterSpec(clazz);
        }
        throw new NullPointerException("argument to getParameterSpec must not be null");
    }

    @Override
    public byte[] engineGetEncoded() {
        ASN1ObjectIdentifier aSN1ObjectIdentifier;
        ASN1ObjectIdentifier aSN1ObjectIdentifier2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier3 = aSN1ObjectIdentifier2;
        aSN1ObjectIdentifier2 = new ASN1ObjectIdentifier(this.currentSpec.getDigestParamSetOID());
        ASN1ObjectIdentifier aSN1ObjectIdentifier4 = aSN1ObjectIdentifier;
        aSN1ObjectIdentifier = new ASN1ObjectIdentifier(this.currentSpec.getEncryptionParamSetOID());
        try {
            return new GOST3410PublicKeyAlgParameters(new ASN1ObjectIdentifier(this.currentSpec.getPublicKeyParamSetOID()), aSN1ObjectIdentifier3, aSN1ObjectIdentifier4).getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error encoding GOST3410Parameters");
        }
    }

    @Override
    public byte[] engineGetEncoded(String string2) {
        if (!this.isASN1FormatString(string2) && !string2.equalsIgnoreCase("X.509")) {
            return null;
        }
        return this.engineGetEncoded();
    }

    public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
        if (clazz != GOST3410PublicKeyParameterSetSpec.class && clazz != AlgorithmParameterSpec.class) {
            throw new InvalidParameterSpecException("unknown parameter spec passed to GOST3410 parameters object.");
        }
        return this.currentSpec;
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof GOST3410ParameterSpec) {
            this.currentSpec = (GOST3410ParameterSpec)algorithmParameterSpec;
            return;
        }
        throw new InvalidParameterSpecException("GOST3410ParameterSpec required to initialise a GOST3410 algorithm parameters object");
    }

    @Override
    public void engineInit(byte[] byArray) {
        try {
            this.currentSpec = GOST3410ParameterSpec.fromPublicKeyAlg(GOST3410PublicKeyAlgParameters.getInstance((ASN1Sequence)ASN1Primitive.fromByteArray(byArray)));
            return;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IOException("Not a valid GOST3410 Parameter encoding.");
        }
        catch (ClassCastException classCastException) {
            throw new IOException("Not a valid GOST3410 Parameter encoding.");
        }
    }

    @Override
    public void engineInit(byte[] byArray, String string2) {
        if (!this.isASN1FormatString(string2) && !string2.equalsIgnoreCase("X.509")) {
            throw new IOException(i.a("Unknown parameter format ", string2));
        }
        this.engineInit(byArray);
    }

    @Override
    public String engineToString() {
        return "GOST3410 Parameters";
    }
}

