/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DigestInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.AsymmetricBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.MD2Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.MD4Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.NullDigest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD128Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD160Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.RIPEMD256Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RSABlindedEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RSAKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.DigestFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.rsa.RSAUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import d.a;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;

public class DigestSignatureSpi
extends SignatureSpi {
    private Digest digest;
    private AsymmetricBlockCipher cipher;
    private AlgorithmIdentifier algId;

    public DigestSignatureSpi(Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        this.digest = digest;
        this.cipher = asymmetricBlockCipher;
        this.algId = null;
    }

    public DigestSignatureSpi(ASN1ObjectIdentifier aSN1ObjectIdentifier, Digest digest, AsymmetricBlockCipher asymmetricBlockCipher) {
        AlgorithmIdentifier algorithmIdentifier;
        ((DigestSignatureSpi)((Object)algorithmIdentifier2)).digest = digest;
        ((DigestSignatureSpi)((Object)algorithmIdentifier2)).cipher = asymmetricBlockCipher;
        AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
        algorithmIdentifier = new AlgorithmIdentifier(aSN1ObjectIdentifier, DERNull.INSTANCE);
        v1.algId = algorithmIdentifier2;
    }

    private String getType(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    private byte[] derEncode(byte[] byArray) {
        AlgorithmIdentifier algorithmIdentifier = ((DigestSignatureSpi)((Object)algorithmIdentifier)).algId;
        if (algorithmIdentifier == null) {
            return byArray;
        }
        return new DigestInfo(algorithmIdentifier, byArray).getEncoded("DER");
    }

    @Override
    public void engineInitVerify(PublicKey publicKey) {
        if (publicKey instanceof RSAPublicKey) {
            DigestSignatureSpi digestSignatureSpi = rSAKeyParameters;
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePublicKeyParameter((RSAPublicKey)publicKey);
            digestSignatureSpi.digest.reset();
            digestSignatureSpi.cipher.init(false, rSAKeyParameters);
            return;
        }
        throw new InvalidKeyException(a.a(b.a("Supplied key ("), ((DigestSignatureSpi)((Object)rSAKeyParameters)).getType(publicKey), ") is not a RSAPublicKey instance"));
    }

    @Override
    public void engineInitSign(PrivateKey privateKey) {
        if (privateKey instanceof RSAPrivateKey) {
            DigestSignatureSpi digestSignatureSpi = rSAKeyParameters;
            RSAKeyParameters rSAKeyParameters = RSAUtil.generatePrivateKeyParameter((RSAPrivateKey)privateKey);
            digestSignatureSpi.digest.reset();
            digestSignatureSpi.cipher.init(true, rSAKeyParameters);
            return;
        }
        throw new InvalidKeyException(a.a(b.a("Supplied key ("), ((DigestSignatureSpi)((Object)rSAKeyParameters)).getType(privateKey), ") is not a RSAPrivateKey instance"));
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public byte[] engineSign() {
        DigestSignatureSpi digestSignatureSpi = object;
        byte[] byArray = new byte[digestSignatureSpi.digest.getDigestSize()];
        ((DigestSignatureSpi)object).digest.doFinal(byArray, 0);
        Object object = digestSignatureSpi.derEncode(byArray);
        AsymmetricBlockCipher asymmetricBlockCipher = digestSignatureSpi.cipher;
        Object object2 = object;
        int n3 = 0;
        try {
            return asymmetricBlockCipher.processBlock((byte[])object2, n3, ((Object)object2).length);
        }
        catch (Exception exception) {
            throw new SignatureException(((Object)exception).toString());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new SignatureException("key too small for signature type");
        }
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        DigestSignatureSpi digestSignatureSpi = this;
        byte[] byArray2 = new byte[digestSignatureSpi.digest.getDigestSize()];
        DigestSignatureSpi digestSignatureSpi2 = this;
        digestSignatureSpi2.digest.doFinal(byArray2, 0);
        AsymmetricBlockCipher asymmetricBlockCipher = digestSignatureSpi2.cipher;
        int n3 = 0;
        byte[] byArray3 = asymmetricBlockCipher.processBlock(byArray, n3, byArray.length);
        try {
            byArray = digestSignatureSpi.derEncode(byArray2);
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray3.length == byArray.length) {
            return Arrays.constantTimeAreEqual(byArray3, byArray);
        }
        if (byArray3.length == byArray.length - 2) {
            int n4;
            byte[] byArray4 = byArray;
            byArray4[1] = (byte)(byArray[1] - 2);
            byArray4[3] = n4 = (int)(byArray[3] - 2);
            int n5 = (n4 += 4) + 2;
            int n6 = 0;
            for (int i3 = 0; i3 < byArray.length - n5; ++i3) {
                n6 |= byArray3[n4 + i3] ^ byArray[n5 + i3];
            }
            for (n5 = 0; n5 < n4; ++n5) {
                n6 |= byArray3[n5] ^ byArray[n5];
            }
            return n6 == 0;
        }
        Arrays.constantTimeAreEqual(byArray, byArray);
        return false;
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string2, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string2) {
        return null;
    }

    @Override
    public AlgorithmParameters engineGetParameters() {
        return null;
    }

    public static class noneRSA
    extends DigestSignatureSpi {
        public noneRSA() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            NullDigest nullDigest;
            noneRSA noneRSA2 = nullDigest2;
            NullDigest nullDigest2 = nullDigest;
            nullDigest = new NullDigest();
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(nullDigest2, pKCS1Encoding2);
        }
    }

    public static class RIPEMD256
    extends DigestSignatureSpi {
        public RIPEMD256() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            RIPEMD256Digest rIPEMD256Digest;
            RIPEMD256 rIPEMD256 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.ripemd256;
            RIPEMD256Digest rIPEMD256Digest2 = rIPEMD256Digest;
            rIPEMD256Digest = new RIPEMD256Digest();
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, rIPEMD256Digest2, pKCS1Encoding2);
        }
    }

    public static class RIPEMD128
    extends DigestSignatureSpi {
        public RIPEMD128() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            RIPEMD128Digest rIPEMD128Digest;
            RIPEMD128 rIPEMD128 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.ripemd128;
            RIPEMD128Digest rIPEMD128Digest2 = rIPEMD128Digest;
            rIPEMD128Digest = new RIPEMD128Digest();
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, rIPEMD128Digest2, pKCS1Encoding2);
        }
    }

    public static class RIPEMD160
    extends DigestSignatureSpi {
        public RIPEMD160() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            RIPEMD160Digest rIPEMD160Digest;
            RIPEMD160 rIPEMD160 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = TeleTrusTObjectIdentifiers.ripemd160;
            RIPEMD160Digest rIPEMD160Digest2 = rIPEMD160Digest;
            rIPEMD160Digest = new RIPEMD160Digest();
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, rIPEMD160Digest2, pKCS1Encoding2);
        }
    }

    public static class MD5
    extends DigestSignatureSpi {
        public MD5() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            MD5 mD5 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.md5;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createMD5(), pKCS1Encoding2);
        }
    }

    public static class MD4
    extends DigestSignatureSpi {
        public MD4() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            MD4Digest mD4Digest;
            MD4 mD4 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.md4;
            MD4Digest mD4Digest2 = mD4Digest;
            mD4Digest = new MD4Digest();
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, mD4Digest2, pKCS1Encoding2);
        }
    }

    public static class MD2
    extends DigestSignatureSpi {
        public MD2() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            MD2Digest mD2Digest;
            MD2 mD2 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.md2;
            MD2Digest mD2Digest2 = mD2Digest;
            mD2Digest = new MD2Digest();
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, mD2Digest2, pKCS1Encoding2);
        }
    }

    public static class SHA3_512
    extends DigestSignatureSpi {
        public SHA3_512() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA3_512 sHA3_512 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha3_512;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA3_512(), pKCS1Encoding2);
        }
    }

    public static class SHA3_384
    extends DigestSignatureSpi {
        public SHA3_384() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA3_384 sHA3_384 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha3_384;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA3_384(), pKCS1Encoding2);
        }
    }

    public static class SHA3_256
    extends DigestSignatureSpi {
        public SHA3_256() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA3_256 sHA3_256 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha3_256;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA3_256(), pKCS1Encoding2);
        }
    }

    public static class SHA3_224
    extends DigestSignatureSpi {
        public SHA3_224() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA3_224 sHA3_224 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha3_224;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA3_224(), pKCS1Encoding2);
        }
    }

    public static class SHA512_256
    extends DigestSignatureSpi {
        public SHA512_256() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA512_256 sHA512_256 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha512_256;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA512_256(), pKCS1Encoding2);
        }
    }

    public static class SHA512_224
    extends DigestSignatureSpi {
        public SHA512_224() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA512_224 sHA512_224 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha512_224;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA512_224(), pKCS1Encoding2);
        }
    }

    public static class SHA512
    extends DigestSignatureSpi {
        public SHA512() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA512 sHA512 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha512;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA512(), pKCS1Encoding2);
        }
    }

    public static class SHA384
    extends DigestSignatureSpi {
        public SHA384() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA384 sHA384 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha384;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA384(), pKCS1Encoding2);
        }
    }

    public static class SHA256
    extends DigestSignatureSpi {
        public SHA256() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA256 sHA256 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha256;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA256(), pKCS1Encoding2);
        }
    }

    public static class SHA224
    extends DigestSignatureSpi {
        public SHA224() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA224 sHA224 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = NISTObjectIdentifiers.id_sha224;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA224(), pKCS1Encoding2);
        }
    }

    public static class SHA1
    extends DigestSignatureSpi {
        public SHA1() {
            RSABlindedEngine rSABlindedEngine;
            PKCS1Encoding pKCS1Encoding;
            SHA1 sHA1 = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = OIWObjectIdentifiers.idSHA1;
            PKCS1Encoding pKCS1Encoding2 = pKCS1Encoding;
            RSABlindedEngine rSABlindedEngine2 = rSABlindedEngine;
            rSABlindedEngine = new RSABlindedEngine();
            pKCS1Encoding = new PKCS1Encoding(rSABlindedEngine2);
            super(aSN1ObjectIdentifier, DigestFactory.createSHA1(), pKCS1Encoding2);
        }
    }
}

