/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DSAExt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.signers.DSAEncoding;
import java.math.BigInteger;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;

public abstract class DSABase
extends SignatureSpi
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    public Digest digest;
    public DSAExt signer;
    public DSAEncoding encoding;

    public DSABase(Digest digest, DSAExt dSAExt, DSAEncoding dSAEncoding) {
        this.digest = digest;
        this.signer = dSAExt;
        this.encoding = dSAEncoding;
    }

    @Override
    public void engineUpdate(byte by) {
        this.digest.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.digest.update(byArray, n3, n4);
    }

    @Override
    public byte[] engineSign() {
        DSABase dSABase = bigInteger;
        Object object = new byte[dSABase.digest.getDigestSize()];
        dSABase.digest.doFinal((byte[])object, 0);
        try {
            object = dSABase.signer.generateSignature((byte[])object);
        }
        catch (Exception exception) {
            throw new SignatureException(((Object)exception).toString());
        }
        DSAEncoding dSAEncoding = dSABase.encoding;
        Object[] objectArray = object;
        Object[] objectArray2 = object;
        BigInteger bigInteger = ((DSABase)((Object)bigInteger)).signer.getOrder();
        object = objectArray[0];
        byte by = objectArray2[1];
        return dSAEncoding.encode(bigInteger, (BigInteger)object, (BigInteger)by);
    }

    @Override
    public boolean engineVerify(byte[] byArray) {
        Object object;
        BigInteger[] bigIntegerArray = object;
        byte[] byArray2 = new byte[object.digest.getDigestSize()];
        bigIntegerArray.digest.doFinal(byArray2, 0);
        try {
            object = object.encoding.decode(object.signer.getOrder(), byArray);
        }
        catch (Exception exception) {
            throw new SignatureException("error decoding signature bytes.");
        }
        object = object[0];
        return bigIntegerArray.signer.verifySignature(byArray2, (BigInteger)object, object[1]);
    }

    @Override
    public void engineSetParameter(AlgorithmParameterSpec algorithmParameterSpec) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public void engineSetParameter(String string2, Object object) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }

    @Override
    public Object engineGetParameter(String string2) {
        throw new UnsupportedOperationException("engineSetParameter unsupported");
    }
}

