/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CertificateList;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.IssuingDistributionPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.ExtCRLException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509CRLImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509CRLInternal;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509SignatureUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import f.a;
import java.security.cert.CRLException;

class X509CRLObject
extends X509CRLImpl {
    private final Object cacheLock;
    private X509CRLInternal internalCRLValue;
    private volatile boolean hashValueSet;
    private volatile int hashValue;

    public X509CRLObject(JcaJceHelper jcaJceHelper, CertificateList certificateList) {
        Object object;
        X509CRLObject x509CRLObject = object2;
        CertificateList certificateList2 = certificateList;
        Object object2 = X509CRLObject.createSigAlgName(certificateList2);
        byte[] byArray = X509CRLObject.createSigAlgParams(certificateList2);
        boolean bl = X509CRLObject.isIndirectCRL(certificateList2);
        super(jcaJceHelper, certificateList, (String)object2, byArray, bl);
        object2 = object;
        object = new Object();
        x509CRLObject.cacheLock = object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private X509CRLInternal getInternalCRL() {
        X509CRLInternal x509CRLInternal;
        X509CRLObject x509CRLObject = this;
        Object object = x509CRLObject.cacheLock;
        // MONITORENTER : object
        X509CRLInternal x509CRLInternal2 = x509CRLObject.internalCRLValue;
        if (x509CRLInternal2 != null) {
            // MONITOREXIT : object
            return x509CRLInternal2;
        }
        X509CRLObject x509CRLObject2 = this;
        // MONITOREXIT : object
        try {
            object = x509CRLObject2.getEncoded();
        }
        catch (CRLException cRLException) {
            object = null;
        }
        X509CRLObject x509CRLObject3 = this;
        x509CRLInternal2 = x509CRLInternal;
        X509CRLObject x509CRLObject4 = this;
        Object object2 = x509CRLObject4.bcHelper;
        CertificateList certificateList = x509CRLObject4.c;
        String string2 = x509CRLObject4.sigAlgName;
        byte[] byArray = x509CRLObject4.sigAlgParams;
        boolean bl = x509CRLObject4.isIndirect;
        x509CRLInternal = new X509CRLInternal((JcaJceHelper)object2, certificateList, string2, byArray, bl, (byte[])object);
        object2 = x509CRLObject3.cacheLock;
        // MONITORENTER : object2
        if (x509CRLObject3.internalCRLValue == null) {
            this.internalCRLValue = x509CRLInternal2;
        }
        // MONITOREXIT : object2
        return this.internalCRLValue;
    }

    private static String createSigAlgName(CertificateList certificateList) {
        try {
            return X509SignatureUtil.getSignatureName(certificateList.getSignatureAlgorithm());
        }
        catch (Exception exception) {
            throw new CRLException(a.a("CRL contents invalid: ", exception));
        }
    }

    private static byte[] createSigAlgParams(CertificateList aSN1Encodable) {
        block3: {
            try {
                aSN1Encodable = ((CertificateList)aSN1Encodable).getSignatureAlgorithm().getParameters();
                if (aSN1Encodable != null) break block3;
                return null;
            }
            catch (Exception exception) {
                throw new CRLException(a.a("CRL contents invalid: ", exception));
            }
        }
        return aSN1Encodable.toASN1Primitive().getEncoded("DER");
    }

    private static boolean isIndirectCRL(CertificateList object) {
        byte[] byArray;
        try {
            byArray = X509CRLImpl.getExtensionOctets((CertificateList)object, Extension.issuingDistributionPoint.getId());
        }
        catch (Exception exception) {
            throw new ExtCRLException("Exception reading IssuingDistributionPoint", exception);
        }
        object = byArray;
        if (byArray == null) {
            return false;
        }
        return IssuingDistributionPoint.getInstance(object).isIndirectCRL();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof X509CRLObject) {
            DERBitString dERBitString;
            X509CRLObject x509CRLObject = (X509CRLObject)object;
            if (this.hashValueSet && x509CRLObject.hashValueSet ? this.hashValue != x509CRLObject.hashValue : (this.internalCRLValue == null || x509CRLObject.internalCRLValue == null) && (dERBitString = this.c.getSignature()) != null && !dERBitString.equals(x509CRLObject.c.getSignature())) {
                return false;
            }
        }
        return ((Object)this.getInternalCRL()).equals(object);
    }

    @Override
    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = ((Object)this.getInternalCRL()).hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }
}

