/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1BitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERBitString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.BasicConstraints;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.PKCS12BagAttributeCarrierImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509CertificateImpl;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509CertificateInternal;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.x509.X509SignatureUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.PKCS12BagAttributeCarrier;
import f.a;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.Date;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;

class X509CertificateObject
extends X509CertificateImpl
implements PKCS12BagAttributeCarrier {
    private final Object cacheLock;
    private X509CertificateInternal internalCertificateValue;
    private X500Principal issuerValue;
    private PublicKey publicKeyValue;
    private X500Principal subjectValue;
    private long[] validityValues;
    private volatile boolean hashValueSet;
    private volatile int hashValue;
    private PKCS12BagAttributeCarrier attrCarrier;

    public X509CertificateObject(JcaJceHelper jcaJceHelper, Certificate certificate) {
        PKCS12BagAttributeCarrierImpl pKCS12BagAttributeCarrierImpl;
        Object object;
        X509CertificateObject x509CertificateObject = object2;
        Certificate certificate2 = certificate;
        Object object2 = X509CertificateObject.createBasicConstraints(certificate2);
        boolean[] blArray = X509CertificateObject.createKeyUsage(certificate2);
        String string2 = X509CertificateObject.createSigAlgName(certificate2);
        byte[] byArray = X509CertificateObject.createSigAlgParams(certificate2);
        super(jcaJceHelper, certificate, (BasicConstraints)object2, blArray, string2, byArray);
        object2 = object;
        object = new Object();
        x509CertificateObject.cacheLock = object2;
        object2 = pKCS12BagAttributeCarrierImpl;
        pKCS12BagAttributeCarrierImpl = new PKCS12BagAttributeCarrierImpl();
        x509CertificateObject.attrCarrier = object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private X509CertificateInternal getInternalCertificate() {
        X509CertificateInternal x509CertificateInternal;
        X509CertificateObject x509CertificateObject = this;
        Object object = x509CertificateObject.cacheLock;
        // MONITORENTER : object
        X509CertificateInternal x509CertificateInternal2 = x509CertificateObject.internalCertificateValue;
        if (x509CertificateInternal2 != null) {
            // MONITOREXIT : object
            return x509CertificateInternal2;
        }
        X509CertificateObject x509CertificateObject2 = this;
        // MONITOREXIT : object
        try {
            object = x509CertificateObject2.getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            object = null;
        }
        X509CertificateObject x509CertificateObject3 = this;
        x509CertificateInternal2 = x509CertificateInternal;
        X509CertificateObject x509CertificateObject4 = this;
        Object object2 = x509CertificateObject4.bcHelper;
        Certificate certificate = x509CertificateObject4.c;
        BasicConstraints basicConstraints = x509CertificateObject4.basicConstraints;
        boolean[] blArray = x509CertificateObject4.keyUsage;
        String string2 = x509CertificateObject4.sigAlgName;
        byte[] byArray = x509CertificateObject4.sigAlgParams;
        x509CertificateInternal = new X509CertificateInternal((JcaJceHelper)object2, certificate, basicConstraints, blArray, string2, byArray, (byte[])object);
        object2 = x509CertificateObject3.cacheLock;
        // MONITORENTER : object2
        if (x509CertificateObject3.internalCertificateValue == null) {
            this.internalCertificateValue = x509CertificateInternal2;
        }
        // MONITOREXIT : object2
        return this.internalCertificateValue;
    }

    private static BasicConstraints createBasicConstraints(Certificate object) {
        byte[] byArray;
        try {
            byArray = X509CertificateImpl.getExtensionOctets((Certificate)object, "2.5.29.19");
        }
        catch (Exception exception) {
            throw new CertificateParsingException(a.a("cannot construct BasicConstraints: ", exception));
        }
        object = byArray;
        if (byArray == null) {
            return null;
        }
        return BasicConstraints.getInstance(ASN1Primitive.fromByteArray((byte[])object));
    }

    private static boolean[] createKeyUsage(Certificate object) {
        boolean[] blArray;
        byte[] byArray = X509CertificateImpl.getExtensionOctets((Certificate)object, "2.5.29.15");
        object = byArray;
        if (byArray == null) {
            return null;
        }
        object = DERBitString.getInstance(ASN1Primitive.fromByteArray((byte[])object));
        byte[] byArray2 = ((ASN1BitString)object).getBytes();
        int n3 = byArray2.length;
        int n4 = n3 * 8 - ((ASN1BitString)object).getPadBits();
        int n5 = n4 < 9 ? 9 : n4;
        try {
            blArray = new boolean[n5];
        }
        catch (Exception exception) {
            throw new CertificateParsingException(a.a("cannot construct KeyUsage: ", exception));
        }
        for (int i3 = 0; i3 != n4; ++i3) {
            byte by = byArray2[i3 / 8];
            boolean bl = (by & 128 >>> i3 % 8) != 0;
            blArray[i3] = bl;
            continue;
        }
        return blArray;
    }

    private static String createSigAlgName(Certificate certificate) {
        try {
            return X509SignatureUtil.getSignatureName(certificate.getSignatureAlgorithm());
        }
        catch (Exception exception) {
            throw new CertificateParsingException(a.a("cannot construct SigAlgName: ", exception));
        }
    }

    private static byte[] createSigAlgParams(Certificate aSN1Encodable) {
        block3: {
            try {
                aSN1Encodable = ((Certificate)aSN1Encodable).getSignatureAlgorithm().getParameters();
                if (aSN1Encodable != null) break block3;
                return null;
            }
            catch (Exception exception) {
                throw new CertificateParsingException(a.a("cannot construct SigAlgParams: ", exception));
            }
        }
        return aSN1Encodable.toASN1Primitive().getEncoded("DER");
    }

    @Override
    public void checkValidity(Date object) {
        long l3 = ((Date)object).getTime();
        long[] lArray = this.getValidityValues();
        object = lArray;
        if (l3 <= lArray[1]) {
            if (l3 >= object[0]) {
                return;
            }
            throw new CertificateNotYetValidException(b.a("certificate not valid till ").append(this.c.getStartDate().getTime()).toString());
        }
        throw new CertificateExpiredException(b.a("certificate expired on ").append(this.c.getEndDate().getTime()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public X500Principal getIssuerX500Principal() {
        X509CertificateObject x509CertificateObject = this;
        Object object2 = x509CertificateObject.cacheLock;
        // MONITORENTER : object2
        Object object = x509CertificateObject.issuerValue;
        if (object != null) {
            // MONITOREXIT : object2
            return object;
        }
        X509CertificateObject x509CertificateObject2 = this;
        X509CertificateObject x509CertificateObject3 = x509CertificateObject2;
        // MONITOREXIT : object2
        object2 = super.getIssuerX500Principal();
        object = x509CertificateObject2.cacheLock;
        if (x509CertificateObject3.issuerValue == null) {
            this.issuerValue = object2;
        }
        // MONITOREXIT : object
        return this.issuerValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public PublicKey getPublicKey() {
        X509CertificateObject x509CertificateObject = this;
        Object object2 = x509CertificateObject.cacheLock;
        // MONITORENTER : object2
        Object object = x509CertificateObject.publicKeyValue;
        if (object != null) {
            // MONITOREXIT : object2
            return object;
        }
        // MONITOREXIT : object2
        object2 = super.getPublicKey();
        if (object2 == null) {
            return null;
        }
        X509CertificateObject x509CertificateObject2 = this;
        object = x509CertificateObject2.cacheLock;
        if (x509CertificateObject2.publicKeyValue == null) {
            this.publicKeyValue = object2;
        }
        // MONITOREXIT : object
        return this.publicKeyValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public X500Principal getSubjectX500Principal() {
        X509CertificateObject x509CertificateObject = this;
        Object object2 = x509CertificateObject.cacheLock;
        // MONITORENTER : object2
        Object object = x509CertificateObject.subjectValue;
        if (object != null) {
            // MONITOREXIT : object2
            return object;
        }
        X509CertificateObject x509CertificateObject2 = this;
        X509CertificateObject x509CertificateObject3 = x509CertificateObject2;
        // MONITOREXIT : object2
        object2 = super.getSubjectX500Principal();
        object = x509CertificateObject2.cacheLock;
        if (x509CertificateObject3.subjectValue == null) {
            this.subjectValue = object2;
        }
        // MONITOREXIT : object
        return this.subjectValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public long[] getValidityValues() {
        X509CertificateObject x509CertificateObject = this;
        Object object = x509CertificateObject.cacheLock;
        // MONITORENTER : object
        long[] lArray = x509CertificateObject.validityValues;
        if (x509CertificateObject.validityValues != null) {
            // MONITOREXIT : object
            return lArray;
        }
        X509CertificateObject x509CertificateObject2 = this;
        X509CertificateObject x509CertificateObject3 = x509CertificateObject2;
        X509CertificateObject x509CertificateObject4 = x509CertificateObject2;
        // MONITOREXIT : object
        long[] lArray2 = new long[2];
        object = lArray2;
        long l3 = super.getNotBefore().getTime();
        object[0] = l3;
        lArray2[1] = l3 = super.getNotAfter().getTime();
        Object object2 = x509CertificateObject3.cacheLock;
        // MONITORENTER : object2
        if (x509CertificateObject4.validityValues == null) {
            this.validityValues = (long[])object;
        }
        // MONITOREXIT : object2
        return this.validityValues;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof X509CertificateObject) {
            DERBitString dERBitString;
            X509CertificateObject x509CertificateObject = (X509CertificateObject)object;
            if (this.hashValueSet && x509CertificateObject.hashValueSet ? this.hashValue != x509CertificateObject.hashValue : (this.internalCertificateValue == null || x509CertificateObject.internalCertificateValue == null) && (dERBitString = this.c.getSignature()) != null && !dERBitString.equals(x509CertificateObject.c.getSignature())) {
                return false;
            }
        }
        return ((Object)this.getInternalCertificate()).equals(object);
    }

    @Override
    public int hashCode() {
        if (!this.hashValueSet) {
            this.hashValue = ((Object)this.getInternalCertificate()).hashCode();
            this.hashValueSet = true;
        }
        return this.hashValue;
    }

    public int originalHashCode() {
        int n3;
        byte[] byArray;
        int n4 = 0;
        try {
            byArray = this.getInternalCertificate().getEncoded();
            n3 = 1;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return 0;
        }
        while (true) {
            if (n3 >= byArray.length) break;
            n4 = byArray[n3] * n3 + n4;
            ++n3;
            continue;
            break;
        }
        return n4;
    }

    @Override
    public void setBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1Encodable aSN1Encodable) {
        this.attrCarrier.setBagAttribute(aSN1ObjectIdentifier, aSN1Encodable);
    }

    @Override
    public ASN1Encodable getBagAttribute(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return this.attrCarrier.getBagAttribute(aSN1ObjectIdentifier);
    }

    @Override
    public Enumeration getBagAttributeKeys() {
        return this.attrCarrier.getBagAttributeKeys();
    }
}

