/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.keystore.bcfks;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Object;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.EncryptedObjectStoreData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.EncryptedPrivateKeyData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.EncryptedSecretKeyData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.ObjectData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.ObjectDataSequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.ObjectStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.ObjectStoreData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.ObjectStoreIntegrityCheck;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.PbkdMacIntegrityCheck;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.SecretKeyData;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.bc.SignatureCheck;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.CCMParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.kisa.KISAObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.MiscObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.misc.ScryptParams;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.nsri.NSRIObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ntt.NTTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.EncryptionScheme;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.KeyDerivationFunc;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PBES2Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PBKDF2Params;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.PBEParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA3Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.digests.SHA512Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.generators.SCrypt;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PBKDF2Config;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.PBKDFConfig;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.ScryptConfig;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.BCFKSLoadStoreParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.BCFKSStoreParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.BCLoadStoreParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.BCJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.interfaces.ECKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.RSAKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

class BcFKSKeyStoreSpi
extends KeyStoreSpi {
    private static final Map<String, ASN1ObjectIdentifier> oidMap;
    private static final Map<ASN1ObjectIdentifier, String> publicAlgMap;
    private static final BigInteger CERTIFICATE;
    private static final BigInteger PRIVATE_KEY;
    private static final BigInteger SECRET_KEY;
    private static final BigInteger PROTECTED_PRIVATE_KEY;
    private static final BigInteger PROTECTED_SECRET_KEY;
    private PublicKey verificationKey;
    private BCFKSLoadStoreParameter.CertChainValidator validator;
    private final JcaJceHelper helper;
    private final Map<String, ObjectData> entries = new HashMap<String, ObjectData>();
    private final Map<String, PrivateKey> privateKeyCache = new HashMap<String, PrivateKey>();
    private AlgorithmIdentifier hmacAlgorithm;
    private KeyDerivationFunc hmacPkbdAlgorithm;
    private AlgorithmIdentifier signatureAlgorithm;
    private Date creationDate;
    private Date lastModifiedDate;
    private ASN1ObjectIdentifier storeEncryptionAlgorithm = NISTObjectIdentifiers.id_aes256_CCM;

    private static String getPublicKeyAlg(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        String string2 = publicAlgMap.get(aSN1ObjectIdentifier);
        if (string2 != null) {
            return string2;
        }
        return aSN1ObjectIdentifier.getId();
    }

    public BcFKSKeyStoreSpi(JcaJceHelper jcaJceHelper) {
        this.helper = jcaJceHelper;
    }

    private java.security.cert.Certificate decodeCertificate(Object object) {
        JcaJceHelper jcaJceHelper = ((BcFKSKeyStoreSpi)((Object)jcaJceHelper)).helper;
        if (jcaJceHelper != null) {
            try {
                return jcaJceHelper.createCertificateFactory("X.509").generateCertificate(new ByteArrayInputStream(Certificate.getInstance(object).getEncoded()));
            }
            catch (Exception exception) {
                return null;
            }
        }
        try {
            return CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(Certificate.getInstance(object).getEncoded()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Cipher createCipher(String string2, byte[] byArray) {
        SecretKeySpec secretKeySpec;
        Cipher cipher = ((BcFKSKeyStoreSpi)((Object)secretKeySpec2)).helper.createCipher(string2);
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        secretKeySpec = new SecretKeySpec(byArray, "AES");
        cipher.init(1, secretKeySpec2);
        return cipher;
    }

    private SecureRandom getDefaultSecureRandom() {
        return CryptoServicesRegistrar.getSecureRandom();
    }

    private EncryptedPrivateKeyData createPrivateKeySequence(EncryptedPrivateKeyInfo encryptedPrivateKeyInfo, java.security.cert.Certificate[] certificateArray) {
        Certificate[] certificateArray2 = new Certificate[certificateArray.length];
        for (int i3 = 0; i3 != certificateArray.length; ++i3) {
            certificateArray2[i3] = Certificate.getInstance(certificateArray[i3].getEncoded());
        }
        return new EncryptedPrivateKeyData(encryptedPrivateKeyInfo, certificateArray2);
    }

    private Date extractCreationDate(ObjectData objectData, Date date) {
        try {
            date = objectData.getCreationDate().getDate();
        }
        catch (ParseException parseException) {}
        return date;
    }

    private byte[] generateKey(KeyDerivationFunc aSN1Object, String object, char[] object2, int n3) {
        block12: {
            block15: {
                Object object3;
                block14: {
                    block13: {
                        block8: {
                            block11: {
                                block10: {
                                    block9: {
                                        object3 = PBEParametersGenerator.PKCS12PasswordToBytes((char[])object2);
                                        object = PBEParametersGenerator.PKCS12PasswordToBytes(((String)object).toCharArray());
                                        if (!MiscObjectIdentifiers.id_scrypt.equals(((KeyDerivationFunc)aSN1Object).getAlgorithm())) break block8;
                                        if (((ScryptParams)(aSN1Object = ScryptParams.getInstance(((KeyDerivationFunc)aSN1Object).getParameters()))).getKeyLength() == null) break block9;
                                        n3 = ((ScryptParams)aSN1Object).getKeyLength().intValue();
                                        break block10;
                                    }
                                    if (n3 == -1) break block11;
                                }
                                ASN1Object aSN1Object2 = aSN1Object;
                                int n4 = ((ScryptParams)aSN1Object2).getCostParameter().intValue();
                                int n5 = ((ScryptParams)aSN1Object2).getBlockSize().intValue();
                                int n6 = ((ScryptParams)aSN1Object2).getBlockSize().intValue();
                                return SCrypt.generate(Arrays.concatenate((byte[])object3, (byte[])object), ((ScryptParams)aSN1Object).getSalt(), n4, n5, n6, n3);
                            }
                            throw new IOException("no keyLength found in ScryptParams");
                        }
                        if (!((KeyDerivationFunc)aSN1Object).getAlgorithm().equals(PKCSObjectIdentifiers.id_PBKDF2)) break block12;
                        if (((PBKDF2Params)(aSN1Object = PBKDF2Params.getInstance(((KeyDerivationFunc)aSN1Object).getParameters()))).getKeyLength() == null) break block13;
                        n3 = ((PBKDF2Params)aSN1Object).getKeyLength().intValue();
                        break block14;
                    }
                    if (n3 == -1) break block15;
                }
                if (((PBKDF2Params)aSN1Object).getPrf().getAlgorithm().equals(PKCSObjectIdentifiers.id_hmacWithSHA512)) {
                    PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                    object2 = pKCS5S2ParametersGenerator;
                    ((PKCS5S2ParametersGenerator)object2)(new SHA512Digest());
                    object3 = Arrays.concatenate((byte[])object3, (byte[])object);
                    object = ((PBKDF2Params)aSN1Object).getSalt();
                    ((PBEParametersGenerator)object2).init((byte[])object3, (byte[])object, ((PBKDF2Params)aSN1Object).getIterationCount().intValue());
                    return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n3 * 8)).getKey();
                }
                if (((PBKDF2Params)aSN1Object).getPrf().getAlgorithm().equals(NISTObjectIdentifiers.id_hmacWithSHA3_512)) {
                    PKCS5S2ParametersGenerator pKCS5S2ParametersGenerator;
                    object2 = pKCS5S2ParametersGenerator;
                    ((PKCS5S2ParametersGenerator)object2)(new SHA3Digest(512));
                    object3 = Arrays.concatenate((byte[])object3, (byte[])object);
                    object = ((PBKDF2Params)aSN1Object).getSalt();
                    ((PBEParametersGenerator)object2).init((byte[])object3, (byte[])object, ((PBKDF2Params)aSN1Object).getIterationCount().intValue());
                    return ((KeyParameter)pKCS5S2ParametersGenerator.generateDerivedParameters(n3 * 8)).getKey();
                }
                throw new IOException(b.a("BCFKS KeyStore: unrecognized MAC PBKD PRF: ").append(((PBKDF2Params)aSN1Object).getPrf().getAlgorithm()).toString());
            }
            throw new IOException("no keyLength found in PBKDF2Params");
        }
        throw new IOException("BCFKS KeyStore: unrecognized MAC PBKD.");
    }

    private void verifySig(ASN1Encodable aSN1Encodable, SignatureCheck signatureCheck, PublicKey publicKey) {
        Signature signature = ((BcFKSKeyStoreSpi)((Object)signature)).helper.createSignature(signatureCheck.getSignatureAlgorithm().getAlgorithm().getId());
        signature.initVerify(publicKey);
        signature.update(aSN1Encodable.toASN1Primitive().getEncoded("DER"));
        if (signature.verify(signatureCheck.getSignature().getOctets())) {
            return;
        }
        throw new IOException("BCFKS KeyStore corrupted: signature calculation failed");
    }

    private void verifyMac(byte[] byArray, PbkdMacIntegrityCheck pbkdMacIntegrityCheck, char[] cArray) {
        PbkdMacIntegrityCheck pbkdMacIntegrityCheck2 = pbkdMacIntegrityCheck;
        if (Arrays.constantTimeAreEqual(((BcFKSKeyStoreSpi)this).calculateMac(byArray, (AlgorithmIdentifier)(this = pbkdMacIntegrityCheck2.getMacAlgorithm()), pbkdMacIntegrityCheck2.getPbkdAlgorithm(), cArray), pbkdMacIntegrityCheck.getMac())) {
            return;
        }
        throw new IOException("BCFKS KeyStore corrupted: MAC calculation failed");
    }

    private byte[] calculateMac(byte[] byArray, AlgorithmIdentifier object, KeyDerivationFunc keyDerivationFunc, char[] cArray) {
        SecretKeySpec secretKeySpec;
        String string2;
        Mac mac;
        block5: {
            object = ((AlgorithmIdentifier)object).getAlgorithm().getId();
            mac = this.helper.createMac((String)object);
            try {
                string2 = "INTEGRITY_CHECK";
                if (cArray != null) break block5;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new IOException(b.a("Cannot set up MAC calculation: ").append(invalidKeyException.getMessage()).toString());
            }
            cArray = new char[]{};
        }
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        secretKeySpec2(this.generateKey(keyDerivationFunc, string2, cArray, -1), (String)object);
        mac.init(secretKeySpec2);
        return mac.doFinal(byArray);
    }

    private char[] extractPassword(KeyStore.LoadStoreParameter loadStoreParameter) {
        Object object = loadStoreParameter.getProtectionParameter();
        if (object == null) {
            return null;
        }
        if (object instanceof KeyStore.PasswordProtection) {
            return ((KeyStore.PasswordProtection)object).getPassword();
        }
        if (object instanceof KeyStore.CallbackHandlerProtection) {
            PasswordCallback passwordCallback;
            CallbackHandler callbackHandler = ((KeyStore.CallbackHandlerProtection)object).getCallbackHandler();
            object = passwordCallback;
            passwordCallback = new PasswordCallback("password: ", false);
            try {
                callbackHandler.handle(new Callback[]{object});
                return ((PasswordCallback)object).getPassword();
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                throw new IllegalArgumentException(b.a("PasswordCallback not recognised: ").append(unsupportedCallbackException.getMessage()).toString(), unsupportedCallbackException);
            }
        }
        throw new IllegalArgumentException(b.a("no support for protection parameter of type ").append(object.getClass().getName()).toString());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private EncryptedObjectStoreData getEncryptedObjectStoreData(AlgorithmIdentifier var1_6, char[] var2_7) {
        block18: {
            v0 = this;
            var3_8 /* !! */  = v0.entries.values().toArray(new ObjectData[this.entries.size()]);
            var4_9 = v0.generatePkbdAlgorithmIdentifier(v0.hmacPkbdAlgorithm, 32);
            var5_10 = "STORE_ENCRYPTION";
            if (var2_7 /* !! */  == null) {
                var2_7 /* !! */  = new char[]{};
            }
            v1 = this;
            var2_7 /* !! */  = (char[])v1.generateKey(var4_9, (String)var5_10, var2_7 /* !! */ , 32);
            var5_10 = v2;
            v3 = var1_6;
            v4 = this;
            var1_6 = v4.creationDate;
            var6_11 = v5;
            v5 = new ObjectDataSequence(var3_8 /* !! */ );
            v2 = new ObjectStoreData(v3, (Date)var1_6, v4.lastModifiedDate, var6_11, null);
            v6 = v1.storeEncryptionAlgorithm;
            var1_6 = NISTObjectIdentifiers.id_aes256_CCM;
            if (!v6.equals((ASN1Primitive)var1_6)) ** GOTO lbl34
            v7 = this.createCipher("AES/CCM/NoPadding", (byte[])var2_7 /* !! */ );
            v8 = v7;
            this = v7.doFinal(var5_10.getEncoded());
            var2_7 /* !! */  = (char[])v8.getParameters();
            var3_8 /* !! */  = v9;
            v9 = new PBES2Parameters(var4_9, new EncryptionScheme((ASN1ObjectIdentifier)var1_6, CCMParameters.getInstance(var2_7 /* !! */ .getEncoded())));
            var1_6 = v10;
            v10 = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)var3_8 /* !! */ ), (byte[])this);
            break block18;
lbl34:
            // 1 sources

            this = this.createCipher("AESKWP", (byte[])var2_7 /* !! */ ).doFinal(var5_10.getEncoded());
            var1_6 = v11;
            v12 = var4_9;
            var2_7 /* !! */  = (char[])v13;
            v13 = new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad);
            v11 = new PBES2Parameters(v12, (EncryptionScheme)var2_7 /* !! */ );
            var2_7 /* !! */  = v14;
            try {
                v14 = new EncryptedObjectStoreData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)var1_6), (byte[])this);
                var1_6 = var2_7 /* !! */ ;
            }
            catch (NoSuchProviderException var0_1) {
                throw new IOException(var0_1.toString());
            }
            catch (InvalidKeyException var0_2) {
                throw new IOException(var0_2.toString());
            }
            catch (IllegalBlockSizeException var0_3) {
                throw new IOException(var0_3.toString());
            }
            catch (BadPaddingException var0_4) {
                throw new IOException(var0_4.toString());
            }
            catch (NoSuchPaddingException var0_5) {
                throw new NoSuchAlgorithmException(var0_5.toString());
            }
        }
        return var1_6;
    }

    private boolean isSimilarHmacPbkd(PBKDFConfig object, KeyDerivationFunc keyDerivationFunc) {
        block10: {
            block9: {
                Object object2;
                block8: {
                    if (!((PBKDFConfig)object).getAlgorithm().equals(keyDerivationFunc.getAlgorithm())) {
                        return false;
                    }
                    if (!MiscObjectIdentifiers.id_scrypt.equals(keyDerivationFunc.getAlgorithm())) break block8;
                    if (!(object instanceof ScryptConfig)) {
                        return false;
                    }
                    object2 = (ScryptConfig)object;
                    object = ScryptParams.getInstance(keyDerivationFunc.getParameters());
                    if (((ScryptConfig)object2).getSaltLength() != ((ScryptParams)object).getSalt().length || ((ScryptConfig)object2).getBlockSize() != ((ScryptParams)object).getBlockSize().intValue() || ((ScryptConfig)object2).getCostParameter() != ((ScryptParams)object).getCostParameter().intValue() || ((ScryptConfig)object2).getParallelizationParameter() != ((ScryptParams)object).getParallelizationParameter().intValue()) {
                        return false;
                    }
                    break block9;
                }
                if (!(object instanceof PBKDF2Config)) {
                    return false;
                }
                object2 = (PBKDF2Config)object;
                object = PBKDF2Params.getInstance(keyDerivationFunc.getParameters());
                if (((PBKDF2Config)object2).getSaltLength() != ((PBKDF2Params)object).getSalt().length || ((PBKDF2Config)object2).getIterationCount() != ((PBKDF2Params)object).getIterationCount().intValue()) break block10;
            }
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decryptData(String string2, AlgorithmIdentifier aSN1Object, char[] cArray, byte[] byArray) {
        if (!((AlgorithmIdentifier)aSN1Object).getAlgorithm().equals(PKCSObjectIdentifiers.id_PBES2)) {
            throw new IOException("BCFKS KeyStore cannot recognize protection algorithm.");
        }
        aSN1Object = PBES2Parameters.getInstance(((AlgorithmIdentifier)aSN1Object).getParameters());
        EncryptionScheme encryptionScheme = ((PBES2Parameters)aSN1Object).getEncryptionScheme();
        try {
            AlgorithmParameters algorithmParameters;
            Cipher cipher;
            if (encryptionScheme.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_CCM)) {
                BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object;
                cipher = bcFKSKeyStoreSpi.helper.createCipher("AES/CCM/NoPadding");
                algorithmParameters = bcFKSKeyStoreSpi.helper.createAlgorithmParameters("CCM");
                algorithmParameters.init(CCMParameters.getInstance(encryptionScheme.getParameters()).getEncoded());
            } else {
                if (!encryptionScheme.getAlgorithm().equals(NISTObjectIdentifiers.id_aes256_wrap_pad)) {
                    throw new IOException("BCFKS KeyStore cannot recognize protection encryption algorithm.");
                }
                cipher = ((BcFKSKeyStoreSpi)object).helper.createCipher("AESKWP");
                algorithmParameters = null;
            }
            aSN1Object = ((PBES2Parameters)aSN1Object).getKeyDerivationFunc();
            if (cArray == null) {
                cArray = new char[]{};
            }
            Object object = ((BcFKSKeyStoreSpi)object).generateKey((KeyDerivationFunc)aSN1Object, string2, cArray, 32);
            cipher.init(2, (Key)new SecretKeySpec((byte[])object, "AES"), algorithmParameters);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new IOException(((Object)exception).toString());
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    private AlgorithmIdentifier generateSignatureAlgId(Key key, BCFKSLoadStoreParameter.SignatureAlgorithm signatureAlgorithm) {
        if (key == null) {
            return null;
        }
        if (key instanceof ECKey) {
            if (signatureAlgorithm == BCFKSLoadStoreParameter.SignatureAlgorithm.SHA512withECDSA) {
                return new AlgorithmIdentifier(X9ObjectIdentifiers.ecdsa_with_SHA512);
            }
            if (signatureAlgorithm == BCFKSLoadStoreParameter.SignatureAlgorithm.SHA3_512withECDSA) {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_ecdsa_with_sha3_512);
            }
        }
        if (key instanceof DSAKey) {
            if (signatureAlgorithm == BCFKSLoadStoreParameter.SignatureAlgorithm.SHA512withDSA) {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.dsa_with_sha512);
            }
            if (signatureAlgorithm == BCFKSLoadStoreParameter.SignatureAlgorithm.SHA3_512withDSA) {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_dsa_with_sha3_512);
            }
        }
        if (key instanceof RSAKey) {
            if (signatureAlgorithm == BCFKSLoadStoreParameter.SignatureAlgorithm.SHA512withRSA) {
                return new AlgorithmIdentifier(PKCSObjectIdentifiers.sha512WithRSAEncryption, DERNull.INSTANCE);
            }
            if (signatureAlgorithm == BCFKSLoadStoreParameter.SignatureAlgorithm.SHA3_512withRSA) {
                return new AlgorithmIdentifier(NISTObjectIdentifiers.id_rsassa_pkcs1_v1_5_with_sha3_512, DERNull.INSTANCE);
            }
        }
        throw new IOException("unknown signature algorithm");
    }

    private KeyDerivationFunc generatePkbdAlgorithmIdentifier(PBKDFConfig object, int n3) {
        Object object2;
        ASN1ObjectIdentifier aSN1ObjectIdentifier = MiscObjectIdentifiers.id_scrypt;
        if (aSN1ObjectIdentifier.equals(((PBKDFConfig)object).getAlgorithm())) {
            ScryptParams scryptParams;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object2;
            object2 = (ScryptConfig)object;
            object = new byte[((ScryptConfig)object2).getSaltLength()];
            bcFKSKeyStoreSpi.getDefaultSecureRandom().nextBytes((byte[])object);
            ScryptParams scryptParams2 = scryptParams;
            Object object3 = object2;
            int n4 = ((ScryptConfig)object3).getCostParameter();
            int n5 = ((ScryptConfig)object3).getBlockSize();
            int n6 = ((ScryptConfig)object3).getParallelizationParameter();
            scryptParams = new ScryptParams((byte[])object, n4, n5, n6, n3);
            return new KeyDerivationFunc(aSN1ObjectIdentifier, scryptParams2);
        }
        BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object2;
        object2 = (PBKDF2Config)object;
        object = new byte[((PBKDF2Config)object2).getSaltLength()];
        bcFKSKeyStoreSpi.getDefaultSecureRandom().nextBytes((byte[])object);
        Object object4 = object;
        Object object5 = object2;
        int n7 = ((PBKDF2Config)object5).getIterationCount();
        object = ((PBKDF2Config)object5).getPRF();
        return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, new PBKDF2Params((byte[])object4, n7, n3, (AlgorithmIdentifier)object));
    }

    private KeyDerivationFunc generatePkbdAlgorithmIdentifier(KeyDerivationFunc object, int n3) {
        PBKDF2Params pBKDF2Params;
        Object object2;
        ASN1Object aSN1Object = MiscObjectIdentifiers.id_scrypt;
        if (aSN1Object.equals(((KeyDerivationFunc)object).getAlgorithm())) {
            ScryptParams scryptParams;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object2;
            object2 = ScryptParams.getInstance(((KeyDerivationFunc)object).getParameters());
            object = new byte[((ScryptParams)object2).getSalt().length];
            bcFKSKeyStoreSpi.getDefaultSecureRandom().nextBytes((byte[])object);
            ScryptParams scryptParams2 = scryptParams;
            Object object3 = object;
            Object object4 = object2;
            object2 = ((ScryptParams)object4).getCostParameter();
            object = ((ScryptParams)object4).getBlockSize();
            BigInteger bigInteger = ((ScryptParams)object4).getParallelizationParameter();
            BigInteger bigInteger2 = BigInteger.valueOf(n3);
            scryptParams = new ScryptParams((byte[])object3, (BigInteger)object2, (BigInteger)object, bigInteger, bigInteger2);
            return new KeyDerivationFunc((ASN1ObjectIdentifier)aSN1Object, scryptParams2);
        }
        BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object2;
        object2 = PBKDF2Params.getInstance(((KeyDerivationFunc)object).getParameters());
        object = new byte[((PBKDF2Params)object2).getSalt().length];
        bcFKSKeyStoreSpi.getDefaultSecureRandom().nextBytes((byte[])object);
        aSN1Object = pBKDF2Params;
        Object object5 = object;
        Object object6 = object2;
        int n4 = ((PBKDF2Params)object6).getIterationCount().intValue();
        object = ((PBKDF2Params)object6).getPrf();
        pBKDF2Params = new PBKDF2Params((byte[])object5, n4, n3, (AlgorithmIdentifier)object);
        return new KeyDerivationFunc(PKCSObjectIdentifiers.id_PBKDF2, aSN1Object);
    }

    private KeyDerivationFunc generatePkbdAlgorithmIdentifier(ASN1ObjectIdentifier aSN1Object, int n3) {
        BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object;
        Object object = new byte[64];
        bcFKSKeyStoreSpi.getDefaultSecureRandom().nextBytes((byte[])object);
        ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.id_PBKDF2;
        if (aSN1ObjectIdentifier.equals((ASN1Primitive)aSN1Object)) {
            AlgorithmIdentifier algorithmIdentifier;
            PBKDF2Params pBKDF2Params;
            aSN1Object = pBKDF2Params;
            AlgorithmIdentifier algorithmIdentifier2 = algorithmIdentifier;
            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
            pBKDF2Params = new PBKDF2Params((byte[])object, 51200, n3, algorithmIdentifier2);
            return new KeyDerivationFunc(aSN1ObjectIdentifier, aSN1Object);
        }
        throw new IllegalStateException(a.a("unknown derivation algorithm: ", aSN1Object));
    }

    static {
        HashMap<ASN1ObjectIdentifier, String> hashMap;
        HashMap<String, ASN1ObjectIdentifier> hashMap2;
        Object object = hashMap2;
        oidMap = new HashMap<String, ASN1ObjectIdentifier>();
        HashMap<ASN1ObjectIdentifier, String> hashMap3 = hashMap;
        HashMap<String, ASN1ObjectIdentifier> hashMap4 = object;
        HashMap<ASN1ObjectIdentifier, String> hashMap5 = hashMap3;
        hashMap5();
        publicAlgMap = hashMap5;
        object = OIWObjectIdentifiers.desEDE;
        hashMap4.put("DESEDE", (ASN1ObjectIdentifier)object);
        hashMap4.put("TRIPLEDES", (ASN1ObjectIdentifier)object);
        hashMap4.put("TDEA", (ASN1ObjectIdentifier)object);
        hashMap4.put("HMACSHA1", PKCSObjectIdentifiers.id_hmacWithSHA1);
        hashMap4.put("HMACSHA224", PKCSObjectIdentifiers.id_hmacWithSHA224);
        hashMap4.put("HMACSHA256", PKCSObjectIdentifiers.id_hmacWithSHA256);
        hashMap4.put("HMACSHA384", PKCSObjectIdentifiers.id_hmacWithSHA384);
        hashMap4.put("HMACSHA512", PKCSObjectIdentifiers.id_hmacWithSHA512);
        hashMap4.put("SEED", KISAObjectIdentifiers.id_seedCBC);
        hashMap4.put("CAMELLIA.128", NTTObjectIdentifiers.id_camellia128_cbc);
        hashMap4.put("CAMELLIA.192", NTTObjectIdentifiers.id_camellia192_cbc);
        hashMap4.put("CAMELLIA.256", NTTObjectIdentifiers.id_camellia256_cbc);
        hashMap4.put("ARIA.128", NSRIObjectIdentifiers.id_aria128_cbc);
        hashMap4.put("ARIA.192", NSRIObjectIdentifiers.id_aria192_cbc);
        hashMap4.put("ARIA.256", NSRIObjectIdentifiers.id_aria256_cbc);
        hashMap.put(PKCSObjectIdentifiers.rsaEncryption, "RSA");
        hashMap.put(X9ObjectIdentifiers.id_ecPublicKey, "EC");
        hashMap.put(OIWObjectIdentifiers.elGamalAlgorithm, "DH");
        hashMap.put(PKCSObjectIdentifiers.dhKeyAgreement, "DH");
        hashMap.put(X9ObjectIdentifiers.id_dsa, "DSA");
        CERTIFICATE = BigInteger.valueOf(0L);
        PRIVATE_KEY = BigInteger.valueOf(1L);
        SECRET_KEY = BigInteger.valueOf(2L);
        PROTECTED_PRIVATE_KEY = BigInteger.valueOf(3L);
        PROTECTED_SECRET_KEY = BigInteger.valueOf(4L);
    }

    @Override
    public Key engineGetKey(String string2, char[] object) {
        Object object2 = ((BcFKSKeyStoreSpi)object3).entries.get(string2);
        if (object2 != null) {
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo2;
            if (!((ObjectData)object2).getType().equals(PRIVATE_KEY) && !((ObjectData)object2).getType().equals(PROTECTED_PRIVATE_KEY)) {
                Object object3;
                EncryptedSecretKeyData encryptedSecretKeyData;
                EncryptedSecretKeyData encryptedSecretKeyData2;
                if (!((ObjectData)object2).getType().equals(SECRET_KEY) && !((ObjectData)object2).getType().equals(PROTECTED_SECRET_KEY)) {
                    throw new UnrecoverableKeyException(g.a("BCFKS KeyStore unable to recover secret key (", string2, "): type not recognized"));
                }
                BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object3;
                EncryptedSecretKeyData encryptedSecretKeyData3 = EncryptedSecretKeyData.getInstance(((ObjectData)object2).getData());
                try {
                    encryptedSecretKeyData2 = encryptedSecretKeyData3;
                    encryptedSecretKeyData = encryptedSecretKeyData3;
                    object3 = "SECRET_KEY_ENCRYPTION";
                }
                catch (Exception exception) {
                    throw new UnrecoverableKeyException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, new StringBuilder().append("BCFKS KeyStore unable to recover secret key (").append(string2).append("): ")));
                }
                object2 = encryptedSecretKeyData2.getKeyEncryptionAlgorithm();
                byte[] byArray = encryptedSecretKeyData.getEncryptedKeyData();
                object3 = SecretKeyData.getInstance(bcFKSKeyStoreSpi.decryptData((String)object3, (AlgorithmIdentifier)object2, (char[])object, byArray));
                return bcFKSKeyStoreSpi.helper.createSecretKeyFactory(((SecretKeyData)object3).getKeyAlgorithm().getId()).generateSecret(new SecretKeySpec(((SecretKeyData)object3).getKeyBytes(), ((SecretKeyData)object3).getKeyAlgorithm().getId()));
            }
            Object object4 = ((BcFKSKeyStoreSpi)object3).privateKeyCache.get(string2);
            if (object4 != null) {
                return object4;
            }
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi = object3;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo3 = EncryptedPrivateKeyInfo.getInstance(EncryptedPrivateKeyData.getInstance(((ObjectData)object2).getData()).getEncryptedPrivateKeyInfo());
            try {
                encryptedPrivateKeyInfo2 = encryptedPrivateKeyInfo3;
                encryptedPrivateKeyInfo = encryptedPrivateKeyInfo3;
                object2 = "PRIVATE_KEY_ENCRYPTION";
            }
            catch (Exception exception) {
                throw new UnrecoverableKeyException(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a.a(exception, new StringBuilder().append("BCFKS KeyStore unable to recover private key (").append(string2).append("): ")));
            }
            object4 = encryptedPrivateKeyInfo2.getEncryptionAlgorithm();
            byte[] byArray = encryptedPrivateKeyInfo.getEncryptedData();
            object = PrivateKeyInfo.getInstance(bcFKSKeyStoreSpi.decryptData((String)object2, (AlgorithmIdentifier)object4, (char[])object, byArray));
            object = bcFKSKeyStoreSpi.helper.createKeyFactory(BcFKSKeyStoreSpi.getPublicKeyAlg(((PrivateKeyInfo)object).getPrivateKeyAlgorithm().getAlgorithm())).generatePrivate(new PKCS8EncodedKeySpec(((ASN1Object)object).getEncoded()));
            ((BcFKSKeyStoreSpi)object3).privateKeyCache.put(string2, (PrivateKey)object);
            return object;
        }
        return null;
    }

    @Override
    public java.security.cert.Certificate[] engineGetCertificateChain(String certificateArray) {
        if ((certificateArray = this.entries.get(certificateArray)) != null && (certificateArray.getType().equals(PRIVATE_KEY) || certificateArray.getType().equals(PROTECTED_PRIVATE_KEY))) {
            certificateArray = EncryptedPrivateKeyData.getInstance(certificateArray.getData()).getCertificateChain();
            int n3 = certificateArray.length;
            java.security.cert.Certificate[] certificateArray2 = new X509Certificate[n3];
            for (int i3 = 0; i3 != n3; ++i3) {
                certificateArray2[i3] = this.decodeCertificate(certificateArray[i3]);
            }
            return certificateArray2;
        }
        return null;
    }

    @Override
    public java.security.cert.Certificate engineGetCertificate(String object) {
        if ((object = this.entries.get(object)) != null) {
            if (!((ObjectData)object).getType().equals(PRIVATE_KEY) && !((ObjectData)object).getType().equals(PROTECTED_PRIVATE_KEY)) {
                if (((ObjectData)object).getType().equals(CERTIFICATE)) {
                    return this.decodeCertificate(((ObjectData)object).getData());
                }
            } else {
                return this.decodeCertificate(EncryptedPrivateKeyData.getInstance(((ObjectData)object).getData()).getCertificateChain()[0]);
            }
        }
        return null;
    }

    @Override
    public Date engineGetCreationDate(String string2) {
        ObjectData objectData = ((BcFKSKeyStoreSpi)((Object)objectData)).entries.get(string2);
        if (objectData != null) {
            try {
                return objectData.getLastModifiedDate().getDate();
            }
            catch (ParseException parseException) {
                return new Date();
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void engineSetKeyEntry(String var1_3, Key var2_4, char[] var3_5, java.security.cert.Certificate[] var4_6) {
        block65: {
            block66: {
                block61: {
                    block60: {
                        block62: {
                            block63: {
                                block64: {
                                    block59: {
                                        var5_7 = v0;
                                        v0 = new Date();
                                        var6_8 = this.entries.get(var1_3);
                                        var6_8 = var6_8 != null ? this.extractCreationDate((ObjectData)var6_8, var5_7) : var5_7;
                                        this.privateKeyCache.remove(var1_3);
                                        if (!(var2_4 instanceof PrivateKey)) break block63;
                                        if (var4_6 /* !! */  == null) break block64;
                                        v1 = var3_5 /* !! */ ;
                                        v2 = this;
                                        var2_4 = var2_4.getEncoded();
                                        var7_9 /* !! */  = v2.generatePkbdAlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, 32);
                                        var8_11 = "PRIVATE_KEY_ENCRYPTION";
                                        if (v1 == null) {
                                            var3_5 /* !! */  = new char[]{};
                                        }
                                        v3 = this;
                                        v4 = v3;
                                        var3_5 /* !! */  = (char[])v3.generateKey(var7_9 /* !! */ , (String)var8_11, var3_5 /* !! */ , 32);
                                        v5 = v4.storeEncryptionAlgorithm;
                                        var8_11 = NISTObjectIdentifiers.id_aes256_CCM;
                                        if (!v5.equals((ASN1Primitive)var8_11)) ** GOTO lbl42
                                        v6 = this.createCipher("AES/CCM/NoPadding", (byte[])var3_5 /* !! */ );
                                        v7 = v6;
                                        var2_4 = v6.doFinal((byte[])var2_4);
                                        var3_5 /* !! */  = (char[])v7.getParameters();
                                        var9_13 = v8;
                                        v8 = new PBES2Parameters(var7_9 /* !! */ , new EncryptionScheme((ASN1ObjectIdentifier)var8_11, CCMParameters.getInstance(var3_5 /* !! */ .getEncoded())));
                                        var3_5 /* !! */  = v9;
                                        v9 = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, var9_13), (byte[])var2_4);
                                        break block59;
lbl42:
                                        // 1 sources

                                        var2_4 = this.createCipher("AESKWP", (byte[])var3_5 /* !! */ ).doFinal((byte[])var2_4);
                                        var3_5 /* !! */  = (char[])v10;
                                        v11 = var7_9 /* !! */ ;
                                        var7_9 /* !! */  = v12;
                                        v12 = new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad);
                                        v10 = new PBES2Parameters(v11, (EncryptionScheme)var7_9 /* !! */ );
                                        var7_9 /* !! */  = v13;
                                        v13 = new EncryptedPrivateKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)var3_5 /* !! */ ), (byte[])var2_4);
                                        var3_5 /* !! */  = var7_9 /* !! */ ;
                                    }
                                    v14 = this;
                                    v15 = v14;
                                    var2_4 = v14.createPrivateKeySequence((EncryptedPrivateKeyInfo)var3_5 /* !! */ , var4_6 /* !! */ );
                                    v16 = v15.entries;
                                    v17 = var1_3;
                                    var3_5 /* !! */  = v18;
                                    v19 = var2_4;
                                    var2_4 = BcFKSKeyStoreSpi.PRIVATE_KEY;
                                    var4_6 /* !! */  = (java.security.cert.Certificate[])v19.getEncoded();
                                    try {
                                        v18 = new ObjectData((BigInteger)var2_4, var1_3, (Date)var6_8, var5_7, (byte[])var4_6 /* !! */ , null);
                                        v20 = v16.put(v17, (ObjectData)var3_5 /* !! */ );
                                    }
                                    catch (Exception var0_1) {
                                        throw new ExtKeyStoreException(d.a(var0_1, b.a("BCFKS KeyStore exception storing private key: ")), var0_1);
                                    }
lbl71:
                                    // 2 sources

                                    while (true) {
                                        break block60;
                                        break;
                                    }
                                }
                                throw new KeyStoreException("BCFKS KeyStore requires a certificate chain for private key storage.");
                            }
                            if (!(var2_4 instanceof SecretKey)) break block65;
                            if (var4_6 /* !! */  != null) break block66;
                            try {
                                v21 = var3_5 /* !! */ ;
                                v22 = this;
                                var4_6 /* !! */  = (java.security.cert.Certificate[])var2_4.getEncoded();
                            }
                            catch (Exception var0_2) {
                                throw new ExtKeyStoreException(d.a(var0_2, b.a("BCFKS KeyStore exception storing private key: ")), var0_2);
                            }
                            var7_10 = v22.generatePkbdAlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, 32);
                            var8_12 = "SECRET_KEY_ENCRYPTION";
                            if (v21 == null) {
                                var3_5 /* !! */  = new char[]{};
                            }
                            v23 = var2_4;
                            var2_4 = this.generateKey(var7_10, (String)var8_12, var3_5 /* !! */ , 32);
                            v24 = Strings.toUpperCase(v23.getAlgorithm());
                            var3_5 /* !! */  = (char[])v24;
                            if (v24.indexOf("AES") <= -1) ** GOTO lbl105
                            var3_5 /* !! */  = (char[])v25;
                            v25 = new SecretKeyData(NISTObjectIdentifiers.aes, (byte[])var4_6 /* !! */ );
                            ** GOTO lbl123
lbl105:
                            // 1 sources

                            var8_12 = BcFKSKeyStoreSpi.oidMap;
                            var9_14 = var8_12.get(var3_5 /* !! */ );
                            if (var9_14 == null) ** GOTO lbl113
                            var3_5 /* !! */  = (char[])v26;
                            v26 = new SecretKeyData(var9_14, (byte[])var4_6 /* !! */ );
                            ** GOTO lbl123
lbl113:
                            // 1 sources

                            v27 = var8_12;
                            v28 = new StringBuilder().append((String)var3_5 /* !! */ ).append(".");
                            v29 = var4_6 /* !! */ .length;
                            var8_12 = (ASN1ObjectIdentifier)v27.get(v28.append(v29 * 8).toString());
                            if (var8_12 == null) break block61;
                            var3_5 /* !! */  = v30;
                            v30 = new SecretKeyData((ASN1ObjectIdentifier)var8_12, (byte[])var4_6 /* !! */ );
lbl123:
                            // 3 sources

                            v31 = this.storeEncryptionAlgorithm;
                            var4_6 /* !! */  = NISTObjectIdentifiers.id_aes256_CCM;
                            if (!v31.equals((ASN1Primitive)var4_6 /* !! */ )) ** GOTO lbl140
                            v32 = this.createCipher("AES/CCM/NoPadding", (byte[])var2_4);
                            v33 = v32;
                            var2_4 = v32.doFinal(var3_5 /* !! */ .getEncoded());
                            var3_5 /* !! */  = v33.getParameters();
                            var8_12 = v34;
                            v34 = new PBES2Parameters(var7_10, new EncryptionScheme((ASN1ObjectIdentifier)var4_6 /* !! */ , CCMParameters.getInstance(var3_5 /* !! */ .getEncoded())));
                            var3_5 /* !! */  = v35;
                            v35 = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)var8_12), (byte[])var2_4);
                            break block62;
lbl140:
                            // 1 sources

                            var2_4 = this.createCipher("AESKWP", (byte[])var2_4).doFinal(var3_5 /* !! */ .getEncoded());
                            var3_5 /* !! */  = v36;
                            v37 = var7_10;
                            var4_6 /* !! */  = v38;
                            v38 = new EncryptionScheme(NISTObjectIdentifiers.id_aes256_wrap_pad);
                            v36 = new PBES2Parameters(v37, (EncryptionScheme)var4_6 /* !! */ );
                            var4_6 /* !! */  = v39;
                            v39 = new EncryptedSecretKeyData(new AlgorithmIdentifier(PKCSObjectIdentifiers.id_PBES2, (ASN1Encodable)var3_5 /* !! */ ), (byte[])var2_4);
                            var3_5 /* !! */  = var4_6 /* !! */ ;
                        }
                        v40 = this.entries;
                        v41 = var1_3;
                        var2_4 = v42;
                        v43 = var3_5 /* !! */ ;
                        var3_5 /* !! */  = BcFKSKeyStoreSpi.SECRET_KEY;
                        var4_6 /* !! */  = (java.security.cert.Certificate[])v43.getEncoded();
                        v42 = new ObjectData((BigInteger)var3_5 /* !! */ , var1_3, (Date)var6_8, var5_7, (byte[])var4_6 /* !! */ , null);
                        v20 = v40.put(v41, (ObjectData)var2_4);
                        ** continue;
                    }
                    this.lastModifiedDate = var5_7;
                    return;
                }
                throw new KeyStoreException("BCFKS KeyStore cannot recognize secret key (" + (String)var3_5 /* !! */  + ") for storage.");
            }
            throw new KeyStoreException("BCFKS KeyStore cannot store certificate chain with secret key.");
        }
        throw new KeyStoreException("BCFKS KeyStore unable to recognize key.");
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void engineSetKeyEntry(String string2, byte[] object, java.security.cert.Certificate[] object2) {
        ObjectData objectData;
        String string3;
        Map<String, ObjectData> map;
        ObjectData objectData2;
        void var3_8;
        Date date;
        Date date2 = date;
        date = new Date();
        Object object3 = this.entries.get(string2);
        object3 = object3 != null ? this.extractCreationDate((ObjectData)object3, date2) : date2;
        if (var3_8 != null) {
            ObjectData objectData3;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi3 = this;
            bcFKSKeyStoreSpi3 = bcFKSKeyStoreSpi3;
            bcFKSKeyStoreSpi3 = bcFKSKeyStoreSpi;
            EncryptedPrivateKeyInfo encryptedPrivateKeyInfo = EncryptedPrivateKeyInfo.getInstance(object);
            try {
                bcFKSKeyStoreSpi2.privateKeyCache.remove(string2);
            }
            catch (Exception exception) {
                throw new ExtKeyStoreException(d.a(exception, b.a("BCFKS KeyStore exception storing protected private key: ")), exception);
            }
            Map<String, ObjectData> map2 = bcFKSKeyStoreSpi3.entries;
            String string4 = string2;
            ObjectData objectData4 = objectData3;
            BigInteger bigInteger = PROTECTED_PRIVATE_KEY;
            byte[] byArray = this.createPrivateKeySequence(encryptedPrivateKeyInfo, (java.security.cert.Certificate[])var3_8).getEncoded();
            ObjectData objectData2 = new ObjectData(bigInteger, string2, (Date)object3, date2, byArray, null);
            objectData2 = map2.put(string4, objectData4);
            catch (Exception exception) {
                throw new ExtKeyStoreException("BCFKS KeyStore private key encoding must be an EncryptedPrivateKeyInfo.", exception);
            }
        }
        try {
            map = this.entries;
            string3 = string2;
        }
        catch (Exception exception) {
            throw new ExtKeyStoreException(d.a(exception, b.a("BCFKS KeyStore exception storing protected private key: ")), exception);
        }
        ObjectData objectData5 = objectData;
        ObjectData objectData2 = new ObjectData(PROTECTED_SECRET_KEY, string2, (Date)object3, date2, (byte[])object, null);
        objectData2 = map.put(string3, objectData5);
        this.lastModifiedDate = date2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void engineSetCertificateEntry(String string2, java.security.cert.Certificate serializable) {
        ObjectData objectData;
        String string3;
        Map<String, ObjectData> map;
        Date date;
        Date date2;
        Object object = ((BcFKSKeyStoreSpi)((Object)objectData2)).entries.get(string2);
        Date date3 = date2;
        date2 = new Date();
        if (object != null) {
            if (!((ObjectData)object).getType().equals(CERTIFICATE)) throw new KeyStoreException(i.a("BCFKS KeyStore already has a key entry with alias ", string2));
            object = ((BcFKSKeyStoreSpi)((Object)objectData2)).extractCreationDate((ObjectData)object, date3);
        } else {
            object = date3;
        }
        try {
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi = objectData2;
            date = date3;
            map = ((BcFKSKeyStoreSpi)((Object)objectData2)).entries;
            string3 = string2;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new ExtKeyStoreException(b.a("BCFKS KeyStore unable to handle certificate: ").append(certificateEncodingException.getMessage()).toString(), certificateEncodingException);
        }
        ObjectData objectData2 = objectData;
        Serializable serializable2 = serializable;
        BigInteger bigInteger = CERTIFICATE;
        byte[] byArray = ((java.security.cert.Certificate)serializable2).getEncoded();
        objectData = new ObjectData(bigInteger, string2, (Date)object, date3, byArray, null);
        map.put(string3, objectData2);
        bcFKSKeyStoreSpi.lastModifiedDate = date;
    }

    @Override
    public void engineDeleteEntry(String string2) {
        if (this.entries.get(string2) == null) {
            return;
        }
        BcFKSKeyStoreSpi bcFKSKeyStoreSpi = this;
        bcFKSKeyStoreSpi.privateKeyCache.remove(string2);
        bcFKSKeyStoreSpi.entries.remove(string2);
        bcFKSKeyStoreSpi.lastModifiedDate = new Date();
    }

    @Override
    public Enumeration<String> engineAliases() {
        final Iterator<String> iterator = new HashSet<String>(this.entries.keySet()).iterator();
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            public Object nextElement() {
                return iterator.next();
            }
        };
    }

    @Override
    public boolean engineContainsAlias(String string2) {
        if (string2 != null) {
            return this.entries.containsKey(string2);
        }
        throw new NullPointerException("alias value is null");
    }

    @Override
    public int engineSize() {
        return this.entries.size();
    }

    @Override
    public boolean engineIsKeyEntry(String string2) {
        Object object = ((BcFKSKeyStoreSpi)object).entries.get(string2);
        if (object != null) {
            return ((BigInteger)(object = ((ObjectData)object).getType())).equals(PRIVATE_KEY) || ((BigInteger)object).equals(SECRET_KEY) || ((BigInteger)object).equals(PROTECTED_PRIVATE_KEY) || ((BigInteger)object).equals(PROTECTED_SECRET_KEY);
        }
        return false;
    }

    @Override
    public boolean engineIsCertificateEntry(String string2) {
        ObjectData objectData = ((BcFKSKeyStoreSpi)((Object)objectData)).entries.get(string2);
        if (objectData != null) {
            return objectData.getType().equals(CERTIFICATE);
        }
        return false;
    }

    @Override
    public String engineGetCertificateAlias(java.security.cert.Certificate object) {
        if (object == null) {
            return null;
        }
        try {
            object = ((java.security.cert.Certificate)object).getEncoded();
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return null;
        }
        for (String string2 : this.entries.keySet()) {
            ObjectData objectData = this.entries.get(string2);
            if (objectData.getType().equals(CERTIFICATE)) {
                if (!Arrays.areEqual(objectData.getData(), (byte[])object)) continue;
                return string2;
            }
            if (!objectData.getType().equals(PRIVATE_KEY) && !objectData.getType().equals(PROTECTED_PRIVATE_KEY)) continue;
            try {
                if (!Arrays.areEqual(EncryptedPrivateKeyData.getInstance(objectData.getData()).getCertificateChain()[0].toASN1Primitive().getEncoded(), (byte[])object)) continue;
                return string2;
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void engineStore(KeyStore.LoadStoreParameter var1_2) {
        block23: {
            block28: {
                block25: {
                    block26: {
                        block27: {
                            block22: {
                                block24: {
                                    if (var1_2 == null) break block23;
                                    if (!(var1_2 instanceof BCFKSStoreParameter)) break block24;
                                    v0 = this;
                                    v1 = var1_2;
                                    this = (BCFKSStoreParameter)v1;
                                    var1_2 = v0.extractPassword(v1);
                                    v0.hmacPkbdAlgorithm = v0.generatePkbdAlgorithmIdentifier(this.getStorePBKDFConfig(), 64);
                                    v0.engineStore(this.getOutputStream(), (char[])var1_2);
                                    break block25;
                                }
                                if (!(var1_2 instanceof BCFKSLoadStoreParameter)) break block26;
                                if ((var1_2 = (BCFKSLoadStoreParameter)var1_2).getStoreSignatureKey() == null) break block27;
                                v2 = var1_2;
                                var2_3 = v2.getStoreSignatureKey();
                                this.signatureAlgorithm = super.generateSignatureAlgId((Key)var2_3, v2.getStoreSignatureAlgorithm());
                                this.hmacPkbdAlgorithm = super.generatePkbdAlgorithmIdentifier(var1_2.getStorePBKDFConfig(), 64);
                                this.storeEncryptionAlgorithm = var1_2.getStoreEncryptionAlgorithm() == BCFKSLoadStoreParameter.EncryptionAlgorithm.AES256_CCM ? NISTObjectIdentifiers.id_aes256_CCM : NISTObjectIdentifiers.id_aes256_wrap_pad;
                                if (var1_2.getStoreMacAlgorithm() == BCFKSLoadStoreParameter.MacAlgorithm.HmacSHA512) {
                                    var2_3 = v3;
                                    v3 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
                                    this.hmacAlgorithm = var2_3;
                                } else {
                                    var2_3 = v4;
                                    v4 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
                                    this.hmacAlgorithm = var2_3;
                                }
                                v5 = this;
                                var2_3 = super.extractPassword((KeyStore.LoadStoreParameter)var1_2);
                                var2_3 = super.getEncryptedObjectStoreData(v5.signatureAlgorithm, (char[])var2_3);
                                var3_5 = v5.helper.createSignature(this.signatureAlgorithm.getAlgorithm().getId());
                                var3_5.initSign((PrivateKey)var1_2.getStoreSignatureKey());
                                var3_5.update(var2_3.getEncoded());
                                var4_8 /* !! */  = var1_2.getStoreCertificates();
                                if (var4_8 /* !! */  == null) break block22;
                                var5_9 = var4_8 /* !! */ .length;
                                var6_10 = new Certificate[var5_9];
                                for (var7_11 = 0; var7_11 != var5_9; ++var7_11) {
                                    var6_10[var7_11] = Certificate.getInstance(var4_8 /* !! */ [var7_11].getEncoded());
                                    continue;
                                }
                                var4_8 /* !! */  = v6;
                                try {
                                    v7 = var3_5;
                                    this = this.signatureAlgorithm;
                                }
                                catch (GeneralSecurityException var0_1) {
                                    throw new IOException(b.a("error creating signature: ").append(var0_1.getMessage()).toString(), var0_1);
                                }
                                var3_5 = v7.sign();
                                v6 = new SignatureCheck((AlgorithmIdentifier)this, var6_10, (byte[])var3_5);
                                ** GOTO lbl62
                            }
                            var4_8 /* !! */  = v8;
                            v9 = var3_5;
                            this = this.signatureAlgorithm;
                            v8 = new SignatureCheck((AlgorithmIdentifier)this, v9.sign());
lbl62:
                            // 2 sources

                            v10 = var1_2;
                            v11 = v10;
                            v12 = v10;
                            this = v13;
                            v14 = var2_3;
                            var1_2 = v15;
                            v15 = new ObjectStoreIntegrityCheck((SignatureCheck)var4_8 /* !! */ );
                            v13 = new ObjectStore((EncryptedObjectStoreData)v14, (ObjectStoreIntegrityCheck)var1_2);
                            v11.getOutputStream().write(this.getEncoded());
                            v12.getOutputStream().flush();
                        }
                        var2_4 = super.extractPassword((KeyStore.LoadStoreParameter)var1_2);
                        this.hmacPkbdAlgorithm = super.generatePkbdAlgorithmIdentifier(var1_2.getStorePBKDFConfig(), 64);
                        this.storeEncryptionAlgorithm = var1_2.getStoreEncryptionAlgorithm() == BCFKSLoadStoreParameter.EncryptionAlgorithm.AES256_CCM ? NISTObjectIdentifiers.id_aes256_CCM : NISTObjectIdentifiers.id_aes256_wrap_pad;
                        if (var1_2.getStoreMacAlgorithm() == BCFKSLoadStoreParameter.MacAlgorithm.HmacSHA512) {
                            var3_6 = v16;
                            v16 = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
                            this.hmacAlgorithm = var3_6;
                        } else {
                            var3_7 = v17;
                            v17 = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
                            this.hmacAlgorithm = var3_7;
                        }
                        this.engineStore(var1_2.getOutputStream(), var2_4);
                        break block25;
                    }
                    if (!(var1_2 instanceof BCLoadStoreParameter)) break block28;
                    v18 = this;
                    v19 = var1_2;
                    this = ((BCLoadStoreParameter)v19).getOutputStream();
                    v18.engineStore((OutputStream)this, super.extractPassword((KeyStore.LoadStoreParameter)v19));
                }
                return;
            }
            throw new IllegalArgumentException(b.a("no support for 'parameter' of type ").append(var1_2.getClass().getName()).toString());
        }
        throw new IllegalArgumentException("'parameter' arg cannot be null");
    }

    @Override
    public void engineStore(OutputStream object, char[] object2) {
        if (((BcFKSKeyStoreSpi)((Object)algorithmIdentifier)).creationDate != null) {
            ObjectStoreIntegrityCheck objectStoreIntegrityCheck;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi2;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi3;
            OutputStream outputStream;
            OutputStream outputStream2;
            ASN1Object aSN1Object;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi4 = algorithmIdentifier;
            EncryptedObjectStoreData encryptedObjectStoreData = bcFKSKeyStoreSpi4.getEncryptedObjectStoreData(bcFKSKeyStoreSpi4.hmacAlgorithm, (char[])object2);
            if (MiscObjectIdentifiers.id_scrypt.equals(((BcFKSKeyStoreSpi)((Object)algorithmIdentifier)).hmacPkbdAlgorithm.getAlgorithm())) {
                BcFKSKeyStoreSpi bcFKSKeyStoreSpi5 = algorithmIdentifier;
                aSN1Object = ScryptParams.getInstance(bcFKSKeyStoreSpi5.hmacPkbdAlgorithm.getParameters());
                bcFKSKeyStoreSpi5.hmacPkbdAlgorithm = bcFKSKeyStoreSpi5.generatePkbdAlgorithmIdentifier(bcFKSKeyStoreSpi5.hmacPkbdAlgorithm, ((ScryptParams)aSN1Object).getKeyLength().intValue());
            } else {
                BcFKSKeyStoreSpi bcFKSKeyStoreSpi6 = algorithmIdentifier;
                aSN1Object = PBKDF2Params.getInstance(bcFKSKeyStoreSpi6.hmacPkbdAlgorithm.getParameters());
                bcFKSKeyStoreSpi6.hmacPkbdAlgorithm = bcFKSKeyStoreSpi6.generatePkbdAlgorithmIdentifier(bcFKSKeyStoreSpi6.hmacPkbdAlgorithm, ((PBKDF2Params)aSN1Object).getKeyLength().intValue());
            }
            try {
                OutputStream outputStream3 = object;
                outputStream2 = outputStream3;
                outputStream = outputStream3;
                BcFKSKeyStoreSpi bcFKSKeyStoreSpi7 = algorithmIdentifier;
                bcFKSKeyStoreSpi3 = bcFKSKeyStoreSpi7;
                bcFKSKeyStoreSpi2 = bcFKSKeyStoreSpi7;
                bcFKSKeyStoreSpi = bcFKSKeyStoreSpi7;
                object = encryptedObjectStoreData.getEncoded();
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new IOException(b.a("cannot calculate mac: ").append(noSuchProviderException.getMessage()).toString());
            }
            aSN1Object = bcFKSKeyStoreSpi2.hmacAlgorithm;
            KeyDerivationFunc keyDerivationFunc = bcFKSKeyStoreSpi.hmacPkbdAlgorithm;
            object = bcFKSKeyStoreSpi3.calculateMac((byte[])object, (AlgorithmIdentifier)aSN1Object, keyDerivationFunc, (char[])object2);
            object2 = objectStoreIntegrityCheck;
            BcFKSKeyStoreSpi bcFKSKeyStoreSpi8 = algorithmIdentifier;
            AlgorithmIdentifier algorithmIdentifier = bcFKSKeyStoreSpi8.hmacAlgorithm;
            objectStoreIntegrityCheck = new ObjectStoreIntegrityCheck(new PbkdMacIntegrityCheck(algorithmIdentifier, bcFKSKeyStoreSpi8.hmacPkbdAlgorithm, (byte[])object));
            outputStream2.write(new ObjectStore(encryptedObjectStoreData, (ObjectStoreIntegrityCheck)object2).getEncoded());
            outputStream.flush();
            return;
        }
        throw new IOException("KeyStore not initialized");
    }

    @Override
    public void engineLoad(KeyStore.LoadStoreParameter object) {
        block8: {
            block11: {
                block10: {
                    block9: {
                        Object object2;
                        if (object == null) break block8;
                        if (!(object instanceof BCFKSLoadStoreParameter)) break block9;
                        BcFKSKeyStoreSpi bcFKSKeyStoreSpi = inputStream;
                        object = (BCFKSLoadStoreParameter)object;
                        char[] cArray = bcFKSKeyStoreSpi.extractPassword((KeyStore.LoadStoreParameter)object);
                        bcFKSKeyStoreSpi.hmacPkbdAlgorithm = bcFKSKeyStoreSpi.generatePkbdAlgorithmIdentifier(((BCFKSLoadStoreParameter)object).getStorePBKDFConfig(), 64);
                        ((BcFKSKeyStoreSpi)((Object)inputStream)).storeEncryptionAlgorithm = ((BCFKSLoadStoreParameter)object).getStoreEncryptionAlgorithm() == BCFKSLoadStoreParameter.EncryptionAlgorithm.AES256_CCM ? NISTObjectIdentifiers.id_aes256_CCM : NISTObjectIdentifiers.id_aes256_wrap_pad;
                        if (((BCFKSLoadStoreParameter)object).getStoreMacAlgorithm() == BCFKSLoadStoreParameter.MacAlgorithm.HmacSHA512) {
                            AlgorithmIdentifier algorithmIdentifier;
                            object2 = algorithmIdentifier;
                            algorithmIdentifier = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
                            ((BcFKSKeyStoreSpi)((Object)inputStream)).hmacAlgorithm = object2;
                        } else {
                            AlgorithmIdentifier algorithmIdentifier;
                            object2 = algorithmIdentifier;
                            algorithmIdentifier = new AlgorithmIdentifier(NISTObjectIdentifiers.id_hmacWithSHA3_512, DERNull.INSTANCE);
                            ((BcFKSKeyStoreSpi)((Object)inputStream)).hmacAlgorithm = object2;
                        }
                        Object object3 = inputStream;
                        ((BcFKSKeyStoreSpi)((Object)inputStream)).verificationKey = (PublicKey)((BCFKSLoadStoreParameter)object).getStoreSignatureKey();
                        ((BcFKSKeyStoreSpi)((Object)inputStream)).validator = ((BCFKSLoadStoreParameter)object).getCertChainValidator();
                        object2 = ((BcFKSKeyStoreSpi)((Object)inputStream)).verificationKey;
                        ((BcFKSKeyStoreSpi)object3).signatureAlgorithm = super.generateSignatureAlgId((Key)object2, ((BCFKSLoadStoreParameter)object).getStoreSignatureAlgorithm());
                        object2 = ((BcFKSKeyStoreSpi)object3).storeEncryptionAlgorithm;
                        InputStream inputStream = ((BCLoadStoreParameter)object).getInputStream();
                        ((BcFKSKeyStoreSpi)((Object)inputStream)).engineLoad(inputStream, cArray);
                        if (inputStream != null) {
                            Object object4 = inputStream;
                            if (!super.isSimilarHmacPbkd((PBKDFConfig)(object = ((BCFKSLoadStoreParameter)object).getStorePBKDFConfig()), ((BcFKSKeyStoreSpi)object4).hmacPkbdAlgorithm) || !((ASN1Primitive)object2).equals(((BcFKSKeyStoreSpi)((Object)inputStream)).storeEncryptionAlgorithm)) {
                                throw new IOException("configuration parameters do not match existing store");
                            }
                        }
                        break block10;
                    }
                    if (!(object instanceof BCLoadStoreParameter)) break block11;
                    BcFKSKeyStoreSpi bcFKSKeyStoreSpi = inputStream;
                    KeyStore.LoadStoreParameter loadStoreParameter = object;
                    InputStream inputStream = ((BCLoadStoreParameter)loadStoreParameter).getInputStream();
                    bcFKSKeyStoreSpi.engineLoad(inputStream, bcFKSKeyStoreSpi.extractPassword(loadStoreParameter));
                }
                return;
            }
            throw new IllegalArgumentException(b.a("no support for 'parameter' of type ").append(object.getClass().getName()).toString());
        }
        throw new IllegalArgumentException("'parameter' arg cannot be null");
    }

    /*
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void engineLoad(InputStream iterator, char[] object) {
        block23: {
            void var5_10;
            PublicKey publicKey;
            Object object2;
            AlgorithmIdentifier algorithmIdentifier;
            Object object3;
            block22: {
                block21: {
                    BcFKSKeyStoreSpi bcFKSKeyStoreSpi = date2;
                    bcFKSKeyStoreSpi.entries.clear();
                    bcFKSKeyStoreSpi.privateKeyCache.clear();
                    bcFKSKeyStoreSpi.creationDate = null;
                    bcFKSKeyStoreSpi.lastModifiedDate = null;
                    bcFKSKeyStoreSpi.hmacAlgorithm = null;
                    if (iterator == null) {
                        Date date;
                        BcFKSKeyStoreSpi bcFKSKeyStoreSpi2 = date2;
                        Date date2 = date;
                        bcFKSKeyStoreSpi2.creationDate = new Date();
                        bcFKSKeyStoreSpi2.lastModifiedDate = date2;
                        bcFKSKeyStoreSpi2.verificationKey = null;
                        bcFKSKeyStoreSpi2.validator = null;
                        bcFKSKeyStoreSpi2.hmacAlgorithm = new AlgorithmIdentifier(PKCSObjectIdentifiers.id_hmacWithSHA512, DERNull.INSTANCE);
                        bcFKSKeyStoreSpi2.hmacPkbdAlgorithm = bcFKSKeyStoreSpi2.generatePkbdAlgorithmIdentifier(PKCSObjectIdentifiers.id_PBKDF2, 64);
                        return;
                    }
                    iterator = ObjectStore.getInstance(new ASN1InputStream((InputStream)((Object)iterator)).readObject());
                    object3 = ((ObjectStore)((Object)iterator)).getIntegrityCheck();
                    if (((ObjectStoreIntegrityCheck)object3).getType() != 0) break block21;
                    object3 = PbkdMacIntegrityCheck.getInstance(((ObjectStoreIntegrityCheck)object3).getIntegrityCheck());
                    ((BcFKSKeyStoreSpi)((Object)date2)).hmacAlgorithm = ((PbkdMacIntegrityCheck)object3).getMacAlgorithm();
                    ((BcFKSKeyStoreSpi)((Object)date2)).hmacPkbdAlgorithm = ((PbkdMacIntegrityCheck)object3).getPbkdAlgorithm();
                    algorithmIdentifier = ((BcFKSKeyStoreSpi)((Object)date2)).hmacAlgorithm;
                    try {
                        super.verifyMac(((ObjectStore)((Object)iterator)).getStoreData().toASN1Primitive().getEncoded(), (PbkdMacIntegrityCheck)object3, (char[])object);
                    }
                    catch (NoSuchProviderException noSuchProviderException) {
                        throw new IOException(noSuchProviderException.getMessage());
                    }
                }
                if (((ObjectStoreIntegrityCheck)object3).getType() != 1) {
                    throw new IOException("BCFKS KeyStore unable to recognize integrity check.");
                }
                object3 = SignatureCheck.getInstance(((ObjectStoreIntegrityCheck)object3).getIntegrityCheck());
                algorithmIdentifier = ((SignatureCheck)object3).getSignatureAlgorithm();
                Certificate[] certificateArray = ((SignatureCheck)object3).getCertificates();
                if (((BcFKSKeyStoreSpi)((Object)date2)).validator != null) {
                    if (certificateArray != null) {
                        object2 = ((BcFKSKeyStoreSpi)((Object)date2)).helper.createCertificateFactory("X.509");
                        int n3 = certificateArray.length;
                        X509Certificate[] x509CertificateArray = new X509Certificate[n3];
                        for (int i3 = 0; i3 != n3; ++i3) {
                            x509CertificateArray[i3] = (X509Certificate)((CertificateFactory)object2).generateCertificate(new ByteArrayInputStream(certificateArray[i3].getEncoded()));
                        }
                        if (!((BcFKSKeyStoreSpi)((Object)date2)).validator.isValid(x509CertificateArray)) {
                            throw new IOException("certificate chain in key store signature not valid");
                        }
                        ASN1Encodable aSN1Encodable = ((ObjectStore)((Object)iterator)).getStoreData();
                        publicKey = x509CertificateArray[0].getPublicKey();
                        break block22;
                    } else {
                        throw new IOException("validator specified but no certifcates in store");
                    }
                }
                ASN1Encodable aSN1Encodable = ((ObjectStore)((Object)iterator)).getStoreData();
                publicKey = ((BcFKSKeyStoreSpi)((Object)date2)).verificationKey;
            }
            object2 = publicKey;
            super.verifySig((ASN1Encodable)var5_10, (SignatureCheck)object3, (PublicKey)object2);
            iterator = ((ObjectStore)((Object)iterator)).getStoreData();
            if (iterator instanceof EncryptedObjectStoreData) {
                EncryptedObjectStoreData encryptedObjectStoreData = (EncryptedObjectStoreData)((Object)iterator);
                iterator = encryptedObjectStoreData.getEncryptionAlgorithm();
                object3 = encryptedObjectStoreData.getEncryptedContent().getOctets();
                iterator = ObjectStoreData.getInstance(super.decryptData("STORE_ENCRYPTION", (AlgorithmIdentifier)((Object)iterator), (char[])object, (byte[])object3));
            } else {
                iterator = ObjectStoreData.getInstance(iterator);
            }
            try {
                ((BcFKSKeyStoreSpi)((Object)date2)).creationDate = ((ObjectStoreData)((Object)iterator)).getCreationDate().getDate();
                ((BcFKSKeyStoreSpi)((Object)date2)).lastModifiedDate = ((ObjectStoreData)((Object)iterator)).getLastModifiedDate().getDate();
                if (!((ObjectStoreData)((Object)iterator)).getIntegrityAlgorithm().equals(algorithmIdentifier)) break block23;
                iterator = ((ObjectStoreData)((Object)iterator)).getObjectDataSequence().iterator();
            }
            catch (ParseException parseException) {
                throw new IOException("BCFKS KeyStore unable to parse store data information.");
            }
            while (true) {
                if (!iterator.hasNext()) {
                    return;
                }
                object = ObjectData.getInstance(iterator.next());
                ((BcFKSKeyStoreSpi)((Object)date2)).entries.put(((ObjectData)object).getIdentifier(), (ObjectData)object);
            }
        }
        throw new IOException("BCFKS KeyStore storeData integrity algorithm does not match store integrity algorithm.");
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException(b.a("error verifying signature: ").append(generalSecurityException.getMessage()).toString(), generalSecurityException);
        }
        catch (Exception exception) {
            throw new IOException(exception.getMessage());
        }
    }

    public static class ExtKeyStoreException
    extends KeyStoreException {
        private final Throwable cause;

        public ExtKeyStoreException(String string2, Throwable throwable) {
            super(string2);
            this.cause = throwable;
        }

        @Override
        public Throwable getCause() {
            return this.cause;
        }
    }

    public static class DefShared
    extends SharedKeyStoreSpi {
        public DefShared() {
            DefaultJcaJceHelper defaultJcaJceHelper;
            DefShared defShared = defaultJcaJceHelper2;
            DefaultJcaJceHelper defaultJcaJceHelper2 = defaultJcaJceHelper;
            defaultJcaJceHelper = new DefaultJcaJceHelper();
            super(defaultJcaJceHelper2);
        }
    }

    public static class StdShared
    extends SharedKeyStoreSpi {
        public StdShared() {
            BCJcaJceHelper bCJcaJceHelper;
            StdShared stdShared = bCJcaJceHelper2;
            BCJcaJceHelper bCJcaJceHelper2 = bCJcaJceHelper;
            bCJcaJceHelper = new BCJcaJceHelper();
            super(bCJcaJceHelper2);
        }
    }

    public static class SharedKeyStoreSpi
    extends BcFKSKeyStoreSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private final Map<String, byte[]> cache;
        private final byte[] seedKey;

        public SharedKeyStoreSpi(JcaJceHelper object) {
            byte[] byArray;
            JcaJceHelper jcaJceHelper = object;
            super((JcaJceHelper)object);
            try {
                byArray = new byte[32];
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IllegalArgumentException(b.a("can't create random - ").append(((Object)generalSecurityException).toString()).toString());
            }
            object = byArray;
            this.seedKey = byArray;
            jcaJceHelper.createSecureRandom("DEFAULT").nextBytes((byte[])object);
            this.cache = new HashMap<String, byte[]>();
        }

        private byte[] calculateMac(String string2, char[] cArray) {
            return SCrypt.generate(cArray != null ? Arrays.concatenate(Strings.toUTF8ByteArray(cArray), Strings.toUTF8ByteArray(string2)) : Arrays.concatenate(this.seedKey, Strings.toUTF8ByteArray(string2)), this.seedKey, 16384, 8, 1, 32);
        }

        @Override
        public void engineDeleteEntry(String string2) {
            throw new KeyStoreException("delete operation not supported in shared mode");
        }

        @Override
        public void engineSetKeyEntry(String string2, Key key, char[] cArray, java.security.cert.Certificate[] certificateArray) {
            throw new KeyStoreException("set operation not supported in shared mode");
        }

        @Override
        public void engineSetKeyEntry(String string2, byte[] byArray, java.security.cert.Certificate[] certificateArray) {
            throw new KeyStoreException("set operation not supported in shared mode");
        }

        @Override
        public void engineSetCertificateEntry(String string2, java.security.cert.Certificate certificate) {
            throw new KeyStoreException("set operation not supported in shared mode");
        }

        @Override
        public Key engineGetKey(String string2, char[] object) {
            byte[] byArray;
            SharedKeyStoreSpi sharedKeyStoreSpi;
            try {
                sharedKeyStoreSpi = this;
                byArray = sharedKeyStoreSpi.calculateMac(string2, (char[])object);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new UnrecoverableKeyException("unable to recover key (" + string2 + "): " + invalidKeyException.getMessage());
            }
            if (sharedKeyStoreSpi.cache.containsKey(string2) && !Arrays.constantTimeAreEqual(this.cache.get(string2), byArray)) {
                throw new UnrecoverableKeyException(g.a("unable to recover key (", string2, ")"));
            }
            Key key = super.engineGetKey(string2, (char[])object);
            object = key;
            if (key != null && !this.cache.containsKey(string2)) {
                this.cache.put(string2, byArray);
            }
            return object;
        }
    }

    public static class Def
    extends BcFKSKeyStoreSpi {
        public Def() {
            DefaultJcaJceHelper defaultJcaJceHelper;
            Def def = defaultJcaJceHelper2;
            DefaultJcaJceHelper defaultJcaJceHelper2 = defaultJcaJceHelper;
            defaultJcaJceHelper = new DefaultJcaJceHelper();
            super(defaultJcaJceHelper2);
        }
    }

    public static class Std
    extends BcFKSKeyStoreSpi {
        public Std() {
            BCJcaJceHelper bCJcaJceHelper;
            Std std = bCJcaJceHelper2;
            BCJcaJceHelper bCJcaJceHelper2 = bCJcaJceHelper;
            bCJcaJceHelper = new BCJcaJceHelper();
            super(bCJcaJceHelper2);
        }
    }
}

