/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.rosstandart.RosstandartObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.BufferedBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.CryptoProWrapEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.GOST28147Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.GOST28147WrapEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.GOST28147Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.GCFBBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.spec.IvParameterSpec;

public final class GOST28147 {
    private static Map<ASN1ObjectIdentifier, String> oidMappings = new HashMap<ASN1ObjectIdentifier, String>();
    private static Map<String, ASN1ObjectIdentifier> nameMappings = new HashMap<String, ASN1ObjectIdentifier>();

    private GOST28147() {
    }

    static {
        oidMappings.put(CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_TestParamSet, "E-TEST");
        ASN1ObjectIdentifier aSN1ObjectIdentifier = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet;
        oidMappings.put(aSN1ObjectIdentifier, "E-A");
        ASN1ObjectIdentifier aSN1ObjectIdentifier2 = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_B_ParamSet;
        oidMappings.put(aSN1ObjectIdentifier2, "E-B");
        ASN1ObjectIdentifier aSN1ObjectIdentifier3 = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_C_ParamSet;
        oidMappings.put(aSN1ObjectIdentifier3, "E-C");
        ASN1ObjectIdentifier aSN1ObjectIdentifier4 = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_D_ParamSet;
        oidMappings.put(aSN1ObjectIdentifier4, "E-D");
        ASN1ObjectIdentifier aSN1ObjectIdentifier5 = RosstandartObjectIdentifiers.id_tc26_gost_28147_param_Z;
        oidMappings.put(aSN1ObjectIdentifier5, "PARAM-Z");
        nameMappings.put("E-A", aSN1ObjectIdentifier);
        nameMappings.put("E-B", aSN1ObjectIdentifier2);
        nameMappings.put("E-C", aSN1ObjectIdentifier3);
        nameMappings.put("E-D", aSN1ObjectIdentifier4);
        nameMappings.put("PARAM-Z", aSN1ObjectIdentifier5);
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = GOST28147.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            StringBuilder stringBuilder;
            Object object = stringBuilder;
            stringBuilder = new StringBuilder();
            String string2 = PREFIX;
            ConfigurableProvider configurableProvider2 = configurableProvider;
            d.a((StringBuilder)object, string2, "$ECB", configurableProvider, "Cipher.GOST28147");
            object = CryptoProObjectIdentifiers.gostR28147_gcfb;
            String string3 = com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider, "Alg.Alias.Cipher.GOST", "GOST28147", "Alg.Alias.Cipher.GOST-28147", "GOST28147").append("Cipher.").append(object).toString();
            e.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.e.a(string2, "$GCFB", configurableProvider, string3, string2), "$KeyGen", configurableProvider, "KeyGenerator.GOST28147");
            configurableProvider2.addAlgorithm(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider2, "Alg.Alias.KeyGenerator.GOST", "GOST28147", "Alg.Alias.KeyGenerator.GOST-28147", "GOST28147").append("Alg.Alias.KeyGenerator.").append(object).toString(), "GOST28147");
            configurableProvider2.addAlgorithm(b.a(b.a(new StringBuilder(), string2, "$AlgParams", configurableProvider, "AlgorithmParameters.GOST28147"), string2, "$AlgParamGen", configurableProvider, "AlgorithmParameterGenerator.GOST28147").append("Alg.Alias.AlgorithmParameters.").append(object).toString(), "GOST28147");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameterGenerator." + object, "GOST28147");
            object = "Cipher." + CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_KeyWrap;
            object = com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.e.a(string2, "$CryptoProWrap", configurableProvider, (String)object, "Cipher.").append(CryptoProObjectIdentifiers.id_Gost28147_89_None_KeyWrap).toString();
            e.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.e.a(string2, "$GostWrap", configurableProvider, (String)object, string2), "$Mac", configurableProvider, "Mac.GOST28147MAC");
            configurableProvider.addAlgorithm("Alg.Alias.Mac.GOST28147", "GOST28147MAC");
        }
    }

    public static class AlgParams
    extends BaseAlgParams {
        private ASN1ObjectIdentifier sBox = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet;
        private byte[] iv;

        @Override
        public byte[] localGetEncoded() {
            AlgParams algParams = object;
            Object object = algParams.iv;
            return new GOST28147Parameters((byte[])object, algParams.sBox).getEncoded();
        }

        @Override
        public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
            if (clazz == IvParameterSpec.class) {
                return new IvParameterSpec(((AlgParams)((Object)aSN1ObjectIdentifier)).iv);
            }
            if (clazz != GOST28147ParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
                throw new InvalidParameterSpecException(b.b.a("AlgorithmParameterSpec not recognized: ").append(clazz.getName()).toString());
            }
            AlgParams algParams = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algParams.sBox;
            return new GOST28147ParameterSpec(aSN1ObjectIdentifier, algParams.iv);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                return;
            }
            if (!(algorithmParameterSpec instanceof GOST28147ParameterSpec)) throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            this.iv = ((GOST28147ParameterSpec)algorithmParameterSpec).getIV();
            try {
                this.sBox = BaseAlgParams.getSBoxOID(((GOST28147ParameterSpec)algorithmParameterSpec).getSBox());
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidParameterSpecException(illegalArgumentException.getMessage());
            }
        }

        @Override
        public void localInit(byte[] object) {
            block4: {
                block3: {
                    block2: {
                        ASN1Primitive aSN1Primitive = ASN1Primitive.fromByteArray(object);
                        object = aSN1Primitive;
                        if (!(aSN1Primitive instanceof ASN1OctetString)) break block2;
                        ((AlgParams)((Object)gOST28147Parameters)).iv = ASN1OctetString.getInstance(object).getOctets();
                        break block3;
                    }
                    if (!(object instanceof ASN1Sequence)) break block4;
                    AlgParams algParams = gOST28147Parameters;
                    GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(object);
                    algParams.sBox = gOST28147Parameters.getEncryptionParamSet();
                    algParams.iv = gOST28147Parameters.getIV();
                }
                return;
            }
            throw new IOException("Unable to recognize parameters");
        }

        @Override
        public String engineToString() {
            return "GOST 28147 IV Parameters";
        }
    }

    public static abstract class BaseAlgParams
    extends BaseAlgorithmParameters {
        private ASN1ObjectIdentifier sBox = CryptoProObjectIdentifiers.id_Gost28147_89_CryptoPro_A_ParamSet;
        private byte[] iv;

        public static ASN1ObjectIdentifier getSBoxOID(String string2) {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = null;
            if (string2 != null) {
                aSN1ObjectIdentifier = (ASN1ObjectIdentifier)nameMappings.get(Strings.toUpperCase(string2));
            }
            if (aSN1ObjectIdentifier != null) {
                return aSN1ObjectIdentifier;
            }
            throw new IllegalArgumentException(i.a("Unknown SBOX name: ", string2));
        }

        public static ASN1ObjectIdentifier getSBoxOID(byte[] byArray) {
            return BaseAlgParams.getSBoxOID(GOST28147Engine.getSBoxName(byArray));
        }

        @Override
        public final void engineInit(byte[] byArray) {
            this.engineInit(byArray, "ASN.1");
        }

        @Override
        public final byte[] engineGetEncoded() {
            return this.engineGetEncoded("ASN.1");
        }

        @Override
        public final byte[] engineGetEncoded(String string2) {
            if (this.isASN1FormatString(string2)) {
                return this.localGetEncoded();
            }
            throw new IOException(i.a("Unknown parameter format: ", string2));
        }

        @Override
        public final void engineInit(byte[] byArray, String string2) {
            if (byArray != null) {
                if (this.isASN1FormatString(string2)) {
                    try {
                        this.localInit(byArray);
                        return;
                    }
                    catch (Exception exception) {
                        throw new IOException(a.a(exception, b.b.a("Parameter parsing failed: ")));
                    }
                    catch (IOException iOException) {
                        throw iOException;
                    }
                }
                throw new IOException(i.a("Unknown parameter format: ", string2));
            }
            throw new NullPointerException("Encoded parameters cannot be null");
        }

        public byte[] localGetEncoded() {
            BaseAlgParams baseAlgParams = object;
            Object object = baseAlgParams.iv;
            return new GOST28147Parameters((byte[])object, baseAlgParams.sBox).getEncoded();
        }

        @Override
        public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
            if (clazz == IvParameterSpec.class) {
                return new IvParameterSpec(((BaseAlgParams)((Object)aSN1ObjectIdentifier)).iv);
            }
            if (clazz != GOST28147ParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
                throw new InvalidParameterSpecException(b.b.a("AlgorithmParameterSpec not recognized: ").append(clazz.getName()).toString());
            }
            BaseAlgParams baseAlgParams = aSN1ObjectIdentifier;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = baseAlgParams.sBox;
            return new GOST28147ParameterSpec(aSN1ObjectIdentifier, baseAlgParams.iv);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
            if (algorithmParameterSpec instanceof IvParameterSpec) {
                this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                return;
            }
            if (!(algorithmParameterSpec instanceof GOST28147ParameterSpec)) throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
            this.iv = ((GOST28147ParameterSpec)algorithmParameterSpec).getIV();
            try {
                this.sBox = BaseAlgParams.getSBoxOID(((GOST28147ParameterSpec)algorithmParameterSpec).getSBox());
                return;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InvalidParameterSpecException(illegalArgumentException.getMessage());
            }
        }

        public abstract void localInit(byte[] var1);
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        public byte[] iv = new byte[8];
        public byte[] sBox = GOST28147Engine.getSBox("E-A");

        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
            if (algorithmParameterSpec instanceof GOST28147ParameterSpec) {
                this.sBox = ((GOST28147ParameterSpec)algorithmParameterSpec).getSBox();
                return;
            }
            throw new InvalidAlgorithmParameterException("parameter spec not supported");
        }

        @Override
        public AlgorithmParameters engineGenerateParameters() {
            AlgParamGen algParamGen;
            GOST28147ParameterSpec gOST28147ParameterSpec;
            GOST28147ParameterSpec gOST28147ParameterSpec2;
            AlgorithmParameters algorithmParameters;
            AlgorithmParameters algorithmParameters2;
            if (((BaseAlgorithmParameterGenerator)object).random == null) {
                ((BaseAlgorithmParameterGenerator)object).random = CryptoServicesRegistrar.getSecureRandom();
            }
            AlgParamGen algParamGen2 = object;
            algParamGen2.random.nextBytes(((AlgParamGen)object).iv);
            try {
                GOST28147ParameterSpec gOST28147ParameterSpec3;
                AlgorithmParameters algorithmParameters3 = algParamGen2.createParametersInstance("GOST28147");
                algorithmParameters2 = algorithmParameters3;
                algorithmParameters = algorithmParameters3;
                gOST28147ParameterSpec2 = gOST28147ParameterSpec3;
                gOST28147ParameterSpec = gOST28147ParameterSpec3;
                AlgParamGen algParamGen3 = object;
                algParamGen = algParamGen3;
                Object object = algParamGen3.sBox;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            gOST28147ParameterSpec2((byte[])object, algParamGen.iv);
            algorithmParameters2.init(gOST28147ParameterSpec);
            return algorithmParameters;
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            this(256);
        }

        public KeyGen(int n3) {
            CipherKeyGenerator cipherKeyGenerator;
            KeyGen keyGen = cipherKeyGenerator2;
            CipherKeyGenerator cipherKeyGenerator2 = cipherKeyGenerator;
            cipherKeyGenerator = new CipherKeyGenerator();
            super("GOST28147", n3, cipherKeyGenerator2);
        }
    }

    public static class Mac
    extends BaseMac {
        public Mac() {
            GOST28147Mac gOST28147Mac;
            Mac mac = gOST28147Mac2;
            GOST28147Mac gOST28147Mac2 = gOST28147Mac;
            gOST28147Mac = new GOST28147Mac();
            super(gOST28147Mac2);
        }
    }

    public static class CryptoProWrap
    extends BaseWrapCipher {
        public CryptoProWrap() {
            CryptoProWrapEngine cryptoProWrapEngine;
            CryptoProWrap cryptoProWrap = cryptoProWrapEngine2;
            CryptoProWrapEngine cryptoProWrapEngine2 = cryptoProWrapEngine;
            cryptoProWrapEngine = new CryptoProWrapEngine();
            super(cryptoProWrapEngine2);
        }
    }

    public static class GostWrap
    extends BaseWrapCipher {
        public GostWrap() {
            GOST28147WrapEngine gOST28147WrapEngine;
            GostWrap gostWrap = gOST28147WrapEngine2;
            GOST28147WrapEngine gOST28147WrapEngine2 = gOST28147WrapEngine;
            gOST28147WrapEngine = new GOST28147WrapEngine();
            super(gOST28147WrapEngine2);
        }
    }

    public static class GCFB
    extends BaseBlockCipher {
        public GCFB() {
            GOST28147Engine gOST28147Engine;
            GCFBBlockCipher gCFBBlockCipher;
            BufferedBlockCipher bufferedBlockCipher;
            GCFB gCFB = bufferedBlockCipher2;
            BufferedBlockCipher bufferedBlockCipher2 = bufferedBlockCipher;
            GCFBBlockCipher gCFBBlockCipher2 = gCFBBlockCipher;
            GOST28147Engine gOST28147Engine2 = gOST28147Engine;
            gOST28147Engine = new GOST28147Engine();
            gCFBBlockCipher = new GCFBBlockCipher(gOST28147Engine2);
            bufferedBlockCipher = new BufferedBlockCipher(gCFBBlockCipher2);
            super(bufferedBlockCipher2, 64);
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            GOST28147Engine gOST28147Engine;
            CBCBlockCipher cBCBlockCipher;
            CBC cBC = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            GOST28147Engine gOST28147Engine2 = gOST28147Engine;
            gOST28147Engine = new GOST28147Engine();
            cBCBlockCipher = new CBCBlockCipher(gOST28147Engine2);
            super(cBCBlockCipher2, 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            GOST28147Engine gOST28147Engine;
            ECB eCB = gOST28147Engine2;
            GOST28147Engine gOST28147Engine2 = gOST28147Engine;
            gOST28147Engine = new GOST28147Engine();
            super(gOST28147Engine2);
        }
    }
}

