/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.RC2CBCParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RC2Engine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.engines.RC2WrapEngine;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.CBCBlockCipherMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.CFBBlockCipherMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.modes.CBCBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.d;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.f;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameterGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseWrapCipher;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.PBESecretKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public final class RC2 {
    private RC2() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = RC2.class.getName();

        @Override
        public void configure(ConfigurableProvider configurableProvider) {
            ConfigurableProvider configurableProvider2 = configurableProvider;
            String string2 = PREFIX;
            d.a(b.a(b.a(b.a(b.a(b.a(b.a(b.a(new StringBuilder(), string2, "$AlgParamGen", configurableProvider, "AlgorithmParameterGenerator.RC2"), string2, "$AlgParamGen", configurableProvider, "AlgorithmParameterGenerator.1.2.840.113549.3.2"), string2, "$KeyGenerator", configurableProvider, "KeyGenerator.RC2"), string2, "$KeyGenerator", configurableProvider, "KeyGenerator.1.2.840.113549.3.2"), string2, "$AlgParams", configurableProvider, "AlgorithmParameters.RC2"), string2, "$AlgParams", configurableProvider, "AlgorithmParameters.1.2.840.113549.3.2"), string2, "$ECB", configurableProvider, "Cipher.RC2"), string2, "$Wrap", configurableProvider, "Cipher.RC2WRAP");
            configurableProvider2.addAlgorithm("Alg.Alias.Cipher", PKCSObjectIdentifiers.id_alg_CMSRC2wrap, "RC2WRAP");
            Object object = (String)string2 + "$CBC";
            configurableProvider2.addAlgorithm("Cipher", PKCSObjectIdentifiers.RC2_CBC, (String)object);
            d.a(new StringBuilder(), string2, "$CBCMAC", configurableProvider, "Mac.RC2MAC");
            configurableProvider2.addAlgorithm("Mac.RC2MAC/CFB8", f.a(configurableProvider2, "Alg.Alias.Mac.RC2", "RC2MAC", string2, "$CFB8MAC"));
            configurableProvider2.addAlgorithm("Alg.Alias.Mac.RC2/CFB8", "RC2MAC/CFB8");
            configurableProvider2.addAlgorithm("Alg.Alias.SecretKeyFactory.PBEWITHMD2ANDRC2-CBC", "PBEWITHMD2ANDRC2");
            configurableProvider2.addAlgorithm("Alg.Alias.SecretKeyFactory.PBEWITHMD5ANDRC2-CBC", "PBEWITHMD5ANDRC2");
            configurableProvider2.addAlgorithm("Alg.Alias.SecretKeyFactory.PBEWITHSHA1ANDRC2-CBC", "PBEWITHSHA1ANDRC2");
            object = PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC;
            configurableProvider2.addAlgorithm("Alg.Alias.SecretKeyFactory", (ASN1ObjectIdentifier)object, "PBEWITHMD2ANDRC2");
            ASN1ObjectIdentifier aSN1ObjectIdentifier = PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC;
            configurableProvider2.addAlgorithm("Alg.Alias.SecretKeyFactory", aSN1ObjectIdentifier, "PBEWITHMD5ANDRC2");
            ASN1ObjectIdentifier aSN1ObjectIdentifier2 = PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC;
            configurableProvider2.addAlgorithm("Alg.Alias.SecretKeyFactory", aSN1ObjectIdentifier2, "PBEWITHSHA1ANDRC2");
            d.a(b.a(b.a(b.a(b.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider2, "Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.5", "PBEWITHSHAAND128BITRC2-CBC", "Alg.Alias.SecretKeyFactory.1.2.840.113549.1.12.1.6", "PBEWITHSHAAND40BITRC2-CBC"), string2, "$PBEWithMD2KeyFactory", configurableProvider, "SecretKeyFactory.PBEWITHMD2ANDRC2"), string2, "$PBEWithMD5KeyFactory", configurableProvider, "SecretKeyFactory.PBEWITHMD5ANDRC2"), string2, "$PBEWithSHA1KeyFactory", configurableProvider, "SecretKeyFactory.PBEWITHSHA1ANDRC2"), string2, "$PBEWithSHAAnd128BitKeyFactory", configurableProvider, "SecretKeyFactory.PBEWITHSHAAND128BITRC2-CBC"), string2, "$PBEWithSHAAnd40BitKeyFactory", configurableProvider, "SecretKeyFactory.PBEWITHSHAAND40BITRC2-CBC");
            configurableProvider2.addAlgorithm("Alg.Alias.Cipher", (ASN1ObjectIdentifier)object, "PBEWITHMD2ANDRC2");
            configurableProvider2.addAlgorithm("Alg.Alias.Cipher", aSN1ObjectIdentifier, "PBEWITHMD5ANDRC2");
            configurableProvider2.addAlgorithm("Alg.Alias.Cipher", aSN1ObjectIdentifier2, "PBEWITHSHA1ANDRC2");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.5", "PKCS12PBE");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.1.2.840.113549.1.12.1.6", "PKCS12PBE");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWithSHAAnd3KeyTripleDES", "PKCS12PBE");
            configurableProvider2.addAlgorithm("Alg.Alias.Cipher", PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, "PBEWITHSHAAND128BITRC2-CBC");
            configurableProvider2.addAlgorithm("Alg.Alias.Cipher", PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, "PBEWITHSHAAND40BITRC2-CBC");
            d.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider2, "Alg.Alias.Cipher.PBEWITHSHA1AND128BITRC2-CBC", "PBEWITHSHAAND128BITRC2-CBC", "Alg.Alias.Cipher.PBEWITHSHA1AND40BITRC2-CBC", "PBEWITHSHAAND40BITRC2-CBC"), string2, "$PBEWithSHA1AndRC2", configurableProvider, "Cipher.PBEWITHSHA1ANDRC2");
            d.a(b.a(b.a(com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.d.a(configurableProvider2, "Alg.Alias.Cipher.PBEWITHSHAANDRC2-CBC", "PBEWITHSHA1ANDRC2", "Alg.Alias.Cipher.PBEWITHSHA1ANDRC2-CBC", "PBEWITHSHA1ANDRC2"), string2, "$PBEWithSHAAnd128BitRC2", configurableProvider, "Cipher.PBEWITHSHAAND128BITRC2-CBC"), string2, "$PBEWithSHAAnd40BitRC2", configurableProvider, "Cipher.PBEWITHSHAAND40BITRC2-CBC"), string2, "$PBEWithMD5AndRC2", configurableProvider, "Cipher.PBEWITHMD5ANDRC2");
            configurableProvider2.addAlgorithm("Alg.Alias.Cipher.PBEWITHMD5ANDRC2-CBC", "PBEWITHMD5ANDRC2");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2", "PKCS12PBE");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAANDRC2", "PKCS12PBE");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHA1ANDRC2-CBC", "PKCS12PBE");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND40BITRC2-CBC", "PKCS12PBE");
            configurableProvider2.addAlgorithm("Alg.Alias.AlgorithmParameters.PBEWITHSHAAND128BITRC2-CBC", "PKCS12PBE");
        }
    }

    public static class AlgParams
    extends BaseAlgorithmParameters {
        private static final short[] table = new short[]{189, 86, 234, 242, 162, 241, 172, 42, 176, 147, 209, 156, 27, 51, 253, 208, 48, 4, 182, 220, 125, 223, 50, 75, 247, 203, 69, 155, 49, 187, 33, 90, 65, 159, 225, 217, 74, 77, 158, 218, 160, 104, 44, 195, 39, 95, 128, 54, 62, 238, 251, 149, 26, 254, 206, 168, 52, 169, 19, 240, 166, 63, 216, 12, 120, 36, 175, 35, 82, 193, 103, 23, 245, 102, 144, 231, 232, 7, 184, 96, 72, 230, 30, 83, 243, 146, 164, 114, 140, 8, 21, 110, 134, 0, 132, 250, 244, 127, 138, 66, 25, 246, 219, 205, 20, 141, 80, 18, 186, 60, 6, 78, 236, 179, 53, 17, 161, 136, 142, 43, 148, 153, 183, 113, 116, 211, 228, 191, 58, 222, 150, 14, 188, 10, 237, 119, 252, 55, 107, 3, 121, 137, 98, 198, 215, 192, 210, 124, 106, 139, 34, 163, 91, 5, 93, 2, 117, 213, 97, 227, 24, 143, 85, 81, 173, 31, 11, 94, 133, 229, 194, 87, 99, 202, 61, 108, 180, 197, 204, 112, 178, 145, 89, 13, 71, 32, 200, 79, 88, 224, 1, 226, 22, 56, 196, 111, 59, 15, 101, 70, 190, 126, 45, 123, 130, 249, 64, 181, 29, 115, 248, 235, 38, 199, 135, 151, 37, 84, 177, 40, 170, 152, 157, 165, 100, 109, 122, 212, 16, 129, 68, 239, 73, 214, 174, 46, 221, 118, 92, 47, 167, 28, 201, 9, 105, 154, 131, 207, 41, 57, 185, 233, 76, 255, 67, 171};
        private static final short[] ekb = new short[]{93, 190, 155, 139, 17, 153, 110, 77, 89, 243, 133, 166, 63, 183, 131, 197, 228, 115, 107, 58, 104, 90, 192, 71, 160, 100, 52, 12, 241, 208, 82, 165, 185, 30, 150, 67, 65, 216, 212, 44, 219, 248, 7, 119, 42, 202, 235, 239, 16, 28, 22, 13, 56, 114, 47, 137, 193, 249, 128, 196, 109, 174, 48, 61, 206, 32, 99, 254, 230, 26, 199, 184, 80, 232, 36, 23, 252, 37, 111, 187, 106, 163, 68, 83, 217, 162, 1, 171, 188, 182, 31, 152, 238, 154, 167, 45, 79, 158, 142, 172, 224, 198, 73, 70, 41, 244, 148, 138, 175, 225, 91, 195, 179, 123, 87, 209, 124, 156, 237, 135, 64, 140, 226, 203, 147, 20, 201, 97, 46, 229, 204, 246, 94, 168, 92, 214, 117, 141, 98, 149, 88, 105, 118, 161, 74, 181, 85, 9, 120, 51, 130, 215, 221, 121, 245, 27, 11, 222, 38, 33, 40, 116, 4, 151, 86, 223, 60, 240, 55, 57, 220, 255, 6, 164, 234, 66, 8, 218, 180, 113, 176, 207, 18, 122, 78, 250, 108, 29, 132, 0, 200, 127, 145, 69, 170, 43, 194, 177, 143, 213, 186, 242, 173, 25, 178, 103, 54, 247, 15, 10, 146, 125, 227, 157, 233, 144, 62, 35, 39, 102, 19, 236, 129, 21, 189, 34, 191, 159, 126, 169, 81, 75, 76, 251, 2, 211, 112, 134, 49, 231, 59, 5, 3, 84, 96, 72, 101, 24, 210, 205, 95, 50, 136, 14, 53, 253};
        private byte[] iv;
        private int parameterVersion = 58;

        @Override
        public byte[] engineGetEncoded() {
            return Arrays.clone(this.iv);
        }

        @Override
        public byte[] engineGetEncoded(String string2) {
            if (this.isASN1FormatString(string2)) {
                int n3 = this.parameterVersion;
                if (n3 == -1) {
                    return new RC2CBCParameter(this.engineGetEncoded()).getEncoded();
                }
                return new RC2CBCParameter(n3, this.engineGetEncoded()).getEncoded();
            }
            if (string2.equals("RAW")) {
                return this.engineGetEncoded();
            }
            return null;
        }

        @Override
        public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
            int n3;
            if ((clazz == RC2ParameterSpec.class || clazz == AlgorithmParameterSpec.class) && (n3 = this.parameterVersion) != -1) {
                if (n3 < 256) {
                    short s2 = ekb[this.parameterVersion];
                    return new RC2ParameterSpec(s2, this.iv);
                }
                AlgParams algParams = this;
                int n4 = algParams.parameterVersion;
                return new RC2ParameterSpec(n4, algParams.iv);
            }
            if (clazz == IvParameterSpec.class) {
                return new IvParameterSpec(this.iv);
            }
            throw new InvalidParameterSpecException("unknown parameter spec passed to RC2 parameters object.");
        }

        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
            block6: {
                block5: {
                    block4: {
                        if (!(algorithmParameterSpec instanceof IvParameterSpec)) break block4;
                        this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
                        break block5;
                    }
                    if (!(algorithmParameterSpec instanceof RC2ParameterSpec)) break block6;
                    int n3 = ((RC2ParameterSpec)(algorithmParameterSpec = (RC2ParameterSpec)algorithmParameterSpec)).getEffectiveKeyBits();
                    if (n3 != -1) {
                        this.parameterVersion = n3 < 256 ? table[n3] : n3;
                    }
                    this.iv = ((RC2ParameterSpec)algorithmParameterSpec).getIV();
                }
                return;
            }
            throw new InvalidParameterSpecException("IvParameterSpec or RC2ParameterSpec required to initialise a RC2 parameters algorithm parameters object");
        }

        @Override
        public void engineInit(byte[] byArray) {
            this.iv = Arrays.clone(byArray);
        }

        @Override
        public void engineInit(byte[] object, String string2) {
            if (this.isASN1FormatString(string2)) {
                RC2CBCParameter rC2CBCParameter = RC2CBCParameter.getInstance(ASN1Primitive.fromByteArray((byte[])object));
                object = rC2CBCParameter;
                if (rC2CBCParameter.getRC2ParameterVersion() != null) {
                    this.parameterVersion = ((RC2CBCParameter)object).getRC2ParameterVersion().intValue();
                }
                this.iv = ((RC2CBCParameter)object).getIV();
                return;
            }
            if (string2.equals("RAW")) {
                this.engineInit((byte[])object);
                return;
            }
            throw new IOException("Unknown parameters format in IV parameters object");
        }

        @Override
        public String engineToString() {
            return "RC2 Parameters";
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            CipherKeyGenerator cipherKeyGenerator;
            KeyGenerator keyGenerator = cipherKeyGenerator2;
            CipherKeyGenerator cipherKeyGenerator2 = cipherKeyGenerator;
            cipherKeyGenerator = new CipherKeyGenerator();
            super("RC2", 128, cipherKeyGenerator2);
        }
    }

    public static class AlgParamGen
    extends BaseAlgorithmParameterGenerator {
        public RC2ParameterSpec spec = null;

        @Override
        public void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) {
            if (algorithmParameterSpec instanceof RC2ParameterSpec) {
                this.spec = (RC2ParameterSpec)algorithmParameterSpec;
                return;
            }
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for RC2 parameter generation.");
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            AlgorithmParameters object;
            if (((AlgParamGen)((Object)object)).spec == null) {
                byte[] byArray = new byte[8];
                if (((BaseAlgorithmParameterGenerator)((Object)object)).random == null) {
                    ((BaseAlgorithmParameterGenerator)((Object)object)).random = CryptoServicesRegistrar.getSecureRandom();
                }
                AlgParamGen algParamGen = object;
                algParamGen.random.nextBytes(byArray);
                try {
                    object = algParamGen.createParametersInstance("RC2");
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                {
                    object.init(new IvParameterSpec(byArray));
                    return object;
                }
            }
            try {
                algorithmParameters = ((BaseAlgorithmParameterGenerator)((Object)object)).createParametersInstance("RC2");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            {
                algorithmParameters.init(((AlgParamGen)((Object)object)).spec);
                return algorithmParameters;
            }
        }
    }

    public static class PBEWithMD5KeyFactory
    extends PBESecretKeyFactory {
        public PBEWithMD5KeyFactory() {
            super("PBEwithMD5andRC2", PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC, true, 0, 0, 64, 64);
        }
    }

    public static class PBEWithMD2KeyFactory
    extends PBESecretKeyFactory {
        public PBEWithMD2KeyFactory() {
            super("PBEwithMD2andRC2", PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC, true, 0, 5, 64, 64);
        }
    }

    public static class PBEWithSHAAnd40BitRC2
    extends BaseBlockCipher {
        public PBEWithSHAAnd40BitRC2() {
            RC2Engine rC2Engine;
            CBCBlockCipher cBCBlockCipher;
            PBEWithSHAAnd40BitRC2 pBEWithSHAAnd40BitRC2 = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            cBCBlockCipher = new CBCBlockCipher(rC2Engine2);
            super(cBCBlockCipher2, 2, 1, 40, 8);
        }
    }

    public static class PBEWithSHAAnd128BitRC2
    extends BaseBlockCipher {
        public PBEWithSHAAnd128BitRC2() {
            RC2Engine rC2Engine;
            CBCBlockCipher cBCBlockCipher;
            PBEWithSHAAnd128BitRC2 pBEWithSHAAnd128BitRC2 = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            cBCBlockCipher = new CBCBlockCipher(rC2Engine2);
            super(cBCBlockCipher2, 2, 1, 128, 8);
        }
    }

    public static class PBEWithSHA1AndRC2
    extends BaseBlockCipher {
        public PBEWithSHA1AndRC2() {
            RC2Engine rC2Engine;
            CBCBlockCipher cBCBlockCipher;
            PBEWithSHA1AndRC2 pBEWithSHA1AndRC2 = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            cBCBlockCipher = new CBCBlockCipher(rC2Engine2);
            super(cBCBlockCipher2, 0, 1, 64, 8);
        }
    }

    public static class PBEWithMD5AndRC2
    extends BaseBlockCipher {
        public PBEWithMD5AndRC2() {
            RC2Engine rC2Engine;
            CBCBlockCipher cBCBlockCipher;
            PBEWithMD5AndRC2 pBEWithMD5AndRC2 = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            cBCBlockCipher = new CBCBlockCipher(rC2Engine2);
            super(cBCBlockCipher2, 0, 0, 64, 8);
        }
    }

    public static class PBEWithSHAAnd40BitKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHAAnd40BitKeyFactory() {
            super("PBEwithSHAand40BitRC2-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd40BitRC2_CBC, true, 2, 1, 40, 64);
        }
    }

    public static class PBEWithSHAAnd128BitKeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHAAnd128BitKeyFactory() {
            super("PBEwithSHAand128BitRC2-CBC", PKCSObjectIdentifiers.pbeWithSHAAnd128BitRC2_CBC, true, 2, 1, 128, 64);
        }
    }

    public static class PBEWithSHA1KeyFactory
    extends PBESecretKeyFactory {
        public PBEWithSHA1KeyFactory() {
            super("PBEwithSHA1andRC2", PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC, true, 0, 1, 64, 64);
        }
    }

    public static class CFB8MAC
    extends BaseMac {
        public CFB8MAC() {
            RC2Engine rC2Engine;
            CFBBlockCipherMac cFBBlockCipherMac;
            CFB8MAC cFB8MAC = cFBBlockCipherMac2;
            CFBBlockCipherMac cFBBlockCipherMac2 = cFBBlockCipherMac;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            cFBBlockCipherMac = new CFBBlockCipherMac(rC2Engine2);
            super(cFBBlockCipherMac2);
        }
    }

    public static class CBCMAC
    extends BaseMac {
        public CBCMAC() {
            RC2Engine rC2Engine;
            CBCBlockCipherMac cBCBlockCipherMac;
            CBCMAC cBCMAC = cBCBlockCipherMac2;
            CBCBlockCipherMac cBCBlockCipherMac2 = cBCBlockCipherMac;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            cBCBlockCipherMac = new CBCBlockCipherMac(rC2Engine2);
            super(cBCBlockCipherMac2);
        }
    }

    public static class Wrap
    extends BaseWrapCipher {
        public Wrap() {
            RC2WrapEngine rC2WrapEngine;
            Wrap wrap = rC2WrapEngine2;
            RC2WrapEngine rC2WrapEngine2 = rC2WrapEngine;
            rC2WrapEngine = new RC2WrapEngine();
            super(rC2WrapEngine2);
        }
    }

    public static class CBC
    extends BaseBlockCipher {
        public CBC() {
            RC2Engine rC2Engine;
            CBCBlockCipher cBCBlockCipher;
            CBC cBC = cBCBlockCipher2;
            CBCBlockCipher cBCBlockCipher2 = cBCBlockCipher;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            cBCBlockCipher = new CBCBlockCipher(rC2Engine2);
            super(cBCBlockCipher2, 64);
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            RC2Engine rC2Engine;
            ECB eCB = rC2Engine2;
            RC2Engine rC2Engine2 = rC2Engine;
            rC2Engine = new RC2Engine();
            super(rC2Engine2);
        }
    }
}

