/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.PBEParametersGenerator;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.PBEKeySpec;
import javax.security.auth.Destroyable;

public class BCPBEKey
implements PBEKey,
Destroyable {
    private final AtomicBoolean hasBeenDestroyed;
    public String algorithm;
    public ASN1ObjectIdentifier oid;
    public int type;
    public int digest;
    public int keySize;
    public int ivSize;
    private final char[] password;
    private final byte[] salt;
    private final int iterationCount;
    private final CipherParameters param;
    public boolean tryWrong;

    public BCPBEKey(String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier, int n3, int n4, int n5, int n6, PBEKeySpec pBEKeySpec, CipherParameters cipherParameters) {
        this.hasBeenDestroyed = new AtomicBoolean(false);
        this.tryWrong = false;
        this.algorithm = string2;
        this.oid = aSN1ObjectIdentifier;
        this.type = n3;
        this.digest = n4;
        this.keySize = n5;
        this.ivSize = n6;
        this.password = pBEKeySpec.getPassword();
        this.iterationCount = pBEKeySpec.getIterationCount();
        this.salt = pBEKeySpec.getSalt();
        this.param = cipherParameters;
    }

    public BCPBEKey(String string2, CipherParameters cipherParameters) {
        AtomicBoolean atomicBoolean;
        Serializable serializable = atomicBoolean;
        atomicBoolean = new AtomicBoolean(false);
        v1.hasBeenDestroyed = serializable;
        v1.tryWrong = false;
        v1.algorithm = string2;
        v1.param = cipherParameters;
        v1.password = null;
        v1.iterationCount = -1;
        v1.salt = null;
    }

    public static void checkDestroyed(Destroyable destroyable) {
        if (!destroyable.isDestroyed()) {
            return;
        }
        throw new IllegalStateException("key has been destroyed");
    }

    @Override
    public String getAlgorithm() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.algorithm;
    }

    @Override
    public String getFormat() {
        return "RAW";
    }

    @Override
    public byte[] getEncoded() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        CipherParameters cipherParameters = bCPBEKey.param;
        if (cipherParameters != null) {
            return (cipherParameters instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)cipherParameters).getParameters() : (KeyParameter)cipherParameters).getKey();
        }
        int n3 = this.type;
        if (n3 == 2) {
            return PBEParametersGenerator.PKCS12PasswordToBytes(this.password);
        }
        if (n3 == 5) {
            return PBEParametersGenerator.PKCS5PasswordToUTF8Bytes(this.password);
        }
        return PBEParametersGenerator.PKCS5PasswordToBytes(this.password);
    }

    public int getType() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.type;
    }

    public int getDigest() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.digest;
    }

    public int getKeySize() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.keySize;
    }

    public int getIvSize() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.ivSize;
    }

    public CipherParameters getParam() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.param;
    }

    @Override
    public char[] getPassword() {
        BCPBEKey bCPBEKey = object;
        BCPBEKey.checkDestroyed(bCPBEKey);
        Object object = bCPBEKey.password;
        if (bCPBEKey.password != null) {
            return Arrays.clone((char[])object);
        }
        throw new IllegalStateException("no password available");
    }

    @Override
    public byte[] getSalt() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return Arrays.clone(bCPBEKey.salt);
    }

    @Override
    public int getIterationCount() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.iterationCount;
    }

    public ASN1ObjectIdentifier getOID() {
        BCPBEKey bCPBEKey = this;
        BCPBEKey.checkDestroyed(bCPBEKey);
        return bCPBEKey.oid;
    }

    public void setTryWrongPKCS12Zero(boolean bl) {
        this.tryWrong = bl;
    }

    public boolean shouldTryWrongPKCS12() {
        return this.tryWrong;
    }

    @Override
    public void destroy() {
        if (!((BCPBEKey)object).hasBeenDestroyed.getAndSet(true)) {
            char[] cArray = ((BCPBEKey)object).password;
            if (((BCPBEKey)object).password != null) {
                Arrays.fill(cArray, '\u0000');
            }
            Object object = ((BCPBEKey)object).salt;
            if (((BCPBEKey)object).salt != null) {
                Arrays.fill((byte[])object, (byte)0);
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }
}

