/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Mac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.macs.HMac;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.ParametersWithIV;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.RC2Parameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.SkeinParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKCS12Key;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.GcmSpecUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.PBE;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.AEADParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.SkeinParameterSpec;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import java.util.Map;
import javax.crypto.MacSpi;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.PBEKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;

public class BaseMac
extends MacSpi
implements PBE {
    private static final Class gcmSpecClass = ClassUtil.loadClass(BaseMac.class, "javax.crypto.spec.GCMParameterSpec");
    private Mac macEngine;
    private int scheme;
    private int pbeHash;
    private int keySize;

    public BaseMac(Mac mac) {
        this.scheme = 2;
        this.pbeHash = 1;
        this.keySize = 160;
        this.macEngine = mac;
    }

    public BaseMac(Mac mac, int n3, int n4, int n5) {
        this.macEngine = mac;
        this.scheme = n3;
        this.pbeHash = n4;
        this.keySize = n5;
    }

    private static Hashtable copyMap(Map map) {
        Hashtable hashtable;
        Hashtable hashtable2 = hashtable;
        hashtable = new Hashtable();
        for (Object k3 : map.keySet()) {
            hashtable2.put(k3, map.get(k3));
        }
        return hashtable2;
    }

    @Override
    public void engineInit(Key object, AlgorithmParameterSpec object2) {
        block23: {
            block29: {
                block37: {
                    Object object3;
                    block31: {
                        block36: {
                            Object object4;
                            block35: {
                                KeyParameter keyParameter;
                                block34: {
                                    block33: {
                                        ParametersWithIV parametersWithIV;
                                        block32: {
                                            ParametersWithIV parametersWithIV2;
                                            block30: {
                                                AEADParameters aEADParameters;
                                                block25: {
                                                    KeyParameter keyParameter2;
                                                    block26: {
                                                        block28: {
                                                            block27: {
                                                                block24: {
                                                                    AlgorithmParameterSpec algorithmParameterSpec;
                                                                    if (object == null) break block23;
                                                                    if (!(object instanceof PKCS12Key)) break block24;
                                                                    try {
                                                                        algorithmParameterSpec = object2;
                                                                        object3 = (SecretKey)object;
                                                                    }
                                                                    catch (Exception exception) {
                                                                        throw new InvalidKeyException("PKCS12 requires a SecretKey/PBEKey");
                                                                    }
                                                                    try {
                                                                        object4 = (PBEParameterSpec)algorithmParameterSpec;
                                                                    }
                                                                    catch (Exception exception) {
                                                                        throw new InvalidAlgorithmParameterException("PKCS12 requires a PBEParameterSpec");
                                                                    }
                                                                    if (object3 instanceof PBEKey && object4 == null) {
                                                                        PBEParameterSpec pBEParameterSpec;
                                                                        object4 = pBEParameterSpec;
                                                                        PBEKey pBEKey = (PBEKey)object3;
                                                                        byte[] byArray = pBEKey.getSalt();
                                                                        pBEParameterSpec = new PBEParameterSpec(byArray, pBEKey.getIterationCount());
                                                                    }
                                                                    int n3 = 1;
                                                                    int n4 = 160;
                                                                    if (this.macEngine.getAlgorithmName().startsWith("GOST")) {
                                                                        n3 = 6;
                                                                        n4 = 256;
                                                                    } else {
                                                                        Mac mac = this.macEngine;
                                                                        if (mac instanceof HMac && !mac.getAlgorithmName().startsWith("SHA-1")) {
                                                                            if (this.macEngine.getAlgorithmName().startsWith("SHA-224")) {
                                                                                n3 = 7;
                                                                                n4 = 224;
                                                                            } else if (this.macEngine.getAlgorithmName().startsWith("SHA-256")) {
                                                                                n3 = 4;
                                                                                n4 = 256;
                                                                            } else if (this.macEngine.getAlgorithmName().startsWith("SHA-384")) {
                                                                                n3 = 8;
                                                                                n4 = 384;
                                                                            } else if (this.macEngine.getAlgorithmName().startsWith("SHA-512")) {
                                                                                n3 = 9;
                                                                                n4 = 512;
                                                                            } else if (this.macEngine.getAlgorithmName().startsWith("RIPEMD160")) {
                                                                                n3 = 2;
                                                                                n4 = 160;
                                                                            } else {
                                                                                throw new InvalidAlgorithmParameterException(b.a("no PKCS12 mapping for HMAC: ").append(this.macEngine.getAlgorithmName()).toString());
                                                                            }
                                                                        }
                                                                    }
                                                                    object3 = PBE.Util.makePBEMacParameters((SecretKey)object3, 2, n3, n4, (PBEParameterSpec)object4);
                                                                    break block25;
                                                                }
                                                                if (!(object instanceof BCPBEKey)) break block26;
                                                                object3 = (BCPBEKey)object;
                                                                if (((BCPBEKey)object3).getParam() == null) break block27;
                                                                object3 = ((BCPBEKey)object3).getParam();
                                                                break block25;
                                                            }
                                                            if (!(object2 instanceof PBEParameterSpec)) break block28;
                                                            object3 = PBE.Util.makePBEMacParameters((BCPBEKey)object3, (AlgorithmParameterSpec)object2);
                                                            break block25;
                                                        }
                                                        throw new InvalidAlgorithmParameterException("PBE requires PBE parameters to be set.");
                                                    }
                                                    if (object2 instanceof PBEParameterSpec) break block29;
                                                    object3 = keyParameter2;
                                                    keyParameter2 = new KeyParameter(object.getEncoded());
                                                }
                                                object4 = object3 instanceof ParametersWithIV ? (KeyParameter)((ParametersWithIV)object3).getParameters() : (KeyParameter)object3;
                                                if (!(object2 instanceof AEADParameterSpec)) break block30;
                                                object = (AEADParameterSpec)object2;
                                                object3 = aEADParameters;
                                                Object object5 = object;
                                                int n5 = ((AEADParameterSpec)object5).getMacSizeInBits();
                                                object2 = ((AEADParameterSpec)object5).getNonce();
                                                byte[] byArray = ((AEADParameterSpec)object5).getAssociatedData();
                                                aEADParameters = new AEADParameters((KeyParameter)object4, n5, (byte[])object2, byArray);
                                                break block31;
                                            }
                                            if (!(object2 instanceof IvParameterSpec)) break block32;
                                            object3 = parametersWithIV2;
                                            parametersWithIV2 = new ParametersWithIV((CipherParameters)object4, ((IvParameterSpec)object2).getIV());
                                            break block31;
                                        }
                                        if (!(object2 instanceof RC2ParameterSpec)) break block33;
                                        object3 = parametersWithIV;
                                        AlgorithmParameterSpec algorithmParameterSpec = object2;
                                        object2 = ((KeyParameter)object4).getKey();
                                        RC2ParameterSpec rC2ParameterSpec = (RC2ParameterSpec)algorithmParameterSpec;
                                        object = new RC2Parameters((byte[])object2, rC2ParameterSpec.getEffectiveKeyBits());
                                        parametersWithIV = new ParametersWithIV((CipherParameters)object, rC2ParameterSpec.getIV());
                                        break block31;
                                    }
                                    if (!(object2 instanceof SkeinParameterSpec)) break block34;
                                    object3 = new SkeinParameters.Builder(BaseMac.copyMap(((SkeinParameterSpec)object2).getParameters())).setKey(((KeyParameter)object4).getKey()).build();
                                    break block31;
                                }
                                if (object2 != null) break block35;
                                object3 = keyParameter;
                                keyParameter = new KeyParameter(object.getEncoded());
                                break block31;
                            }
                            object = gcmSpecClass;
                            if (object == null || !((Class)object).isAssignableFrom(object2.getClass())) break block36;
                            object3 = GcmSpecUtil.extractAeadParameters((KeyParameter)object4, (AlgorithmParameterSpec)object2);
                            break block31;
                        }
                        if (!(object2 instanceof PBEParameterSpec)) break block37;
                    }
                    try {
                        this.macEngine.init((CipherParameters)object3);
                        return;
                    }
                    catch (Exception exception) {
                        throw new InvalidAlgorithmParameterException(a.a(exception, b.a("cannot initialize MAC: ")));
                    }
                }
                throw new InvalidAlgorithmParameterException(b.a("unknown parameter type: ").append(object2.getClass().getName()).toString());
            }
            throw new InvalidAlgorithmParameterException(b.a("inappropriate parameter type: ").append(object2.getClass().getName()).toString());
        }
        throw new InvalidKeyException("key is null");
    }

    @Override
    public int engineGetMacLength() {
        return this.macEngine.getMacSize();
    }

    @Override
    public void engineReset() {
        this.macEngine.reset();
    }

    @Override
    public void engineUpdate(byte by) {
        this.macEngine.update(by);
    }

    @Override
    public void engineUpdate(byte[] byArray, int n3, int n4) {
        this.macEngine.update(byArray, n3, n4);
    }

    @Override
    public byte[] engineDoFinal() {
        byte[] byArray = new byte[this.engineGetMacLength()];
        this.macEngine.doFinal(byArray, 0);
        return byArray;
    }
}

