/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.cms.GCMParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AEADParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class GcmSpecUtil {
    public static final Class gcmSpecClass = ClassUtil.loadClass(GcmSpecUtil.class, "javax.crypto.spec.GCMParameterSpec");
    public static final Method tLen;
    public static final Method iv;

    private static Method extractMethod(final String string2) {
        try {
            return (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return gcmSpecClass.getDeclaredMethod(string2, new Class[0]);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            return null;
        }
    }

    public static boolean gcmSpecExists() {
        return gcmSpecClass != null;
    }

    public static boolean isGcmSpec(AlgorithmParameterSpec algorithmParameterSpec) {
        Class clazz = gcmSpecClass;
        return clazz != null && clazz.isInstance(algorithmParameterSpec);
    }

    public static boolean isGcmSpec(Class clazz) {
        return gcmSpecClass == clazz;
    }

    public static AlgorithmParameterSpec extractGcmSpec(ASN1Primitive aSN1Object) {
        aSN1Object = GCMParameters.getInstance(aSN1Object);
        Class clazz = gcmSpecClass;
        Class[] classArray = new Class[2];
        classArray[0] = Integer.TYPE;
        classArray[1] = byte[].class;
        Constructor constructor = clazz.getConstructor(classArray);
        Object[] objectArray = new Object[2];
        int n3 = ((GCMParameters)aSN1Object).getIcvLen();
        objectArray[0] = Integers.valueOf(n3 * 8);
        int n4 = 1;
        try {
            objectArray[n4] = ((GCMParameters)aSN1Object).getNonce();
            return (AlgorithmParameterSpec)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new InvalidParameterSpecException(a.a(exception, b.a("Construction failed: ")));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InvalidParameterSpecException("No constructor found!");
        }
    }

    public static AEADParameters extractAeadParameters(final KeyParameter keyParameter, final AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            return (AEADParameters)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return new AEADParameters(keyParameter, (Integer)tLen.invoke((Object)algorithmParameterSpec, new Object[0]), (byte[])iv.invoke((Object)algorithmParameterSpec, new Object[0]));
                }
            });
        }
        catch (Exception exception) {
            throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec.");
        }
    }

    public static GCMParameters extractGcmParameters(final AlgorithmParameterSpec algorithmParameterSpec) {
        try {
            return (GCMParameters)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return new GCMParameters((byte[])iv.invoke((Object)algorithmParameterSpec, new Object[0]), (Integer)tLen.invoke((Object)algorithmParameterSpec, new Object[0]) / 8);
                }
            });
        }
        catch (Exception exception) {
            throw new InvalidParameterSpecException("Cannot process GCMParameterSpec");
        }
    }

    static {
        if (gcmSpecClass != null) {
            tLen = GcmSpecUtil.extractMethod("getTLen");
            iv = GcmSpecUtil.extractMethod("getIV");
        } else {
            tLen = null;
            iv = null;
        }
    }
}

