/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseAlgorithmParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import f.a;
import java.io.IOException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public class IvAlgorithmParameters
extends BaseAlgorithmParameters {
    private byte[] iv;

    @Override
    public byte[] engineGetEncoded() {
        return this.engineGetEncoded("ASN.1");
    }

    @Override
    public byte[] engineGetEncoded(String string2) {
        if (this.isASN1FormatString(string2)) {
            return new DEROctetString(this.engineGetEncoded("RAW")).getEncoded();
        }
        if (string2.equals("RAW")) {
            return Arrays.clone(this.iv);
        }
        return null;
    }

    @Override
    public AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) {
        if (clazz != IvParameterSpec.class && clazz != AlgorithmParameterSpec.class) {
            throw new InvalidParameterSpecException("unknown parameter spec passed to IV parameters object.");
        }
        return new IvParameterSpec(this.iv);
    }

    @Override
    public void engineInit(AlgorithmParameterSpec algorithmParameterSpec) {
        if (algorithmParameterSpec instanceof IvParameterSpec) {
            this.iv = ((IvParameterSpec)algorithmParameterSpec).getIV();
            return;
        }
        throw new InvalidParameterSpecException("IvParameterSpec required to initialise a IV parameters algorithm parameters object");
    }

    @Override
    public void engineInit(byte[] byArray) {
        if (byArray.length % 8 != 0 && byArray[0] == 4 && byArray[1] == byArray.length - 2) {
            byArray = ((ASN1OctetString)ASN1Primitive.fromByteArray(byArray)).getOctets();
        }
        this.iv = Arrays.clone(byArray);
    }

    @Override
    public void engineInit(byte[] byArray, String string2) {
        if (this.isASN1FormatString(string2)) {
            try {
                this.engineInit(((ASN1OctetString)ASN1Primitive.fromByteArray(byArray)).getOctets());
                return;
            }
            catch (Exception exception) {
                throw new IOException(a.a("Exception decoding: ", exception));
            }
        }
        if (string2.equals("RAW")) {
            this.engineInit(byArray);
            return;
        }
        throw new IOException("Unknown parameters format in IV parameters object");
    }

    @Override
    public String engineToString() {
        return "IV Parameters";
    }
}

