/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CipherParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BCPBEKey;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.PBE;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.PBEKeySpec;

public class PBESecretKeyFactory
extends BaseSecretKeyFactory {
    private boolean forCipher;
    private int scheme;
    private int digest;
    private int keySize;
    private int ivSize;

    public PBESecretKeyFactory(String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier, boolean bl, int n3, int n4, int n5, int n6) {
        super(string2, aSN1ObjectIdentifier);
        this.forCipher = bl;
        this.scheme = n3;
        this.digest = n4;
        this.keySize = n5;
        this.ivSize = n6;
    }

    @Override
    public SecretKey engineGenerateSecret(KeySpec keySpec) {
        if (keySpec instanceof PBEKeySpec) {
            CipherParameters cipherParameters;
            int n3;
            int n4;
            int n5;
            Object object;
            if (((PBEKeySpec)(keySpec = (PBEKeySpec)keySpec)).getSalt() == null) {
                PBESecretKeyFactory pBESecretKeyFactory = object;
                object = pBESecretKeyFactory.algName;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = pBESecretKeyFactory.algOid;
                int n6 = pBESecretKeyFactory.scheme;
                int n7 = pBESecretKeyFactory.digest;
                int n8 = pBESecretKeyFactory.keySize;
                int n9 = pBESecretKeyFactory.ivSize;
                return new BCPBEKey((String)object, aSN1ObjectIdentifier, n6, n7, n8, n9, (PBEKeySpec)keySpec, null);
            }
            if (((PBESecretKeyFactory)object).forCipher) {
                PBESecretKeyFactory pBESecretKeyFactory = object;
                int n10 = pBESecretKeyFactory.scheme;
                n5 = pBESecretKeyFactory.digest;
                n4 = pBESecretKeyFactory.keySize;
                n3 = pBESecretKeyFactory.ivSize;
                cipherParameters = PBE.Util.makePBEParameters((PBEKeySpec)keySpec, n10, n5, n4, n3);
            } else {
                PBESecretKeyFactory pBESecretKeyFactory = object;
                int n11 = pBESecretKeyFactory.scheme;
                n5 = pBESecretKeyFactory.digest;
                n4 = pBESecretKeyFactory.keySize;
                cipherParameters = PBE.Util.makePBEMacParameters((PBEKeySpec)keySpec, n11, n5, n4);
            }
            Object object2 = object;
            object = ((BaseSecretKeyFactory)object2).algName;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = ((BaseSecretKeyFactory)object2).algOid;
            n4 = ((PBESecretKeyFactory)object2).scheme;
            n3 = ((PBESecretKeyFactory)object2).digest;
            int n12 = ((PBESecretKeyFactory)object2).keySize;
            int n13 = ((PBESecretKeyFactory)object2).ivSize;
            return new BCPBEKey((String)object, aSN1ObjectIdentifier, n4, n3, n12, n13, (PBEKeySpec)keySpec, cipherParameters);
        }
        throw new InvalidKeySpecException("Invalid KeySpec");
    }
}

