/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.security.spec.EncodedKeySpec;

public class OpenSSHPublicKeySpec
extends EncodedKeySpec {
    private static final String[] allowedTypes = new String[]{"ssh-rsa", "ssh-ed25519", "ssh-dss"};
    private final String type;

    public OpenSSHPublicKeySpec(byte[] byArray) {
        super(byArray);
        int n3 = 4;
        int n4 = ((byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF) + n3;
        if (n4 < byArray.length) {
            this.type = Strings.fromByteArray(Arrays.copyOfRange(byArray, n3, n4));
            if (this.type.startsWith("ecdsa")) {
                return;
            }
            int n5 = 0;
            while (true) {
                String[] stringArray = allowedTypes;
                if (n5 >= allowedTypes.length) break;
                if (stringArray[n5].equals(this.type)) {
                    return;
                }
                ++n5;
            }
            throw new IllegalArgumentException(b.a("unrecognised public key type ").append(this.type).toString());
        }
        throw new IllegalArgumentException("invalid public key blob: type field longer than blob");
    }

    @Override
    public String getFormat() {
        return "OpenSSH";
    }

    public String getType() {
        return this.type;
    }
}

