/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.j;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.security.spec.AlgorithmParameterSpec;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class SkeinParameterSpec
implements AlgorithmParameterSpec {
    public static final int PARAM_TYPE_KEY = 0;
    public static final int PARAM_TYPE_CONFIG = 4;
    public static final int PARAM_TYPE_PERSONALISATION = 8;
    public static final int PARAM_TYPE_PUBLIC_KEY = 12;
    public static final int PARAM_TYPE_KEY_IDENTIFIER = 16;
    public static final int PARAM_TYPE_NONCE = 20;
    public static final int PARAM_TYPE_MESSAGE = 48;
    public static final int PARAM_TYPE_OUTPUT = 63;
    private Map parameters;

    public SkeinParameterSpec() {
        HashMap hashMap;
        SkeinParameterSpec skeinParameterSpec = hashMap2;
        HashMap hashMap2 = hashMap;
        hashMap = new HashMap();
        skeinParameterSpec(hashMap2);
    }

    private SkeinParameterSpec(Map map) {
        this.parameters = Collections.unmodifiableMap(map);
    }

    public /* synthetic */ SkeinParameterSpec(Map map, 1 var2_2) {
        this(map);
    }

    public Map getParameters() {
        return this.parameters;
    }

    public byte[] getKey() {
        return Arrays.clone((byte[])this.parameters.get(Integers.valueOf(0)));
    }

    public byte[] getPersonalisation() {
        return Arrays.clone((byte[])this.parameters.get(Integers.valueOf(8)));
    }

    public byte[] getPublicKey() {
        return Arrays.clone((byte[])this.parameters.get(Integers.valueOf(12)));
    }

    public byte[] getKeyIdentifier() {
        return Arrays.clone((byte[])this.parameters.get(Integers.valueOf(16)));
    }

    public byte[] getNonce() {
        return Arrays.clone((byte[])this.parameters.get(Integers.valueOf(20)));
    }

    public static class Builder {
        private Map parameters;

        public Builder() {
            HashMap hashMap;
            HashMap hashMap2 = hashMap;
            hashMap = new HashMap();
            v1.parameters = hashMap2;
        }

        public Builder(SkeinParameterSpec skeinParameterSpec) {
            this.parameters = new HashMap();
            for (Integer n3 : skeinParameterSpec.parameters.keySet()) {
                this.parameters.put(n3, skeinParameterSpec.parameters.get(n3));
            }
        }

        public Builder set(int n3, byte[] byArray) {
            if (byArray != null) {
                if (n3 != 0 && (n3 <= 4 || n3 >= 63 || n3 == 48)) {
                    throw new IllegalArgumentException("Parameter types must be in the range 0,5..47,49..62.");
                }
                if (n3 != 4) {
                    Builder builder = this;
                    builder.parameters.put(Integers.valueOf(n3), byArray);
                    return builder;
                }
                throw new IllegalArgumentException("Parameter type 4 is reserved for internal use.");
            }
            throw new IllegalArgumentException("Parameter value must not be null.");
        }

        public Builder setKey(byte[] byArray) {
            return this.set(0, byArray);
        }

        public Builder setPersonalisation(byte[] byArray) {
            return this.set(8, byArray);
        }

        public Builder setPersonalisation(Date date, String string2, String string3) {
            OutputStreamWriter outputStreamWriter;
            ByteArrayOutputStream byteArrayOutputStream;
            Builder builder;
            try {
                builder = byteArrayOutputStream2;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(j.a("Byte I/O failed: ", iOException));
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
            String string4 = string3;
            OutputStreamWriter outputStreamWriter3 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter4 = outputStreamWriter3;
            OutputStreamWriter outputStreamWriter5 = outputStreamWriter3;
            String string5 = string2;
            OutputStreamWriter outputStreamWriter6 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter7 = outputStreamWriter6;
            OutputStreamWriter outputStreamWriter8 = outputStreamWriter6;
            outputStreamWriter6((OutputStream)byteArrayOutputStream2, "UTF-8");
            outputStreamWriter8.write(new SimpleDateFormat("YYYYMMDD").format(date));
            outputStreamWriter7.write(" ");
            outputStreamWriter4.write(string5);
            outputStreamWriter5.write(" ");
            outputStreamWriter.write(string4);
            outputStreamWriter.close();
            int n3 = 8;
            return builder.set(n3, byteArrayOutputStream.toByteArray());
        }

        public Builder setPersonalisation(Date date, Locale locale, String string2, String string3) {
            OutputStreamWriter outputStreamWriter;
            ByteArrayOutputStream byteArrayOutputStream;
            Builder builder;
            try {
                builder = byteArrayOutputStream2;
            }
            catch (IOException iOException) {
                throw new IllegalStateException(j.a("Byte I/O failed: ", iOException));
            }
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
            byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter2 = outputStreamWriter;
            String string4 = string3;
            OutputStreamWriter outputStreamWriter3 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter4 = outputStreamWriter3;
            OutputStreamWriter outputStreamWriter5 = outputStreamWriter3;
            String string5 = string2;
            OutputStreamWriter outputStreamWriter6 = outputStreamWriter2;
            OutputStreamWriter outputStreamWriter7 = outputStreamWriter6;
            OutputStreamWriter outputStreamWriter8 = outputStreamWriter6;
            outputStreamWriter6((OutputStream)byteArrayOutputStream2, "UTF-8");
            outputStreamWriter8.write(new SimpleDateFormat("YYYYMMDD", locale).format(date));
            outputStreamWriter7.write(" ");
            outputStreamWriter4.write(string5);
            outputStreamWriter5.write(" ");
            outputStreamWriter.write(string4);
            outputStreamWriter.close();
            int n3 = 8;
            return builder.set(n3, byteArrayOutputStream.toByteArray());
        }

        public Builder setPublicKey(byte[] byArray) {
            return this.set(12, byArray);
        }

        public Builder setKeyIdentifier(byte[] byArray) {
            return this.set(16, byArray);
        }

        public Builder setNonce(byte[] byArray) {
            return this.set(20, byArray);
        }

        public SkeinParameterSpec build() {
            return new SkeinParameterSpec(this.parameters, null);
        }
    }
}

