/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.e;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isara.IsaraObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.util.ClassUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AlgorithmProvider;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.util.AsymmetricKeyInfoConverter;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BouncyCastleProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.asn1.PQCObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.lms.LMSKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.McElieceCCA2KeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.mceliece.McElieceKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.newhope.NHKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.qtesla.QTESLAKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.rainbow.RainbowKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.sphincs.Sphincs256KeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.XMSSKeyFactorySpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.pqc.jcajce.provider.xmss.XMSSMTKeyFactorySpi;
import java.security.AccessController;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.PublicKey;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public final class BouncyCastleProvider
extends Provider
implements ConfigurableProvider {
    private static String info = "BouncyCastle Security Provider v1.67";
    public static final String PROVIDER_NAME = "BC";
    public static final ProviderConfiguration CONFIGURATION = new BouncyCastleProviderConfiguration();
    private static final Map keyInfoConverters = new HashMap();
    private static final Class revChkClass = ClassUtil.loadClass(BouncyCastleProvider.class, "java.security.cert.PKIXRevocationChecker");
    private static final String SYMMETRIC_PACKAGE = "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.symmetric.";
    private static final String[] SYMMETRIC_GENERIC = new String[]{"PBEPBKDF1", "PBEPBKDF2", "PBEPKCS12", "TLSKDF", "SCRYPT"};
    private static final String[] SYMMETRIC_MACS = new String[]{"SipHash", "SipHash128", "Poly1305"};
    private static final String[] SYMMETRIC_CIPHERS = new String[]{"AES", "ARC4", "ARIA", "Blowfish", "Camellia", "CAST5", "CAST6", "ChaCha", "DES", "DESede", "GOST28147", "Grainv1", "Grain128", "HC128", "HC256", "IDEA", "Noekeon", "RC2", "RC5", "RC6", "Rijndael", "Salsa20", "SEED", "Serpent", "Shacal2", "Skipjack", "SM4", "TEA", "Twofish", "Threefish", "VMPC", "VMPCKSA3", "XTEA", "XSalsa20", "OpenSSLPBKDF", "DSTU7624", "GOST3412_2015", "Zuc"};
    private static final String ASYMMETRIC_PACKAGE = "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.";
    private static final String[] ASYMMETRIC_GENERIC = new String[]{"X509", "IES", "COMPOSITE"};
    private static final String[] ASYMMETRIC_CIPHERS = new String[]{"DSA", "DH", "EC", "RSA", "GOST", "ECGOST", "ElGamal", "DSTU4145", "GM", "EdEC"};
    private static final String DIGEST_PACKAGE = "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.digest.";
    private static final String[] DIGESTS = new String[]{"GOST3411", "Keccak", "MD2", "MD4", "MD5", "SHA1", "RIPEMD128", "RIPEMD160", "RIPEMD256", "RIPEMD320", "SHA224", "SHA256", "SHA384", "SHA512", "SHA3", "Skein", "SM3", "Tiger", "Whirlpool", "Blake2b", "Blake2s", "DSTU7564", "Haraka"};
    private static final String KEYSTORE_PACKAGE = "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.keystore.";
    private static final String[] KEYSTORES = new String[]{"BC", "BCFKS", "PKCS12"};
    private static final String SECURE_RANDOM_PACKAGE = "com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.drbg.";
    private static final String[] SECURE_RANDOMS = new String[]{"DRBG"};

    public BouncyCastleProvider() {
        String string2 = info;
        super(PROVIDER_NAME, 1.67, string2);
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                BouncyCastleProvider.this.setup();
                return null;
            }
        });
    }

    private void setup() {
        BouncyCastleProvider bouncyCastleProvider = this;
        bouncyCastleProvider.loadAlgorithms(DIGEST_PACKAGE, DIGESTS);
        bouncyCastleProvider.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_GENERIC);
        bouncyCastleProvider.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_MACS);
        bouncyCastleProvider.loadAlgorithms(SYMMETRIC_PACKAGE, SYMMETRIC_CIPHERS);
        bouncyCastleProvider.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_GENERIC);
        bouncyCastleProvider.loadAlgorithms(ASYMMETRIC_PACKAGE, ASYMMETRIC_CIPHERS);
        bouncyCastleProvider.loadAlgorithms(KEYSTORE_PACKAGE, KEYSTORES);
        bouncyCastleProvider.loadAlgorithms(SECURE_RANDOM_PACKAGE, SECURE_RANDOMS);
        bouncyCastleProvider.loadPQCKeys();
        ((Dictionary)bouncyCastleProvider).put("X509Store.CERTIFICATE/COLLECTION", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreCertCollection");
        ((Dictionary)bouncyCastleProvider).put("X509Store.ATTRIBUTECERTIFICATE/COLLECTION", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreAttrCertCollection");
        ((Dictionary)bouncyCastleProvider).put("X509Store.CRL/COLLECTION", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreCRLCollection");
        ((Dictionary)bouncyCastleProvider).put("X509Store.CERTIFICATEPAIR/COLLECTION", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreCertPairCollection");
        ((Dictionary)bouncyCastleProvider).put("X509Store.CERTIFICATE/LDAP", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreLDAPCerts");
        ((Dictionary)bouncyCastleProvider).put("X509Store.CRL/LDAP", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreLDAPCRLs");
        ((Dictionary)bouncyCastleProvider).put("X509Store.ATTRIBUTECERTIFICATE/LDAP", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreLDAPAttrCerts");
        ((Dictionary)bouncyCastleProvider).put("X509Store.CERTIFICATEPAIR/LDAP", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509StoreLDAPCertPairs");
        ((Dictionary)bouncyCastleProvider).put("X509StreamParser.CERTIFICATE", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CertParser");
        ((Dictionary)bouncyCastleProvider).put("X509StreamParser.ATTRIBUTECERTIFICATE", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509AttrCertParser");
        ((Dictionary)bouncyCastleProvider).put("X509StreamParser.CRL", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CRLParser");
        ((Dictionary)bouncyCastleProvider).put("X509StreamParser.CERTIFICATEPAIR", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CertPairParser");
        ((Dictionary)bouncyCastleProvider).put("Cipher.BROKENPBEWITHMD5ANDDES", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithMD5AndDES");
        ((Dictionary)bouncyCastleProvider).put("Cipher.BROKENPBEWITHSHA1ANDDES", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BrokenJCEBlockCipher$BrokePBEWithSHA1AndDES");
        ((Dictionary)bouncyCastleProvider).put("Cipher.OLDPBEWITHSHAANDTWOFISH-CBC", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.BrokenJCEBlockCipher$OldPBEWithSHAAndTwofish");
        if (revChkClass != null) {
            BouncyCastleProvider bouncyCastleProvider2 = this;
            ((Dictionary)bouncyCastleProvider2).put("CertPathValidator.RFC3281", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            ((Dictionary)bouncyCastleProvider2).put("CertPathBuilder.RFC3281", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            ((Dictionary)bouncyCastleProvider2).put("CertPathValidator.RFC3280", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            ((Dictionary)bouncyCastleProvider2).put("CertPathBuilder.RFC3280", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
            ((Dictionary)bouncyCastleProvider2).put("CertPathValidator.PKIX", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathValidatorSpi_8");
            ((Dictionary)bouncyCastleProvider2).put("CertPathBuilder.PKIX", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathBuilderSpi_8");
        } else {
            BouncyCastleProvider bouncyCastleProvider3 = this;
            ((Dictionary)bouncyCastleProvider3).put("CertPathValidator.RFC3281", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXAttrCertPathValidatorSpi");
            ((Dictionary)bouncyCastleProvider3).put("CertPathBuilder.RFC3281", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXAttrCertPathBuilderSpi");
            ((Dictionary)bouncyCastleProvider3).put("CertPathValidator.RFC3280", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            ((Dictionary)bouncyCastleProvider3).put("CertPathBuilder.RFC3280", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
            ((Dictionary)bouncyCastleProvider3).put("CertPathValidator.PKIX", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathValidatorSpi");
            ((Dictionary)bouncyCastleProvider3).put("CertPathBuilder.PKIX", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCertPathBuilderSpi");
        }
        BouncyCastleProvider bouncyCastleProvider4 = this;
        ((Dictionary)bouncyCastleProvider4).put("CertStore.Collection", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.CertStoreCollectionSpi");
        ((Dictionary)bouncyCastleProvider4).put("CertStore.LDAP", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509LDAPCertStoreSpi");
        ((Dictionary)bouncyCastleProvider4).put("CertStore.Multi", "com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.MultiCertStoreSpi");
        ((Dictionary)bouncyCastleProvider4).put("Alg.Alias.CertStore.X509LDAP", "LDAP");
    }

    private void loadAlgorithms(String string2, String[] stringArray) {
        for (int i3 = 0; i3 != stringArray.length; ++i3) {
            Class clazz = ClassUtil.loadClass(BouncyCastleProvider.class, b.a(string2).append(stringArray[i3]).append("$Mappings").toString());
            if (clazz == null) continue;
            try {
                ((AlgorithmProvider)clazz.newInstance()).configure(this);
                continue;
            }
            catch (Exception exception) {
                throw new InternalError(e.a("cannot create instance of ", string2).append(stringArray[i3]).append("$Mappings : ").append(exception).toString());
            }
        }
    }

    private void loadPQCKeys() {
        LMSKeyFactorySpi lMSKeyFactorySpi;
        QTESLAKeyFactorySpi qTESLAKeyFactorySpi;
        QTESLAKeyFactorySpi qTESLAKeyFactorySpi2;
        RainbowKeyFactorySpi rainbowKeyFactorySpi;
        McElieceCCA2KeyFactorySpi mcElieceCCA2KeyFactorySpi;
        McElieceKeyFactorySpi mcElieceKeyFactorySpi;
        XMSSMTKeyFactorySpi xMSSMTKeyFactorySpi;
        XMSSMTKeyFactorySpi xMSSMTKeyFactorySpi2;
        XMSSKeyFactorySpi xMSSKeyFactorySpi;
        XMSSKeyFactorySpi xMSSKeyFactorySpi2;
        NHKeyFactorySpi nHKeyFactorySpi;
        Sphincs256KeyFactorySpi sphincs256KeyFactorySpi;
        BouncyCastleProvider bouncyCastleProvider = object;
        Object object = PQCObjectIdentifiers.sphincs256;
        KeyFactorySpi keyFactorySpi = sphincs256KeyFactorySpi;
        sphincs256KeyFactorySpi = new Sphincs256KeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.newHope;
        keyFactorySpi = nHKeyFactorySpi;
        nHKeyFactorySpi = new NHKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.xmss;
        keyFactorySpi = xMSSKeyFactorySpi2;
        xMSSKeyFactorySpi2 = new XMSSKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = IsaraObjectIdentifiers.id_alg_xmss;
        keyFactorySpi = xMSSKeyFactorySpi;
        xMSSKeyFactorySpi = new XMSSKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.xmss_mt;
        keyFactorySpi = xMSSMTKeyFactorySpi2;
        xMSSMTKeyFactorySpi2 = new XMSSMTKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = IsaraObjectIdentifiers.id_alg_xmssmt;
        keyFactorySpi = xMSSMTKeyFactorySpi;
        xMSSMTKeyFactorySpi = new XMSSMTKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.mcEliece;
        keyFactorySpi = mcElieceKeyFactorySpi;
        mcElieceKeyFactorySpi = new McElieceKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.mcElieceCca2;
        keyFactorySpi = mcElieceCCA2KeyFactorySpi;
        mcElieceCCA2KeyFactorySpi = new McElieceCCA2KeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.rainbow;
        keyFactorySpi = rainbowKeyFactorySpi;
        rainbowKeyFactorySpi = new RainbowKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.qTESLA_p_I;
        keyFactorySpi = qTESLAKeyFactorySpi2;
        qTESLAKeyFactorySpi2 = new QTESLAKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PQCObjectIdentifiers.qTESLA_p_III;
        keyFactorySpi = qTESLAKeyFactorySpi;
        qTESLAKeyFactorySpi = new QTESLAKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
        object = PKCSObjectIdentifiers.id_alg_hss_lms_hashsig;
        keyFactorySpi = lMSKeyFactorySpi;
        lMSKeyFactorySpi = new LMSKeyFactorySpi();
        bouncyCastleProvider.addKeyInfoConverter((ASN1ObjectIdentifier)object, (AsymmetricKeyInfoConverter)((Object)keyFactorySpi));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AsymmetricKeyInfoConverter getAsymmetricKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        Map map = keyInfoConverters;
        synchronized (map) {
            return (AsymmetricKeyInfoConverter)map.get(aSN1ObjectIdentifier);
        }
    }

    public static PublicKey getPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter(subjectPublicKeyInfo.getAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePublic(subjectPublicKeyInfo);
    }

    public static PrivateKey getPrivateKey(PrivateKeyInfo privateKeyInfo) {
        AsymmetricKeyInfoConverter asymmetricKeyInfoConverter = BouncyCastleProvider.getAsymmetricKeyInfoConverter(privateKeyInfo.getPrivateKeyAlgorithm().getAlgorithm());
        if (asymmetricKeyInfoConverter == null) {
            return null;
        }
        return asymmetricKeyInfoConverter.generatePrivate(privateKeyInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter(String string2, Object object) {
        ProviderConfiguration providerConfiguration = CONFIGURATION;
        synchronized (providerConfiguration) {
            ((BouncyCastleProviderConfiguration)providerConfiguration).setParameter(string2, object);
            return;
        }
    }

    @Override
    public boolean hasAlgorithm(String string2, String string3) {
        return ((Hashtable)this).containsKey(string2 + "." + string3) || ((Hashtable)this).containsKey("Alg.Alias." + string2 + "." + string3);
    }

    @Override
    public void addAlgorithm(String string2, String string3) {
        if (!((Hashtable)this).containsKey(string2)) {
            ((Dictionary)this).put(string2, string3);
            return;
        }
        throw new IllegalStateException(g.a("duplicate provider key (", string2, ") found"));
    }

    @Override
    public void addAlgorithm(String string2, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string3) {
        BouncyCastleProvider bouncyCastleProvider = this;
        bouncyCastleProvider.addAlgorithm(string2 + "." + aSN1ObjectIdentifier, string3);
        bouncyCastleProvider.addAlgorithm(string2 + ".OID." + aSN1ObjectIdentifier, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier, AsymmetricKeyInfoConverter asymmetricKeyInfoConverter) {
        Map<Object, Object> map = keyInfoConverters;
        synchronized (map) {
            map.put(aSN1ObjectIdentifier, asymmetricKeyInfoConverter);
            return;
        }
    }

    @Override
    public AsymmetricKeyInfoConverter getKeyInfoConverter(ASN1ObjectIdentifier aSN1ObjectIdentifier) {
        return (AsymmetricKeyInfoConverter)keyInfoConverters.get(aSN1ObjectIdentifier);
    }

    @Override
    public void addAttributes(String string2, Map<String, String> map) {
        for (String string3 : map.keySet()) {
            String string4 = g.a(string2, " ", string3);
            if (!((Hashtable)this).containsKey(string4)) {
                ((Dictionary)this).put(string4, map.get(string3));
                continue;
            }
            throw new IllegalStateException(g.a("duplicate provider attribute key (", string4, ") found"));
        }
    }
}

