/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.CryptoServicesRegistrar;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.config.ProviderConfigurationPermission;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec.ECParameterSpec;
import java.math.BigInteger;
import java.security.Permission;
import java.security.spec.DSAParameterSpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.spec.DHParameterSpec;

class BouncyCastleProviderConfiguration
implements ProviderConfiguration {
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission("BC", "ecImplicitlyCa");
    private static Permission BC_DH_LOCAL_PERMISSION = new ProviderConfigurationPermission("BC", "threadLocalDhDefaultParams");
    private static Permission BC_DH_PERMISSION = new ProviderConfigurationPermission("BC", "DhDefaultParams");
    private static Permission BC_EC_CURVE_PERMISSION = new ProviderConfigurationPermission("BC", "acceptableEcCurves");
    private static Permission BC_ADDITIONAL_EC_CURVE_PERMISSION = new ProviderConfigurationPermission("BC", "additionalEcParameters");
    private ThreadLocal ecThreadSpec;
    private ThreadLocal dhThreadSpec;
    private volatile ECParameterSpec ecImplicitCaParams;
    private volatile Object dhDefaultParams;
    private volatile Set acceptableNamedCurves;
    private volatile Map additionalECParameters;

    public BouncyCastleProviderConfiguration() {
        HashMap hashMap;
        HashSet hashSet;
        ThreadLocal threadLocal;
        ThreadLocal threadLocal2;
        Object object = threadLocal2;
        threadLocal2 = new ThreadLocal();
        v1.ecThreadSpec = object;
        object = threadLocal;
        threadLocal = new ThreadLocal();
        v1.dhThreadSpec = object;
        object = hashSet;
        hashSet = new HashSet();
        v1.acceptableNamedCurves = object;
        object = hashMap;
        hashMap = new HashMap();
        v1.additionalECParameters = object;
    }

    public void setParameter(String object, Object object2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (((String)object).equals("threadLocalEcImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            object = !(object2 instanceof ECParameterSpec) && object2 != null ? EC5Util.convertSpec((java.security.spec.ECParameterSpec)object2) : (ECParameterSpec)object2;
            if (object == null) {
                this.ecThreadSpec.remove();
            } else {
                this.ecThreadSpec.set(object);
            }
        } else if (((String)object).equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            this.ecImplicitCaParams = !(object2 instanceof ECParameterSpec) && object2 != null ? EC5Util.convertSpec((java.security.spec.ECParameterSpec)object2) : (ECParameterSpec)object2;
        } else if (((String)object).equals("threadLocalDhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_LOCAL_PERMISSION);
            }
            if (!(object2 instanceof DHParameterSpec) && !(object2 instanceof DHParameterSpec[]) && object2 != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec");
            }
            if (object2 == null) {
                this.dhThreadSpec.remove();
            } else {
                this.dhThreadSpec.set(object2);
            }
        } else if (((String)object).equals("DhDefaultParams")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_DH_PERMISSION);
            }
            if (!(object2 instanceof DHParameterSpec) && !(object2 instanceof DHParameterSpec[]) && object2 != null) {
                throw new IllegalArgumentException("not a valid DHParameterSpec or DHParameterSpec[]");
            }
            this.dhDefaultParams = object2;
        } else if (((String)object).equals("acceptableEcCurves")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_CURVE_PERMISSION);
            }
            this.acceptableNamedCurves = (Set)object2;
        } else if (((String)object).equals("additionalEcParameters")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_ADDITIONAL_EC_CURVE_PERMISSION);
            }
            this.additionalECParameters = (Map)object2;
        }
    }

    @Override
    public ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecThreadSpec.get();
        if (eCParameterSpec != null) {
            return eCParameterSpec;
        }
        return this.ecImplicitCaParams;
    }

    @Override
    public DHParameterSpec getDHDefaultParameters(int n3) {
        Object object;
        Object object2 = object.dhThreadSpec.get();
        if (object2 == null) {
            object2 = object.dhDefaultParams;
        }
        if (object2 instanceof DHParameterSpec) {
            object = (DHParameterSpec)object2;
            if (object.getP().bitLength() == n3) {
                return object;
            }
        } else if (object2 instanceof DHParameterSpec[]) {
            object = (DHParameterSpec[])object2;
            for (int i3 = 0; i3 != ((DHParameterSpec[])object).length; ++i3) {
                if (object[i3].getP().bitLength() != n3) continue;
                return object[i3];
            }
        }
        if ((object = (DHParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DH_DEFAULT_PARAMS, n3)) != null) {
            return new DHDomainParameterSpec((DHParameters)object);
        }
        return null;
    }

    @Override
    public DSAParameterSpec getDSADefaultParameters(int n3) {
        Object object = (DSAParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DSA_DEFAULT_PARAMS, n3);
        if (object != null) {
            Object object2 = object;
            object = ((DSAParameters)object2).getP();
            BigInteger bigInteger = ((DSAParameters)object2).getQ();
            BigInteger bigInteger2 = ((DSAParameters)object2).getG();
            return new DSAParameterSpec((BigInteger)object, bigInteger, bigInteger2);
        }
        return null;
    }

    @Override
    public Set getAcceptableNamedCurves() {
        return Collections.unmodifiableSet(this.acceptableNamedCurves);
    }

    @Override
    public Map getAdditionalECParameters() {
        return Collections.unmodifiableMap(this.additionalECParameters);
    }
}

