/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationFunction;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.DerivationParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.OutputLengthException;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.KDFParameters;

public class BrokenKDF2BytesGenerator
implements DerivationFunction {
    private Digest digest;
    private byte[] shared;
    private byte[] iv;

    public BrokenKDF2BytesGenerator(Digest digest) {
        this.digest = digest;
    }

    @Override
    public void init(DerivationParameters derivationParameters) {
        if (derivationParameters instanceof KDFParameters) {
            BrokenKDF2BytesGenerator brokenKDF2BytesGenerator = kDFParameters;
            KDFParameters kDFParameters = (KDFParameters)derivationParameters;
            brokenKDF2BytesGenerator.shared = kDFParameters.getSharedSecret();
            brokenKDF2BytesGenerator.iv = kDFParameters.getIV();
            return;
        }
        throw new IllegalArgumentException("KDF parameters required for generator");
    }

    public Digest getDigest() {
        return this.digest;
    }

    @Override
    public int generateBytes(byte[] byArray, int n3, int n4) {
        if (byArray.length - n4 >= n3) {
            long l3 = (long)n4 * 8L;
            if (l3 <= (long)this.digest.getDigestSize() * 8L * 0x80000000L) {
                int n5 = (int)(l3 / (long)this.digest.getDigestSize());
                int n6 = this.digest.getDigestSize();
                byte[] byArray2 = new byte[n6];
                for (int i3 = 1; i3 <= n5; ++i3) {
                    BrokenKDF2BytesGenerator brokenKDF2BytesGenerator = this;
                    brokenKDF2BytesGenerator.digest.update(this.shared, 0, this.shared.length);
                    brokenKDF2BytesGenerator.digest.update((byte)(i3 & 0xFF));
                    brokenKDF2BytesGenerator.digest.update((byte)(i3 >> 8 & 0xFF));
                    brokenKDF2BytesGenerator.digest.update((byte)(i3 >> 16 & 0xFF));
                    brokenKDF2BytesGenerator.digest.update((byte)(i3 >> 24 & 0xFF));
                    brokenKDF2BytesGenerator.digest.update(this.iv, 0, this.iv.length);
                    brokenKDF2BytesGenerator.digest.doFinal(byArray2, 0);
                    int n7 = n4 - n3;
                    if (n7 > n6) {
                        System.arraycopy(byArray2, 0, byArray, n3, n6);
                        n3 += n6;
                        continue;
                    }
                    System.arraycopy(byArray2, 0, byArray, n3, n7);
                }
                this.digest.reset();
                return n4;
            }
            throw new IllegalArgumentException("Output length too large");
        }
        throw new OutputLengthException("output buffer too small");
    }
}

