/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import b.b;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Enumerated;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1GeneralizedTime;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1OutputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1String;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DEROctetString;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.i;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.isismtt.ISISMTTObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.X500Name;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x500.style.RFC4519Style;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.CRLDistPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DistributionPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Extension;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralName;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.GeneralNames;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.PolicyInformation;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCRLStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCRLStoreSelector;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertRevocationCheckerParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertStore;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXCertStoreSelector;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXExtendedBuilderParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.PKIXExtendedParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.util.JcaJceHelper;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.exception.ExtCertPathBuilderException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.exception.ExtCertPathValidatorException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.AnnotatedException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.CertStatus;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.CrlCache;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXCRLUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PKIXPolicyNode;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PrincipalUtils;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.RFC3280CertPathUtilities;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.RecoverableCertPathValidatorException;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CRLObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Properties;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Store;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.StoreException;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509AttributeCertificate;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PolicyNode;
import java.security.cert.PolicyQualifierInfo;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

class CertPathValidatorUtilities {
    public static final PKIXCRLUtil CRL_UTIL = new PKIXCRLUtil();
    public static final String CERTIFICATE_POLICIES = Extension.certificatePolicies.getId();
    public static final String BASIC_CONSTRAINTS = Extension.basicConstraints.getId();
    public static final String POLICY_MAPPINGS = Extension.policyMappings.getId();
    public static final String SUBJECT_ALTERNATIVE_NAME = Extension.subjectAlternativeName.getId();
    public static final String NAME_CONSTRAINTS = Extension.nameConstraints.getId();
    public static final String KEY_USAGE = Extension.keyUsage.getId();
    public static final String INHIBIT_ANY_POLICY = Extension.inhibitAnyPolicy.getId();
    public static final String ISSUING_DISTRIBUTION_POINT = Extension.issuingDistributionPoint.getId();
    public static final String DELTA_CRL_INDICATOR = Extension.deltaCRLIndicator.getId();
    public static final String POLICY_CONSTRAINTS = Extension.policyConstraints.getId();
    public static final String FRESHEST_CRL = Extension.freshestCRL.getId();
    public static final String CRL_DISTRIBUTION_POINTS = Extension.cRLDistributionPoints.getId();
    public static final String AUTHORITY_KEY_IDENTIFIER = Extension.authorityKeyIdentifier.getId();
    public static final String ANY_POLICY = "2.5.29.32.0";
    public static final String CRL_NUMBER = Extension.cRLNumber.getId();
    public static final int KEY_CERT_SIGN = 5;
    public static final int CRL_SIGN = 6;
    public static final String[] crlReasons = new String[]{"unspecified", "keyCompromise", "cACompromise", "affiliationChanged", "superseded", "cessationOfOperation", "certificateHold", "unknown", "removeFromCRL", "privilegeWithdrawn", "aACompromise"};

    public static Collection findTargets(PKIXExtendedBuilderParameters object) {
        Set<Object> set;
        PKIXCertStoreSelector pKIXCertStoreSelector = ((PKIXExtendedBuilderParameters)object).getBaseParameters().getTargetConstraints();
        try {
            set = CertPathValidatorUtilities.findCertificates(pKIXCertStoreSelector, ((PKIXExtendedBuilderParameters)object).getBaseParameters().getCertificateStores());
        }
        catch (AnnotatedException annotatedException) {
            throw new ExtCertPathBuilderException("Error finding target certificate.", annotatedException);
        }
        set.addAll(CertPathValidatorUtilities.findCertificates(pKIXCertStoreSelector, ((PKIXExtendedBuilderParameters)object).getBaseParameters().getCertStores()));
        if (set.isEmpty()) {
            object = pKIXCertStoreSelector.getCertificate();
            if (object != null) {
                set = Collections.singleton(object);
            } else {
                throw new CertPathBuilderException("No certificate found matching targetConstraints.");
            }
        }
        return set;
    }

    public static TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set set) {
        return CertPathValidatorUtilities.findTrustAnchor(x509Certificate, set, null);
    }

    public static TrustAnchor findTrustAnchor(X509Certificate x509Certificate, Set object, String string2) {
        X509CertSelector x509CertSelector;
        Set set = object;
        object = null;
        PublicKey publicKey = null;
        Throwable throwable = null;
        X509CertSelector x509CertSelector2 = x509CertSelector;
        x509CertSelector2();
        X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
        x509CertSelector.setSubject(x500Principal);
        X500Name x500Name = null;
        Iterator iterator = set.iterator();
        while (iterator.hasNext() && object == null) {
            block11: {
                block9: {
                    block10: {
                        object = (TrustAnchor)iterator.next();
                        if (((TrustAnchor)object).getTrustedCert() == null) break block10;
                        if (!x509CertSelector2.match(((TrustAnchor)object).getTrustedCert())) break block9;
                        publicKey = ((TrustAnchor)object).getTrustedCert().getPublicKey();
                        break block11;
                    }
                    if (((TrustAnchor)object).getCA() != null && ((TrustAnchor)object).getCAName() != null && ((TrustAnchor)object).getCAPublicKey() != null) {
                        if (x500Name == null) {
                            x500Name = X500Name.getInstance(x500Principal.getEncoded());
                        }
                        try {
                            if (!x500Name.equals(X500Name.getInstance(((TrustAnchor)object).getCA().getEncoded()))) break block9;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {}
                        publicKey = ((TrustAnchor)object).getCAPublicKey();
                    }
                }
                object = null;
            }
            if (publicKey == null) continue;
            try {
                CertPathValidatorUtilities.verifyX509Certificate(x509Certificate, publicKey, string2);
            }
            catch (Exception exception) {
                object = null;
                publicKey = null;
            }
        }
        if (object == null && throwable != null) {
            throw new AnnotatedException("TrustAnchor found but certificate validation failed.", throwable);
        }
        return object;
    }

    public static boolean isIssuerTrustAnchor(X509Certificate x509Certificate, Set set, String string2) {
        try {
            return CertPathValidatorUtilities.findTrustAnchor(x509Certificate, set, string2) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static List<PKIXCertStore> getAdditionalStoresFromAltNames(byte[] objectArray, Map<GeneralName, PKIXCertStore> map) {
        if (objectArray != null) {
            ArrayList<PKIXCertStore> arrayList;
            objectArray = GeneralNames.getInstance(ASN1OctetString.getInstance(objectArray).getOctets()).getNames();
            ArrayList<PKIXCertStore> arrayList2 = arrayList;
            arrayList = new ArrayList<PKIXCertStore>();
            for (int i3 = 0; i3 != objectArray.length; ++i3) {
                PKIXCertStore pKIXCertStore = map.get(objectArray[i3]);
                if (pKIXCertStore == null) continue;
                arrayList2.add(pKIXCertStore);
            }
            return arrayList2;
        }
        return Collections.EMPTY_LIST;
    }

    public static Date getValidDate(PKIXExtendedParameters cloneable) {
        if ((cloneable = cloneable.getDate()) == null) {
            Date date;
            cloneable = date;
            date = new Date();
        }
        return cloneable;
    }

    public static boolean isSelfIssued(X509Certificate x509Certificate) {
        return x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN());
    }

    public static ASN1Primitive getExtensionValue(X509Extension object, String string2) {
        byte[] byArray = object.getExtensionValue(string2);
        object = byArray;
        if (byArray == null) {
            return null;
        }
        return CertPathValidatorUtilities.getObject(string2, (byte[])object);
    }

    private static ASN1Primitive getObject(String string2, byte[] byArray) {
        try {
            return ASN1Primitive.fromByteArray(ASN1OctetString.getInstance(new ASN1InputStream(byArray).readObject()).getOctets());
        }
        catch (Exception exception) {
            throw new AnnotatedException(i.a("exception processing extension ", string2), exception);
        }
    }

    public static AlgorithmIdentifier getAlgorithmIdentifier(PublicKey publicKey) {
        try {
            return SubjectPublicKeyInfo.getInstance(new ASN1InputStream(publicKey.getEncoded()).readObject()).getAlgorithm();
        }
        catch (Exception exception) {
            throw new ExtCertPathValidatorException("Subject public key cannot be decoded.", exception);
        }
    }

    public static final Set getQualifierSet(ASN1Sequence object) {
        ByteArrayOutputStream byteArrayOutputStream;
        HashSet<PolicyQualifierInfo> hashSet;
        HashSet<PolicyQualifierInfo> hashSet2 = hashSet;
        hashSet = new HashSet<PolicyQualifierInfo>();
        if (object == null) {
            return hashSet2;
        }
        ASN1Sequence aSN1Sequence = object;
        object = byteArrayOutputStream;
        ASN1OutputStream aSN1OutputStream = ASN1OutputStream.create(new ByteArrayOutputStream());
        Enumeration enumeration = aSN1Sequence.getObjects();
        while (enumeration.hasMoreElements()) {
            Object object2;
            try {
                object2 = object;
                aSN1OutputStream.writeObject((ASN1Encodable)enumeration.nextElement());
                hashSet2.add(new PolicyQualifierInfo(((ByteArrayOutputStream)object).toByteArray()));
            }
            catch (IOException iOException) {
                throw new ExtCertPathValidatorException("Policy qualifier info cannot be decoded.", iOException);
            }
            ((ByteArrayOutputStream)object2).reset();
        }
        return hashSet2;
    }

    public static PKIXPolicyNode removePolicyNode(PKIXPolicyNode pKIXPolicyNode, List[] listArray, PKIXPolicyNode object) {
        PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)((PKIXPolicyNode)object).getParent();
        if (pKIXPolicyNode == null) {
            return null;
        }
        if (pKIXPolicyNode2 == null) {
            for (int i3 = 0; i3 < listArray.length; ++i3) {
                ArrayList arrayList;
                object = arrayList;
                arrayList = new ArrayList();
                listArray[i3] = object;
            }
            return null;
        }
        pKIXPolicyNode2.removeChild((PKIXPolicyNode)object);
        CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, (PKIXPolicyNode)object);
        return pKIXPolicyNode;
    }

    private static void removePolicyNodeRecurse(List[] listArray, PKIXPolicyNode object) {
        listArray[((PKIXPolicyNode)object).getDepth()].remove(object);
        if (((PKIXPolicyNode)object).hasChildren()) {
            object = ((PKIXPolicyNode)object).getChildren();
            while (object.hasNext()) {
                CertPathValidatorUtilities.removePolicyNodeRecurse(listArray, (PKIXPolicyNode)object.next());
            }
        }
    }

    public static boolean processCertD1i(int n3, List[] object, ASN1ObjectIdentifier object2, Set set) {
        Object object3 = object[n3 - 1];
        for (int i3 = 0; i3 < object3.size(); ++i3) {
            ArrayList arrayList;
            PKIXPolicyNode pKIXPolicyNode;
            HashSet hashSet;
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)object3.get(i3);
            if (!pKIXPolicyNode2.getExpectedPolicies().contains(((ASN1ObjectIdentifier)object2).getId())) continue;
            List[] listArray = object;
            object = hashSet;
            object();
            hashSet.add(((ASN1ObjectIdentifier)object2).getId());
            object3 = pKIXPolicyNode;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = object2;
            object2 = arrayList;
            arrayList = new ArrayList();
            String string2 = aSN1ObjectIdentifier.getId();
            pKIXPolicyNode2.addChild(new PKIXPolicyNode((List)object2, n3, (Set)object, pKIXPolicyNode2, set, string2, false));
            listArray[n3].add(object3);
            return true;
        }
        return false;
    }

    public static void processCertD1ii(int n3, List[] object, ASN1ObjectIdentifier object2, Set set) {
        Object object3 = object[n3 - 1];
        for (int i3 = 0; i3 < object3.size(); ++i3) {
            ArrayList arrayList;
            PKIXPolicyNode pKIXPolicyNode;
            HashSet hashSet;
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)object3.get(i3);
            if (!ANY_POLICY.equals(pKIXPolicyNode2.getValidPolicy())) continue;
            List[] listArray = object;
            object = hashSet;
            object();
            hashSet.add(((ASN1ObjectIdentifier)object2).getId());
            object3 = pKIXPolicyNode;
            ASN1ObjectIdentifier aSN1ObjectIdentifier = object2;
            object2 = arrayList;
            arrayList = new ArrayList();
            String string2 = aSN1ObjectIdentifier.getId();
            pKIXPolicyNode2.addChild(new PKIXPolicyNode((List)object2, n3, (Set)object, pKIXPolicyNode2, set, string2, false));
            listArray[n3].add(object3);
            return;
        }
    }

    public static void prepareNextCertB1(int n3, List[] object, String string2, Map object2, X509Certificate object3) {
        boolean bl = false;
        for (Object object4 : object[n3]) {
            if (!((PKIXPolicyNode)object4).getValidPolicy().equals(string2)) continue;
            bl = true;
            ((PKIXPolicyNode)object4).expectedPolicies = (Set)object2.get(string2);
            break;
        }
        if (!bl) {
            Object object5 = object[n3].iterator();
            while (object5.hasNext()) {
                ArrayList arrayList;
                PKIXPolicyNode pKIXPolicyNode;
                Object object4;
                Object object6 = (PKIXPolicyNode)object5.next();
                if (!ANY_POLICY.equals(((PKIXPolicyNode)object6).getValidPolicy())) continue;
                object5 = null;
                try {
                    object4 = ASN1Sequence.getInstance(CertPathValidatorUtilities.getExtensionValue((X509Extension)object3, CERTIFICATE_POLICIES)).getObjects();
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Certificate policies cannot be decoded.", exception);
                }
                while (object4.hasMoreElements()) {
                    PolicyInformation policyInformation;
                    try {
                        policyInformation = PolicyInformation.getInstance(object4.nextElement());
                        if (!ANY_POLICY.equals(policyInformation.getPolicyIdentifier().getId())) continue;
                    }
                    catch (Exception exception) {
                        throw new AnnotatedException("Policy information cannot be decoded.", exception);
                    }
                    try {
                        object5 = CertPathValidatorUtilities.getQualifierSet(policyInformation.getPolicyQualifiers());
                        break;
                    }
                    catch (CertPathValidatorException certPathValidatorException) {
                        throw new ExtCertPathValidatorException("Policy qualifier info set could not be built.", certPathValidatorException);
                    }
                }
                boolean bl2 = false;
                if (object3.getCriticalExtensionOIDs() != null) {
                    bl2 = object3.getCriticalExtensionOIDs().contains(CERTIFICATE_POLICIES);
                }
                if (!ANY_POLICY.equals(((PKIXPolicyNode)(object3 = (PKIXPolicyNode)((PKIXPolicyNode)object6).getParent())).getValidPolicy())) break;
                List[] listArray = object;
                object = pKIXPolicyNode;
                Map map = object2;
                object2 = arrayList;
                arrayList = new ArrayList();
                object6 = (Set)map.get(string2);
                ((PKIXPolicyNode)object3).addChild(new PKIXPolicyNode((List)object2, n3, (Set)object6, (PolicyNode)object3, (Set)object5, string2, bl2));
                listArray[n3].add(object);
                break;
            }
        }
    }

    public static PKIXPolicyNode prepareNextCertB2(int n3, List[] listArray, String string2, PKIXPolicyNode pKIXPolicyNode) {
        Iterator iterator = listArray[n3].iterator();
        while (iterator.hasNext()) {
            PKIXPolicyNode pKIXPolicyNode2 = (PKIXPolicyNode)iterator.next();
            if (!pKIXPolicyNode2.getValidPolicy().equals(string2)) continue;
            ((PKIXPolicyNode)pKIXPolicyNode2.getParent()).removeChild(pKIXPolicyNode2);
            iterator.remove();
            for (int i3 = n3 - 1; i3 >= 0; --i3) {
                PKIXPolicyNode pKIXPolicyNode3;
                List list = listArray[i3];
                for (int i4 = 0; i4 < list.size() && ((pKIXPolicyNode3 = (PKIXPolicyNode)list.get(i4)).hasChildren() || (pKIXPolicyNode = CertPathValidatorUtilities.removePolicyNode(pKIXPolicyNode, listArray, pKIXPolicyNode3)) != null); ++i4) {
                }
            }
        }
        return pKIXPolicyNode;
    }

    public static boolean isAnyPolicy(Set set) {
        return set == null || set.contains(ANY_POLICY) || set.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection findCertificates(PKIXCertStoreSelector pKIXCertStoreSelector, List sequencedCollection) {
        LinkedHashSet linkedHashSet;
        SequencedCollection<Object> sequencedCollection2 = sequencedCollection;
        sequencedCollection = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        Iterator iterator = sequencedCollection2.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object e3 = iterator.next();
            if (e3 instanceof Store) {
                try {
                    bl = sequencedCollection.addAll(((Store)e3).getMatches(pKIXCertStoreSelector));
                }
                catch (StoreException storeException) {
                    throw new AnnotatedException("Problem while picking certificates from X.509 store.", storeException);
                }
            }
            try {
                bl = sequencedCollection.addAll(PKIXCertStoreSelector.getCertificates(pKIXCertStoreSelector, (CertStore)e3));
            }
            catch (CertStoreException certStoreException) {
                throw new AnnotatedException("Problem while picking certificates from certificate store.", certStoreException);
            }
        }
        return sequencedCollection;
    }

    public static List<PKIXCRLStore> getAdditionalStoresFromCRLDistributionPoint(CRLDistPoint distributionPointArray, Map<GeneralName, PKIXCRLStore> object, Date date, JcaJceHelper jcaJceHelper) {
        if (distributionPointArray != null) {
            Object object2;
            ArrayList<PKIXCRLStore> arrayList;
            try {
                distributionPointArray = distributionPointArray.getDistributionPoints();
            }
            catch (Exception exception) {
                throw new AnnotatedException("Distribution points could not be read.", exception);
            }
            ArrayList<PKIXCRLStore> arrayList2 = arrayList;
            arrayList = new ArrayList<PKIXCRLStore>();
            for (int i3 = 0; i3 < distributionPointArray.length; ++i3) {
                GeneralName[] generalNameArray = distributionPointArray[i3].getDistributionPoint();
                if (generalNameArray == null || generalNameArray.getType() != 0) continue;
                generalNameArray = GeneralNames.getInstance(generalNameArray.getName()).getNames();
                for (int i4 = 0; i4 < generalNameArray.length; ++i4) {
                    object2 = (PKIXCRLStore)object.get(generalNameArray[i4]);
                    if (object2 == null) continue;
                    arrayList2.add((PKIXCRLStore)object2);
                }
            }
            if (arrayList2.isEmpty() && Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.x509.enableCRLDP")) {
                try {
                    object = jcaJceHelper.createCertificateFactory("X.509");
                }
                catch (Exception exception) {
                    throw new AnnotatedException(a.a(exception, b.a("cannot create certificate factory: ")), exception);
                }
                block10: for (int i5 = 0; i5 < distributionPointArray.length; ++i5) {
                    GeneralName[] generalNameArray = distributionPointArray[i5].getDistributionPoint();
                    if (generalNameArray == null || generalNameArray.getType() != 0) continue;
                    generalNameArray = GeneralNames.getInstance(generalNameArray.getName()).getNames();
                    for (int i6 = 0; i6 < generalNameArray.length; ++i6) {
                        URI uRI;
                        Date date2;
                        Object object3;
                        Object object4 = generalNameArray[i5];
                        if (((GeneralName)object4).getTagNo() != 6) continue;
                        try {
                            object3 = object;
                            date2 = date;
                        }
                        catch (Exception exception) {}
                        object2 = uRI;
                        uRI = new URI(((ASN1String)((Object)((GeneralName)object4).getName())).getString());
                        object4 = CrlCache.getCrl((CertificateFactory)object3, date2, (URI)object2);
                        if (object4 == null) continue block10;
                        arrayList2.add((PKIXCRLStore)object4);
                        continue block10;
                    }
                }
            }
            return arrayList2;
        }
        return Collections.EMPTY_LIST;
    }

    public static void getCRLIssuersFromDistributionPoint(DistributionPoint object, Collection collection, X509CRLSelector x509CRLSelector) {
        block10: {
            ArrayList<X500Name> arrayList;
            block9: {
                block8: {
                    ArrayList<X500Name> arrayList2;
                    arrayList = arrayList2;
                    arrayList2 = new ArrayList<X500Name>();
                    if (((DistributionPoint)object).getCRLIssuer() == null) break block8;
                    object = ((DistributionPoint)object).getCRLIssuer().getNames();
                    for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                        if (((GeneralName)object[i3]).getTagNo() != 4) continue;
                        try {
                            arrayList.add(X500Name.getInstance(((GeneralName)object[i3]).getName().toASN1Primitive().getEncoded()));
                        }
                        catch (IOException iOException) {
                            throw new AnnotatedException("CRL issuer information from distribution point cannot be decoded.", iOException);
                        }
                    }
                    break block9;
                }
                if (((DistributionPoint)object).getDistributionPoint() != null) {
                    object = collection.iterator();
                    while (object.hasNext()) {
                        arrayList.add((X500Name)object.next());
                    }
                }
                break block10;
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                try {
                    x509CRLSelector.addIssuerName(((X500Name)object.next()).getEncoded());
                }
                catch (IOException iOException) {
                    throw new AnnotatedException("Cannot decode CRL issuer information.", iOException);
                }
            }
            return;
        }
        throw new AnnotatedException("CRL issuer is omitted from distribution point but no distributionPoint field present.");
    }

    private static BigInteger getSerialNumber(Object object) {
        return ((X509Certificate)object).getSerialNumber();
    }

    public static void getCertStatus(Date date, X509CRL object, Object object2, CertStatus certStatus) {
        X509CRLEntry x509CRLEntry;
        block13: {
            block12: {
                try {
                    if (!X509CRLObject.isIndirectCRL((X509CRL)object)) break block12;
                    x509CRLEntry = ((X509CRL)object).getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber(object2));
                    if (x509CRLEntry == null) {
                        return;
                    }
                    X500Principal x500Principal = x509CRLEntry.getCertificateIssuer();
                    object = x500Principal == null ? PrincipalUtils.getIssuerPrincipal((X509CRL)object) : PrincipalUtils.getX500Name(x500Principal);
                }
                catch (CRLException cRLException) {
                    throw new AnnotatedException("Failed check for indirect CRL.", cRLException);
                }
                if (!PrincipalUtils.getEncodedIssuerPrincipal(object2).equals(object)) {
                    return;
                }
                break block13;
            }
            if (!PrincipalUtils.getEncodedIssuerPrincipal(object2).equals(PrincipalUtils.getIssuerPrincipal((X509CRL)object))) {
                return;
            }
            x509CRLEntry = ((X509CRL)object).getRevokedCertificate(CertPathValidatorUtilities.getSerialNumber(object2));
            if (x509CRLEntry == null) {
                return;
            }
        }
        object = null;
        if (x509CRLEntry.hasExtensions()) {
            if (!x509CRLEntry.hasUnsupportedCriticalExtension()) {
                try {
                    object = ASN1Enumerated.getInstance(CertPathValidatorUtilities.getExtensionValue(x509CRLEntry, Extension.reasonCode.getId()));
                }
                catch (Exception exception) {
                    throw new AnnotatedException("Reason code CRL entry extension could not be decoded.", exception);
                }
            } else {
                throw new AnnotatedException("CRL entry has unsupported critical extensions.");
            }
        }
        int n3 = object == null ? 0 : ((ASN1Enumerated)object).intValueExact();
        if (date.getTime() >= x509CRLEntry.getRevocationDate().getTime() || n3 == 0 || n3 == 1 || n3 == 2 || n3 == 10) {
            certStatus.setCertStatus(n3);
            certStatus.setRevocationDate(x509CRLEntry.getRevocationDate());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set getDeltaCRLs(Date cloneable, X509CRL object, List<CertStore> object2, List<PKIXCRLStore> distributionPointArray, JcaJceHelper jcaJceHelper) {
        HashSet hashSet;
        PKIXCRLStoreSelector.Builder builder;
        Object object3;
        Object object4;
        X509CRLSelector x509CRLSelector;
        Cloneable cloneable2 = x509CRLSelector;
        cloneable2();
        try {
            x509CRLSelector.addIssuerName(PrincipalUtils.getIssuerPrincipal((X509CRL)object).getEncoded());
            object4 = null;
        }
        catch (IOException iOException) {
            throw new AnnotatedException("Cannot extract issuer from CRL.", iOException);
        }
        try {
            object3 = CertPathValidatorUtilities.getExtensionValue((X509Extension)object, CRL_NUMBER);
            if (object3 != null) {
                object4 = ASN1Integer.getInstance(object3).getPositiveValue();
            }
        }
        catch (Exception exception) {
            throw new AnnotatedException("CRL number extension could not be extracted from CRL.", exception);
        }
        try {
            object = object.getExtensionValue(ISSUING_DISTRIBUTION_POINT);
            object3 = object4 == null ? null : object4.add(BigInteger.valueOf(1L));
            cloneable2.setMinCRLNumber((BigInteger)object3);
        }
        catch (Exception exception) {
            throw new AnnotatedException("Issuing distribution point extension value could not be read.", exception);
        }
        Object object5 = object3 = builder;
        ((PKIXCRLStoreSelector.Builder)object3)((CRLSelector)cloneable2);
        ((PKIXCRLStoreSelector.Builder)object5).setIssuingDistributionPoint((byte[])object);
        ((PKIXCRLStoreSelector.Builder)object5).setIssuingDistributionPointEnabled(true);
        builder.setMaxBaseCRLNumber((BigInteger)object4);
        cloneable2 = builder.build();
        object2 = CRL_UTIL.findCRLs((PKIXCRLStoreSelector)cloneable2, (Date)cloneable, (List)object2, (List)distributionPointArray);
        if (object2.isEmpty() && Properties.isOverrideSet("com.fis.ekyc.nfc.build_in.bouncycastle.x509.enableCRLDP")) {
            try {
                Iterator iterator = object;
                object = jcaJceHelper.createCertificateFactory("X.509");
                distributionPointArray = CRLDistPoint.getInstance(iterator).getDistributionPoints();
            }
            catch (Exception exception) {
                throw new AnnotatedException(a.a(exception, b.a("cannot create certificate factory: ")), exception);
            }
            block13: for (int i3 = 0; i3 < distributionPointArray.length; ++i3) {
                object4 = distributionPointArray[i3].getDistributionPoint();
                if (object4 == null || object4.getType() != 0) continue;
                object4 = GeneralNames.getInstance(object4.getName()).getNames();
                for (int i4 = 0; i4 < ((GeneralName[])object4).length; ++i4) {
                    URI uRI;
                    Cloneable cloneable3;
                    Object object6;
                    Object object7 = object4[i3];
                    if (((GeneralName)object7).getTagNo() != 6) continue;
                    try {
                        object6 = object;
                        cloneable3 = cloneable;
                    }
                    catch (Exception exception) {}
                    Object object8 = uRI;
                    uRI = new URI(((ASN1String)((Object)((GeneralName)object7).getName())).getString());
                    object7 = CrlCache.getCrl((CertificateFactory)object6, (Date)cloneable3, (URI)object8);
                    if (object7 == null) continue block13;
                    List list = object7;
                    object7 = Collections.emptyList();
                    object8 = Collections.singletonList(list);
                    object2 = CRL_UTIL.findCRLs((PKIXCRLStoreSelector)cloneable2, (Date)cloneable, (List)object7, (List)object8);
                    continue block13;
                }
            }
        }
        cloneable = hashSet;
        hashSet = new HashSet();
        object = object2.iterator();
        while (object.hasNext()) {
            object2 = (X509CRL)object.next();
            if (!CertPathValidatorUtilities.isDeltaCRL((X509CRL)object2)) continue;
            ((HashSet)cloneable).add(object2);
        }
        return cloneable;
    }

    private static boolean isDeltaCRL(X509CRL object) {
        if ((object = object.getCriticalExtensionOIDs()) == null) {
            return false;
        }
        return object.contains(RFC3280CertPathUtilities.DELTA_CRL_INDICATOR);
    }

    public static Set getCompleteCRLs(PKIXCertRevocationCheckerParameters pKIXCertRevocationCheckerParameters, DistributionPoint object, Object object2, Date date, PKIXExtendedParameters object3) {
        HashSet<X500Name> hashSet;
        X509CRLSelector x509CRLSelector;
        DistributionPoint distributionPoint = object;
        object = x509CRLSelector;
        x509CRLSelector = new X509CRLSelector();
        try {
            hashSet = new HashSet<X500Name>();
            hashSet.add(PrincipalUtils.getEncodedIssuerPrincipal(object2));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Could not get issuer information from distribution point.", annotatedException);
        }
        CertPathValidatorUtilities.getCRLIssuersFromDistributionPoint(distributionPoint, hashSet, (X509CRLSelector)object);
        if (object2 instanceof X509Certificate) {
            ((X509CRLSelector)object).setCertificateChecking((X509Certificate)object2);
        }
        object = new PKIXCRLStoreSelector.Builder((CRLSelector)object).setCompleteCRLEnabled(true).build();
        if (((PKIXExtendedParameters)object3).getDate() != null) {
            date = ((PKIXExtendedParameters)object3).getDate();
        }
        PKIXCRLStoreSelector<? extends CRL> pKIXCRLStoreSelector = object;
        PKIXExtendedParameters pKIXExtendedParameters = object3;
        object = pKIXExtendedParameters.getCertStores();
        object3 = pKIXExtendedParameters.getCRLStores();
        Set set = CRL_UTIL.findCRLs(pKIXCRLStoreSelector, date, (List)object, (List)object3);
        CertPathValidatorUtilities.checkCRLsNotEmpty(pKIXCertRevocationCheckerParameters, set, object2);
        return set;
    }

    public static Date getValidCertDateFromValidityModel(PKIXExtendedParameters pKIXExtendedParameters, CertPath certPath, int n3) {
        if (pKIXExtendedParameters.getValidityModel() == 1) {
            if (n3 <= 0) {
                return CertPathValidatorUtilities.getValidDate(pKIXExtendedParameters);
            }
            int n4 = n3 - 1;
            if (n4 == 0) {
                ASN1GeneralizedTime aSN1GeneralizedTime;
                block10: {
                    aSN1GeneralizedTime = null;
                    byte[] byArray = ((X509Certificate)certPath.getCertificates().get(n4)).getExtensionValue(ISISMTTObjectIdentifiers.id_isismtt_at_dateOfCertGen.getId());
                    if (byArray == null) break block10;
                    try {
                        aSN1GeneralizedTime = ASN1GeneralizedTime.getInstance(ASN1Primitive.fromByteArray(byArray));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new AnnotatedException("Date of cert gen extension could not be read.");
                    }
                    catch (IOException iOException) {
                        throw new AnnotatedException("Date of cert gen extension could not be read.");
                    }
                }
                if (aSN1GeneralizedTime != null) {
                    try {
                        return aSN1GeneralizedTime.getDate();
                    }
                    catch (ParseException parseException) {
                        throw new AnnotatedException("Date from date of cert gen extension could not be parsed.", parseException);
                    }
                }
                return ((X509Certificate)certPath.getCertificates().get(n4)).getNotBefore();
            }
            return ((X509Certificate)certPath.getCertificates().get(n4)).getNotBefore();
        }
        return CertPathValidatorUtilities.getValidDate(pKIXExtendedParameters);
    }

    public static PublicKey getNextWorkingKey(List object, int n3, JcaJceHelper object2) {
        Serializable serializable = ((Certificate)object.get(n3)).getPublicKey();
        if (!(serializable instanceof DSAPublicKey)) {
            return serializable;
        }
        if ((serializable = (DSAPublicKey)serializable).getParams() != null) {
            return serializable;
        }
        while (++n3 < object.size()) {
            Serializable serializable2 = ((X509Certificate)object.get(n3)).getPublicKey();
            if (serializable2 instanceof DSAPublicKey) {
                DSAPublicKeySpec dSAPublicKeySpec;
                if ((serializable2 = (DSAPublicKey)serializable2).getParams() == null) continue;
                JcaJceHelper jcaJceHelper = object2;
                object = serializable2.getParams();
                DSAPublicKeySpec dSAPublicKeySpec2 = dSAPublicKeySpec;
                Object object3 = object;
                object = serializable.getY();
                object2 = object3.getP();
                serializable = object3.getQ();
                serializable2 = object3.getG();
                dSAPublicKeySpec = new DSAPublicKeySpec((BigInteger)object, (BigInteger)object2, (BigInteger)serializable, (BigInteger)serializable2);
                try {
                    return jcaJceHelper.createKeyFactory("DSA").generatePublic(dSAPublicKeySpec2);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
            throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
        }
        throw new CertPathValidatorException("DSA parameters cannot be inherited from previous certificate.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection findIssuerCerts(X509Certificate iterator, List<CertStore> list, List<PKIXCertStore> list2) {
        List<PKIXCertStore> list3;
        Iterator iterator2;
        ArrayList arrayList;
        LinkedHashSet linkedHashSet;
        Cloneable cloneable;
        block13: {
            byte[] byArray;
            X509CertSelector x509CertSelector;
            cloneable = x509CertSelector;
            ((X509CertSelector)cloneable)();
            try {
                x509CertSelector.setSubject(PrincipalUtils.getIssuerPrincipal(iterator).getEncoded());
            }
            catch (Exception exception) {
                throw new AnnotatedException("Subject criteria for certificate selector to find issuer certificate could not be set.", exception);
            }
            try {
                byArray = iterator.getExtensionValue(AUTHORITY_KEY_IDENTIFIER);
            }
            catch (Exception exception) {}
            iterator = (Iterator)byArray;
            if (byArray == null) break block13;
            byte[] byArray2 = AuthorityKeyIdentifier.getInstance(ASN1OctetString.getInstance(iterator).getOctets()).getKeyIdentifier();
            iterator = (Iterator)byArray2;
            if (byArray2 == null) break block13;
            ((X509CertSelector)cloneable).setSubjectKeyIdentifier(new DEROctetString((byte[])iterator).getEncoded());
        }
        iterator = new PKIXCertStoreSelector.Builder((CertSelector)cloneable).build();
        cloneable = linkedHashSet;
        linkedHashSet = new LinkedHashSet();
        ArrayList arrayList2 = arrayList;
        try {
            iterator2 = iterator;
            list3 = list2;
            arrayList2();
            arrayList2.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)((Object)iterator), list));
        }
        catch (AnnotatedException annotatedException) {
            throw new AnnotatedException("Issuer certificate cannot be searched.", annotatedException);
        }
        {
            arrayList.addAll(CertPathValidatorUtilities.findCertificates((PKIXCertStoreSelector)((Object)iterator2), list3));
        }
        {
            iterator = arrayList.iterator();
        }
        while (iterator.hasNext()) {
            cloneable.add((X509Certificate)iterator.next());
        }
        return cloneable;
    }

    public static void verifyX509Certificate(X509Certificate x509Certificate, PublicKey publicKey, String string2) {
        if (string2 == null) {
            x509Certificate.verify(publicKey);
        } else {
            x509Certificate.verify(publicKey, string2);
        }
    }

    public static void checkCRLsNotEmpty(PKIXCertRevocationCheckerParameters object, Set object2, Object object3) {
        if (object2.isEmpty()) {
            if (object3 instanceof X509AttributeCertificate) {
                object2 = (X509AttributeCertificate)object3;
                PKIXCertRevocationCheckerParameters pKIXCertRevocationCheckerParameters = object;
                object = b.a("No CRLs found for issuer \"").append(object2.getIssuer().getPrincipals()[0]).append("\"").toString();
                object2 = pKIXCertRevocationCheckerParameters.getCertPath();
                int n3 = pKIXCertRevocationCheckerParameters.getIndex();
                throw new RecoverableCertPathValidatorException((String)object, null, (CertPath)object2, n3);
            }
            object2 = (X509Certificate)object3;
            PKIXCertRevocationCheckerParameters pKIXCertRevocationCheckerParameters = object;
            object = b.a("No CRLs found for issuer \"").append(RFC4519Style.INSTANCE.toString(PrincipalUtils.getIssuerPrincipal((X509Certificate)object2))).append("\"").toString();
            object2 = pKIXCertRevocationCheckerParameters.getCertPath();
            int n4 = pKIXCertRevocationCheckerParameters.getIndex();
            throw new RecoverableCertPathValidatorException((String)object, null, (CertPath)object2, n4);
        }
    }
}

