/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;

public class DHUtil {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey serializable) {
        if (serializable instanceof DHPublicKey) {
            serializable = (DHPublicKey)serializable;
            BigInteger bigInteger = serializable.getY();
            BigInteger bigInteger2 = serializable.getParams().getP();
            PublicKey publicKey = serializable;
            serializable = publicKey.getParams().getG();
            int n3 = publicKey.getParams().getL();
            return new DHPublicKeyParameters(bigInteger, new DHParameters(bigInteger2, (BigInteger)serializable, null, n3));
        }
        throw new InvalidKeyException("can't identify DH public key.");
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey serializable) {
        if (serializable instanceof DHPrivateKey) {
            serializable = (DHPrivateKey)serializable;
            BigInteger bigInteger = serializable.getX();
            BigInteger bigInteger2 = serializable.getParams().getP();
            PrivateKey privateKey = serializable;
            serializable = privateKey.getParams().getG();
            int n3 = privateKey.getParams().getL();
            return new DHPrivateKeyParameters(bigInteger, new DHParameters(bigInteger2, (BigInteger)serializable, null, n3));
        }
        throw new InvalidKeyException("can't identify DH private key.");
    }
}

