/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Primitive;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.DHParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.DHDomainParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.util.a;
import com.fis.ekyc.nfc.build_in.bouncycastle.jcajce.provider.asymmetric.util.KeyUtil;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class JCEDHPublicKey
implements DHPublicKey {
    public static final long serialVersionUID = -216691575254424324L;
    private BigInteger y;
    private DHParameterSpec dhSpec;
    private SubjectPublicKeyInfo info;

    public JCEDHPublicKey(DHPublicKeySpec dHPublicKeySpec) {
        JCEDHPublicKey jCEDHPublicKey = serializable;
        jCEDHPublicKey.y = dHPublicKeySpec.getY();
        DHPublicKeySpec dHPublicKeySpec2 = dHPublicKeySpec;
        Serializable serializable = dHPublicKeySpec2.getP();
        jCEDHPublicKey.dhSpec = new DHParameterSpec((BigInteger)serializable, dHPublicKeySpec2.getG());
    }

    public JCEDHPublicKey(DHPublicKey dHPublicKey) {
        this.y = dHPublicKey.getY();
        this.dhSpec = dHPublicKey.getParams();
    }

    public JCEDHPublicKey(DHPublicKeyParameters dHPublicKeyParameters) {
        JCEDHPublicKey jCEDHPublicKey = serializable;
        jCEDHPublicKey.y = dHPublicKeyParameters.getY();
        DHPublicKeyParameters dHPublicKeyParameters2 = dHPublicKeyParameters;
        Serializable serializable = dHPublicKeyParameters2.getParameters().getG();
        jCEDHPublicKey.dhSpec = new DHParameterSpec(dHPublicKeyParameters.getParameters().getP(), (BigInteger)serializable, dHPublicKeyParameters2.getParameters().getL());
    }

    public JCEDHPublicKey(BigInteger bigInteger, DHParameterSpec dHParameterSpec) {
        this.y = bigInteger;
        this.dhSpec = dHParameterSpec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JCEDHPublicKey(SubjectPublicKeyInfo object) {
        Object object2;
        Object object3 = object;
        ((JCEDHPublicKey)object2).info = object;
        try {
            ((JCEDHPublicKey)object2).y = ((ASN1Integer)((SubjectPublicKeyInfo)object).parsePublicKey()).getValue();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DH public key");
        }
        object = ASN1Sequence.getInstance(((SubjectPublicKeyInfo)object3).getAlgorithmId().getParameters());
        Object object4 = ((SubjectPublicKeyInfo)object3).getAlgorithmId().getAlgorithm();
        if (!((ASN1Primitive)object4).equals(PKCSObjectIdentifiers.dhKeyAgreement) && !((JCEDHPublicKey)object2).isPKCSParam((ASN1Sequence)object)) {
            if (!((ASN1Primitive)object4).equals(X9ObjectIdentifiers.dhpublicnumber)) throw new IllegalArgumentException(a.a("unknown algorithm type: ", (ASN1ObjectIdentifier)object4));
            JCEDHPublicKey jCEDHPublicKey = object2;
            object2 = DHDomainParameters.getInstance(object);
            jCEDHPublicKey.dhSpec = new DHParameterSpec(((DHDomainParameters)object2).getP().getValue(), ((DHDomainParameters)object2).getG().getValue());
            return;
        } else if (((DHParameter)(object = DHParameter.getInstance(object))).getL() != null) {
            JCEDHPublicKey jCEDHPublicKey = object2;
            Object object5 = object;
            object2 = ((DHParameter)object5).getP();
            object4 = ((DHParameter)object5).getG();
            jCEDHPublicKey.dhSpec = new DHParameterSpec((BigInteger)object2, (BigInteger)object4, ((DHParameter)object).getL().intValue());
            return;
        } else {
            DHParameterSpec dHParameterSpec;
            JCEDHPublicKey jCEDHPublicKey = object2;
            object2 = dHParameterSpec;
            Object object6 = object;
            object = ((DHParameter)object6).getP();
            dHParameterSpec = new DHParameterSpec((BigInteger)object, ((DHParameter)object6).getG());
            jCEDHPublicKey.dhSpec = object2;
        }
    }

    private boolean isPKCSParam(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 2) {
            return true;
        }
        if (aSN1Sequence.size() > 3) {
            return false;
        }
        ASN1Sequence aSN1Sequence2 = aSN1Sequence;
        ASN1Integer aSN1Integer = ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(2));
        return aSN1Integer.getValue().compareTo(BigInteger.valueOf(ASN1Integer.getInstance(aSN1Sequence2.getObjectAt(0)).getValue().bitLength())) <= 0;
    }

    private void readObject(ObjectInputStream object) {
        JCEDHPublicKey jCEDHPublicKey = serializable;
        jCEDHPublicKey.y = (BigInteger)((ObjectInputStream)object).readObject();
        ObjectInputStream objectInputStream = object;
        Serializable serializable = (BigInteger)objectInputStream.readObject();
        object = (BigInteger)objectInputStream.readObject();
        int n3 = objectInputStream.readInt();
        jCEDHPublicKey.dhSpec = new DHParameterSpec((BigInteger)serializable, (BigInteger)object, n3);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.getY());
        objectOutputStream.writeObject(this.dhSpec.getP());
        objectOutputStream.writeObject(this.dhSpec.getG());
        objectOutputStream.writeInt(this.dhSpec.getL());
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        Object object = this.info;
        if (object != null) {
            return KeyUtil.getEncodedSubjectPublicKeyInfo((SubjectPublicKeyInfo)object);
        }
        JCEDHPublicKey jCEDHPublicKey = this;
        object = jCEDHPublicKey.dhSpec.getG();
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(PKCSObjectIdentifiers.dhKeyAgreement, new DHParameter(this.dhSpec.getP(), (BigInteger)object, jCEDHPublicKey.dhSpec.getL())), new ASN1Integer(this.y));
    }

    @Override
    public DHParameterSpec getParams() {
        return this.dhSpec;
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }
}

