/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Integer;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.DERNull;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.DSAParameter;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.params.DSAPublicKeyParameters;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAParameterSpec;
import java.security.spec.DSAPublicKeySpec;

public class JDKDSAPublicKey
implements DSAPublicKey {
    private static final long serialVersionUID = 1752452449903495175L;
    private BigInteger y;
    private DSAParams dsaSpec;

    public JDKDSAPublicKey(DSAPublicKeySpec object) {
        JDKDSAPublicKey jDKDSAPublicKey = serializable;
        jDKDSAPublicKey.y = ((DSAPublicKeySpec)object).getY();
        DSAPublicKeySpec dSAPublicKeySpec = object;
        Serializable serializable = dSAPublicKeySpec.getP();
        object = dSAPublicKeySpec.getQ();
        BigInteger bigInteger = dSAPublicKeySpec.getG();
        jDKDSAPublicKey.dsaSpec = new DSAParameterSpec((BigInteger)serializable, (BigInteger)object, bigInteger);
    }

    public JDKDSAPublicKey(DSAPublicKey dSAPublicKey) {
        this.y = dSAPublicKey.getY();
        this.dsaSpec = dSAPublicKey.getParams();
    }

    public JDKDSAPublicKey(DSAPublicKeyParameters dSAPublicKeyParameters) {
        JDKDSAPublicKey jDKDSAPublicKey = serializable;
        jDKDSAPublicKey.y = dSAPublicKeyParameters.getY();
        DSAPublicKeyParameters dSAPublicKeyParameters2 = dSAPublicKeyParameters;
        Serializable serializable = dSAPublicKeyParameters2.getParameters().getQ();
        jDKDSAPublicKey.dsaSpec = new DSAParameterSpec(dSAPublicKeyParameters.getParameters().getP(), (BigInteger)serializable, dSAPublicKeyParameters2.getParameters().getG());
    }

    public JDKDSAPublicKey(BigInteger bigInteger, DSAParameterSpec dSAParameterSpec) {
        this.y = bigInteger;
        this.dsaSpec = dSAParameterSpec;
    }

    public JDKDSAPublicKey(SubjectPublicKeyInfo object) {
        block2: {
            try {
                ((JDKDSAPublicKey)object3).y = ((ASN1Integer)((SubjectPublicKeyInfo)object).parsePublicKey()).getValue();
                if (!((JDKDSAPublicKey)object3).isNotNull(((SubjectPublicKeyInfo)object).getAlgorithm().getParameters())) break block2;
                JDKDSAPublicKey jDKDSAPublicKey = object3;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("invalid info structure in DSA public key");
            }
            Object object2 = object3 = DSAParameter.getInstance(((SubjectPublicKeyInfo)object).getAlgorithm().getParameters());
            Object object3 = ((DSAParameter)object2).getP();
            object = ((DSAParameter)object2).getQ();
            BigInteger bigInteger = ((DSAParameter)object2).getG();
            jDKDSAPublicKey.dsaSpec = new DSAParameterSpec((BigInteger)object3, (BigInteger)object, bigInteger);
        }
    }

    private boolean isNotNull(ASN1Encodable aSN1Encodable) {
        return aSN1Encodable != null && !DERNull.INSTANCE.equals(aSN1Encodable);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        JDKDSAPublicKey jDKDSAPublicKey = serializable;
        jDKDSAPublicKey.y = (BigInteger)objectInputStream.readObject();
        ObjectInputStream objectInputStream2 = objectInputStream;
        Serializable serializable = (BigInteger)objectInputStream2.readObject();
        jDKDSAPublicKey.dsaSpec = new DSAParameterSpec((BigInteger)objectInputStream.readObject(), (BigInteger)serializable, (BigInteger)objectInputStream2.readObject());
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.writeObject(this.y);
        objectOutputStream.writeObject(this.dsaSpec.getP());
        objectOutputStream.writeObject(this.dsaSpec.getQ());
        objectOutputStream.writeObject(this.dsaSpec.getG());
    }

    @Override
    public String getAlgorithm() {
        return "DSA";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public byte[] getEncoded() {
        try {
            var1_1 = this.dsaSpec;
            if (var1_1 != null) ** GOTO lbl15
        }
        catch (IOException v0) {
            return null;
        }
        v1 = v2;
        v3 = v2;
        v4 = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa);
        var1_1 = v5;
        v5 = new ASN1Integer(this.y);
        v1(v4, (ASN1Encodable)var1_1);
        return v3.getEncoded("DER");
lbl15:
        // 1 sources

        v6 = v7;
        v8 = v7;
        v9 = v10;
        v11 = v10;
        v12 = X9ObjectIdentifiers.id_dsa;
        v13 = v14;
        v15 = v14;
        v16 = var1_1.getP();
        v17 = this;
        v18 = v17;
        var1_1 = v17.dsaSpec.getQ();
        v13(v16, (BigInteger)var1_1, v18.dsaSpec.getG());
        v9(v12, v15);
        v6(v11, new ASN1Integer(this.y));
        return v8.getEncoded("DER");
    }

    @Override
    public DSAParams getParams() {
        return this.dsaSpec;
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = Strings.lineSeparator();
        stringBuffer.append("DSA Public Key").append(string2);
        stringBuffer.append("            y: ").append(this.getY().toString(16)).append(string2);
        return stringBuffer.toString();
    }

    public int hashCode() {
        return this.getY().hashCode() ^ this.getParams().getG().hashCode() ^ this.getParams().getP().hashCode() ^ this.getParams().getQ().hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DSAPublicKey)) {
            return false;
        }
        object = (DSAPublicKey)object;
        return this.getY().equals(object.getY()) && this.getParams().getG().equals(object.getParams().getG()) && this.getParams().getP().equals(object.getParams().getP()) && this.getParams().getQ().equals(object.getParams().getQ());
    }
}

