/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Encodable;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1InputStream;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Sequence;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1Set;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.ASN1TaggedObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.pkcs.SignedData;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.PEMUtil;
import com.fis.ekyc.nfc.build_in.bouncycastle.jce.provider.X509CertificateObject;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.X509StreamParserSpi;
import com.fis.ekyc.nfc.build_in.bouncycastle.x509.util.StreamParsingException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;

public class X509CertParser
extends X509StreamParserSpi {
    private static final PEMUtil PEM_PARSER = new PEMUtil("CERTIFICATE");
    private ASN1Set sData = null;
    private int sDataObjectCount = 0;
    private InputStream currentStream = null;

    private Certificate readDERCertificate(InputStream object) {
        if (((ASN1Sequence)(object = (ASN1Sequence)new ASN1InputStream((InputStream)object).readObject())).size() > 1 && ((ASN1Sequence)object).getObjectAt(0) instanceof ASN1ObjectIdentifier && ((ASN1Sequence)object).getObjectAt(0).equals(PKCSObjectIdentifiers.signedData)) {
            this.sData = new SignedData(ASN1Sequence.getInstance((ASN1TaggedObject)((ASN1Sequence)object).getObjectAt(1), true)).getCertificates();
            return this.getCertificate();
        }
        return new X509CertificateObject(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate.getInstance(object));
    }

    private Certificate getCertificate() {
        if (this.sData != null) {
            while (this.sDataObjectCount < this.sData.size()) {
                int n3 = this.sDataObjectCount;
                this.sDataObjectCount = n3 + 1;
                ASN1Encodable aSN1Encodable = this.sData.getObjectAt(n3);
                if (!(aSN1Encodable instanceof ASN1Sequence)) continue;
                return new X509CertificateObject(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Encodable));
            }
        }
        return null;
    }

    private Certificate readPEMCertificate(InputStream inputStream) {
        ASN1Sequence aSN1Sequence = PEM_PARSER.readPEMObject(inputStream);
        if (aSN1Sequence != null) {
            return new X509CertificateObject(com.fis.ekyc.nfc.build_in.bouncycastle.asn1.x509.Certificate.getInstance(aSN1Sequence));
        }
        return null;
    }

    @Override
    public void engineInit(InputStream inputStream) {
        X509CertParser x509CertParser = this;
        x509CertParser.currentStream = inputStream;
        x509CertParser.sData = null;
        x509CertParser.sDataObjectCount = 0;
        if (!inputStream.markSupported()) {
            this.currentStream = new BufferedInputStream(this.currentStream);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object engineRead() {
        try {
            ASN1Set aSN1Set = this.sData;
            if (aSN1Set != null) {
                if (this.sDataObjectCount != aSN1Set.size()) {
                    return this.getCertificate();
                }
                X509CertParser x509CertParser = this;
                x509CertParser.sData = null;
                x509CertParser.sDataObjectCount = 0;
                return null;
            }
            X509CertParser x509CertParser = this;
            x509CertParser.currentStream.mark(10);
            int n3 = x509CertParser.currentStream.read();
            if (n3 == -1) {
                return null;
            }
            if (n3 != 48) {
                X509CertParser x509CertParser2 = this;
                x509CertParser2.currentStream.reset();
                return x509CertParser2.readPEMCertificate(x509CertParser2.currentStream);
            }
            X509CertParser x509CertParser3 = this;
            x509CertParser3.currentStream.reset();
            return x509CertParser3.readDERCertificate(x509CertParser3.currentStream);
        }
        catch (Exception exception) {
            throw new StreamParsingException(((Object)exception).toString(), exception);
        }
    }

    @Override
    public Collection engineReadAll() {
        Certificate certificate;
        ArrayList<Certificate> arrayList;
        ArrayList<Certificate> arrayList2 = arrayList;
        arrayList = new ArrayList<Certificate>();
        while ((certificate = (Certificate)this.engineRead()) != null) {
            arrayList2.add(certificate);
        }
        return arrayList2;
    }
}

