/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.jce.spec;

import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.security.spec.AlgorithmParameterSpec;

public class IESParameterSpec
implements AlgorithmParameterSpec {
    private byte[] derivation;
    private byte[] encoding;
    private int macKeySize;
    private int cipherKeySize;
    private byte[] nonce;
    private boolean usePointCompression;

    public IESParameterSpec(byte[] byArray, byte[] byArray2, int n3) {
        this(byArray, byArray2, n3, -1, null, false);
    }

    public IESParameterSpec(byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3) {
        this(byArray, byArray2, n3, n4, byArray3, false);
    }

    public IESParameterSpec(byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, boolean bl) {
        if (byArray != null) {
            byArray = new byte[byArray.length];
            this.derivation = byArray;
            int n5 = byArray.length;
            System.arraycopy(byArray, 0, byArray, 0, n5);
        } else {
            this.derivation = null;
        }
        if (byArray2 != null) {
            byArray = new byte[byArray2.length];
            this.encoding = byArray;
            int n6 = byArray2.length;
            System.arraycopy(byArray2, 0, byArray, 0, n6);
        } else {
            this.encoding = null;
        }
        this.macKeySize = n3;
        this.cipherKeySize = n4;
        this.nonce = Arrays.clone(byArray3);
        this.usePointCompression = bl;
    }

    public byte[] getDerivationV() {
        return Arrays.clone(this.derivation);
    }

    public byte[] getEncodingV() {
        return Arrays.clone(this.encoding);
    }

    public int getMacKeySize() {
        return this.macKeySize;
    }

    public int getCipherKeySize() {
        return this.cipherKeySize;
    }

    public byte[] getNonce() {
        return Arrays.clone(this.nonce);
    }

    public void setPointCompression(boolean bl) {
        this.usePointCompression = bl;
    }

    public boolean getPointCompression() {
        return this.usePointCompression;
    }
}

