/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math;

import com.fis.ekyc.nfc.build_in.bouncycastle.asn1.g;
import com.fis.ekyc.nfc.build_in.bouncycastle.crypto.Digest;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import java.math.BigInteger;
import java.security.SecureRandom;

public abstract class Primes {
    public static final int SMALL_FACTOR_LIMIT = 211;
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);
    private static final BigInteger THREE = BigInteger.valueOf(3L);

    public static STOutput generateSTRandomPrime(Digest digest, int n3, byte[] byArray) {
        if (digest != null) {
            if (n3 >= 2) {
                if (byArray != null && byArray.length != 0) {
                    return Primes.implSTRandomPrime(digest, n3, Arrays.clone(byArray));
                }
                throw new IllegalArgumentException("'inputSeed' cannot be null or empty");
            }
            throw new IllegalArgumentException("'length' must be >= 2");
        }
        throw new IllegalArgumentException("'hash' cannot be null");
    }

    public static MROutput enhancedMRProbablePrimeTest(BigInteger bigInteger, SecureRandom serializable, int n3) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (serializable != null) {
            if (n3 >= 1) {
                if (bigInteger.bitLength() == 2) {
                    return MROutput.probablyPrime();
                }
                if (!bigInteger.testBit(0)) {
                    return MROutput.provablyCompositeWithFactor(Primes.TWO);
                }
                BigInteger bigInteger2 = bigInteger.subtract(ONE);
                BigInteger bigInteger3 = bigInteger.subtract(TWO);
                int n4 = bigInteger2.getLowestSetBit();
                BigInteger bigInteger4 = bigInteger2.shiftRight(n4);
                for (int i3 = 0; i3 < n3; ++i3) {
                    BigInteger bigInteger5;
                    boolean bl;
                    BigInteger bigInteger6;
                    block12: {
                        BigInteger bigInteger7;
                        bigInteger6 = BigIntegers.createRandomInRange(TWO, bigInteger3, serializable);
                        BigInteger bigInteger8 = bigInteger6.gcd(bigInteger);
                        if (bigInteger8.compareTo(bigInteger7 = ONE) > 0) {
                            return MROutput.provablyCompositeWithFactor(bigInteger8);
                        }
                        if ((bigInteger6 = bigInteger6.modPow(bigInteger4, bigInteger)).equals(bigInteger7) || bigInteger6.equals(bigInteger2)) continue;
                        bl = false;
                        for (int i4 = 1; i4 < n4; ++i4) {
                            bigInteger5 = bigInteger6.modPow(TWO, bigInteger);
                            if (bigInteger5.equals(bigInteger2)) {
                                bl = true;
                            } else if (!bigInteger5.equals(ONE)) {
                                bigInteger6 = bigInteger5;
                                continue;
                            }
                            break block12;
                        }
                        bigInteger5 = bigInteger6;
                    }
                    if (bl) continue;
                    serializable = ONE;
                    if (!bigInteger5.equals(serializable) && (bigInteger6 = bigInteger5.modPow(TWO, bigInteger)).equals(serializable)) {
                        bigInteger6 = bigInteger5;
                    }
                    if ((bigInteger = bigInteger6.subtract((BigInteger)serializable).gcd(bigInteger)).compareTo((BigInteger)serializable) > 0) {
                        return MROutput.provablyCompositeWithFactor(bigInteger);
                    }
                    return MROutput.provablyCompositeNotPrimePower();
                }
                return MROutput.probablyPrime();
            }
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        throw new IllegalArgumentException("'random' cannot be null");
    }

    public static boolean hasAnySmallFactors(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        Primes.checkCandidate(bigInteger2, "candidate");
        return Primes.implHasAnySmallFactors(bigInteger2);
    }

    public static boolean isMRProbablePrime(BigInteger bigInteger, SecureRandom secureRandom, int n3) {
        Primes.checkCandidate(bigInteger, "candidate");
        if (secureRandom != null) {
            if (n3 >= 1) {
                if (bigInteger.bitLength() == 2) {
                    return true;
                }
                if (!bigInteger.testBit(0)) {
                    return false;
                }
                BigInteger bigInteger2 = bigInteger.subtract(ONE);
                BigInteger bigInteger3 = bigInteger.subtract(TWO);
                int n4 = bigInteger2.getLowestSetBit();
                BigInteger bigInteger4 = bigInteger2.shiftRight(n4);
                for (int i3 = 0; i3 < n3; ++i3) {
                    BigInteger bigInteger5 = BigIntegers.createRandomInRange(TWO, bigInteger3, secureRandom);
                    if (Primes.implMRProbablePrimeToBase(bigInteger, bigInteger2, bigInteger4, n4, bigInteger5)) continue;
                    return false;
                }
                return true;
            }
            throw new IllegalArgumentException("'iterations' must be > 0");
        }
        throw new IllegalArgumentException("'random' cannot be null");
    }

    public static boolean isMRProbablePrimeToBase(BigInteger bigInteger, BigInteger bigInteger2) {
        Primes.checkCandidate(bigInteger, "candidate");
        Primes.checkCandidate(bigInteger2, "base");
        BigInteger bigInteger3 = ONE;
        if (bigInteger2.compareTo(bigInteger.subtract(bigInteger3)) < 0) {
            if (bigInteger.bitLength() == 2) {
                return true;
            }
            BigInteger bigInteger4 = bigInteger;
            BigInteger bigInteger5 = bigInteger4.subtract(bigInteger3);
            int n3 = bigInteger5.getLowestSetBit();
            return Primes.implMRProbablePrimeToBase(bigInteger4, bigInteger5, bigInteger5.shiftRight(n3), n3, bigInteger2);
        }
        throw new IllegalArgumentException("'base' must be < ('candidate' - 1)");
    }

    private static void checkCandidate(BigInteger bigInteger, String string2) {
        if (bigInteger != null && bigInteger.signum() >= 1 && bigInteger.bitLength() >= 2) {
            return;
        }
        throw new IllegalArgumentException(g.a("'", string2, "' must be non-null and >= 2"));
    }

    private static boolean implHasAnySmallFactors(BigInteger bigInteger) {
        int n3 = bigInteger.mod(BigInteger.valueOf(223092870)).intValue();
        if (n3 % 2 != 0 && n3 % 3 != 0 && n3 % 5 != 0 && n3 % 7 != 0 && n3 % 11 != 0 && n3 % 13 != 0 && n3 % 17 != 0 && n3 % 19 != 0 && n3 % 23 != 0) {
            n3 = bigInteger.mod(BigInteger.valueOf(58642669)).intValue();
            if (n3 % 29 != 0 && n3 % 31 != 0 && n3 % 37 != 0 && n3 % 41 != 0 && n3 % 43 != 0) {
                n3 = bigInteger.mod(BigInteger.valueOf(600662303)).intValue();
                if (n3 % 47 != 0 && n3 % 53 != 0 && n3 % 59 != 0 && n3 % 61 != 0 && n3 % 67 != 0) {
                    n3 = bigInteger.mod(BigInteger.valueOf(33984931)).intValue();
                    if (n3 % 71 != 0 && n3 % 73 != 0 && n3 % 79 != 0 && n3 % 83 != 0) {
                        n3 = bigInteger.mod(BigInteger.valueOf(89809099)).intValue();
                        if (n3 % 89 != 0 && n3 % 97 != 0 && n3 % 101 != 0 && n3 % 103 != 0) {
                            n3 = bigInteger.mod(BigInteger.valueOf(167375713)).intValue();
                            if (n3 % 107 != 0 && n3 % 109 != 0 && n3 % 113 != 0 && n3 % 127 != 0) {
                                n3 = bigInteger.mod(BigInteger.valueOf(371700317)).intValue();
                                if (n3 % 131 != 0 && n3 % 137 != 0 && n3 % 139 != 0 && n3 % 149 != 0) {
                                    n3 = bigInteger.mod(BigInteger.valueOf(645328247)).intValue();
                                    if (n3 % 151 != 0 && n3 % 157 != 0 && n3 % 163 != 0 && n3 % 167 != 0) {
                                        n3 = bigInteger.mod(BigInteger.valueOf(1070560157)).intValue();
                                        if (n3 % 173 != 0 && n3 % 179 != 0 && n3 % 181 != 0 && n3 % 191 != 0) {
                                            int n4 = bigInteger.mod(BigInteger.valueOf(1596463769)).intValue();
                                            return n4 % 193 == 0 || n4 % 197 == 0 || n4 % 199 == 0 || n4 % 211 == 0;
                                            {
                                            }
                                        }
                                        return true;
                                    }
                                    return true;
                                }
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                    return true;
                }
                return true;
            }
            return true;
        }
        return true;
    }

    private static boolean implMRProbablePrimeToBase(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, int n3, BigInteger bigInteger4) {
        if (!(bigInteger3 = bigInteger4.modPow(bigInteger3, bigInteger)).equals(ONE) && !bigInteger3.equals(bigInteger2)) {
            boolean bl = false;
            for (int i3 = 1; i3 < n3; ++i3) {
                if ((bigInteger3 = bigInteger3.modPow(TWO, bigInteger)).equals(bigInteger2)) {
                    bl = true;
                    break;
                }
                if (!bigInteger3.equals(ONE)) continue;
                return false;
            }
            return bl;
        }
        return true;
    }

    private static STOutput implSTRandomPrime(Digest digest, int n3, byte[] object) {
        int n4 = digest.getDigestSize();
        if (n3 < 33) {
            int n5 = n4;
            n4 = 0;
            byte[] byArray = new byte[n5];
            byte[] byArray2 = new byte[n5];
            do {
                Primes.hash(digest, (byte[])object, byArray, 0);
                Primes.inc((byte[])object, 1);
                Primes.hash(digest, (byte[])object, byArray2, 0);
                Primes.inc((byte[])object, 1);
                ++n4;
                long l3 = (long)((Primes.extract32(byArray) ^ Primes.extract32(byArray2)) & -1 >>> 32 - n3 | (1 << n3 - 1 | 1)) & 0xFFFFFFFFL;
                if (!Primes.isPrime32(l3)) continue;
                return new STOutput(BigInteger.valueOf(l3), (byte[])object, n4, null);
            } while (n4 <= n3 * 4);
            throw new IllegalStateException("Too many iterations in Shawe-Taylor Random_Prime Routine");
        }
        STOutput sTOutput = Primes.implSTRandomPrime(digest, (n3 + 3) / 2, (byte[])object);
        object = sTOutput.getPrime();
        byte[] byArray = sTOutput.getPrimeSeed();
        int n6 = sTOutput.getPrimeGenCounter();
        int n7 = n4 * 8;
        int n8 = n3 - 1;
        n7 = n8 / n7 + 1;
        BigInteger bigInteger = ONE;
        BigInteger bigInteger2 = ((BigInteger)object).shiftLeft(1);
        BigInteger bigInteger3 = Primes.hashGen(digest, byArray, n7).mod(bigInteger.shiftLeft(n8)).setBit(n8).subtract(bigInteger).divide(bigInteger2).add(bigInteger).shiftLeft(1);
        int n9 = 0;
        bigInteger = bigInteger3.multiply((BigInteger)object).add(bigInteger);
        int n10 = n6;
        while (true) {
            if (bigInteger.bitLength() > n3) {
                bigInteger = ONE;
                bigInteger3 = bigInteger.shiftLeft(n8).subtract(bigInteger).divide(bigInteger2).add(bigInteger).shiftLeft(1);
                bigInteger = bigInteger3.multiply((BigInteger)object).add(bigInteger);
            }
            ++n10;
            if (!Primes.implHasAnySmallFactors(bigInteger)) {
                BigInteger bigInteger4;
                bigInteger3 = bigInteger3.add(BigInteger.valueOf(n9));
                n9 = 0;
                BigInteger bigInteger5 = Primes.hashGen(digest, byArray, n7).mod(bigInteger.subtract(THREE)).add(TWO).modPow(bigInteger3, bigInteger);
                if (bigInteger.gcd(bigInteger5.subtract(bigInteger4 = ONE)).equals(bigInteger4) && bigInteger5.modPow((BigInteger)object, bigInteger).equals(bigInteger4)) {
                    return new STOutput(bigInteger, byArray, n10, null);
                }
            } else {
                Primes.inc(byArray, n7);
            }
            if (n10 >= n3 * 4 + n6) break;
            n9 += 2;
            bigInteger = bigInteger.add(bigInteger2);
        }
        throw new IllegalStateException("Too many iterations in Shawe-Taylor Random_Prime Routine");
    }

    private static int extract32(byte[] byArray) {
        int n3 = 0;
        int n4 = Math.min(4, byArray.length);
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n3;
            n3 = n5 + 1;
            n5 = n6 | (byArray[byArray.length - n3] & 0xFF) << n5 * 8;
            int n7 = n3;
            n3 = n5;
            n5 = n7;
        }
        return n3;
    }

    private static void hash(Digest digest, byte[] byArray, byte[] byArray2, int n3) {
        Digest digest2 = digest;
        int n4 = byArray.length;
        digest2.update(byArray, 0, n4);
        digest2.doFinal(byArray2, n3);
    }

    private static BigInteger hashGen(Digest digest, byte[] byArray, int n3) {
        int n4 = digest.getDigestSize();
        int n5 = n3 * n4;
        byte[] byArray2 = new byte[n5];
        for (int i3 = 0; i3 < n3; ++i3) {
            Primes.hash(digest, byArray, byArray2, n5 -= n4);
            Primes.inc(byArray, 1);
        }
        return new BigInteger(1, byArray2);
    }

    private static void inc(byte[] byArray, int n3) {
        int n4 = byArray.length;
        while (n3 > 0 && (n4 += -1) >= 0) {
            byArray[n4] = (byte)(n3 += byArray[n4] & 0xFF);
            n3 >>>= 8;
        }
    }

    private static boolean isPrime32(long l3) {
        if (l3 >>> 32 == 0L) {
            long l4 = l3 - 5L;
            long l5 = l4 == 0L ? 0 : (l4 < 0L ? -1 : 1);
            if (l5 <= 0) {
                return l3 == 2L || l3 == 3L || l5 == false;
            }
            if ((l3 & 1L) != 0L && l3 % 3L != 0L && l3 % 5L != 0L) {
                l5 = 8;
                long[] lArray = new long[8];
                long[] lArray2 = lArray;
                lArray[0] = 1L;
                lArray[1] = 7L;
                lArray[2] = 11L;
                lArray[3] = 13L;
                lArray[4] = 17L;
                lArray[5] = 19L;
                lArray[6] = 23L;
                lArray[7] = 29L;
                long l6 = 0L;
                int n3 = 1;
                while (true) {
                    if (n3 < l5) {
                        if (l3 % (l6 + lArray2[n3]) == 0L) {
                            return l3 < 30L;
                        }
                        ++n3;
                        continue;
                    }
                    if ((l6 += 30L) * l6 >= l3) {
                        return true;
                    }
                    n3 = 0;
                }
            }
            return false;
        }
        throw new IllegalArgumentException("Size limit exceeded");
    }

    public static class STOutput {
        private BigInteger prime;
        private byte[] primeSeed;
        private int primeGenCounter;

        private STOutput(BigInteger bigInteger, byte[] byArray, int n3) {
            this.prime = bigInteger;
            this.primeSeed = byArray;
            this.primeGenCounter = n3;
        }

        public /* synthetic */ STOutput(BigInteger bigInteger, byte[] byArray, int n3, 1 var4_4) {
            this(bigInteger, byArray, n3);
        }

        public BigInteger getPrime() {
            return this.prime;
        }

        public byte[] getPrimeSeed() {
            return this.primeSeed;
        }

        public int getPrimeGenCounter() {
            return this.primeGenCounter;
        }
    }

    public static class MROutput {
        private boolean provablyComposite;
        private BigInteger factor;

        private static MROutput probablyPrime() {
            return new MROutput(false, null);
        }

        private static MROutput provablyCompositeWithFactor(BigInteger bigInteger) {
            return new MROutput(true, bigInteger);
        }

        private static MROutput provablyCompositeNotPrimePower() {
            return new MROutput(true, null);
        }

        private MROutput(boolean bl, BigInteger bigInteger) {
            this.provablyComposite = bl;
            this.factor = bigInteger;
        }

        public BigInteger getFactor() {
            return this.factor;
        }

        public boolean isProvablyComposite() {
            return this.provablyComposite;
        }

        public boolean isNotPrimePower() {
            return this.provablyComposite && this.factor == null;
        }
    }
}

