/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.LongArray;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.BigIntegers;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Integers;
import java.math.BigInteger;
import java.util.Random;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract String getFieldName();

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement addOne();

    public abstract ECFieldElement subtract(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement divide(ECFieldElement var1);

    public abstract ECFieldElement negate();

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public int bitLength() {
        return this.toBigInteger().bitLength();
    }

    public boolean isOne() {
        return this.bitLength() == 1;
    }

    public boolean isZero() {
        return this.toBigInteger().signum() == 0;
    }

    public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiply(eCFieldElement).subtract(eCFieldElement2.multiply(eCFieldElement3));
    }

    public ECFieldElement multiplyPlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
        return this.multiply(eCFieldElement).add(eCFieldElement2.multiply(eCFieldElement3));
    }

    public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.square().subtract(eCFieldElement.multiply(eCFieldElement2));
    }

    public ECFieldElement squarePlusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return this.square().add(eCFieldElement.multiply(eCFieldElement2));
    }

    public ECFieldElement squarePow(int n3) {
        for (int i3 = 0; i3 < n3; ++i3) {
            ECFieldElement eCFieldElement = eCFieldElement.square();
        }
        return eCFieldElement;
    }

    public boolean testBitZero() {
        return this.toBigInteger().testBit(0);
    }

    public String toString() {
        return this.toBigInteger().toString(16);
    }

    public byte[] getEncoded() {
        return BigIntegers.asUnsignedByteArray((this.getFieldSize() + 7) / 8, this.toBigInteger());
    }

    public static class F2m
    extends AbstractF2m {
        public static final int GNB = 1;
        public static final int TPB = 2;
        public static final int PPB = 3;
        private int representation;
        private int m;
        private int[] ks;
        public LongArray x;

        public F2m(int n3, int n4, int n5, int n6, BigInteger bigInteger) {
            block2: {
                block5: {
                    block6: {
                        LongArray longArray;
                        block4: {
                            block3: {
                                if (bigInteger == null || bigInteger.signum() < 0 || bigInteger.bitLength() > n3) break block2;
                                if (n5 != 0 || n6 != 0) break block3;
                                F2m f2m = longArray2;
                                f2m.representation = 2;
                                int[] nArray = new int[1];
                                int[] nArray2 = nArray;
                                nArray[0] = n4;
                                f2m.ks = nArray2;
                                break block4;
                            }
                            if (n5 >= n6) break block5;
                            if (n5 <= 0) break block6;
                            F2m f2m = longArray2;
                            f2m.representation = 3;
                            int[] nArray = new int[3];
                            int[] nArray3 = nArray;
                            nArray[0] = n4;
                            nArray[1] = n5;
                            nArray[2] = n6;
                            f2m.ks = nArray3;
                        }
                        F2m f2m = longArray2;
                        f2m.m = n3;
                        LongArray longArray2 = longArray;
                        longArray = new LongArray(bigInteger);
                        f2m.x = longArray2;
                        return;
                    }
                    throw new IllegalArgumentException("k2 must be larger than 0");
                }
                throw new IllegalArgumentException("k2 must be smaller than k3");
            }
            throw new IllegalArgumentException("x value invalid in F2m field element");
        }

        public F2m(int n3, int[] nArray, LongArray longArray) {
            this.m = n3;
            n3 = nArray.length == 1 ? 2 : 3;
            F2m f2m = this;
            f2m.representation = n3;
            f2m.ks = nArray;
            f2m.x = longArray;
        }

        @Override
        public int bitLength() {
            return this.x.degree();
        }

        @Override
        public boolean isOne() {
            return this.x.isOne();
        }

        @Override
        public boolean isZero() {
            return this.x.isZero();
        }

        @Override
        public boolean testBitZero() {
            return this.x.testBitZero();
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x.toBigInteger();
        }

        @Override
        public String getFieldName() {
            return "F2m";
        }

        @Override
        public int getFieldSize() {
            return this.m;
        }

        @Override
        public ECFieldElement add(ECFieldElement eCFieldElement) {
            LongArray longArray = (LongArray)this.x.clone();
            longArray.addShiftedByWords(((F2m)eCFieldElement).x, 0);
            F2m f2m = this;
            int n3 = f2m.m;
            return new F2m(n3, f2m.ks, longArray);
        }

        @Override
        public ECFieldElement addOne() {
            F2m f2m = this;
            int n3 = f2m.m;
            int[] nArray = f2m.ks;
            return new F2m(n3, nArray, this.x.addOne());
        }

        @Override
        public ECFieldElement subtract(ECFieldElement eCFieldElement) {
            return this.add(eCFieldElement);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement eCFieldElement) {
            F2m f2m = this;
            int n3 = f2m.m;
            int[] nArray = f2m.ks;
            return new F2m(n3, nArray, this.x.modMultiply(((F2m)eCFieldElement).x, n3, nArray));
        }

        @Override
        public ECFieldElement multiplyMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement eCFieldElement3) {
            return this.multiplyPlusProduct(eCFieldElement, eCFieldElement2, eCFieldElement3);
        }

        @Override
        public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement object3) {
            LongArray longArray = this.x;
            F2m f2m = this;
            object = ((F2m)object).x;
            object2 = ((F2m)object2).x;
            object3 = ((F2m)object3).x;
            int n3 = f2m.m;
            int[] nArray = f2m.ks;
            LongArray longArray2 = longArray.multiply((LongArray)object, n3, nArray);
            F2m f2m2 = this;
            int n4 = f2m2.m;
            LongArray longArray3 = ((LongArray)object2).multiply((LongArray)object3, n4, f2m2.ks);
            if (longArray2 == longArray || longArray2 == object) {
                longArray2 = (LongArray)longArray2.clone();
            }
            F2m f2m3 = this;
            longArray2.addShiftedByWords(longArray3, 0);
            int n5 = f2m3.m;
            longArray2.reduce(n5, f2m3.ks);
            F2m f2m4 = this;
            int n6 = f2m4.m;
            return new F2m(n6, f2m4.ks, longArray2);
        }

        @Override
        public ECFieldElement divide(ECFieldElement eCFieldElement) {
            return this.multiply(eCFieldElement.invert());
        }

        @Override
        public ECFieldElement negate() {
            return this;
        }

        @Override
        public ECFieldElement square() {
            F2m f2m = this;
            int n3 = f2m.m;
            int[] nArray = f2m.ks;
            return new F2m(n3, nArray, this.x.modSquare(n3, nArray));
        }

        @Override
        public ECFieldElement squareMinusProduct(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            return this.squarePlusProduct(eCFieldElement, eCFieldElement2);
        }

        @Override
        public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
            LongArray longArray = this.x;
            F2m f2m = this;
            object = ((F2m)object).x;
            object2 = ((F2m)object2).x;
            int n3 = f2m.m;
            LongArray longArray2 = longArray.square(n3, f2m.ks);
            F2m f2m2 = this;
            int n4 = f2m2.m;
            LongArray longArray3 = ((LongArray)object).multiply((LongArray)object2, n4, f2m2.ks);
            if (longArray2 == longArray) {
                longArray2 = (LongArray)longArray2.clone();
            }
            F2m f2m3 = this;
            longArray2.addShiftedByWords(longArray3, 0);
            int n5 = f2m3.m;
            longArray2.reduce(n5, f2m3.ks);
            F2m f2m4 = this;
            int n6 = f2m4.m;
            return new F2m(n6, f2m4.ks, longArray2);
        }

        @Override
        public ECFieldElement squarePow(int n3) {
            if (n3 >= 1) {
                F2m f2m;
                F2m f2m2 = f2m;
                F2m f2m3 = f2m4;
                int n4 = f2m3.m;
                int[] nArray = f2m3.ks;
                f2m = new F2m(n4, nArray, f2m4.x.modSquareN(n3, n4, nArray));
                F2m f2m4 = f2m2;
            }
            return f2m4;
        }

        @Override
        public ECFieldElement invert() {
            F2m f2m = this;
            int n3 = f2m.m;
            int[] nArray = f2m.ks;
            return new F2m(n3, nArray, this.x.modInverse(n3, nArray));
        }

        @Override
        public ECFieldElement sqrt() {
            if (!eCFieldElement.x.isZero() && !eCFieldElement.x.isOne()) {
                F2m f2m = eCFieldElement;
                ECFieldElement eCFieldElement = f2m.squarePow(f2m.m - 1);
            }
            return eCFieldElement;
        }

        public int getRepresentation() {
            return this.representation;
        }

        public int getM() {
            return this.m;
        }

        public int getK1() {
            return this.ks[0];
        }

        public int getK2() {
            Object object = ((F2m)object).ks;
            return ((F2m)object).ks.length >= 2 ? (int)object[1] : 0;
        }

        public int getK3() {
            Object object = ((F2m)object).ks;
            return ((F2m)object).ks.length >= 3 ? (int)object[2] : 0;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof F2m)) {
                return false;
            }
            object = (F2m)object;
            return this.m == ((F2m)object).m && this.representation == ((F2m)object).representation && Arrays.areEqual(this.ks, ((F2m)object).ks) && this.x.equals(((F2m)object).x);
        }

        public int hashCode() {
            return this.x.hashCode() ^ this.m ^ Arrays.hashCode(this.ks);
        }
    }

    public static abstract class AbstractF2m
    extends ECFieldElement {
        public ECFieldElement halfTrace() {
            int n3 = this.getFieldSize();
            if ((n3 & 1) != 0) {
                n3 = n3 + 1 >>> 1;
                int n4 = 31 - Integers.numberOfLeadingZeros(n3);
                int n5 = 1;
                ECFieldElement eCFieldElement = this;
                while (n4 > 0) {
                    ECFieldElement eCFieldElement2 = eCFieldElement.squarePow(n5 << 1).add(eCFieldElement);
                    int n6 = n3 >>> (n4 += -1);
                    if ((n6 & 1) != 0) {
                        eCFieldElement2 = eCFieldElement2.squarePow(2).add(this);
                        n5 = n6;
                        eCFieldElement = eCFieldElement2;
                        continue;
                    }
                    n5 = n6;
                    eCFieldElement = eCFieldElement2;
                }
                return eCFieldElement;
            }
            throw new IllegalStateException("Half-trace only defined for odd m");
        }

        public boolean hasFastTrace() {
            return false;
        }

        public int trace() {
            int n3 = this.getFieldSize();
            int n4 = 31 - Integers.numberOfLeadingZeros(n3);
            int n5 = 1;
            ECFieldElement eCFieldElement = this;
            while (n4 > 0) {
                ECFieldElement eCFieldElement2 = eCFieldElement.squarePow(n5).add(eCFieldElement);
                int n6 = n3 >>> (n4 += -1);
                if ((n6 & 1) != 0) {
                    eCFieldElement2 = eCFieldElement2.square().add(this);
                    n5 = n6;
                    eCFieldElement = eCFieldElement2;
                    continue;
                }
                n5 = n6;
                eCFieldElement = eCFieldElement2;
            }
            if (eCFieldElement.isZero()) {
                return 0;
            }
            if (eCFieldElement.isOne()) {
                return 1;
            }
            throw new IllegalStateException("Internal error in trace calculation");
        }
    }

    public static class Fp
    extends AbstractFp {
        public BigInteger q;
        public BigInteger r;
        public BigInteger x;

        public static BigInteger calculateResidue(BigInteger bigInteger) {
            int n3 = bigInteger.bitLength();
            if (n3 >= 96 && bigInteger.shiftRight(n3 - 64).longValue() == -1L) {
                return ECConstants.ONE.shiftLeft(n3).subtract(bigInteger);
            }
            return null;
        }

        public Fp(BigInteger bigInteger, BigInteger bigInteger2) {
            this(bigInteger, Fp.calculateResidue(bigInteger), bigInteger2);
        }

        public Fp(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            if (bigInteger3 != null && bigInteger3.signum() >= 0 && bigInteger3.compareTo(bigInteger) < 0) {
                Fp fp = this;
                fp.q = bigInteger;
                fp.r = bigInteger2;
                fp.x = bigInteger3;
                return;
            }
            throw new IllegalArgumentException("x value invalid in Fp field element");
        }

        private ECFieldElement checkSqrt(ECFieldElement eCFieldElement) {
            if (!eCFieldElement.square().equals(this)) {
                eCFieldElement = null;
            }
            return eCFieldElement;
        }

        private BigInteger[] lucasSequence(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
            int n3 = bigInteger3.getLowestSetBit();
            BigInteger bigInteger4 = ECConstants.ONE;
            BigInteger bigInteger5 = ECConstants.TWO;
            int n4 = bigInteger3.bitLength() - 1;
            BigInteger bigInteger6 = bigInteger;
            BigInteger bigInteger7 = bigInteger5;
            BigInteger bigInteger8 = bigInteger4;
            bigInteger5 = bigInteger4;
            for (int i3 = n4; i3 >= n3 + 1; --i3) {
                bigInteger4 = this.modMult(bigInteger4, bigInteger5);
                if (bigInteger3.testBit(i3)) {
                    BigInteger bigInteger9 = bigInteger6;
                    bigInteger5 = this.modMult(bigInteger4, bigInteger2);
                    bigInteger8 = this.modMult(bigInteger8, bigInteger6);
                    bigInteger7 = this.modReduce(bigInteger6.multiply(bigInteger7).subtract(bigInteger.multiply(bigInteger4)));
                    bigInteger6 = this.modReduce(bigInteger9.multiply(bigInteger9).subtract(bigInteger5.shiftLeft(1)));
                    BigInteger bigInteger10 = bigInteger8;
                    bigInteger8 = bigInteger5;
                    bigInteger5 = bigInteger10;
                } else {
                    BigInteger bigInteger11 = bigInteger7;
                    bigInteger5 = this.modReduce(bigInteger8.multiply(bigInteger7).subtract(bigInteger4));
                    bigInteger6 = this.modReduce(bigInteger6.multiply(bigInteger7).subtract(bigInteger.multiply(bigInteger4)));
                    BigInteger bigInteger12 = bigInteger8 = this.modReduce(bigInteger11.multiply(bigInteger11).subtract(bigInteger4.shiftLeft(1)));
                    bigInteger8 = bigInteger4;
                    bigInteger7 = bigInteger12;
                }
                BigInteger bigInteger13 = bigInteger8;
                bigInteger8 = bigInteger5;
                bigInteger5 = bigInteger13;
            }
            Fp fp = this;
            Fp fp2 = this;
            bigInteger3 = fp2.modMult(bigInteger4, bigInteger5);
            bigInteger2 = fp2.modMult(bigInteger3, bigInteger2);
            bigInteger4 = this.modReduce(bigInteger8.multiply(bigInteger7).subtract(bigInteger3));
            bigInteger = fp.modReduce(bigInteger6.multiply(bigInteger7).subtract(bigInteger.multiply(bigInteger3)));
            bigInteger2 = fp.modMult(bigInteger3, bigInteger2);
            for (int i4 = 1; i4 <= n3; ++i4) {
                BigInteger bigInteger14 = bigInteger;
                bigInteger4 = this.modMult(bigInteger4, bigInteger);
                bigInteger = this.modReduce(bigInteger14.multiply(bigInteger14).subtract(bigInteger2.shiftLeft(1)));
                bigInteger2 = this.modMult(bigInteger2, bigInteger2);
            }
            return new BigInteger[]{bigInteger4, bigInteger};
        }

        @Override
        public BigInteger toBigInteger() {
            return this.x;
        }

        @Override
        public String getFieldName() {
            return "Fp";
        }

        @Override
        public int getFieldSize() {
            return this.q.bitLength();
        }

        public BigInteger getQ() {
            return this.q;
        }

        @Override
        public ECFieldElement add(ECFieldElement object) {
            Fp fp = bigInteger;
            ECFieldElement eCFieldElement = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            BigInteger bigInteger2 = fp2.x;
            bigInteger2 = fp.modAdd(bigInteger2, eCFieldElement.toBigInteger());
            return new Fp(bigInteger, (BigInteger)object, bigInteger2);
        }

        @Override
        public ECFieldElement addOne() {
            BigInteger bigInteger = ((Fp)((Object)bigInteger2)).x.add(ECConstants.ONE);
            if (bigInteger.compareTo(((Fp)((Object)bigInteger2)).q) == 0) {
                bigInteger = ECConstants.ZERO;
            }
            Fp fp = bigInteger2;
            BigInteger bigInteger2 = fp.q;
            return new Fp(bigInteger2, fp.r, bigInteger);
        }

        @Override
        public ECFieldElement subtract(ECFieldElement object) {
            Fp fp = bigInteger;
            ECFieldElement eCFieldElement = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            BigInteger bigInteger2 = fp2.x;
            bigInteger2 = fp.modSubtract(bigInteger2, eCFieldElement.toBigInteger());
            return new Fp(bigInteger, (BigInteger)object, bigInteger2);
        }

        @Override
        public ECFieldElement multiply(ECFieldElement object) {
            Fp fp = bigInteger;
            ECFieldElement eCFieldElement = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            BigInteger bigInteger2 = fp2.x;
            bigInteger2 = fp.modMult(bigInteger2, eCFieldElement.toBigInteger());
            return new Fp(bigInteger, (BigInteger)object, bigInteger2);
        }

        @Override
        public ECFieldElement multiplyMinusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2 = object2;
            ECFieldElement eCFieldElement3 = object;
            object = ((Fp)((Object)bigInteger)).x;
            object2 = eCFieldElement3.toBigInteger();
            Object object3 = object;
            object = eCFieldElement.toBigInteger();
            object2 = ((BigInteger)object3).multiply((BigInteger)object2);
            object = eCFieldElement2.toBigInteger().multiply((BigInteger)object);
            Fp fp = bigInteger;
            Object object4 = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            object2 = fp.modReduce(((BigInteger)object2).subtract((BigInteger)object4));
            return new Fp(bigInteger, (BigInteger)object, (BigInteger)object2);
        }

        @Override
        public ECFieldElement multiplyPlusProduct(ECFieldElement object, ECFieldElement object2, ECFieldElement eCFieldElement) {
            ECFieldElement eCFieldElement2 = object2;
            ECFieldElement eCFieldElement3 = object;
            object = ((Fp)((Object)bigInteger)).x;
            object2 = eCFieldElement3.toBigInteger();
            Object object3 = object;
            object = eCFieldElement.toBigInteger();
            object2 = ((BigInteger)object3).multiply((BigInteger)object2);
            object = eCFieldElement2.toBigInteger().multiply((BigInteger)object);
            Fp fp = bigInteger;
            Object object4 = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            object2 = fp.modReduce(((BigInteger)object2).add((BigInteger)object4));
            return new Fp(bigInteger, (BigInteger)object, (BigInteger)object2);
        }

        @Override
        public ECFieldElement divide(ECFieldElement object) {
            Fp fp = bigInteger;
            ECFieldElement eCFieldElement = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            BigInteger bigInteger2 = fp2.x;
            bigInteger2 = fp.modMult(bigInteger2, fp.modInverse(eCFieldElement.toBigInteger()));
            return new Fp(bigInteger, (BigInteger)object, bigInteger2);
        }

        @Override
        public ECFieldElement negate() {
            if (((Fp)object).x.signum() != 0) {
                Fp fp;
                Fp fp2 = fp;
                BigInteger bigInteger = ((Fp)object).q;
                Fp fp3 = object;
                Object object = fp3.r;
                fp = new Fp(bigInteger, (BigInteger)object, bigInteger.subtract(fp3.x));
                object = fp2;
            }
            return object;
        }

        @Override
        public ECFieldElement square() {
            Fp fp = bigInteger;
            BigInteger bigInteger = fp.q;
            BigInteger bigInteger2 = fp.r;
            BigInteger bigInteger3 = fp.x;
            BigInteger bigInteger4 = fp.modMult(bigInteger3, bigInteger3);
            return new Fp(bigInteger, bigInteger2, bigInteger4);
        }

        @Override
        public ECFieldElement squareMinusProduct(ECFieldElement object, ECFieldElement object2) {
            ECFieldElement eCFieldElement = object;
            Object object3 = object = ((Fp)((Object)bigInteger)).x;
            object = ((ECFieldElement)object2).toBigInteger();
            object2 = ((BigInteger)object3).multiply((BigInteger)object3);
            object = eCFieldElement.toBigInteger().multiply((BigInteger)object);
            Fp fp = bigInteger;
            Object object4 = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            object2 = fp.modReduce(((BigInteger)object2).subtract((BigInteger)object4));
            return new Fp(bigInteger, (BigInteger)object, (BigInteger)object2);
        }

        @Override
        public ECFieldElement squarePlusProduct(ECFieldElement object, ECFieldElement object2) {
            ECFieldElement eCFieldElement = object;
            Object object3 = object = ((Fp)((Object)bigInteger)).x;
            object = ((ECFieldElement)object2).toBigInteger();
            object2 = ((BigInteger)object3).multiply((BigInteger)object3);
            object = eCFieldElement.toBigInteger().multiply((BigInteger)object);
            Fp fp = bigInteger;
            Object object4 = object;
            Fp fp2 = bigInteger;
            BigInteger bigInteger = fp2.q;
            object = fp2.r;
            object2 = fp.modReduce(((BigInteger)object2).add((BigInteger)object4));
            return new Fp(bigInteger, (BigInteger)object, (BigInteger)object2);
        }

        @Override
        public ECFieldElement invert() {
            Fp fp = bigInteger;
            BigInteger bigInteger = fp.q;
            BigInteger bigInteger2 = fp.r;
            BigInteger bigInteger3 = fp.modInverse(fp.x);
            return new Fp(bigInteger, bigInteger2, bigInteger3);
        }

        @Override
        public ECFieldElement sqrt() {
            if (!((ECFieldElement)object).isZero() && !((ECFieldElement)object).isOne()) {
                if (((Fp)object).q.testBit(0)) {
                    Random random;
                    Object object;
                    if (((Fp)object).q.testBit(1)) {
                        Fp fp = object;
                        BigInteger bigInteger = fp.q.shiftRight(2).add(ECConstants.ONE);
                        Fp fp2 = object;
                        BigInteger bigInteger2 = fp2.q;
                        BigInteger bigInteger3 = fp2.r;
                        return fp.checkSqrt(new Fp(bigInteger2, bigInteger3, ((Fp)object).x.modPow(bigInteger, bigInteger2)));
                    }
                    if (((Fp)object).q.testBit(2)) {
                        Fp fp = object;
                        Fp fp3 = object;
                        BigInteger bigInteger = fp3.q.shiftRight(3);
                        BigInteger bigInteger4 = fp.modMult(bigInteger = fp.x.modPow(bigInteger, fp3.q), fp.x);
                        if (fp.modMult(bigInteger4, bigInteger).equals(ECConstants.ONE)) {
                            Fp fp4 = object;
                            Fp fp5 = object;
                            object = fp5.q;
                            return fp4.checkSqrt(new Fp((BigInteger)object, fp5.r, bigInteger4));
                        }
                        Fp fp6 = object;
                        Fp fp7 = object;
                        bigInteger = fp7.q.shiftRight(2);
                        bigInteger = fp6.modMult(bigInteger4, ECConstants.TWO.modPow(bigInteger, fp7.q));
                        Object object2 = object;
                        object = ((Fp)object2).q;
                        return fp6.checkSqrt(new Fp((BigInteger)object, ((Fp)object2).r, bigInteger));
                    }
                    Fp fp = object;
                    BigInteger bigInteger = fp.q.shiftRight(1);
                    BigInteger bigInteger5 = ECConstants.ONE;
                    if (!fp.x.modPow(bigInteger, ((Fp)object).q).equals(bigInteger5)) {
                        return null;
                    }
                    Fp fp8 = object;
                    BigInteger bigInteger6 = fp8.x;
                    BigInteger bigInteger7 = fp8.modDouble(fp8.modDouble(bigInteger6));
                    BigInteger bigInteger8 = bigInteger.add(bigInteger5);
                    bigInteger5 = ((Fp)object).q.subtract(bigInteger5);
                    Random random2 = random;
                    random = new Random();
                    while (true) {
                        BigInteger bigInteger9;
                        BigInteger bigInteger10 = bigInteger9;
                        bigInteger10(((Fp)object).q.bitLength(), random2);
                        if (bigInteger9.compareTo(((Fp)object).q) >= 0) continue;
                        BigInteger bigInteger11 = bigInteger10;
                        if (!((Fp)object).modReduce(bigInteger11.multiply(bigInteger11).subtract(bigInteger7)).modPow(bigInteger, ((Fp)object).q).equals(bigInteger5)) continue;
                        Object object3 = object;
                        BigInteger[] bigIntegerArray = super.lucasSequence(bigInteger10, bigInteger6, bigInteger8);
                        bigInteger10 = bigIntegerArray[0];
                        BigInteger bigInteger12 = bigIntegerArray[1];
                        if (((Fp)object3).modMult(bigInteger12, bigInteger12).equals(bigInteger7)) {
                            Object object4 = object;
                            object = ((Fp)object4).q;
                            bigInteger = ((Fp)object4).r;
                            bigInteger5 = ((Fp)object4).modHalfAbs(bigInteger12);
                            return new Fp((BigInteger)object, bigInteger, bigInteger5);
                        }
                        if (!bigInteger10.equals(ECConstants.ONE) && !bigInteger10.equals(bigInteger5)) break;
                    }
                    return null;
                }
                throw new RuntimeException("not done yet");
            }
            return object;
        }

        public BigInteger modAdd(BigInteger bigInteger, BigInteger bigInteger2) {
            if ((bigInteger = bigInteger.add(bigInteger2)).compareTo(this.q) >= 0) {
                bigInteger = bigInteger.subtract(this.q);
            }
            return bigInteger;
        }

        public BigInteger modDouble(BigInteger bigInteger) {
            if ((bigInteger = bigInteger.shiftLeft(1)).compareTo(this.q) >= 0) {
                bigInteger = bigInteger.subtract(this.q);
            }
            return bigInteger;
        }

        public BigInteger modHalf(BigInteger bigInteger) {
            if (bigInteger.testBit(0)) {
                bigInteger = this.q.add(bigInteger);
            }
            return bigInteger.shiftRight(1);
        }

        public BigInteger modHalfAbs(BigInteger bigInteger) {
            if (bigInteger.testBit(0)) {
                bigInteger = this.q.subtract(bigInteger);
            }
            return bigInteger.shiftRight(1);
        }

        public BigInteger modInverse(BigInteger bigInteger) {
            return BigIntegers.modOddInverse(this.q, bigInteger);
        }

        public BigInteger modMult(BigInteger bigInteger, BigInteger bigInteger2) {
            return this.modReduce(bigInteger.multiply(bigInteger2));
        }

        public BigInteger modReduce(BigInteger bigInteger) {
            if (this.r != null) {
                boolean bl = bigInteger.signum() < 0;
                if (bl) {
                    bigInteger = bigInteger.abs();
                }
                Fp fp = this;
                int n3 = fp.q.bitLength();
                boolean bl2 = fp.r.equals(ECConstants.ONE);
                while (bigInteger.bitLength() > n3 + 1) {
                    BigInteger bigInteger2 = bigInteger;
                    bigInteger = bigInteger2.shiftRight(n3);
                    BigInteger bigInteger3 = bigInteger2.subtract(bigInteger.shiftLeft(n3));
                    if (!bl2) {
                        bigInteger = bigInteger.multiply(this.r);
                    }
                    bigInteger = bigInteger.add(bigInteger3);
                }
                while (bigInteger.compareTo(this.q) >= 0) {
                    bigInteger = bigInteger.subtract(this.q);
                }
                if (bl && bigInteger.signum() != 0) {
                    bigInteger = this.q.subtract(bigInteger);
                }
            } else {
                bigInteger = bigInteger.mod(this.q);
            }
            return bigInteger;
        }

        public BigInteger modSubtract(BigInteger bigInteger, BigInteger bigInteger2) {
            if ((bigInteger = bigInteger.subtract(bigInteger2)).signum() < 0) {
                bigInteger = bigInteger.add(this.q);
            }
            return bigInteger;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fp)) {
                return false;
            }
            object = (Fp)object;
            return this.q.equals(((Fp)object).q) && this.x.equals(((Fp)object).x);
        }

        public int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }

    public static abstract class AbstractFp
    extends ECFieldElement {
    }
}

