/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.FixedPointPreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompCallback;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompInfo;
import java.math.BigInteger;

public class FixedPointUtil {
    public static final String PRECOMP_NAME = "bc_fixed_point";

    public static int getCombSize(ECCurve eCCurve) {
        BigInteger bigInteger = eCCurve.getOrder();
        return bigInteger == null ? eCCurve.getFieldSize() + 1 : bigInteger.bitLength();
    }

    public static FixedPointPreCompInfo getFixedPointPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null;
    }

    public static FixedPointPreCompInfo precompute(final ECPoint eCPoint) {
        PreCompCallback preCompCallback;
        final ECCurve eCCurve = eCPoint.getCurve();
        PreCompCallback preCompCallback2 = preCompCallback;
        preCompCallback = new PreCompCallback(){

            private boolean checkExisting(FixedPointPreCompInfo fixedPointPreCompInfo, int n3) {
                return fixedPointPreCompInfo != null && this.checkTable(fixedPointPreCompInfo.getLookupTable(), n3);
            }

            private boolean checkTable(ECLookupTable eCLookupTable, int n3) {
                return eCLookupTable != null && eCLookupTable.getSize() >= n3;
            }

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                FixedPointPreCompInfo fixedPointPreCompInfo;
                int n3;
                int n4;
                int n5;
                int n6;
                if (this.checkExisting((FixedPointPreCompInfo)(preCompInfo = preCompInfo instanceof FixedPointPreCompInfo ? (FixedPointPreCompInfo)preCompInfo : null), n6 = 1 << (n5 = (n4 = FixedPointUtil.getCombSize(eCCurve)) > 250 ? 6 : 5))) {
                    return preCompInfo;
                }
                int n7 = (n4 + n5 - 1) / n5;
                ECPoint[] eCPointArray = new ECPoint[n5 + 1];
                ECPoint[] eCPointArray2 = eCPointArray;
                eCPointArray[0] = eCPoint;
                for (n3 = 1; n3 < n5; ++n3) {
                    eCPointArray2[n3] = eCPointArray2[n3 - 1].timesPow2(n7);
                }
                eCPointArray2[n5] = eCPointArray2[0].subtract(eCPointArray2[1]);
                eCCurve.normalizeAll(eCPointArray2);
                ECPoint[] eCPointArray3 = new ECPoint[n6];
                ECPoint[] eCPointArray4 = eCPointArray3;
                eCPointArray3[0] = eCPointArray2[0];
                for (n3 = n5 - 1; n3 >= 0; --n3) {
                    int n8;
                    ECPoint eCPoint2 = eCPointArray2[n3];
                    for (int i3 = n8 = 1 << n3; i3 < n6; i3 += n8 << 1) {
                        eCPointArray4[i3] = eCPointArray4[i3 - n8].add(eCPoint2);
                    }
                }
                eCCurve.normalizeAll(eCPointArray4);
                FixedPointPreCompInfo fixedPointPreCompInfo2 = fixedPointPreCompInfo;
                fixedPointPreCompInfo2();
                fixedPointPreCompInfo2.setLookupTable(eCCurve.createCacheSafeLookupTable(eCPointArray4, 0, n6));
                fixedPointPreCompInfo2.setOffset(eCPointArray2[n5]);
                fixedPointPreCompInfo.setWidth(n5);
                return fixedPointPreCompInfo;
            }
        };
        return (FixedPointPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, preCompCallback2);
    }
}

