/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import java.math.BigInteger;

class LongArray
implements Cloneable {
    private static final short[] INTERLEAVE2_TABLE = new short[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};
    private static final int[] INTERLEAVE3_TABLE = new int[]{0, 1, 8, 9, 64, 65, 72, 73, 512, 513, 520, 521, 576, 577, 584, 585, 4096, 4097, 4104, 4105, 4160, 4161, 4168, 4169, 4608, 4609, 4616, 4617, 4672, 4673, 4680, 4681, 32768, 32769, 32776, 32777, 32832, 32833, 32840, 32841, 33280, 33281, 33288, 33289, 33344, 33345, 33352, 33353, 36864, 36865, 36872, 36873, 36928, 36929, 36936, 36937, 37376, 37377, 37384, 37385, 37440, 37441, 37448, 37449, 262144, 262145, 262152, 262153, 262208, 262209, 262216, 262217, 262656, 262657, 262664, 262665, 262720, 262721, 262728, 262729, 266240, 266241, 266248, 266249, 266304, 266305, 266312, 266313, 266752, 266753, 266760, 266761, 266816, 266817, 266824, 266825, 294912, 294913, 294920, 294921, 294976, 294977, 294984, 294985, 295424, 295425, 295432, 295433, 295488, 295489, 295496, 295497, 299008, 299009, 299016, 299017, 299072, 299073, 299080, 299081, 299520, 299521, 299528, 299529, 299584, 299585, 299592, 299593};
    private static final int[] INTERLEAVE4_TABLE = new int[]{0, 1, 16, 17, 256, 257, 272, 273, 4096, 4097, 4112, 4113, 4352, 4353, 4368, 4369, 65536, 65537, 65552, 65553, 65792, 65793, 65808, 65809, 69632, 69633, 69648, 69649, 69888, 69889, 69904, 69905, 0x100000, 0x100001, 0x100010, 0x100011, 0x100100, 0x100101, 0x100110, 0x100111, 0x101000, 0x101001, 0x101010, 0x101011, 0x101100, 0x101101, 0x101110, 0x101111, 0x110000, 0x110001, 0x110010, 0x110011, 0x110100, 0x110101, 0x110110, 0x110111, 0x111000, 0x111001, 0x111010, 0x111011, 0x111100, 0x111101, 0x111110, 0x111111, 0x1000000, 0x1000001, 0x1000010, 0x1000011, 0x1000100, 0x1000101, 0x1000110, 0x1000111, 0x1001000, 0x1001001, 0x1001010, 0x1001011, 0x1001100, 0x1001101, 0x1001110, 0x1001111, 0x1010000, 0x1010001, 0x1010010, 0x1010011, 0x1010100, 0x1010101, 0x1010110, 0x1010111, 0x1011000, 0x1011001, 0x1011010, 0x1011011, 0x1011100, 0x1011101, 0x1011110, 0x1011111, 0x1100000, 0x1100001, 0x1100010, 0x1100011, 0x1100100, 0x1100101, 0x1100110, 0x1100111, 0x1101000, 0x1101001, 0x1101010, 0x1101011, 0x1101100, 0x1101101, 0x1101110, 0x1101111, 0x1110000, 0x1110001, 0x1110010, 0x1110011, 0x1110100, 0x1110101, 0x1110110, 0x1110111, 0x1111000, 0x1111001, 0x1111010, 0x1111011, 0x1111100, 0x1111101, 0x1111110, 0x1111111, 0x10000000, 0x10000001, 0x10000010, 0x10000011, 0x10000100, 0x10000101, 0x10000110, 0x10000111, 0x10001000, 0x10001001, 0x10001010, 0x10001011, 0x10001100, 0x10001101, 0x10001110, 0x10001111, 0x10010000, 0x10010001, 0x10010010, 0x10010011, 0x10010100, 0x10010101, 0x10010110, 0x10010111, 0x10011000, 0x10011001, 0x10011010, 0x10011011, 0x10011100, 0x10011101, 0x10011110, 0x10011111, 0x10100000, 0x10100001, 0x10100010, 0x10100011, 0x10100100, 0x10100101, 0x10100110, 0x10100111, 0x10101000, 0x10101001, 0x10101010, 0x10101011, 0x10101100, 0x10101101, 0x10101110, 0x10101111, 0x10110000, 0x10110001, 0x10110010, 0x10110011, 0x10110100, 0x10110101, 0x10110110, 0x10110111, 0x10111000, 0x10111001, 0x10111010, 0x10111011, 0x10111100, 0x10111101, 0x10111110, 0x10111111, 0x11000000, 0x11000001, 0x11000010, 0x11000011, 0x11000100, 0x11000101, 0x11000110, 0x11000111, 0x11001000, 0x11001001, 0x11001010, 0x11001011, 0x11001100, 0x11001101, 0x11001110, 0x11001111, 0x11010000, 0x11010001, 0x11010010, 0x11010011, 0x11010100, 0x11010101, 0x11010110, 0x11010111, 0x11011000, 0x11011001, 0x11011010, 0x11011011, 0x11011100, 0x11011101, 0x11011110, 0x11011111, 0x11100000, 0x11100001, 0x11100010, 0x11100011, 0x11100100, 0x11100101, 0x11100110, 0x11100111, 0x11101000, 0x11101001, 0x11101010, 0x11101011, 0x11101100, 0x11101101, 0x11101110, 0x11101111, 0x11110000, 0x11110001, 0x11110010, 0x11110011, 0x11110100, 0x11110101, 0x11110110, 0x11110111, 0x11111000, 0x11111001, 0x11111010, 0x11111011, 0x11111100, 0x11111101, 0x11111110, 0x11111111};
    private static final int[] INTERLEAVE5_TABLE = new int[]{0, 1, 32, 33, 1024, 1025, 1056, 1057, 32768, 32769, 32800, 32801, 33792, 33793, 33824, 33825, 0x100000, 0x100001, 0x100020, 0x100021, 0x100400, 0x100401, 1049632, 1049633, 0x108000, 0x108001, 1081376, 1081377, 1082368, 1082369, 1082400, 1082401, 0x2000000, 0x2000001, 0x2000020, 0x2000021, 0x2000400, 33555457, 0x2000420, 33555489, 0x2008000, 33587201, 0x2008020, 33587233, 33588224, 33588225, 33588256, 33588257, 0x2100000, 0x2100001, 0x2100020, 0x2100021, 34604032, 34604033, 34604064, 34604065, 34635776, 34635777, 34635808, 34635809, 34636800, 34636801, 34636832, 34636833, 0x40000000, 0x40000001, 0x40000020, 1073741857, 0x40000400, 0x40000401, 0x40000420, 1073742881, 0x40008000, 1073774593, 1073774624, 1073774625, 0x40008400, 1073775617, 1073775648, 1073775649, 0x40100000, 0x40100001, 1074790432, 1074790433, 0x40100400, 0x40100401, 1074791456, 1074791457, 1074823168, 1074823169, 1074823200, 1074823201, 1074824192, 1074824193, 1074824224, 1074824225, 0x42000000, 1107296257, 0x42000020, 1107296289, 0x42000400, 1107297281, 0x42000420, 1107297313, 1107329024, 1107329025, 1107329056, 1107329057, 1107330048, 1107330049, 1107330080, 1107330081, 1108344832, 1108344833, 1108344864, 1108344865, 1108345856, 1108345857, 1108345888, 1108345889, 1108377600, 1108377601, 1108377632, 1108377633, 1108378624, 1108378625, 1108378656, 1108378657};
    private static final long[] INTERLEAVE7_TABLE = new long[]{0L, 1L, 128L, 129L, 16384L, 16385L, 16512L, 16513L, 0x200000L, 0x200001L, 0x200080L, 2097281L, 0x204000L, 2113537L, 2113664L, 2113665L, 0x10000000L, 0x10000001L, 0x10000080L, 0x10000081L, 0x10004000L, 0x10004001L, 268451968L, 268451969L, 0x10200000L, 0x10200001L, 270532736L, 270532737L, 270548992L, 270548993L, 270549120L, 270549121L, 0x800000000L, 0x800000001L, 0x800000080L, 0x800000081L, 0x800004000L, 34359754753L, 0x800004080L, 34359754881L, 0x800200000L, 34361835521L, 0x800200080L, 34361835649L, 34361851904L, 34361851905L, 34361852032L, 34361852033L, 0x810000000L, 0x810000001L, 0x810000080L, 0x810000081L, 34628190208L, 34628190209L, 34628190336L, 34628190337L, 34630270976L, 34630270977L, 34630271104L, 34630271105L, 34630287360L, 34630287361L, 34630287488L, 34630287489L, 0x40000000000L, 0x40000000001L, 0x40000000080L, 4398046511233L, 0x40000004000L, 0x40000004001L, 0x40000004080L, 4398046527617L, 0x40000200000L, 4398048608257L, 4398048608384L, 4398048608385L, 0x40000204000L, 4398048624641L, 4398048624768L, 4398048624769L, 0x40010000000L, 0x40010000001L, 4398314946688L, 4398314946689L, 0x40010004000L, 0x40010004001L, 4398314963072L, 4398314963073L, 4398317043712L, 4398317043713L, 4398317043840L, 4398317043841L, 4398317060096L, 4398317060097L, 4398317060224L, 4398317060225L, 0x40800000000L, 4432406249473L, 0x40800000080L, 4432406249601L, 0x40800004000L, 4432406265857L, 0x40800004080L, 4432406265985L, 4432408346624L, 4432408346625L, 4432408346752L, 4432408346753L, 4432408363008L, 4432408363009L, 4432408363136L, 4432408363137L, 4432674684928L, 4432674684929L, 4432674685056L, 4432674685057L, 4432674701312L, 4432674701313L, 4432674701440L, 4432674701441L, 4432676782080L, 4432676782081L, 4432676782208L, 4432676782209L, 4432676798464L, 4432676798465L, 4432676798592L, 4432676798593L, 0x2000000000000L, 0x2000000000001L, 0x2000000000080L, 562949953421441L, 0x2000000004000L, 562949953437697L, 562949953437824L, 562949953437825L, 0x2000000200000L, 0x2000000200001L, 0x2000000200080L, 562949955518593L, 0x2000000204000L, 562949955534849L, 562949955534976L, 562949955534977L, 0x2000010000000L, 0x2000010000001L, 562950221856896L, 562950221856897L, 562950221873152L, 562950221873153L, 562950221873280L, 562950221873281L, 0x2000010200000L, 0x2000010200001L, 562950223954048L, 562950223954049L, 562950223970304L, 562950223970305L, 562950223970432L, 562950223970433L, 0x2000800000000L, 562984313159681L, 0x2000800000080L, 562984313159809L, 562984313176064L, 562984313176065L, 562984313176192L, 562984313176193L, 0x2000800200000L, 562984315256833L, 0x2000800200080L, 562984315256961L, 562984315273216L, 562984315273217L, 562984315273344L, 562984315273345L, 562984581595136L, 562984581595137L, 562984581595264L, 562984581595265L, 562984581611520L, 562984581611521L, 562984581611648L, 562984581611649L, 562984583692288L, 562984583692289L, 562984583692416L, 562984583692417L, 562984583708672L, 562984583708673L, 562984583708800L, 562984583708801L, 0x2040000000000L, 567347999932417L, 567347999932544L, 567347999932545L, 0x2040000004000L, 567347999948801L, 567347999948928L, 567347999948929L, 0x2040000200000L, 567348002029569L, 567348002029696L, 567348002029697L, 0x2040000204000L, 567348002045953L, 567348002046080L, 567348002046081L, 567348268367872L, 567348268367873L, 567348268368000L, 567348268368001L, 567348268384256L, 567348268384257L, 567348268384384L, 567348268384385L, 567348270465024L, 567348270465025L, 567348270465152L, 567348270465153L, 567348270481408L, 567348270481409L, 567348270481536L, 567348270481537L, 567382359670784L, 567382359670785L, 567382359670912L, 567382359670913L, 567382359687168L, 567382359687169L, 567382359687296L, 567382359687297L, 567382361767936L, 567382361767937L, 567382361768064L, 567382361768065L, 567382361784320L, 567382361784321L, 567382361784448L, 567382361784449L, 567382628106240L, 567382628106241L, 567382628106368L, 567382628106369L, 567382628122624L, 567382628122625L, 567382628122752L, 567382628122753L, 567382630203392L, 567382630203393L, 567382630203520L, 567382630203521L, 567382630219776L, 567382630219777L, 567382630219904L, 567382630219905L, 0x100000000000000L, 0x100000000000001L, 0x100000000000080L, 0x100000000000081L, 0x100000000004000L, 0x100000000004001L, 72057594037944448L, 72057594037944449L, 0x100000000200000L, 0x100000000200001L, 72057594040025216L, 72057594040025217L, 72057594040041472L, 72057594040041473L, 72057594040041600L, 72057594040041601L, 0x100000010000000L, 0x100000010000001L, 0x100000010000080L, 0x100000010000081L, 0x100000010004000L, 0x100000010004001L, 72057594306379904L, 72057594306379905L, 0x100000010200000L, 0x100000010200001L, 72057594308460672L, 72057594308460673L, 72057594308476928L, 72057594308476929L, 72057594308477056L, 72057594308477057L, 0x100000800000000L, 0x100000800000001L, 0x100000800000080L, 0x100000800000081L, 72057628397682688L, 72057628397682689L, 72057628397682816L, 72057628397682817L, 72057628399763456L, 72057628399763457L, 72057628399763584L, 72057628399763585L, 72057628399779840L, 72057628399779841L, 72057628399779968L, 72057628399779969L, 0x100000810000000L, 0x100000810000001L, 0x100000810000080L, 0x100000810000081L, 72057628666118144L, 72057628666118145L, 72057628666118272L, 72057628666118273L, 72057628668198912L, 72057628668198913L, 72057628668199040L, 72057628668199041L, 72057628668215296L, 72057628668215297L, 72057628668215424L, 72057628668215425L, 0x100040000000000L, 0x100040000000001L, 72061992084439168L, 72061992084439169L, 0x100040000004000L, 0x100040000004001L, 72061992084455552L, 72061992084455553L, 72061992086536192L, 72061992086536193L, 72061992086536320L, 72061992086536321L, 72061992086552576L, 72061992086552577L, 72061992086552704L, 72061992086552705L, 0x100040010000000L, 0x100040010000001L, 72061992352874624L, 72061992352874625L, 0x100040010004000L, 0x100040010004001L, 72061992352891008L, 72061992352891009L, 72061992354971648L, 72061992354971649L, 72061992354971776L, 72061992354971777L, 72061992354988032L, 72061992354988033L, 72061992354988160L, 72061992354988161L, 72062026444177408L, 72062026444177409L, 72062026444177536L, 72062026444177537L, 72062026444193792L, 72062026444193793L, 72062026444193920L, 72062026444193921L, 72062026446274560L, 72062026446274561L, 72062026446274688L, 72062026446274689L, 72062026446290944L, 72062026446290945L, 72062026446291072L, 72062026446291073L, 72062026712612864L, 72062026712612865L, 72062026712612992L, 72062026712612993L, 72062026712629248L, 72062026712629249L, 72062026712629376L, 72062026712629377L, 72062026714710016L, 72062026714710017L, 72062026714710144L, 72062026714710145L, 72062026714726400L, 72062026714726401L, 72062026714726528L, 72062026714726529L, 0x102000000000000L, 0x102000000000001L, 72620543991349376L, 72620543991349377L, 72620543991365632L, 72620543991365633L, 72620543991365760L, 72620543991365761L, 0x102000000200000L, 0x102000000200001L, 72620543993446528L, 72620543993446529L, 72620543993462784L, 72620543993462785L, 72620543993462912L, 72620543993462913L, 0x102000010000000L, 0x102000010000001L, 72620544259784832L, 72620544259784833L, 72620544259801088L, 72620544259801089L, 72620544259801216L, 72620544259801217L, 0x102000010200000L, 0x102000010200001L, 72620544261881984L, 72620544261881985L, 72620544261898240L, 72620544261898241L, 72620544261898368L, 72620544261898369L, 72620578351087616L, 72620578351087617L, 72620578351087744L, 72620578351087745L, 72620578351104000L, 72620578351104001L, 72620578351104128L, 72620578351104129L, 72620578353184768L, 72620578353184769L, 72620578353184896L, 72620578353184897L, 72620578353201152L, 72620578353201153L, 72620578353201280L, 72620578353201281L, 72620578619523072L, 72620578619523073L, 72620578619523200L, 72620578619523201L, 72620578619539456L, 72620578619539457L, 72620578619539584L, 72620578619539585L, 72620578621620224L, 72620578621620225L, 72620578621620352L, 72620578621620353L, 72620578621636608L, 72620578621636609L, 72620578621636736L, 72620578621636737L, 72624942037860352L, 72624942037860353L, 72624942037860480L, 72624942037860481L, 72624942037876736L, 72624942037876737L, 72624942037876864L, 72624942037876865L, 72624942039957504L, 72624942039957505L, 72624942039957632L, 72624942039957633L, 72624942039973888L, 72624942039973889L, 72624942039974016L, 72624942039974017L, 72624942306295808L, 72624942306295809L, 72624942306295936L, 72624942306295937L, 72624942306312192L, 72624942306312193L, 72624942306312320L, 72624942306312321L, 72624942308392960L, 72624942308392961L, 72624942308393088L, 72624942308393089L, 72624942308409344L, 72624942308409345L, 72624942308409472L, 72624942308409473L, 72624976397598720L, 72624976397598721L, 72624976397598848L, 72624976397598849L, 72624976397615104L, 72624976397615105L, 72624976397615232L, 72624976397615233L, 72624976399695872L, 72624976399695873L, 72624976399696000L, 72624976399696001L, 72624976399712256L, 72624976399712257L, 72624976399712384L, 72624976399712385L, 72624976666034176L, 72624976666034177L, 72624976666034304L, 72624976666034305L, 72624976666050560L, 72624976666050561L, 72624976666050688L, 72624976666050689L, 72624976668131328L, 72624976668131329L, 72624976668131456L, 72624976668131457L, 72624976668147712L, 72624976668147713L, 72624976668147840L, 72624976668147841L};
    private static final String ZEROES = "0000000000000000000000000000000000000000000000000000000000000000";
    public static final byte[] bitLengths = new byte[]{0, 1, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8};
    private long[] m_ints;

    public LongArray(int n3) {
        this.m_ints = new long[n3];
    }

    public LongArray(long[] lArray) {
        this.m_ints = lArray;
    }

    public LongArray(long[] lArray, int n3, int n4) {
        if (n3 == 0 && n4 == lArray.length) {
            ((LongArray)object).m_ints = lArray;
        } else {
            LongArray longArray = object;
            long[] lArray2 = new long[n4];
            Object object = lArray2;
            longArray.m_ints = lArray2;
            System.arraycopy(lArray, n3, object, 0, n4);
        }
    }

    public LongArray(BigInteger object) {
        if (object != null && ((BigInteger)object).signum() >= 0) {
            if (((BigInteger)object).signum() == 0) {
                LongArray longArray = object2;
                long[] lArray = new long[1];
                Object object2 = lArray;
                lArray[0] = 0L;
                longArray.m_ints = (long[])object2;
                return;
            }
            byte[] byArray = ((BigInteger)object).toByteArray();
            object = byArray;
            int n3 = byArray.length;
            int n4 = 0;
            if (byArray[0] == 0) {
                n4 = 1;
            }
            int n5 = --n3;
            int n6 = (n5 + 7) / 8;
            ((LongArray)object2).m_ints = new long[n6];
            n3 = n6 - 1;
            int n7 = n5 % 8 + n4;
            long l3 = 0L;
            if (n4 < n7) {
                while (n4 < n7) {
                    l3 = l3 << 8 | (long)(object[n4] & 0xFF);
                    ++n4;
                }
                int n8 = n3;
                n3 = n8 + -1;
                ((LongArray)object2).m_ints[n8] = l3;
            }
            while (n3 >= 0) {
                long l4 = 0L;
                for (int i3 = 0; i3 < 8; ++i3) {
                    l4 = l4 << 8 | (long)(object[n4++] & 0xFF);
                }
                ((LongArray)object2).m_ints[n3] = l4;
                --n3;
            }
            return;
        }
        throw new IllegalArgumentException("invalid F2m field value");
    }

    private int degreeFrom(int n3) {
        long l3;
        n3 = n3 + 62 >>> 6;
        do {
            if (n3 != 0) continue;
            return 0;
        } while ((l3 = this.m_ints[n3 += -1]) == 0L);
        return (n3 << 6) + LongArray.bitLength(l3);
    }

    private static int bitLength(long l3) {
        int n3;
        int n4 = (int)(l3 >>> 32);
        if (n4 == 0) {
            n4 = (int)l3;
            n3 = 0;
        } else {
            n3 = 32;
        }
        int n5 = n4 >>> 16;
        n5 = n5 == 0 ? ((n5 = n4 >>> 8) == 0 ? bitLengths[n4] : bitLengths[n5] + 8) : ((n4 = n5 >>> 8) == 0 ? bitLengths[n5] + 16 : bitLengths[n4] + 24);
        return n3 + n5;
    }

    private long[] resizedInts(int n3) {
        long[] lArray = new long[n3];
        int n4 = Math.min(this.m_ints.length, n3);
        System.arraycopy(this.m_ints, 0, lArray, 0, n4);
        return lArray;
    }

    private static long shiftUp(long[] lArray, int n3, int n4, int n5) {
        int n6 = 64 - n5;
        long l3 = 0L;
        for (int i3 = 0; i3 < n4; ++i3) {
            int n7 = n3 + i3;
            long l4 = lArray[n7];
            lArray[n7] = l4 << n5 | l3;
            l3 = l4 >>> n6;
        }
        return l3;
    }

    private static long shiftUp(long[] lArray, int n3, long[] lArray2, int n4, int n5, int n6) {
        int n7 = 64 - n6;
        long l3 = 0L;
        for (int i3 = 0; i3 < n5; ++i3) {
            long l4 = lArray[n3 + i3];
            int n8 = n4 + i3;
            lArray2[n8] = l3 = l4 << n6 | l3;
            l3 = l4 >>> n7;
        }
        return l3;
    }

    private void addShiftedByBitsSafe(LongArray longArray, int n3, int n4) {
        int n5 = n4;
        n3 = n3 + 63 >>> 6;
        n4 = n5 >>> 6;
        int n6 = n5 & 0x3F;
        if (n6 == 0) {
            LongArray.add(this.m_ints, n4, longArray.m_ints, 0, n3);
            return;
        }
        long l3 = LongArray.addShiftedUp(this.m_ints, n4, longArray.m_ints, 0, n3, n6);
        if (l3 != 0L) {
            long l4;
            int n7 = n3 + n4;
            this.m_ints[n7] = l4 = this.m_ints[n7] ^ l3;
        }
    }

    private static long addShiftedUp(long[] lArray, int n3, long[] lArray2, int n4, int n5, int n6) {
        int n7 = 64 - n6;
        long l3 = 0L;
        for (int i3 = 0; i3 < n5; ++i3) {
            long l4 = lArray2[n4 + i3];
            int n8 = n3 + i3;
            lArray[n8] = l3 = lArray[n8] ^ (l4 << n6 | l3);
            l3 = l4 >>> n7;
        }
        return l3;
    }

    private static long addShiftedDown(long[] lArray, int n3, long[] lArray2, int n4, int n5, int n6) {
        int n7 = 64 - n6;
        long l3 = 0L;
        while ((n5 += -1) >= 0) {
            long l4 = lArray2[n4 + n5];
            int n8 = n3 + n5;
            lArray[n8] = l3 = lArray[n8] ^ (l4 >>> n6 | l3);
            l3 = l4 << n7;
        }
        return l3;
    }

    private static void add(long[] lArray, int n3, long[] lArray2, int n4, int n5) {
        for (int i3 = 0; i3 < n5; ++i3) {
            long l3;
            int n6 = n3 + i3;
            lArray[n6] = l3 = lArray[n6] ^ lArray2[n4 + i3];
        }
    }

    private static void add(long[] lArray, int n3, long[] lArray2, int n4, long[] lArray3, int n5, int n6) {
        for (int i3 = 0; i3 < n6; ++i3) {
            long l3;
            int n7 = n5 + i3;
            lArray3[n7] = l3 = lArray[n3 + i3] ^ lArray2[n4 + i3];
        }
    }

    private static void addBoth(long[] lArray, int n3, long[] lArray2, int n4, long[] lArray3, int n5, int n6) {
        for (int i3 = 0; i3 < n6; ++i3) {
            long l3;
            int n7 = n3 + i3;
            lArray[n7] = l3 = lArray[n7] ^ (lArray2[n4 + i3] ^ lArray3[n5 + i3]);
        }
    }

    private static void distribute(long[] lArray, int n3, int n4, int n5, int n6) {
        for (int i3 = 0; i3 < n6; ++i3) {
            long l3;
            long l4 = lArray[n3 + i3];
            int n7 = n4 + i3;
            lArray[n7] = l3 = lArray[n7] ^ l4;
            n7 = n5 + i3;
            lArray[n7] = l4 = lArray[n7] ^ l4;
        }
    }

    private static void flipWord(long[] lArray, int n3, int n4, long l3) {
        n3 += n4 >>> 6;
        if ((n4 &= 0x3F) == 0) {
            lArray[n3] = lArray[n3] ^ l3;
        } else {
            lArray[n3] = lArray[n3] ^ l3 << n4;
            long l4 = l3 >>> 64 - n4;
            if (l4 != 0L) {
                long l5;
                int n5 = n3 + 1;
                lArray[n5] = l5 = lArray[n5] ^ l4;
            }
        }
    }

    private static boolean testBit(long[] lArray, int n3, int n4) {
        int n5 = n4;
        int n6 = n5 >>> 6;
        long l3 = 1L << (n3 = n5 & 0x3F);
        return (lArray[n3 + n6] & l3) != 0L;
    }

    private static void flipBit(long[] lArray, int n3, int n4) {
        int n5 = n3;
        int n6 = n4;
        int n7 = n6 >>> 6;
        n3 = n6 & 0x3F;
        long l3 = 1L << n3;
        n4 = n5 + n7;
        lArray[n4] = l3 = lArray[n4] ^ l3;
    }

    private static void multiplyWord(long l3, long[] lArray, int n3, long[] lArray2, int n4) {
        if ((l3 & 1L) != 0L) {
            LongArray.add(lArray2, n4, lArray, 0, n3);
        }
        int n5 = 1;
        while ((l3 >>>= 1) != 0L) {
            long l4;
            if ((l3 & 1L) != 0L && (l4 = LongArray.addShiftedUp(lArray2, n4, lArray, 0, n3, n5)) != 0L) {
                int n6 = n4 + n3;
                lArray2[n6] = l4 = lArray2[n6] ^ l4;
            }
            ++n5;
        }
    }

    private static LongArray reduceResult(long[] lArray, int n3, int n4, int n5, int[] nArray) {
        n4 = LongArray.reduceInPlace(lArray, n3, n4, n5, nArray);
        return new LongArray(lArray, n3, n4);
    }

    private static int reduceInPlace(long[] lArray, int n3, int n4, int n5, int[] nArray) {
        int n6;
        int n7 = n5 + 63 >>> 6;
        if (n4 < n7) {
            return n4;
        }
        int n8 = Math.min(n4 << 6, (n5 << 1) - 1);
        for (n6 = (v1120142) - n8; n6 >= 64; n6 -= 64) {
            --n4;
        }
        int n9 = nArray.length;
        int n10 = nArray[n9 - 1];
        n9 = n9 > 1 ? nArray[n9 - 2] : 0;
        n6 = Math.min(n8 - (n10 = Math.max(n5, n10 + 64)), n5 - n9) + n6 >> 6;
        if (n6 > 1) {
            n8 = n4 - n6;
            LongArray.reduceVectorWise(lArray, n3, n4, n8, n5, nArray);
            while (n4 > n8) {
                lArray[n3 + (n4 += -1)] = 0L;
            }
            n8 <<= 6;
        }
        if (n8 > n10) {
            LongArray.reduceWordWise(lArray, n3, n4, n10, n5, nArray);
        } else {
            n10 = n8;
        }
        if (n10 > n5) {
            LongArray.reduceBitWise(lArray, n3, n10, n5, nArray);
        }
        return n7;
    }

    private static void reduceBitWise(long[] lArray, int n3, int n4, int n5, int[] nArray) {
        while ((n4 += -1) >= n5) {
            if (!LongArray.testBit(lArray, n3, n4)) continue;
            LongArray.reduceBit(lArray, n3, n4, n5, nArray);
        }
    }

    private static void reduceBit(long[] lArray, int n3, int n4, int n5, int[] nArray) {
        LongArray.flipBit(lArray, n3, n4);
        n4 -= n5;
        n5 = nArray.length;
        while ((n5 += -1) >= 0) {
            LongArray.flipBit(lArray, n3, nArray[n5] + n4);
        }
        LongArray.flipBit(lArray, n3, n4);
    }

    private static void reduceWordWise(long[] lArray, int n3, int n4, int n5, int n6, int[] nArray) {
        int n7 = n5 >>> 6;
        while ((n4 += -1) > n7) {
            int n8 = n3 + n4;
            long l3 = lArray[n8];
            if (l3 == 0L) continue;
            lArray[n8] = 0L;
            LongArray.reduceWord(lArray, n3, n4 << 6, l3, n6, nArray);
        }
        long l4 = lArray[n7 = n3 + n7];
        n4 = n5 & 0x3F;
        long l5 = l4 >>> n4;
        if (l5 != 0L) {
            lArray[n7] = l4 ^ l5 << n4;
            LongArray.reduceWord(lArray, n3, n5, l5, n6, nArray);
        }
    }

    private static void reduceWord(long[] lArray, int n3, int n4, long l3, int n5, int[] nArray) {
        n4 -= n5;
        n5 = nArray.length;
        while ((n5 += -1) >= 0) {
            LongArray.flipWord(lArray, n3, n4 + nArray[n5], l3);
        }
        LongArray.flipWord(lArray, n3, n4, l3);
    }

    private static void reduceVectorWise(long[] lArray, int n3, int n4, int n5, int n6, int[] nArray) {
        n6 = (n5 << 6) - n6;
        int n7 = nArray.length;
        while ((n7 += -1) >= 0) {
            int n8 = n3 + n5;
            int n9 = n4 - n5;
            int n10 = n6 + nArray[n7];
            LongArray.flipVector(lArray, n3, lArray, n8, n9, n10);
        }
        int n11 = n4;
        n4 = n3 + n5;
        n5 = n11 - n5;
        LongArray.flipVector(lArray, n3, lArray, n4, n5, n6);
    }

    private static void flipVector(long[] lArray, int n3, long[] lArray2, int n4, int n5, int n6) {
        n3 += n6 >>> 6;
        if ((n6 &= 0x3F) == 0) {
            LongArray.add(lArray, n3, lArray2, n4, n5);
        } else {
            int n7 = 64 - n6;
            long l3 = LongArray.addShiftedDown(lArray, n3 + 1, lArray2, n4, n5, n7);
            lArray[n3] = lArray[n3] ^ l3;
        }
    }

    private static void squareInPlace(long[] lArray, int n3, int n4, int[] nArray) {
        n4 = n3 << 1;
        while ((n3 += -1) >= 0) {
            long l3;
            long[] lArray2 = lArray;
            long l4 = lArray2[n3];
            lArray2[--n4] = l3 = LongArray.interleave2_32to64((int)(l4 >>> 32));
            lArray[n4 += -1] = LongArray.interleave2_32to64((int)l4);
        }
    }

    private static void interleave(long[] lArray, int n3, long[] lArray2, int n4, int n5, int n6) {
        if (n6 != 3) {
            if (n6 != 5) {
                if (n6 != 7) {
                    int n7 = bitLengths[n6] - 1;
                    LongArray.interleave2_n(lArray, n3, lArray2, n4, n5, n7);
                } else {
                    LongArray.interleave7(lArray, n3, lArray2, n4, n5);
                }
            } else {
                LongArray.interleave5(lArray, n3, lArray2, n4, n5);
            }
        } else {
            LongArray.interleave3(lArray, n3, lArray2, n4, n5);
        }
    }

    private static void interleave3(long[] lArray, int n3, long[] lArray2, int n4, int n5) {
        for (int i3 = 0; i3 < n5; ++i3) {
            long l3;
            int n6 = n4 + i3;
            lArray2[n6] = l3 = LongArray.interleave3(lArray[n3 + i3]);
        }
    }

    private static long interleave3(long l3) {
        return l3 & Long.MIN_VALUE | LongArray.interleave3_21to63((int)l3 & 0x1FFFFF) | LongArray.interleave3_21to63((int)(l3 >>> 21) & 0x1FFFFF) << 1 | LongArray.interleave3_21to63((int)(l3 >>> 42) & 0x1FFFFF) << 2;
    }

    private static long interleave3_21to63(int n3) {
        int[] nArray = INTERLEAVE3_TABLE;
        int n4 = n3;
        int n5 = n3;
        n3 = nArray[n3 & 0x7F];
        int n6 = nArray[n5 >>> 7 & 0x7F];
        return ((long)INTERLEAVE3_TABLE[n4 >>> 14] & 0xFFFFFFFFL) << 42 | ((long)n6 & 0xFFFFFFFFL) << 21 | (long)n3 & 0xFFFFFFFFL;
    }

    private static void interleave5(long[] lArray, int n3, long[] lArray2, int n4, int n5) {
        for (int i3 = 0; i3 < n5; ++i3) {
            long l3;
            int n6 = n4 + i3;
            lArray2[n6] = l3 = LongArray.interleave5(lArray[n3 + i3]);
        }
    }

    private static long interleave5(long l3) {
        return LongArray.interleave3_13to65((int)l3 & 0x1FFF) | LongArray.interleave3_13to65((int)(l3 >>> 13) & 0x1FFF) << 1 | LongArray.interleave3_13to65((int)(l3 >>> 26) & 0x1FFF) << 2 | LongArray.interleave3_13to65((int)(l3 >>> 39) & 0x1FFF) << 3 | LongArray.interleave3_13to65((int)(l3 >>> 52) & 0x1FFF) << 4;
    }

    private static long interleave3_13to65(int n3) {
        n3 = INTERLEAVE5_TABLE[n3 & 0x7F];
        return ((long)INTERLEAVE5_TABLE[n3 >>> 7] & 0xFFFFFFFFL) << 35 | (long)n3 & 0xFFFFFFFFL;
    }

    private static void interleave7(long[] lArray, int n3, long[] lArray2, int n4, int n5) {
        for (int i3 = 0; i3 < n5; ++i3) {
            long l3;
            int n6 = n4 + i3;
            lArray2[n6] = l3 = LongArray.interleave7(lArray[n3 + i3]);
        }
    }

    private static long interleave7(long l3) {
        long[] lArray = INTERLEAVE7_TABLE;
        return l3 & Long.MIN_VALUE | INTERLEAVE7_TABLE[(int)l3 & 0x1FF] | lArray[(int)(l3 >>> 9) & 0x1FF] << 1 | lArray[(int)(l3 >>> 18) & 0x1FF] << 2 | lArray[(int)(l3 >>> 27) & 0x1FF] << 3 | lArray[(int)(l3 >>> 36) & 0x1FF] << 4 | lArray[(int)(l3 >>> 45) & 0x1FF] << 5 | lArray[(int)(l3 >>> 54) & 0x1FF] << 6;
    }

    private static void interleave2_n(long[] lArray, int n3, long[] lArray2, int n4, int n5, int n6) {
        for (int i3 = 0; i3 < n5; ++i3) {
            long l3;
            int n7 = n4 + i3;
            lArray2[n7] = l3 = LongArray.interleave2_n(lArray[n3 + i3], n6);
        }
    }

    private static long interleave2_n(long l3, int n3) {
        while (n3 > 1) {
            n3 -= 2;
            l3 = LongArray.interleave4_16to64((int)l3 & 0xFFFF) | LongArray.interleave4_16to64((int)(l3 >>> 16) & 0xFFFF) << 1 | LongArray.interleave4_16to64((int)(l3 >>> 32) & 0xFFFF) << 2 | LongArray.interleave4_16to64((int)(l3 >>> 48) & 0xFFFF) << 3;
        }
        if (n3 > 0) {
            l3 = LongArray.interleave2_32to64((int)l3) | LongArray.interleave2_32to64((int)(l3 >>> 32)) << 1;
        }
        return l3;
    }

    private static long interleave4_16to64(int n3) {
        n3 = INTERLEAVE4_TABLE[n3 & 0xFF];
        return ((long)INTERLEAVE4_TABLE[n3 >>> 8] & 0xFFFFFFFFL) << 32 | (long)n3 & 0xFFFFFFFFL;
    }

    private static long interleave2_32to64(int n3) {
        short[] sArray = INTERLEAVE2_TABLE;
        int n4 = sArray[n3 & 0xFF] | sArray[n3 >>> 8 & 0xFF] << 16;
        return ((long)(INTERLEAVE2_TABLE[n3 >>> 16 & 0xFF] | sArray[n3 >>> 24] << 16) & 0xFFFFFFFFL) << 32 | (long)n4 & 0xFFFFFFFFL;
    }

    public void copyTo(long[] lArray, int n3) {
        int n4 = this.m_ints.length;
        System.arraycopy(this.m_ints, 0, lArray, n3, n4);
    }

    public boolean isOne() {
        Object object = ((LongArray)object).m_ints;
        if (((LongArray)object).m_ints[0] != 1L) {
            return false;
        }
        for (int i3 = 1; i3 < ((Object)object).length; ++i3) {
            if (object[i3] == 0L) continue;
            return false;
        }
        return true;
    }

    public boolean isZero() {
        Object object = ((LongArray)object).m_ints;
        for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
            if (object[i3] == 0L) continue;
            return false;
        }
        return true;
    }

    public int getUsedLength() {
        LongArray longArray = this;
        return longArray.getUsedLengthFrom(longArray.m_ints.length);
    }

    public int getUsedLengthFrom(int n3) {
        Object object = ((LongArray)object).m_ints;
        if ((n3 = Math.min(n3, ((LongArray)object).m_ints.length)) < 1) {
            return 0;
        }
        if (object[0] != 0L) {
            while (object[n3 += -1] == 0L) {
            }
            return n3 + 1;
        }
        do {
            if (object[n3 += -1] == 0L) continue;
            return n3 + 1;
        } while (n3 > 0);
        return 0;
    }

    public int degree() {
        long l3;
        int n3 = this.m_ints.length;
        do {
            if (n3 != 0) continue;
            return 0;
        } while ((l3 = this.m_ints[n3 += -1]) == 0L);
        return (n3 << 6) + LongArray.bitLength(l3);
    }

    public BigInteger toBigInteger() {
        int n3 = this.getUsedLength();
        if (n3 == 0) {
            return ECConstants.ZERO;
        }
        int n4 = n3 - 1;
        long l3 = this.m_ints[n4];
        byte[] byArray = new byte[8];
        int n5 = 0;
        boolean bl = false;
        for (int i3 = 7; i3 >= 0; --i3) {
            byte by = (byte)(l3 >>> i3 * 8);
            if (!bl && by == 0) continue;
            bl = true;
            int n6 = n5 + 1;
            byArray[n5] = by;
            n5 = n6;
        }
        byte[] byArray2 = new byte[n4 * 8 + n5];
        for (int i4 = 0; i4 < n5; ++i4) {
            byArray2[i4] = byArray[i4];
        }
        n3 -= 2;
        while (n3 >= 0) {
            long l4 = this.m_ints[n3];
            for (int i5 = 7; i5 >= 0; --i5) {
                byArray2[n5++] = (byte)(l4 >>> i5 * 8);
            }
            --n3;
        }
        return new BigInteger(1, byArray2);
    }

    public LongArray addOne() {
        long l3;
        Object object;
        if (((LongArray)object).m_ints.length == 0) {
            long[] lArray = new long[1];
            object = lArray;
            lArray[0] = 1L;
            return new LongArray((long[])object);
        }
        LongArray longArray = object;
        long[] lArray = longArray.resizedInts(Math.max(1, longArray.getUsedLength()));
        object = lArray;
        lArray[0] = l3 = lArray[0] ^ 1L;
        return new LongArray((long[])object);
    }

    public void addShiftedByWords(LongArray longArray, int n3) {
        int n4 = longArray.getUsedLength();
        if (n4 == 0) {
            return;
        }
        int n5 = n4 + n3;
        if (n5 > this.m_ints.length) {
            this.m_ints = this.resizedInts(n5);
        }
        LongArray.add(this.m_ints, n3, longArray.m_ints, 0, n4);
    }

    public int getLength() {
        return this.m_ints.length;
    }

    public boolean testBitZero() {
        Object object = ((LongArray)object).m_ints;
        return ((LongArray)object).m_ints.length > 0 && (object[0] & 1L) != 0L;
    }

    public LongArray modMultiplyLD(LongArray object, int n3, int[] nArray) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = longArray2.degree();
        if (n8 == 0) {
            return longArray2;
        }
        int n9 = ((LongArray)object).degree();
        if (n9 == 0) {
            return object;
        }
        if (n8 > n9) {
            int n10 = n9;
            n9 = n8;
            n8 = n10;
        } else {
            LongArray longArray = object;
            object = longArray2;
            LongArray longArray2 = longArray;
        }
        int n11 = n8 + 63 >>> 6;
        int n12 = n8;
        int n13 = n9;
        n8 = n13 + 63 >>> 6;
        int n14 = n12 + n13 + 62 >>> 6;
        if (n11 == 1) {
            long l3 = ((LongArray)object).m_ints[0];
            if (l3 == 1L) {
                return longArray2;
            }
            long[] lArray = new long[n14];
            object = lArray;
            LongArray.multiplyWord(l3, longArray2.m_ints, n8, (long[])object, 0);
            return LongArray.reduceResult(lArray, 0, n14, n3, nArray);
        }
        int n15 = n9 + 7 + 63 >>> 6;
        int[] nArray2 = new int[16];
        int[] nArray3 = nArray2;
        int n16 = n15 << 4;
        long[] lArray = new long[n16];
        nArray2[1] = n15;
        System.arraycopy(longArray2.m_ints, 0, lArray, n15, n8);
        int n17 = n15;
        for (n8 = 2; n8 < 16; ++n8) {
            nArray3[n8] = n17 += n15;
            if ((n8 & 1) == 0) {
                LongArray.shiftUp(lArray, n17 >>> 1, lArray, n17, n15, 1);
                continue;
            }
            n7 = n17 - n15;
            LongArray.add(lArray, n15, lArray, n7, lArray, n17, n15);
        }
        Object object2 = object;
        object = new long[n16];
        LongArray.shiftUp(lArray, 0, (long[])object, 0, n16, 4);
        long[] lArray2 = ((LongArray)object2).m_ints;
        long[] lArray3 = new long[n14];
        n17 = 15;
        for (n7 = 56; n7 >= 0; n7 -= 8) {
            for (n6 = 1; n6 < n11; n6 += 2) {
                int n18 = (int)(lArray2[n6] >>> n7);
                n5 = n18 & n17;
                n4 = n18 >>> 4 & n17;
                int n19 = n6 - 1;
                n5 = nArray3[n5];
                n4 = nArray3[n4];
                LongArray.addBoth(lArray3, n19, lArray, n5, (long[])object, n4, n15);
            }
            LongArray.shiftUp(lArray3, 0, n14, 8);
        }
        for (n7 = 56; n7 >= 0; n7 -= 8) {
            for (n6 = 0; n6 < n11; n6 += 2) {
                int n20 = (int)(lArray2[n6] >>> n7);
                n5 = n20 & n17;
                n4 = n20 >>> 4 & n17;
                n5 = nArray3[n5];
                n4 = nArray3[n4];
                LongArray.addBoth(lArray3, n6, lArray, n5, (long[])object, n4, n15);
            }
            if (n7 <= 0) continue;
            LongArray.shiftUp(lArray3, 0, n14, 8);
        }
        return LongArray.reduceResult(lArray3, 0, n14, n3, nArray);
    }

    public LongArray modMultiply(LongArray object, int n3, int[] nArray) {
        int n4;
        int n5 = longArray2.degree();
        if (n5 == 0) {
            return longArray2;
        }
        int n6 = ((LongArray)object).degree();
        if (n6 == 0) {
            return object;
        }
        if (n5 > n6) {
            int n7 = n6;
            n6 = n5;
            n5 = n7;
        } else {
            LongArray longArray = object;
            object = longArray2;
            LongArray longArray2 = longArray;
        }
        int n8 = n5 + 63 >>> 6;
        int n9 = n5;
        int n10 = n6;
        n5 = n10 + 63 >>> 6;
        int n11 = n9 + n10 + 62 >>> 6;
        if (n8 == 1) {
            long l3 = ((LongArray)object).m_ints[0];
            if (l3 == 1L) {
                return longArray2;
            }
            long[] lArray = new long[n11];
            object = lArray;
            LongArray.multiplyWord(l3, longArray2.m_ints, n5, (long[])object, 0);
            return LongArray.reduceResult(lArray, 0, n11, n3, nArray);
        }
        int n12 = n6 + 7 + 63 >>> 6;
        int[] nArray2 = new int[16];
        int[] nArray3 = nArray2;
        int n13 = n12 << 4;
        long[] lArray = new long[n13];
        nArray2[1] = n12;
        System.arraycopy(longArray2.m_ints, 0, lArray, n12, n5);
        int n14 = n12;
        for (n5 = 2; n5 < 16; ++n5) {
            nArray3[n5] = n14 += n12;
            if ((n5 & 1) == 0) {
                LongArray.shiftUp(lArray, n14 >>> 1, lArray, n14, n12, 1);
                continue;
            }
            n4 = n14 - n12;
            LongArray.add(lArray, n12, lArray, n4, lArray, n14, n12);
        }
        Object object2 = object;
        object = new long[n13];
        LongArray.shiftUp(lArray, 0, (long[])object, 0, n13, 4);
        long[] lArray2 = ((LongArray)object2).m_ints;
        n13 = n11 << 3;
        long[] lArray3 = new long[n13];
        n4 = 15;
        block1: for (int i3 = 0; i3 < n8; ++i3) {
            long l4 = lArray2[i3];
            int n15 = i3;
            while (true) {
                long l5 = l4;
                int n16 = (int)l5 & n4;
                long l6 = l5 >>> 4;
                int n17 = n16;
                n16 = (int)l6 & n4;
                int n18 = nArray3[n17];
                n16 = nArray3[n16];
                LongArray.addBoth(lArray3, n15, lArray, n18, (long[])object, n16, n12);
                l4 = l6 >>> 4;
                if (l4 == 0L) {
                    continue block1;
                }
                n15 += n11;
            }
        }
        while ((n13 -= n11) != 0) {
            LongArray.addShiftedUp(lArray3, n13 - n11, lArray3, n13, n11, 8);
        }
        return LongArray.reduceResult(lArray3, 0, n11, n3, nArray);
    }

    /*
     * WARNING - void declaration
     */
    public LongArray modMultiplyAlt(LongArray longArray, int n3, int[] nArray) {
        int n4;
        void var16_19;
        int n5;
        Object object;
        int n6 = ((LongArray)object).degree();
        if (n6 == 0) {
            return object;
        }
        int n7 = longArray.degree();
        if (n7 == 0) {
            return longArray;
        }
        if (n6 > n7) {
            int n8 = n7;
            LongArray longArray2 = longArray;
            longArray = object;
            object = longArray2;
            n7 = n6;
            n6 = n8;
        }
        int n9 = n6 + 63 >>> 6;
        int n10 = n6;
        int n11 = n7;
        n6 = n11 + 63 >>> 6;
        int n12 = n10 + n11 + 62 >>> 6;
        if (n9 == 1) {
            long l3 = ((LongArray)object).m_ints[0];
            if (l3 == 1L) {
                return longArray;
            }
            long[] lArray = new long[n12];
            object = lArray;
            LongArray.multiplyWord(l3, longArray.m_ints, n6, (long[])object, 0);
            return LongArray.reduceResult(lArray, 0, n12, n3, nArray);
        }
        int n13 = n7;
        n7 = 4;
        int n14 = 64;
        int n15 = 8;
        int n16 = n13 + 15 + 63 >>> 6;
        int n17 = n16 * n15;
        int n18 = 32;
        int n19 = 16;
        int[] nArray2 = new int[16];
        int[] nArray3 = nArray2;
        nArray3[0] = n9;
        nArray2[1] = n5 = n9 + n17;
        int i3 = 2;
        while (var16_19 < n19) {
            nArray3[var16_19] = n5 += n12;
            ++var16_19;
        }
        Object object2 = object;
        object = new long[n5 + n12 + 1];
        LongArray.interleave(((LongArray)object2).m_ints, 0, (long[])object, 0, n9, 4);
        System.arraycopy(longArray.m_ints, 0, object, n9, n6);
        n6 = n9;
        for (n4 = 1; n4 < n15; ++n4) {
            LongArray.shiftUp((long[])object, n9, (long[])object, n6 += n16, n16, n4);
        }
        n4 = 15;
        n6 = 0;
        block2: while (true) {
            n5 = 0;
            block3: while (true) {
                reference n25 = object[n5] >>> n6;
                int n20 = 0;
                int n21 = n9;
                while (true) {
                    int n22;
                    if ((n22 = (int)n25 & n4) != 0) {
                        LongArray.add((long[])object, n5 + nArray3[n22], (long[])object, n21, n16);
                    }
                    if (++n20 == n15) {
                        if (++n5 < n9) continue block3;
                        if ((n6 += n18) >= n14) {
                            if (n6 >= 64) {
                                while ((n19 += -1) > 1) {
                                    if (((long)n19 & 1L) == 0L) {
                                        n4 = nArray3[n19 >>> 1];
                                        n6 = nArray3[n19];
                                        LongArray.addShiftedUp((long[])object, n4, (long[])object, n6, n12, 16);
                                        continue;
                                    }
                                    n4 = nArray3[n19];
                                    n6 = nArray3[n19 - 1];
                                    n7 = nArray3[1];
                                    LongArray.distribute((long[])object, n4, n6, n7, n12);
                                }
                                return LongArray.reduceResult((long[])object, nArray3[1], n12, n3, nArray);
                            }
                            int n23 = n4;
                            n4 = 60;
                            int n24 = n6 = n23 & n23 << 4;
                            n6 = n4;
                            n4 = n24;
                        }
                        LongArray.shiftUp((long[])object, n9, n17, n15);
                        continue block2;
                    }
                    int n26 = n21 + n16;
                    reference var19_24 = n25 >>> n7;
                    int n27 = n26;
                    n25 = var19_24;
                }
                break;
            }
            break;
        }
    }

    public LongArray modReduce(int n3, int[] nArray) {
        long[] lArray = Arrays.clone(((LongArray)object).m_ints);
        Object object = lArray;
        n3 = LongArray.reduceInPlace(lArray, 0, lArray.length, n3, nArray);
        return new LongArray((long[])object, 0, n3);
    }

    public LongArray multiply(LongArray object, int n3, int[] nArray) {
        int n4;
        Object object2;
        n3 = ((LongArray)object2).degree();
        if (n3 == 0) {
            return object2;
        }
        int n5 = ((LongArray)object).degree();
        if (n5 == 0) {
            return object;
        }
        if (n3 > n5) {
            int n6 = n5;
            n5 = n3;
            n3 = n6;
        } else {
            LongArray longArray = object;
            object = object2;
            object2 = longArray;
        }
        int n7 = n3 + 63 >>> 6;
        int n8 = n3;
        int n9 = n5;
        n3 = n9 + 63 >>> 6;
        int n10 = n8 + n9 + 62 >>> 6;
        if (n7 == 1) {
            long l3 = ((LongArray)object).m_ints[0];
            if (l3 == 1L) {
                return object2;
            }
            LongArray longArray = object2;
            object2 = new long[n10];
            LongArray.multiplyWord(l3, longArray.m_ints, n3, (long[])object2, 0);
            return new LongArray((long[])object2, 0, n10);
        }
        int n11 = n5 + 7 + 63 >>> 6;
        int[] nArray2 = new int[16];
        int[] nArray3 = nArray2;
        int n12 = n11 << 4;
        long[] lArray = new long[n12];
        nArray2[1] = n11;
        System.arraycopy(((LongArray)object2).m_ints, 0, lArray, n11, n3);
        int n13 = n11;
        for (n3 = 2; n3 < 16; ++n3) {
            nArray3[n3] = n13 += n11;
            if ((n3 & 1) == 0) {
                LongArray.shiftUp(lArray, n13 >>> 1, lArray, n13, n11, 1);
                continue;
            }
            n4 = n13 - n11;
            LongArray.add(lArray, n11, lArray, n4, lArray, n13, n11);
        }
        LongArray longArray = object;
        object = new long[n12];
        LongArray.shiftUp(lArray, 0, (long[])object, 0, n12, 4);
        long[] lArray2 = longArray.m_ints;
        n12 = n10 << 3;
        long[] lArray3 = new long[n12];
        n4 = 15;
        block1: for (int i3 = 0; i3 < n7; ++i3) {
            long l4 = lArray2[i3];
            int n14 = i3;
            while (true) {
                long l5 = l4;
                int n15 = (int)l5 & n4;
                long l6 = l5 >>> 4;
                int n16 = n15;
                n15 = (int)l6 & n4;
                int n17 = nArray3[n16];
                n15 = nArray3[n15];
                LongArray.addBoth(lArray3, n14, lArray, n17, (long[])object, n15, n11);
                l4 = l6 >>> 4;
                if (l4 == 0L) {
                    continue block1;
                }
                n14 += n10;
            }
        }
        while ((n12 -= n10) != 0) {
            LongArray.addShiftedUp(lArray3, n12 - n10, lArray3, n12, n10, 8);
        }
        return new LongArray(lArray3, 0, n10);
    }

    public void reduce(int n3, int[] nArray) {
        long[] lArray = ((LongArray)object).m_ints;
        if ((n3 = LongArray.reduceInPlace(((LongArray)object).m_ints, 0, lArray.length, n3, nArray)) < lArray.length) {
            LongArray longArray = object;
            long[] lArray2 = new long[n3];
            Object object = lArray2;
            longArray.m_ints = lArray2;
            System.arraycopy(lArray, 0, object, 0, n3);
        }
    }

    public LongArray modSquare(int n3, int[] nArray) {
        int n4 = this.getUsedLength();
        if (n4 == 0) {
            return this;
        }
        long[] lArray = new long[n4 <<= 1];
        int n5 = 0;
        while (n5 < n4) {
            long l3;
            long l4 = this.m_ints[n5 >>> 1];
            lArray[n5++] = LongArray.interleave2_32to64((int)l4);
            int n6 = n5 + 1;
            lArray[n5] = l3 = LongArray.interleave2_32to64((int)(l4 >>> 32));
            n5 = n6;
        }
        int n7 = LongArray.reduceInPlace(lArray, 0, n4, n3, nArray);
        return new LongArray(lArray, 0, n7);
    }

    public LongArray modSquareN(int n3, int n4, int[] nArray) {
        int n5 = this.getUsedLength();
        if (n5 == 0) {
            return this;
        }
        int n6 = n4 + 63 >>> 6 << 1;
        long[] lArray = new long[n6];
        System.arraycopy(this.m_ints, 0, lArray, 0, n5);
        while ((n3 += -1) >= 0) {
            LongArray.squareInPlace(lArray, n5, n4, nArray);
            n5 = LongArray.reduceInPlace(lArray, 0, n6, n4, nArray);
        }
        return new LongArray(lArray, 0, n5);
    }

    public LongArray square(int n3, int[] objectArray) {
        n3 = this.getUsedLength();
        if (n3 == 0) {
            return this;
        }
        objectArray = new long[n3 <<= 1];
        int n4 = 0;
        while (n4 < n3) {
            long l3 = this.m_ints[n4 >>> 1];
            objectArray[n4++] = (int)LongArray.interleave2_32to64((int)l3);
            int n5 = n4 + 1;
            long l4 = LongArray.interleave2_32to64((int)(l3 >>> 32));
            objectArray[n4] = (int)l4;
            n4 = n5;
        }
        return new LongArray((long[])objectArray, 0, n3);
    }

    public LongArray modInverse(int n3, int[] object) {
        Object object3;
        Object object2 = ((LongArray)object3).degree();
        if (object2 != 0) {
            LongArray longArray;
            LongArray longArray2;
            LongArray[] longArrayArray;
            if (object2 == 1) {
                return object3;
            }
            object3 = (LongArray)((LongArray)object3).clone();
            int n4 = n3 + 63 >>> 6;
            LongArray[] longArrayArray2 = longArrayArray;
            int n5 = n3;
            LongArray.reduceBit(new LongArray((int)n4).m_ints, 0, n5, n5, (int[])object);
            object = longArray2;
            new LongArray((int)n4).m_ints[0] = 1L;
            LongArray longArray3 = longArray;
            longArray = new LongArray(n4);
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = object2;
            nArray[1] = n3 + 1;
            LongArray[] longArrayArray3 = new LongArray[2];
            LongArray[] longArrayArray4 = longArrayArray3;
            longArrayArray3[0] = object3;
            longArrayArray3[1] = longArrayArray2;
            int[] nArray3 = new int[2];
            object3 = nArray3;
            nArray3[0] = 1;
            nArray3[1] = object2 = 0;
            LongArray[] longArrayArray5 = new LongArray[2];
            longArrayArray2 = longArrayArray5;
            longArrayArray5[0] = object;
            longArrayArray5[1] = longArray3;
            int n6 = 1;
            int n7 = nArray[1];
            int n8 = n7 - nArray2[0];
            while (true) {
                if (n8 < 0) {
                    n8 = -n8;
                    nArray2[n6] = n7;
                    object3[n6] = object2;
                    n6 = 1 - n6;
                    n7 = nArray2[n6];
                    object2 = object3[n6];
                }
                Object object4 = 1 - n6;
                LongArray longArray4 = longArrayArray4[object4];
                longArrayArray4[n6].addShiftedByBitsSafe(longArray4, nArray2[object4], n8);
                int n9 = longArrayArray4[n6].degreeFrom(n7);
                if (n9 == 0) {
                    return longArrayArray2[object4];
                }
                Object object5 = object3[object4];
                longArrayArray2[n6].addShiftedByBitsSafe(longArrayArray2[object4], (int)object5, n8);
                reference v8 = object5 + n8;
                object4 = v8;
                if (v8 > object2) {
                    object2 = object4;
                } else if (object4 == object2) {
                    object2 = longArrayArray2[n6].degreeFrom((int)object2);
                }
                n8 = n9 - n7 + n8;
                n7 = n9;
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object object) {
        if (!(object instanceof LongArray)) {
            return false;
        }
        object = (LongArray)object;
        int n3 = this.getUsedLength();
        if (((LongArray)object).getUsedLength() != n3) {
            return false;
        }
        for (int i3 = 0; i3 < n3; ++i3) {
            if (this.m_ints[i3] == ((LongArray)object).m_ints[i3]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n3 = this.getUsedLength();
        int n4 = 1;
        for (int i3 = 0; i3 < n3; ++i3) {
            long l3 = this.m_ints[i3];
            n4 = (n4 * 31 ^ (int)l3) * 31 ^ (int)(l3 >>> 32);
        }
        return n4;
    }

    public Object clone() {
        return new LongArray(Arrays.clone(this.m_ints));
    }

    public String toString() {
        StringBuffer stringBuffer;
        int n3 = this.getUsedLength();
        if (n3 == 0) {
            return "0";
        }
        StringBuffer stringBuffer2 = stringBuffer;
        stringBuffer = new StringBuffer(Long.toBinaryString(this.m_ints[n3 += -1]));
        while ((n3 += -1) >= 0) {
            String string2 = Long.toBinaryString(this.m_ints[n3]);
            int n4 = string2.length();
            if (n4 < 64) {
                stringBuffer2.append(ZEROES.substring(n4));
            }
            stringBuffer2.append(string2);
        }
        return stringBuffer2.toString();
    }
}

