/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import java.math.BigInteger;

class SimpleBigDecimal {
    private static final long serialVersionUID = 1L;
    private final BigInteger bigInt;
    private final int scale;

    public static SimpleBigDecimal getInstance(BigInteger bigInteger, int n3) {
        return new SimpleBigDecimal(bigInteger.shiftLeft(n3), n3);
    }

    public SimpleBigDecimal(BigInteger bigInteger, int n3) {
        if (n3 >= 0) {
            SimpleBigDecimal simpleBigDecimal = this;
            simpleBigDecimal.bigInt = bigInteger;
            simpleBigDecimal.scale = n3;
            return;
        }
        throw new IllegalArgumentException("scale may not be negative");
    }

    private void checkScale(SimpleBigDecimal simpleBigDecimal) {
        if (this.scale == simpleBigDecimal.scale) {
            return;
        }
        throw new IllegalArgumentException("Only SimpleBigDecimal of same scale allowed in arithmetic operations");
    }

    public SimpleBigDecimal adjustScale(int n3) {
        if (n3 >= 0) {
            int n4 = this.scale;
            if (n3 == n4) {
                return this;
            }
            return new SimpleBigDecimal(this.bigInt.shiftLeft(n3 - n4), n3);
        }
        throw new IllegalArgumentException("scale may not be negative");
    }

    public SimpleBigDecimal add(SimpleBigDecimal simpleBigDecimal) {
        ((SimpleBigDecimal)((Object)bigInteger)).checkScale(simpleBigDecimal);
        SimpleBigDecimal simpleBigDecimal2 = bigInteger;
        BigInteger bigInteger = simpleBigDecimal2.bigInt.add(simpleBigDecimal.bigInt);
        return new SimpleBigDecimal(bigInteger, simpleBigDecimal2.scale);
    }

    public SimpleBigDecimal add(BigInteger bigInteger) {
        SimpleBigDecimal simpleBigDecimal = bigInteger2;
        BigInteger bigInteger2 = simpleBigDecimal.bigInt.add(bigInteger.shiftLeft(((SimpleBigDecimal)((Object)bigInteger2)).scale));
        return new SimpleBigDecimal(bigInteger2, simpleBigDecimal.scale);
    }

    public SimpleBigDecimal negate() {
        SimpleBigDecimal simpleBigDecimal = bigInteger;
        BigInteger bigInteger = simpleBigDecimal.bigInt.negate();
        return new SimpleBigDecimal(bigInteger, simpleBigDecimal.scale);
    }

    public SimpleBigDecimal subtract(SimpleBigDecimal simpleBigDecimal) {
        return this.add(simpleBigDecimal.negate());
    }

    public SimpleBigDecimal subtract(BigInteger bigInteger) {
        SimpleBigDecimal simpleBigDecimal = bigInteger2;
        BigInteger bigInteger2 = simpleBigDecimal.bigInt.subtract(bigInteger.shiftLeft(((SimpleBigDecimal)((Object)bigInteger2)).scale));
        return new SimpleBigDecimal(bigInteger2, simpleBigDecimal.scale);
    }

    public SimpleBigDecimal multiply(SimpleBigDecimal simpleBigDecimal) {
        ((SimpleBigDecimal)((Object)bigInteger)).checkScale(simpleBigDecimal);
        SimpleBigDecimal simpleBigDecimal2 = bigInteger;
        BigInteger bigInteger = simpleBigDecimal2.bigInt.multiply(simpleBigDecimal.bigInt);
        int n3 = simpleBigDecimal2.scale;
        return new SimpleBigDecimal(bigInteger, n3 + n3);
    }

    public SimpleBigDecimal multiply(BigInteger bigInteger) {
        SimpleBigDecimal simpleBigDecimal = bigInteger2;
        BigInteger bigInteger2 = simpleBigDecimal.bigInt.multiply(bigInteger);
        return new SimpleBigDecimal(bigInteger2, simpleBigDecimal.scale);
    }

    public SimpleBigDecimal divide(SimpleBigDecimal simpleBigDecimal) {
        SimpleBigDecimal simpleBigDecimal2 = bigInteger2;
        simpleBigDecimal2.checkScale(simpleBigDecimal);
        BigInteger bigInteger = simpleBigDecimal2.bigInt.shiftLeft(((SimpleBigDecimal)((Object)bigInteger2)).scale);
        SimpleBigDecimal simpleBigDecimal3 = bigInteger2;
        BigInteger bigInteger2 = bigInteger.divide(simpleBigDecimal.bigInt);
        return new SimpleBigDecimal(bigInteger2, simpleBigDecimal3.scale);
    }

    public SimpleBigDecimal divide(BigInteger bigInteger) {
        SimpleBigDecimal simpleBigDecimal = bigInteger2;
        BigInteger bigInteger2 = simpleBigDecimal.bigInt.divide(bigInteger);
        return new SimpleBigDecimal(bigInteger2, simpleBigDecimal.scale);
    }

    public SimpleBigDecimal shiftLeft(int n3) {
        SimpleBigDecimal simpleBigDecimal = bigInteger;
        BigInteger bigInteger = simpleBigDecimal.bigInt.shiftLeft(n3);
        return new SimpleBigDecimal(bigInteger, simpleBigDecimal.scale);
    }

    public int compareTo(SimpleBigDecimal simpleBigDecimal) {
        SimpleBigDecimal simpleBigDecimal2 = this;
        simpleBigDecimal2.checkScale(simpleBigDecimal);
        return simpleBigDecimal2.bigInt.compareTo(simpleBigDecimal.bigInt);
    }

    public int compareTo(BigInteger bigInteger) {
        return this.bigInt.compareTo(bigInteger.shiftLeft(this.scale));
    }

    public BigInteger floor() {
        return this.bigInt.shiftRight(this.scale);
    }

    public BigInteger round() {
        return this.add(new SimpleBigDecimal(ECConstants.ONE, 1).adjustScale(this.scale)).floor();
    }

    public int intValue() {
        return this.floor().intValue();
    }

    public long longValue() {
        return this.floor().longValue();
    }

    public int getScale() {
        return this.scale;
    }

    public String toString() {
        String string2;
        int n3;
        if (((SimpleBigDecimal)((Object)string3)).scale == 0) {
            return ((SimpleBigDecimal)((Object)string3)).bigInt.toString();
        }
        SimpleBigDecimal simpleBigDecimal = string3;
        Object object = simpleBigDecimal.floor();
        Object object2 = simpleBigDecimal.bigInt.subtract(((BigInteger)object).shiftLeft(((SimpleBigDecimal)((Object)string3)).scale));
        if (simpleBigDecimal.bigInt.signum() == -1) {
            object2 = ECConstants.ONE.shiftLeft(((SimpleBigDecimal)((Object)string3)).scale).subtract((BigInteger)object2);
        }
        if (((BigInteger)object).signum() == -1 && !((BigInteger)object2).equals(ECConstants.ZERO)) {
            object = ((BigInteger)object).add(ECConstants.ONE);
        }
        SimpleBigDecimal simpleBigDecimal2 = string3;
        SimpleBigDecimal simpleBigDecimal3 = string3;
        String string3 = ((BigInteger)object).toString();
        object = new char[simpleBigDecimal3.scale];
        object2 = ((BigInteger)object2).toString(2);
        int n4 = ((String)object2).length();
        int n5 = simpleBigDecimal2.scale - n4;
        for (n3 = 0; n3 < n5; ++n3) {
            object[n3] = 48;
        }
        for (n3 = 0; n3 < n4; ++n3) {
            int n6 = n5 + n3;
            object[n6] = ((String)object2).charAt(n3);
        }
        object2 = string2;
        string2 = new String((char[])object);
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.append(".");
        stringBuffer.append((String)object2);
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SimpleBigDecimal)) {
            return false;
        }
        object = (SimpleBigDecimal)object;
        return this.bigInt.equals(((SimpleBigDecimal)object).bigInt) && this.scale == ((SimpleBigDecimal)object).scale;
    }

    public int hashCode() {
        return this.bigInt.hashCode() ^ this.scale;
    }
}

