/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.SimpleBigDecimal;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ZTauElement;
import java.math.BigInteger;

class Tnaf {
    private static final BigInteger MINUS_ONE;
    private static final BigInteger MINUS_TWO;
    private static final BigInteger MINUS_THREE;
    public static final byte WIDTH = 4;
    public static final byte POW_2_WIDTH = 16;
    public static final ZTauElement[] alpha0;
    public static final byte[][] alpha0Tnaf;
    public static final ZTauElement[] alpha1;
    public static final byte[][] alpha1Tnaf;

    public static BigInteger norm(byte by, ZTauElement object) {
        block4: {
            BigInteger bigInteger;
            block3: {
                BigInteger bigInteger2;
                BigInteger bigInteger3;
                block2: {
                    ZTauElement zTauElement = object;
                    BigInteger bigInteger4 = zTauElement.u;
                    bigInteger3 = bigInteger4.multiply(bigInteger4);
                    object = zTauElement.u.multiply(((ZTauElement)object).v);
                    BigInteger bigInteger5 = zTauElement.v;
                    bigInteger2 = bigInteger5.multiply(bigInteger5).shiftLeft(1);
                    if (by != 1) break block2;
                    bigInteger = bigInteger3.add((BigInteger)object).add(bigInteger2);
                    break block3;
                }
                if (by != -1) break block4;
                bigInteger = bigInteger3.subtract((BigInteger)object).add(bigInteger2);
            }
            return bigInteger;
        }
        throw new IllegalArgumentException("mu must be 1 or -1");
    }

    public static SimpleBigDecimal norm(byte by, SimpleBigDecimal simpleBigDecimal, SimpleBigDecimal simpleBigDecimal2) {
        block4: {
            SimpleBigDecimal simpleBigDecimal3;
            block3: {
                SimpleBigDecimal simpleBigDecimal4;
                block2: {
                    SimpleBigDecimal simpleBigDecimal5 = simpleBigDecimal2;
                    SimpleBigDecimal simpleBigDecimal6 = simpleBigDecimal;
                    SimpleBigDecimal simpleBigDecimal7 = simpleBigDecimal;
                    simpleBigDecimal = simpleBigDecimal7.multiply(simpleBigDecimal7);
                    simpleBigDecimal2 = simpleBigDecimal6.multiply(simpleBigDecimal2);
                    simpleBigDecimal4 = simpleBigDecimal5.multiply(simpleBigDecimal5).shiftLeft(1);
                    if (by != 1) break block2;
                    simpleBigDecimal3 = simpleBigDecimal.add(simpleBigDecimal2).add(simpleBigDecimal4);
                    break block3;
                }
                if (by != -1) break block4;
                simpleBigDecimal3 = simpleBigDecimal.subtract(simpleBigDecimal2).add(simpleBigDecimal4);
            }
            return simpleBigDecimal3;
        }
        throw new IllegalArgumentException("mu must be 1 or -1");
    }

    public static ZTauElement round(SimpleBigDecimal object, SimpleBigDecimal object2, byte by) {
        block9: {
            byte by2;
            int n3;
            BigInteger bigInteger;
            block15: {
                block14: {
                    block13: {
                        BigInteger bigInteger2;
                        SimpleBigDecimal simpleBigDecimal;
                        SimpleBigDecimal simpleBigDecimal2;
                        block12: {
                            block11: {
                                block10: {
                                    int n4 = ((SimpleBigDecimal)object).getScale();
                                    if (((SimpleBigDecimal)object2).getScale() != n4) break block9;
                                    if (by != 1 && by != -1) {
                                        throw new IllegalArgumentException("mu must be 1 or -1");
                                    }
                                    SimpleBigDecimal simpleBigDecimal3 = object;
                                    object = ((SimpleBigDecimal)object).round();
                                    bigInteger = ((SimpleBigDecimal)object2).round();
                                    simpleBigDecimal2 = simpleBigDecimal3.subtract((BigInteger)object);
                                    object2 = ((SimpleBigDecimal)object2).subtract(bigInteger);
                                    simpleBigDecimal = simpleBigDecimal2.add(simpleBigDecimal2);
                                    simpleBigDecimal = by == 1 ? simpleBigDecimal.add((SimpleBigDecimal)object2) : simpleBigDecimal.subtract((SimpleBigDecimal)object2);
                                    SimpleBigDecimal simpleBigDecimal4 = object2;
                                    SimpleBigDecimal simpleBigDecimal5 = simpleBigDecimal4.add(simpleBigDecimal4).add((SimpleBigDecimal)object2);
                                    object2 = simpleBigDecimal5.add((SimpleBigDecimal)object2);
                                    if (by == 1) {
                                        SimpleBigDecimal simpleBigDecimal6 = simpleBigDecimal2;
                                        simpleBigDecimal2 = simpleBigDecimal6.subtract(simpleBigDecimal5);
                                        object2 = simpleBigDecimal6.add((SimpleBigDecimal)object2);
                                    } else {
                                        SimpleBigDecimal simpleBigDecimal7 = simpleBigDecimal2;
                                        simpleBigDecimal2 = simpleBigDecimal7.add(simpleBigDecimal5);
                                        object2 = simpleBigDecimal7.subtract((SimpleBigDecimal)object2);
                                    }
                                    n3 = 0;
                                    by2 = 0;
                                    bigInteger2 = ECConstants.ONE;
                                    if (simpleBigDecimal.compareTo(bigInteger2) < 0) break block10;
                                    if (simpleBigDecimal2.compareTo(MINUS_ONE) < 0) break block11;
                                    n3 = 1;
                                    break block12;
                                }
                                if (((SimpleBigDecimal)object2).compareTo(ECConstants.TWO) < 0) break block12;
                            }
                            by2 = by;
                        }
                        if (simpleBigDecimal.compareTo(MINUS_ONE) >= 0) break block13;
                        if (simpleBigDecimal2.compareTo(bigInteger2) >= 0) break block14;
                        n3 = -1;
                        break block15;
                    }
                    if (((SimpleBigDecimal)object2).compareTo(MINUS_TWO) >= 0) break block15;
                }
                by2 = -by;
            }
            object = ((BigInteger)object).add(BigInteger.valueOf(n3));
            object2 = bigInteger.add(BigInteger.valueOf(by2));
            return new ZTauElement((BigInteger)object, (BigInteger)object2);
        }
        throw new IllegalArgumentException("lambda0 and lambda1 do not have same scale");
    }

    public static SimpleBigDecimal approximateDivisionByN(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, byte by, int n3, int n4) {
        int n5 = n3;
        int n6 = (n5 + 5) / 2 + n4;
        BigInteger bigInteger4 = bigInteger2.multiply(bigInteger.shiftRight(n5 - n6 - 2 + by));
        bigInteger2 = bigInteger4.add(bigInteger3.multiply(bigInteger4.shiftRight(n3)));
        int n7 = n6 - n4;
        BigInteger bigInteger5 = bigInteger2.shiftRight(n7);
        if (bigInteger2.testBit(n7 - 1)) {
            bigInteger5 = bigInteger5.add(ECConstants.ONE);
        }
        return new SimpleBigDecimal(bigInteger5, n4);
    }

    public static byte[] tauAdicNaf(byte by, ZTauElement zTauElement) {
        if (by != 1 && by != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        int n3 = Tnaf.norm(by, zTauElement).bitLength();
        byte[] byArray = new byte[n3 > 30 ? n3 + 4 : 34];
        ZTauElement zTauElement2 = zTauElement;
        int n4 = 0;
        int n5 = 0;
        BigInteger bigInteger = zTauElement2.u;
        BigInteger bigInteger2 = zTauElement2.v;
        while (true) {
            BigInteger bigInteger3;
            if (bigInteger.equals(bigInteger3 = ECConstants.ZERO) && bigInteger2.equals(bigInteger3)) {
                int n6 = n5 + 1;
                by = (byte)n6;
                byte[] byArray2 = new byte[n6];
                System.arraycopy(byArray, 0, byArray2, 0, by);
                return byArray2;
            }
            if (bigInteger.testBit(0)) {
                BigInteger bigInteger4;
                byte by2 = (byte)ECConstants.TWO.subtract(bigInteger.subtract(bigInteger2.shiftLeft(1)).mod(ECConstants.FOUR)).intValue();
                byArray[n4] = n5 = (int)by2;
                bigInteger = by2 == 1 ? (bigInteger4 = bigInteger.clearBit(0)) : (bigInteger4 = bigInteger.add(ECConstants.ONE));
                n5 = n4;
            } else {
                byArray[n4] = 0;
            }
            bigInteger3 = bigInteger.shiftRight(1);
            bigInteger2 = by == 1 ? bigInteger2.add(bigInteger3) : bigInteger2.subtract(bigInteger3);
            bigInteger = bigInteger.shiftRight(1).negate();
            ++n4;
            BigInteger bigInteger5 = bigInteger2;
            bigInteger2 = bigInteger;
            bigInteger = bigInteger5;
        }
    }

    public static ECPoint.AbstractF2m tau(ECPoint.AbstractF2m abstractF2m) {
        return abstractF2m.tau();
    }

    public static byte getMu(ECCurve.AbstractF2m abstractF2m) {
        if (abstractF2m.isKoblitz()) {
            if (abstractF2m.getA().isZero()) {
                return -1;
            }
            return 1;
        }
        throw new IllegalArgumentException("No Koblitz curve (ABC), TNAF multiplication not possible");
    }

    public static byte getMu(ECFieldElement eCFieldElement) {
        return (byte)(eCFieldElement.isZero() ? -1 : 1);
    }

    public static byte getMu(int n3) {
        return (byte)(n3 == 0 ? -1 : 1);
    }

    public static BigInteger[] getLucas(byte by, int n3, boolean bl) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (by != 1 && by != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        if (bl) {
            bigInteger2 = ECConstants.TWO;
            bigInteger = BigInteger.valueOf(by);
        } else {
            bigInteger2 = ECConstants.ZERO;
            bigInteger = ECConstants.ONE;
        }
        for (int i3 = 1; i3 < n3; ++i3) {
            BigInteger bigInteger3 = by == 1 ? bigInteger : bigInteger.negate();
            bigInteger2 = bigInteger3.subtract(bigInteger2.shiftLeft(1));
            BigInteger bigInteger4 = bigInteger;
            bigInteger = bigInteger2;
            bigInteger2 = bigInteger4;
        }
        return new BigInteger[]{bigInteger2, bigInteger};
    }

    public static BigInteger getTw(byte by, int n3) {
        if (n3 == 4) {
            if (by == 1) {
                return BigInteger.valueOf(6L);
            }
            return BigInteger.valueOf(10L);
        }
        BigInteger[] bigIntegerArray = Tnaf.getLucas(by, n3, false);
        BigInteger bigInteger = ECConstants.ZERO.setBit(n3);
        return ECConstants.TWO.multiply(bigIntegerArray[0]).multiply(bigIntegerArray[1].modInverse(bigInteger)).mod(bigInteger);
    }

    public static BigInteger[] getSi(ECCurve.AbstractF2m abstractF2m) {
        if (abstractF2m.isKoblitz()) {
            ECCurve.AbstractF2m abstractF2m2 = abstractF2m;
            int n3 = abstractF2m2.getFieldSize();
            int n4 = abstractF2m2.getA().toBigInteger().intValue();
            byte by = Tnaf.getMu(n4);
            int n5 = Tnaf.getShiftsForCofactor(abstractF2m.getCofactor());
            Object object = Tnaf.getLucas(by, n3 + 3 - n4, false);
            if (by == 1) {
                BigInteger[] bigIntegerArray = object;
                bigIntegerArray[0] = object[0].negate();
                bigIntegerArray[1] = object[1].negate();
            }
            BigInteger bigInteger = ECConstants.ONE;
            object = bigInteger.add(object[1]).shiftRight(n5);
            BigInteger bigInteger2 = bigInteger.add(object[0]).shiftRight(n5).negate();
            return new BigInteger[]{object, bigInteger2};
        }
        throw new IllegalArgumentException("si is defined for Koblitz curves only");
    }

    public static BigInteger[] getSi(int n3, int n4, BigInteger bigInteger) {
        byte by = Tnaf.getMu(n4);
        int n5 = n3;
        n3 = Tnaf.getShiftsForCofactor(bigInteger);
        Object object = Tnaf.getLucas(by, n5 + 3 - n4, false);
        if (by == 1) {
            BigInteger[] bigIntegerArray = object;
            bigIntegerArray[0] = object[0].negate();
            bigIntegerArray[1] = object[1].negate();
        }
        BigInteger bigInteger2 = ECConstants.ONE;
        object = bigInteger2.add(object[1]).shiftRight(n3);
        BigInteger bigInteger3 = bigInteger2.add(object[0]).shiftRight(n3).negate();
        return new BigInteger[]{object, bigInteger3};
    }

    public static int getShiftsForCofactor(BigInteger bigInteger) {
        if (bigInteger != null) {
            if (bigInteger.equals(ECConstants.TWO)) {
                return 1;
            }
            if (bigInteger.equals(ECConstants.FOUR)) {
                return 2;
            }
        }
        throw new IllegalArgumentException("h (Cofactor) must be 2 or 4");
    }

    public static ZTauElement partModReduction(BigInteger object, int n3, byte by, BigInteger[] bigIntegerArray, byte by2, byte by3) {
        BigInteger bigInteger = by2 == 1 ? bigIntegerArray[0].add(bigIntegerArray[1]) : bigIntegerArray[0].subtract(bigIntegerArray[1]);
        BigInteger bigInteger2 = object;
        BigInteger bigInteger3 = bigInteger;
        bigInteger = Tnaf.getLucas(by2, n3, true)[1];
        object = Tnaf.round(Tnaf.approximateDivisionByN((BigInteger)object, bigIntegerArray[0], bigInteger, by, n3, by3), Tnaf.approximateDivisionByN((BigInteger)object, bigIntegerArray[1], bigInteger, by, n3, by3), by2);
        BigInteger bigInteger4 = bigInteger2.subtract(bigInteger3.multiply(((ZTauElement)object).u)).subtract(BigInteger.valueOf(2L).multiply(bigIntegerArray[1]).multiply(((ZTauElement)object).v));
        object = bigIntegerArray[1].multiply(((ZTauElement)object).u).subtract(bigIntegerArray[0].multiply(((ZTauElement)object).v));
        return new ZTauElement(bigInteger4, (BigInteger)object);
    }

    public static ECPoint.AbstractF2m multiplyRTnaf(ECPoint.AbstractF2m object, BigInteger bigIntegerArray) {
        ECPoint.AbstractF2m abstractF2m = object;
        BigInteger[] bigIntegerArray2 = bigIntegerArray;
        object = (ECCurve.AbstractF2m)((ECPoint)object).getCurve();
        int n3 = ((ECCurve)object).getA().toBigInteger().intValue();
        byte by = Tnaf.getMu(n3);
        bigIntegerArray = ((ECCurve.AbstractF2m)object).getSi();
        return Tnaf.multiplyTnaf(abstractF2m, Tnaf.partModReduction((BigInteger)bigIntegerArray2, ((ECCurve)object).getFieldSize(), (byte)n3, bigIntegerArray, by, (byte)10));
    }

    public static ECPoint.AbstractF2m multiplyTnaf(ECPoint.AbstractF2m abstractF2m, ZTauElement zTauElement) {
        ECPoint.AbstractF2m abstractF2m2 = abstractF2m;
        return Tnaf.multiplyFromTnaf(abstractF2m2, Tnaf.tauAdicNaf(Tnaf.getMu(((ECCurve.AbstractF2m)abstractF2m2.getCurve()).getA()), zTauElement));
    }

    public static ECPoint.AbstractF2m multiplyFromTnaf(ECPoint.AbstractF2m abstractF2m, byte[] byArray) {
        ECPoint.AbstractF2m abstractF2m2 = abstractF2m;
        ECPoint.AbstractF2m abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m2.getCurve().getInfinity();
        ECPoint.AbstractF2m abstractF2m4 = (ECPoint.AbstractF2m)abstractF2m2.negate();
        int n3 = 0;
        for (int i3 = byArray.length - 1; i3 >= 0; --i3) {
            ++n3;
            byte by = byArray[i3];
            if (by == 0) continue;
            abstractF2m3 = abstractF2m3.tauPow(n3);
            n3 = 0;
            ECPoint.AbstractF2m abstractF2m5 = by > 0 ? abstractF2m : abstractF2m4;
            abstractF2m3 = (ECPoint.AbstractF2m)abstractF2m3.add(abstractF2m5);
        }
        if (n3 > 0) {
            abstractF2m3 = abstractF2m3.tauPow(n3);
        }
        return abstractF2m3;
    }

    public static byte[] tauAdicWNaf(byte by, ZTauElement object, byte by2, BigInteger bigInteger, BigInteger bigInteger2, ZTauElement[] zTauElementArray) {
        if (by != 1 && by != -1) {
            throw new IllegalArgumentException("mu must be 1 or -1");
        }
        int n3 = Tnaf.norm(by, (ZTauElement)object).bitLength();
        byte[] byArray = new byte[n3 > 30 ? n3 + 4 + by2 : by2 + 34];
        ZTauElement zTauElement = object;
        object = bigInteger.shiftRight(1);
        BigInteger bigInteger3 = zTauElement.u;
        BigInteger bigInteger4 = zTauElement.v;
        int n4 = 0;
        BigInteger bigInteger5;
        while (!bigInteger3.equals(bigInteger5 = ECConstants.ZERO) || !bigInteger4.equals(bigInteger5)) {
            if (bigInteger3.testBit(0)) {
                bigInteger5 = bigInteger3.add(bigInteger4.multiply(bigInteger2)).mod(bigInteger);
                byte by3 = bigInteger5.compareTo((BigInteger)object) >= 0 ? (byte)bigInteger5.subtract(bigInteger).intValue() : (byte)bigInteger5.intValue();
                byArray[n4] = by3;
                boolean bl = true;
                if (by3 < 0) {
                    bl = false;
                    by3 = -by3;
                }
                if (bl) {
                    bigInteger3 = bigInteger3.subtract(zTauElementArray[by3].u);
                    bigInteger4 = bigInteger4.subtract(zTauElementArray[by3].v);
                } else {
                    bigInteger3 = bigInteger3.add(zTauElementArray[by3].u);
                    bigInteger4 = bigInteger4.add(zTauElementArray[by3].v);
                }
            } else {
                byArray[n4] = 0;
            }
            bigInteger4 = by == 1 ? bigInteger4.add(bigInteger3.shiftRight(1)) : bigInteger4.subtract(bigInteger3.shiftRight(1));
            bigInteger3 = bigInteger3.shiftRight(1).negate();
            ++n4;
            BigInteger bigInteger6 = bigInteger4;
            bigInteger4 = bigInteger3;
            bigInteger3 = bigInteger6;
        }
        return byArray;
    }

    public static ECPoint.AbstractF2m[] getPreComp(ECPoint.AbstractF2m abstractF2m, byte by) {
        byte[][] byArray = by == 0 ? alpha0Tnaf : alpha1Tnaf;
        ECPoint[] eCPointArray = new ECPoint.AbstractF2m[byArray.length + 1 >>> 1];
        ECPoint[] eCPointArray2 = eCPointArray;
        eCPointArray[0] = abstractF2m;
        int n3 = byArray.length;
        for (int i3 = 3; i3 < n3; i3 += 2) {
            int n4 = i3;
            int n5 = n4 >>> 1;
            eCPointArray2[n5] = Tnaf.multiplyFromTnaf(abstractF2m, byArray[n4]);
        }
        abstractF2m.getCurve().normalizeAll(eCPointArray2);
        return eCPointArray2;
    }

    static {
        ZTauElement zTauElement;
        ZTauElement zTauElement2;
        ZTauElement zTauElement3;
        ZTauElement zTauElement4;
        ZTauElement zTauElement5;
        ZTauElement zTauElement6;
        ZTauElement zTauElement7;
        ZTauElement zTauElement8;
        Object object = ECConstants.ONE;
        Object object2 = ((BigInteger)object).negate();
        MINUS_ONE = object2;
        MINUS_TWO = ECConstants.TWO.negate();
        Object object3 = ECConstants.THREE.negate();
        MINUS_THREE = object3;
        ZTauElement[] zTauElementArray = new ZTauElement[9];
        zTauElementArray[0] = null;
        Object object4 = zTauElement8;
        BigInteger bigInteger = ECConstants.ZERO;
        zTauElement8 = new ZTauElement((BigInteger)object, bigInteger);
        zTauElementArray[1] = object4;
        zTauElementArray[2] = null;
        object4 = zTauElement7;
        zTauElement7 = new ZTauElement((BigInteger)object3, (BigInteger)object2);
        zTauElementArray[3] = object4;
        zTauElementArray[4] = null;
        object4 = zTauElement6;
        BigInteger bigInteger2 = object2;
        zTauElement6 = new ZTauElement(bigInteger2, bigInteger2);
        zTauElementArray[5] = object4;
        zTauElementArray[6] = null;
        object4 = zTauElement5;
        zTauElement5 = new ZTauElement((BigInteger)object, (BigInteger)object2);
        zTauElementArray[7] = object4;
        zTauElementArray[8] = null;
        alpha0 = zTauElementArray;
        byte[][] byArrayArray = new byte[8][];
        byArrayArray[0] = null;
        byte[] byArray = new byte[1];
        object4 = byArray;
        byArray[0] = 1;
        byArrayArray[1] = (byte[])object4;
        byArrayArray[2] = null;
        byte[] byArray2 = new byte[3];
        object4 = byArray2;
        byArray2[0] = -1;
        byArray2[1] = 0;
        byArray2[2] = 1;
        byArrayArray[3] = (byte[])object4;
        byArrayArray[4] = null;
        byte[] byArray3 = new byte[3];
        object4 = byArray3;
        byArray3[0] = 1;
        byArray3[1] = 0;
        byArray3[2] = 1;
        byArrayArray[5] = (byte[])object4;
        byArrayArray[6] = null;
        byte[] byArray4 = new byte[4];
        object4 = byArray4;
        byArray4[0] = -1;
        byArray4[1] = 0;
        byArray4[2] = 0;
        byArray4[3] = 1;
        byArrayArray[7] = (byte[])object4;
        alpha0Tnaf = byArrayArray;
        ZTauElement[] zTauElementArray2 = new ZTauElement[9];
        zTauElementArray2[0] = null;
        object4 = zTauElement4;
        zTauElement4 = new ZTauElement((BigInteger)object, bigInteger);
        zTauElementArray2[1] = object4;
        zTauElementArray2[2] = null;
        object4 = zTauElement3;
        zTauElement3 = new ZTauElement((BigInteger)object3, (BigInteger)object);
        zTauElementArray2[3] = object4;
        zTauElementArray2[4] = null;
        object3 = zTauElement2;
        zTauElement2 = new ZTauElement((BigInteger)object2, (BigInteger)object);
        zTauElementArray2[5] = object3;
        zTauElementArray2[6] = null;
        object2 = zTauElement;
        BigInteger bigInteger3 = object;
        zTauElement = new ZTauElement(bigInteger3, bigInteger3);
        zTauElementArray2[7] = object2;
        zTauElementArray2[8] = null;
        alpha1 = zTauElementArray2;
        byte[][] byArrayArray2 = new byte[8][];
        byArrayArray2[0] = null;
        byte[] byArray5 = new byte[1];
        object = byArray5;
        byArray5[0] = 1;
        byArrayArray2[1] = (byte[])object;
        byArrayArray2[2] = null;
        byte[] byArray6 = new byte[3];
        object = byArray6;
        byArray6[0] = -1;
        byArray6[1] = 0;
        byArray6[2] = 1;
        byArrayArray2[3] = (byte[])object;
        byArrayArray2[4] = null;
        byte[] byArray7 = new byte[3];
        object = byArray7;
        byArray7[0] = 1;
        byArray7[1] = 0;
        byArray7[2] = 1;
        byArrayArray2[5] = (byte[])object;
        byArrayArray2[6] = null;
        byte[] byArray8 = new byte[4];
        object = byArray8;
        byArray8[0] = -1;
        byArray8[1] = 0;
        byArray8[2] = 0;
        byArray8[3] = -1;
        byArrayArray2[7] = (byte[])object;
        alpha1Tnaf = byArrayArray2;
    }
}

