/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECAlgorithms;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPointMap;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompCallback;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.PreCompInfo;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.WNafPreCompInfo;
import java.math.BigInteger;

public abstract class WNafUtil {
    public static final String PRECOMP_NAME = "bc_wnaf";
    private static final int[] DEFAULT_WINDOW_SIZE_CUTOFFS = new int[]{13, 41, 121, 337, 897, 2305};
    private static final int MAX_WIDTH = 16;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final int[] EMPTY_INTS = new int[0];
    private static final ECPoint[] EMPTY_POINTS = new ECPoint[0];

    public static void configureBasepoint(ECPoint eCPoint) {
        PreCompCallback preCompCallback;
        ECCurve eCCurve = eCPoint.getCurve();
        if (eCCurve == null) {
            return;
        }
        Object object = eCCurve.getOrder();
        final int n3 = Math.min(16, WNafUtil.getWindowSize(object == null ? eCCurve.getFieldSize() + 1 : ((BigInteger)object).bitLength()) + 3);
        object = preCompCallback;
        preCompCallback = new PreCompCallback(){

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo;
                WNafPreCompInfo wNafPreCompInfo2;
                if ((preCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null) != null && ((WNafPreCompInfo)preCompInfo).getConfWidth() == n3) {
                    PreCompInfo preCompInfo2 = preCompInfo;
                    ((WNafPreCompInfo)preCompInfo2).setPromotionCountdown(0);
                    return preCompInfo2;
                }
                WNafPreCompInfo wNafPreCompInfo3 = wNafPreCompInfo2 = wNafPreCompInfo;
                wNafPreCompInfo3();
                wNafPreCompInfo3.setPromotionCountdown(0);
                wNafPreCompInfo.setConfWidth(n3);
                if (preCompInfo != null) {
                    wNafPreCompInfo2.setPreComp(((WNafPreCompInfo)preCompInfo).getPreComp());
                    wNafPreCompInfo2.setPreCompNeg(((WNafPreCompInfo)preCompInfo).getPreCompNeg());
                    wNafPreCompInfo2.setTwice(((WNafPreCompInfo)preCompInfo).getTwice());
                    wNafPreCompInfo2.setWidth(((WNafPreCompInfo)preCompInfo).getWidth());
                }
                return wNafPreCompInfo2;
            }
        };
        eCCurve.precompute(eCPoint, PRECOMP_NAME, (PreCompCallback)object);
    }

    public static int[] generateCompactNaf(BigInteger bigInteger) {
        if (bigInteger.bitLength() >>> 16 == 0) {
            if (bigInteger.signum() == 0) {
                return EMPTY_INTS;
            }
            BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
            int n3 = bigInteger2.bitLength();
            int n4 = n3 >> 1;
            int[] nArray = new int[n4];
            BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
            int n5 = n3 - 1;
            int n6 = 0;
            int n7 = 0;
            for (int i3 = 1; i3 < n5; ++i3) {
                if (!bigInteger3.testBit(i3)) {
                    ++n7;
                    continue;
                }
                int n8 = bigInteger.testBit(i3) ? -1 : 1;
                nArray[n6++] = n8 << 16 | n7;
                n7 = 1;
                ++i3;
            }
            int n9 = n6 + 1;
            nArray[n6] = n7 | 0x10000;
            if (n4 > n9) {
                nArray = WNafUtil.trim(nArray, n9);
            }
            return nArray;
        }
        throw new IllegalArgumentException("'k' must have bitlength < 2^16");
    }

    public static int[] generateCompactWindowNaf(int n3, BigInteger bigInteger) {
        if (n3 == 2) {
            return WNafUtil.generateCompactNaf(bigInteger);
        }
        if (n3 >= 2 && n3 <= 16) {
            if (bigInteger.bitLength() >>> 16 == 0) {
                if (bigInteger.signum() == 0) {
                    return EMPTY_INTS;
                }
                int n4 = bigInteger.bitLength() / n3 + 1;
                int[] nArray = new int[n4];
                int n5 = 1 << n3;
                int n6 = n5 - 1;
                int n7 = n5 >>> 1;
                int n8 = 0;
                int n9 = 0;
                int n10 = 0;
                while (n10 <= bigInteger.bitLength()) {
                    int n11;
                    if (bigInteger.testBit(n10) == n8) {
                        ++n10;
                        continue;
                    }
                    int n12 = n8;
                    bigInteger = bigInteger.shiftRight(n10);
                    n8 = bigInteger.intValue() & n6;
                    if (n12 != 0) {
                        ++n8;
                    }
                    if ((n11 = (n8 & n7) != 0 ? 1 : 0) != 0) {
                        n8 -= n5;
                    }
                    if (n9 > 0) {
                        --n10;
                    }
                    nArray[n9++] = n8 << 16 | n10;
                    n8 = n11;
                    n10 = n3;
                }
                if (n4 > n9) {
                    nArray = WNafUtil.trim(nArray, n9);
                }
                return nArray;
            }
            throw new IllegalArgumentException("'k' must have bitlength < 2^16");
        }
        throw new IllegalArgumentException("'width' must be in the range [2, 16]");
    }

    public static byte[] generateJSF(BigInteger bigInteger, BigInteger bigInteger2) {
        int n3 = Math.max(bigInteger.bitLength(), bigInteger2.bitLength()) + 1;
        byte[] byArray = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        while (true) {
            int n8;
            if (!(n5 | n6) && bigInteger.bitLength() <= n7 && bigInteger2.bitLength() <= n7) {
                if (n3 > n4) {
                    byArray = WNafUtil.trim(byArray, n4);
                }
                return byArray;
            }
            int n9 = (bigInteger.intValue() >>> n7) + n5 & 7;
            int n10 = (bigInteger2.intValue() >>> n7) + n6 & 7;
            int n11 = n9 & 1;
            if (n11 != 0 && n9 + (n11 -= n9 & 2) == 4 && (n10 & 3) == 2) {
                n11 = -n11;
            }
            if ((n8 = n10 & 1) != 0 && n10 + (n8 -= n10 & 2) == 4 && (n9 & 3) == 2) {
                n8 = -n8;
            }
            if (n5 << 1 == n11 + 1) {
                n5 ^= 1;
            }
            if (n6 << 1 == n8 + 1) {
                n6 ^= 1;
            }
            if (++n7 == 30) {
                BigInteger bigInteger3 = bigInteger2;
                int n12 = 0;
                bigInteger2 = bigInteger.shiftRight(30);
                BigInteger bigInteger4 = bigInteger3.shiftRight(30);
                BigInteger bigInteger5 = bigInteger2;
                n7 = n12;
                bigInteger2 = bigInteger4;
                bigInteger = bigInteger5;
            }
            byArray[n4++] = (byte)(n11 << 4 | n8 & 0xF);
        }
    }

    public static byte[] generateNaf(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return EMPTY_BYTES;
        }
        BigInteger bigInteger2 = bigInteger.shiftLeft(1).add(bigInteger);
        int n3 = bigInteger2.bitLength() - 1;
        byte[] byArray = new byte[n3];
        BigInteger bigInteger3 = bigInteger2.xor(bigInteger);
        for (int i3 = 1; i3 < n3; ++i3) {
            byte by;
            if (!bigInteger3.testBit(i3)) continue;
            int n4 = i3;
            int n5 = n4 - 1;
            byArray[n5] = by = (byte)(bigInteger.testBit(n4) ? -1 : 1);
            ++i3;
        }
        byArray[n3 - 1] = 1;
        return byArray;
    }

    public static byte[] generateWindowNaf(int n3, BigInteger bigInteger) {
        if (n3 == 2) {
            return WNafUtil.generateNaf(bigInteger);
        }
        if (n3 >= 2 && n3 <= 8) {
            if (bigInteger.signum() == 0) {
                return EMPTY_BYTES;
            }
            int n4 = bigInteger.bitLength() + 1;
            byte[] byArray = new byte[n4];
            int n5 = 1 << n3;
            int n6 = n5 - 1;
            int n7 = n5 >>> 1;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            while (n10 <= bigInteger.bitLength()) {
                int n11;
                if (bigInteger.testBit(n10) == n8) {
                    ++n10;
                    continue;
                }
                int n12 = n8;
                bigInteger = bigInteger.shiftRight(n10);
                n8 = bigInteger.intValue() & n6;
                if (n12 != 0) {
                    ++n8;
                }
                if ((n11 = (n8 & n7) != 0 ? 1 : 0) != 0) {
                    n8 -= n5;
                }
                if (n9 > 0) {
                    --n10;
                }
                int n13 = n8;
                n8 = n9 + n10;
                n9 = n8 + 1;
                byArray[n8] = (byte)n13;
                n8 = n11;
                n10 = n3;
            }
            if (n4 > n9) {
                byArray = WNafUtil.trim(byArray, n9);
            }
            return byArray;
        }
        throw new IllegalArgumentException("'width' must be in the range [2, 8]");
    }

    public static int getNafWeight(BigInteger bigInteger) {
        if (bigInteger.signum() == 0) {
            return 0;
        }
        return bigInteger.shiftLeft(1).add(bigInteger).xor(bigInteger).bitCount();
    }

    public static WNafPreCompInfo getWNafPreCompInfo(ECPoint eCPoint) {
        return WNafUtil.getWNafPreCompInfo(eCPoint.getCurve().getPreCompInfo(eCPoint, PRECOMP_NAME));
    }

    public static WNafPreCompInfo getWNafPreCompInfo(PreCompInfo preCompInfo) {
        return preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
    }

    public static int getWindowSize(int n3) {
        return WNafUtil.getWindowSize(n3, DEFAULT_WINDOW_SIZE_CUTOFFS, 16);
    }

    public static int getWindowSize(int n3, int n4) {
        return WNafUtil.getWindowSize(n3, DEFAULT_WINDOW_SIZE_CUTOFFS, n4);
    }

    public static int getWindowSize(int n3, int[] nArray) {
        return WNafUtil.getWindowSize(n3, nArray, 16);
    }

    public static int getWindowSize(int n3, int[] nArray, int n4) {
        int n5;
        for (n5 = 0; n5 < nArray.length && n3 >= nArray[n5]; ++n5) {
        }
        return Math.max(2, Math.min(n4, n5 + 2));
    }

    public static WNafPreCompInfo precompute(final ECPoint eCPoint, final int n3, final boolean bl) {
        PreCompCallback preCompCallback;
        final ECCurve eCCurve = eCPoint.getCurve();
        PreCompCallback preCompCallback2 = preCompCallback;
        preCompCallback = new PreCompCallback(){

            private boolean checkExisting(WNafPreCompInfo wNafPreCompInfo, int n32, int n4, boolean bl2) {
                return wNafPreCompInfo != null && wNafPreCompInfo.getWidth() >= Math.max(wNafPreCompInfo.getConfWidth(), n32) && this.checkTable(wNafPreCompInfo.getPreComp(), n4) && (!bl2 || this.checkTable(wNafPreCompInfo.getPreCompNeg(), n4));
            }

            private boolean checkTable(ECPoint[] eCPointArray, int n32) {
                return eCPointArray != null && eCPointArray.length >= n32;
            }

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo;
                boolean bl2;
                int n32;
                preCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null;
                2 v02 = this;
                int n4 = Math.max(2, Math.min(16, v02.n3));
                if (this.checkExisting((WNafPreCompInfo)preCompInfo, n4, n32 = 1 << n4 - 2, bl2 = v02.bl)) {
                    PreCompInfo preCompInfo2 = preCompInfo;
                    ((WNafPreCompInfo)preCompInfo2).decrementPromotionCountdown();
                    return preCompInfo2;
                }
                WNafPreCompInfo wNafPreCompInfo2 = wNafPreCompInfo;
                wNafPreCompInfo = new WNafPreCompInfo();
                ECPoint[] eCPointArray = null;
                ECPoint[] eCPointArray2 = null;
                ECPoint eCPoint5 = null;
                if (preCompInfo != null) {
                    PreCompInfo preCompInfo3 = preCompInfo;
                    wNafPreCompInfo2.setPromotionCountdown(((WNafPreCompInfo)preCompInfo).decrementPromotionCountdown());
                    wNafPreCompInfo2.setConfWidth(((WNafPreCompInfo)preCompInfo).getConfWidth());
                    eCPointArray = ((WNafPreCompInfo)preCompInfo3).getPreComp();
                    eCPointArray2 = ((WNafPreCompInfo)preCompInfo3).getPreCompNeg();
                    eCPoint5 = ((WNafPreCompInfo)preCompInfo3).getTwice();
                }
                int n5 = Math.min(16, Math.max(wNafPreCompInfo2.getConfWidth(), n4));
                n4 = 1 << n5 - 2;
                int n6 = 0;
                if (eCPointArray == null) {
                    eCPointArray = EMPTY_POINTS;
                } else {
                    n6 = eCPointArray.length;
                }
                if (n6 < n4) {
                    eCPointArray = WNafUtil.resizeTable(eCPointArray, n4);
                    if (n4 == 1) {
                        eCPointArray[0] = eCPoint.normalize();
                    } else {
                        int n7;
                        if (n6 == 0) {
                            eCPointArray[0] = eCPoint;
                            n7 = 1;
                        } else {
                            n7 = n6;
                        }
                        Object object = null;
                        if (n4 == 2) {
                            eCPointArray[1] = eCPoint.threeTimes();
                        } else {
                            int n8;
                            ECPoint eCPoint2;
                            Object object2;
                            int n9;
                            Object object3 = eCPointArray[n7 - 1];
                            if (eCPoint5 == null && !(eCPoint5 = eCPointArray[0].twice()).isInfinity() && ECAlgorithms.isFpCurve(eCCurve) && eCCurve.getFieldSize() >= 64 && ((n9 = eCCurve.getCoordinateSystem()) == 2 || n9 == 3 || n9 == 4)) {
                                ECPoint eCPoint3 = object3;
                                object = eCPoint5.getZCoord(0);
                                object3 = eCCurve.createPoint(eCPoint5.getXCoord().toBigInteger(), eCPoint5.getYCoord().toBigInteger());
                                ECFieldElement eCFieldElement = ((ECFieldElement)object).square();
                                object2 = eCFieldElement.multiply((ECFieldElement)object);
                                object2 = eCPoint3.scaleX(eCFieldElement).scaleY((ECFieldElement)object2);
                                if (n6 == 0) {
                                    eCPointArray[0] = object2;
                                }
                                eCPoint2 = object3;
                                object3 = object;
                                n8 = n7;
                            } else {
                                eCPoint2 = eCPoint5;
                                object2 = object3;
                                object3 = object;
                                n8 = n7;
                            }
                            while (n8 < n4) {
                                ECPoint eCPoint4;
                                int n10 = n8 + 1;
                                eCPointArray[n8] = eCPoint4 = ((ECPoint)object2).add(eCPoint2);
                                object2 = eCPoint4;
                                n8 = n10;
                            }
                            object = object3;
                        }
                        eCCurve.normalizeAll(eCPointArray, n6, n4 - n6, (ECFieldElement)object);
                    }
                }
                if (bl) {
                    int n11;
                    if (eCPointArray2 == null) {
                        n11 = 0;
                        eCPointArray2 = new ECPoint[n4];
                    } else {
                        n11 = eCPointArray2.length;
                        if (n11 < n4) {
                            eCPointArray2 = WNafUtil.resizeTable(eCPointArray2, n4);
                        }
                    }
                    while (n11 < n4) {
                        eCPointArray2[n11] = eCPointArray[n11].negate();
                        ++n11;
                    }
                }
                WNafPreCompInfo wNafPreCompInfo3 = wNafPreCompInfo2;
                wNafPreCompInfo3.setPreComp(eCPointArray);
                wNafPreCompInfo3.setPreCompNeg(eCPointArray2);
                wNafPreCompInfo3.setTwice(eCPoint5);
                wNafPreCompInfo3.setWidth(n5);
                return wNafPreCompInfo3;
            }
        };
        return (WNafPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, preCompCallback2);
    }

    public static WNafPreCompInfo precomputeWithPointMap(ECPoint object, final ECPointMap eCPointMap, final WNafPreCompInfo wNafPreCompInfo, final boolean bl) {
        PreCompCallback preCompCallback;
        ECCurve eCCurve = ((ECPoint)object).getCurve();
        ECPoint eCPoint = object;
        object = preCompCallback;
        preCompCallback = new PreCompCallback(){

            private boolean checkExisting(WNafPreCompInfo wNafPreCompInfo2, int n3, int n4, boolean bl2) {
                return wNafPreCompInfo2 != null && wNafPreCompInfo2.getWidth() >= n3 && this.checkTable(wNafPreCompInfo2.getPreComp(), n4) && (!bl2 || this.checkTable(wNafPreCompInfo2.getPreCompNeg(), n4));
            }

            private boolean checkTable(ECPoint[] eCPointArray, int n3) {
                return eCPointArray != null && eCPointArray.length >= n3;
            }

            @Override
            public PreCompInfo precompute(PreCompInfo preCompInfo) {
                WNafPreCompInfo wNafPreCompInfo2;
                int n3;
                int n4;
                int n5;
                if (eCPointArray3.checkExisting((WNafPreCompInfo)(preCompInfo = preCompInfo instanceof WNafPreCompInfo ? (WNafPreCompInfo)preCompInfo : null), n5 = eCPointArray3.wNafPreCompInfo.getWidth(), n4 = eCPointArray3.wNafPreCompInfo.getPreComp().length, (n3 = eCPointArray3.bl) != 0)) {
                    PreCompInfo preCompInfo2 = preCompInfo;
                    ((WNafPreCompInfo)preCompInfo2).decrementPromotionCountdown();
                    return preCompInfo2;
                }
                preCompInfo = wNafPreCompInfo2;
                ((WNafPreCompInfo)preCompInfo)();
                wNafPreCompInfo2.setPromotionCountdown(eCPointArray3.wNafPreCompInfo.getPromotionCountdown());
                ECPoint[] eCPointArray = eCPointArray3.wNafPreCompInfo.getTwice();
                if (eCPointArray != null) {
                    ((WNafPreCompInfo)preCompInfo).setTwice(eCPointArray3.eCPointMap.map((ECPoint)eCPointArray));
                }
                eCPointArray = eCPointArray3.wNafPreCompInfo.getPreComp();
                n3 = eCPointArray.length;
                ECPoint[] eCPointArray2 = new ECPoint[n3];
                for (int i3 = 0; i3 < eCPointArray.length; ++i3) {
                    eCPointArray2[i3] = eCPointArray3.eCPointMap.map(eCPointArray[i3]);
                }
                ((WNafPreCompInfo)preCompInfo).setPreComp(eCPointArray2);
                ((WNafPreCompInfo)preCompInfo).setWidth(n5);
                if (eCPointArray3.bl) {
                    ECPoint[] eCPointArray3 = new ECPoint[n3];
                    for (n5 = 0; n5 < n3; ++n5) {
                        eCPointArray3[n5] = eCPointArray2[n5].negate();
                    }
                    ((WNafPreCompInfo)preCompInfo).setPreCompNeg(eCPointArray3);
                }
                return preCompInfo;
            }
        };
        return (WNafPreCompInfo)eCCurve.precompute(eCPoint, PRECOMP_NAME, (PreCompCallback)object);
    }

    private static byte[] trim(byte[] byArray, int n3) {
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, 0, byArray2, 0, n3);
        return byArray2;
    }

    private static int[] trim(int[] nArray, int n3) {
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, 0, nArray2, 0, n3);
        return nArray2;
    }

    private static ECPoint[] resizeTable(ECPoint[] eCPointArray, int n3) {
        ECPoint[] eCPointArray2 = new ECPoint[n3];
        int n4 = eCPointArray.length;
        System.arraycopy(eCPointArray, 0, eCPointArray2, 0, n4);
        return eCPointArray2;
    }
}

