/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb.Curve25519Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb.Curve25519FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb.Curve25519Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Curve25519
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final BigInteger C_a;
    private static final BigInteger C_b;
    private static final int CURVE25519_DEFAULT_COORDS = 4;
    private static final ECFieldElement[] CURVE25519_AFFINE_ZS;
    public Curve25519Point infinity;

    public Curve25519() {
        Curve25519 curve25519 = this;
        super(q);
        curve25519.infinity = new Curve25519Point(this, null, null);
        curve25519.a = curve25519.fromBigInteger(C_a);
        curve25519.b = curve25519.fromBigInteger(C_b);
        curve25519.order = new BigInteger(1, Hex.decodeStrict("1000000000000000000000000000000014DEF9DEA2F79CD65812631A5CF5D3ED"));
        curve25519.cofactor = BigInteger.valueOf(8L);
        curve25519.coord = 4;
    }

    static {
        Curve25519FieldElement curve25519FieldElement;
        Curve25519FieldElement curve25519FieldElement2;
        BigInteger bigInteger;
        q = Curve25519FieldElement.Q;
        BigInteger bigInteger2 = bigInteger;
        C_a = new BigInteger(1, Hex.decodeStrict("2AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA984914A144"));
        C_b = new BigInteger(1, Hex.decodeStrict("7B425ED097B425ED097B425ED097B425ED097B425ED097B4260B5E9C7710C864"));
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[2];
        Curve25519FieldElement curve25519FieldElement3 = curve25519FieldElement2;
        curve25519FieldElement2 = new Curve25519FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = curve25519FieldElement3;
        curve25519FieldElement3 = curve25519FieldElement;
        curve25519FieldElement = new Curve25519FieldElement(bigInteger2);
        eCFieldElementArray[1] = curve25519FieldElement3;
        CURVE25519_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new Curve25519();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 4;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new Curve25519FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new Curve25519Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final int[] nArray = new int[n4 * 8 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat256.copy(((Curve25519FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 8);
            n5 += 8;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                Curve25519FieldElement curve25519FieldElement;
                Curve25519FieldElement curve25519FieldElement2 = curve25519FieldElement;
                curve25519FieldElement = new Curve25519FieldElement(nArray2);
                return curve25519FieldElement2.Curve25519.this.createRawPoint(new Curve25519FieldElement(nArray3), curve25519FieldElement2, CURVE25519_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 8; ++i4) {
                        int[] nArray3 = nArray;
                        nArray4[i4] = nArray4[i4] ^ nArray[n42 + i4] & n5;
                        nArray2[i4] = nArray2[i4] ^ nArray3[n42 + 8 + i4] & n5;
                    }
                    n42 += 16;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n42 = n3 * 8 * 2;
                for (int i3 = 0; i3 < 8; ++i3) {
                    int[] nArray3 = nArray;
                    nArray4[i3] = nArray3[n42 + i3];
                    nArray2[i3] = nArray[n42 + 8 + i3];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        Curve25519Field.random(secureRandom, nArray);
        return new Curve25519FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        Curve25519Field.randomMult(secureRandom, nArray);
        return new Curve25519FieldElement((int[])object);
    }
}

