/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.djb;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class Curve25519Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{-19, -1, -1, -1, -1, -1, -1, Integer.MAX_VALUE};
    private static final int P7 = Integer.MAX_VALUE;
    private static final int[] PExt = new int[]{361, 0, 0, 0, 0, 0, 0, 0, -19, -1, -1, -1, -1, -1, -1, 0x3FFFFFFF};
    private static final int PInv = 19;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat256.add(nArray, nArray2, nArray3);
        if (Nat256.gte(nArray3, P)) {
            Curve25519Field.subPFrom(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat.add(16, nArray, nArray2, nArray3);
        nArray = PExt;
        if (Nat.gte(16, nArray3, nArray)) {
            Curve25519Field.subPExtFrom(nArray3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        Nat.inc(8, nArray, nArray2);
        if (Nat256.gte(nArray2, P)) {
            Curve25519Field.subPFrom(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        object = Nat256.fromBigInteger((BigInteger)object);
        while (true) {
            int[] nArray = P;
            if (!Nat256.gte((int[])object, P)) break;
            Nat256.subFrom(nArray, (int[])object);
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(8, nArray, 0, nArray2);
        } else {
            Nat256.add(nArray, P, nArray2);
            Nat.shiftDownBit(8, nArray2, 0);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 8; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat256.createExt();
        Nat256.mul(nArray, nArray2, nArray4);
        Curve25519Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        Nat256.mulAddTo(nArray, nArray2, nArray3);
        nArray = PExt;
        if (Nat.gte(16, nArray3, nArray)) {
            Curve25519Field.subPExtFrom(nArray3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (Curve25519Field.isZero(nArray) != 0) {
            Nat256.sub(P, P, nArray2);
        } else {
            Nat256.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[32];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 8);
            nArray[7] = nArray[7] & Integer.MAX_VALUE;
        } while (Nat.lessThan(8, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            Curve25519Field.random(secureRandom, nArray);
        } while (Curve25519Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int[] nArray3 = nArray2;
        int n3 = nArray[7];
        Nat.shiftUpBit(8, nArray, 8, n3, nArray2, 0);
        int n4 = Nat256.mulByWordAddTo(19, nArray, nArray2) << 1;
        int n5 = nArray3[7];
        int n6 = (n5 >>> 31) - (n3 >>> 31) + n4;
        n4 = n5 & Integer.MAX_VALUE;
        nArray3[7] = Nat.addWordTo(7, n6 * 19, nArray2) + n4;
        if (Nat256.gte(nArray2, P)) {
            Curve25519Field.subPFrom(nArray2);
        }
    }

    public static void reduce27(int n3, int[] nArray) {
        int n4 = n3;
        n3 = nArray[7];
        nArray[7] = Nat.addWordTo(7, (n4 << 1 | n3 >>> 31) * 19, nArray) + (n3 &= Integer.MAX_VALUE);
        if (Nat256.gte(nArray, P)) {
            Curve25519Field.subPFrom(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        Curve25519Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        Curve25519Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            Nat256.square(nArray2, nArray3);
            Curve25519Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.sub(nArray, nArray2, nArray3) != 0) {
            Curve25519Field.addPTo(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(16, nArray, nArray2, nArray3) != 0) {
            Curve25519Field.addPExtTo(nArray3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        Nat.shiftUpBit(8, nArray, 0, nArray2);
        if (Nat256.gte(nArray2, P)) {
            Curve25519Field.subPFrom(nArray2);
        }
    }

    private static int addPTo(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - 19L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            l3 = Nat.decAt(7, nArray, 1);
        }
        l3 = ((long)nArray[7] & 0xFFFFFFFFL) + 0x80000000L + l3;
        nArray[7] = (int)l3;
        return (int)(l3 >> 32);
    }

    private static int addPExtTo(int[] nArray) {
        int[] nArray2 = PExt;
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + ((long)PExt[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            l3 = Nat.incAt(8, nArray, 1);
        }
        l3 = ((long)nArray[8] & 0xFFFFFFFFL) - 19L + l3;
        nArray[8] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            l3 = Nat.decAt(15, nArray, 9);
        }
        long l4 = ((long)nArray[15] & 0xFFFFFFFFL) + ((long)(nArray2[15] + 1) & 0xFFFFFFFFL) + l3;
        nArray[15] = (int)l4;
        return (int)(l4 >> 32);
    }

    private static int subPFrom(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + 19L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            l3 = Nat.incAt(7, nArray, 1);
        }
        l3 = ((long)nArray[7] & 0xFFFFFFFFL) - 0x80000000L + l3;
        nArray[7] = (int)l3;
        return (int)(l3 >> 32);
    }

    private static int subPExtFrom(int[] nArray) {
        int[] nArray2 = PExt;
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - ((long)PExt[0] & 0xFFFFFFFFL);
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            l3 = Nat.decAt(8, nArray, 1);
        }
        l3 = ((long)nArray[8] & 0xFFFFFFFFL) + 19L + l3;
        nArray[8] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            l3 = Nat.incAt(15, nArray, 9);
        }
        long l4 = ((long)nArray[15] & 0xFFFFFFFFL) - ((long)(nArray2[15] + 1) & 0xFFFFFFFFL) + l3;
        nArray[15] = (int)l4;
        return (int)(l4 >> 32);
    }
}

