/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm.SM2P256V1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm.SM2P256V1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm.SM2P256V1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2P256V1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SM2P256V1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SM2P256V1_AFFINE_ZS;
    public SM2P256V1Point infinity;

    public SM2P256V1Curve() {
        SM2P256V1Curve sM2P256V1Curve = this;
        super(q);
        sM2P256V1Curve.infinity = new SM2P256V1Point(this, null, null);
        sM2P256V1Curve.a = sM2P256V1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC")));
        sM2P256V1Curve.b = sM2P256V1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93")));
        sM2P256V1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123"));
        sM2P256V1Curve.cofactor = BigInteger.valueOf(1L);
        sM2P256V1Curve.coord = 2;
    }

    static {
        SM2P256V1FieldElement sM2P256V1FieldElement;
        q = SM2P256V1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SM2P256V1FieldElement sM2P256V1FieldElement2 = sM2P256V1FieldElement;
        sM2P256V1FieldElement = new SM2P256V1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = sM2P256V1FieldElement2;
        SM2P256V1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SM2P256V1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SM2P256V1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SM2P256V1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SM2P256V1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final int[] nArray = new int[n4 * 8 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat256.copy(((SM2P256V1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 8);
            n5 += 8;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SM2P256V1FieldElement sM2P256V1FieldElement;
                SM2P256V1FieldElement sM2P256V1FieldElement2 = sM2P256V1FieldElement;
                sM2P256V1FieldElement = new SM2P256V1FieldElement(nArray2);
                return sM2P256V1FieldElement2.SM2P256V1Curve.this.createRawPoint(new SM2P256V1FieldElement(nArray3), sM2P256V1FieldElement2, SM2P256V1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 8; ++i4) {
                        int[] nArray3 = nArray;
                        nArray4[i4] = nArray4[i4] ^ nArray[n42 + i4] & n5;
                        nArray2[i4] = nArray2[i4] ^ nArray3[n42 + 8 + i4] & n5;
                    }
                    n42 += 16;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n42 = n3 * 8 * 2;
                for (int i3 = 0; i3 < 8; ++i3) {
                    int[] nArray3 = nArray;
                    nArray4[i3] = nArray3[n42 + i3];
                    nArray2[i3] = nArray[n42 + 8 + i3];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SM2P256V1Field.random(secureRandom, nArray);
        return new SM2P256V1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SM2P256V1Field.randomMult(secureRandom, nArray);
        return new SM2P256V1FieldElement((int[])object);
    }
}

