/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.gm;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2P256V1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{-1, -1, 0, -1, -1, -1, -1, -2};
    private static final int[] PExt = new int[]{1, 0, -2, 1, 1, -2, 0, 2, -2, -3, 3, -2, -1, -1, 0, -2};
    private static final int P7s1 = Integer.MAX_VALUE;
    private static final int PExt15s1 = Integer.MAX_VALUE;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.add(nArray, nArray2, nArray3) != 0 || nArray3[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(nArray3, P)) {
            SM2P256V1Field.addPInvTo(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.add(16, nArray, nArray2, nArray3) != 0 || nArray3[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, nArray3, nArray = PExt)) {
            Nat.subFrom(16, PExt, nArray3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(8, nArray, nArray2) != 0 || nArray2[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(nArray2, P)) {
            SM2P256V1Field.addPInvTo(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat256.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[7] >>> 1 >= Integer.MAX_VALUE) {
            int[] nArray2 = P;
            if (Nat256.gte((int[])object, P)) {
                Nat256.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(8, nArray, 0, nArray2);
        } else {
            int n3 = Nat256.add(nArray, P, nArray2);
            Nat.shiftDownBit(8, nArray2, n3);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 8; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat256.createExt();
        Nat256.mul(nArray, nArray2, nArray4);
        SM2P256V1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, nArray3, nArray = PExt)) {
            Nat.subFrom(16, PExt, nArray3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SM2P256V1Field.isZero(nArray) != 0) {
            Nat256.sub(P, P, nArray2);
        } else {
            Nat256.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[32];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 8);
        } while (Nat.lessThan(8, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SM2P256V1Field.random(secureRandom, nArray);
        } while (SM2P256V1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l3 = (long)nArray[8] & 0xFFFFFFFFL;
        long l4 = (long)nArray[9] & 0xFFFFFFFFL;
        long l5 = (long)nArray[10] & 0xFFFFFFFFL;
        long l6 = (long)nArray[11] & 0xFFFFFFFFL;
        long l7 = (long)nArray[12] & 0xFFFFFFFFL;
        long l8 = (long)nArray[13] & 0xFFFFFFFFL;
        long l9 = (long)nArray[14] & 0xFFFFFFFFL;
        long l10 = (long)nArray[15] & 0xFFFFFFFFL;
        long l11 = l3 + l4;
        long l12 = l5 + l6;
        long l13 = l11;
        l11 = l7 + l10;
        long l14 = l8 + l9;
        long l15 = l14 + (l10 << 1);
        long l16 = l13 + l14;
        l11 = l12 + l11 + l16;
        long l17 = ((long)nArray[0] & 0xFFFFFFFFL) + l11 + l8 + l9 + l10 + 0L;
        nArray2[0] = (int)l17;
        l17 >>= 32;
        l17 = ((long)nArray[1] & 0xFFFFFFFFL) + l11 - l3 + l9 + l10 + l17;
        nArray2[1] = (int)l17;
        l16 = ((long)nArray[2] & 0xFFFFFFFFL) - l16 + (l17 >>= 32);
        nArray2[2] = (int)l16;
        l4 = ((long)nArray[3] & 0xFFFFFFFFL) + l11 - l4 - l5 + l8 + (l16 >>= 32);
        nArray2[3] = (int)l4;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + l11 - l12 - l3 + l9 + (l4 >>= 32);
        nArray2[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + l15 + l5 + l3;
        nArray2[5] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + l6 + l9 + l10 + l3;
        nArray2[6] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[7] & 0xFFFFFFFFL) + l11 + l15 + l7 + l3;
        nArray2[7] = (int)l3;
        SM2P256V1Field.reduce32((int)(l3 >> 32), nArray2);
    }

    public static void reduce32(int n3, int[] nArray) {
        long l3 = 0L;
        if (n3 != 0) {
            long l4 = (long)n3 & 0xFFFFFFFFL;
            l3 = ((long)nArray[0] & 0xFFFFFFFFL) + l4 + l3;
            nArray[0] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
                l3 >>= 32;
            }
            l3 = ((long)nArray[2] & 0xFFFFFFFFL) - l4 + l3;
            nArray[2] = (int)l3;
            l3 >>= 32;
            l3 = ((long)nArray[3] & 0xFFFFFFFFL) + l4 + l3;
            nArray[3] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                nArray[4] = (int)(l3 += (long)nArray[4] & 0xFFFFFFFFL);
                l3 = (l3 >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
                nArray[5] = (int)l3;
                l3 = (l3 >> 32) + ((long)nArray[6] & 0xFFFFFFFFL);
                nArray[6] = (int)l3;
                l3 >>= 32;
            }
            l3 = ((long)nArray[7] & 0xFFFFFFFFL) + l4 + l3;
            nArray[7] = (int)l3;
            l3 >>= 32;
        }
        if (l3 != 0L || nArray[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(nArray, P)) {
            SM2P256V1Field.addPInvTo(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SM2P256V1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SM2P256V1Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            Nat256.square(nArray2, nArray3);
            SM2P256V1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.sub(nArray, nArray2, nArray3) != 0) {
            SM2P256V1Field.subPInvFrom(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(16, nArray, nArray2, nArray3) != 0) {
            Nat.addTo(16, PExt, nArray3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(8, nArray, 0, nArray2) != 0 || nArray2[7] >>> 1 >= Integer.MAX_VALUE && Nat256.gte(nArray2, P)) {
            SM2P256V1Field.addPInvTo(nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 >>= 32;
        }
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) - 1L + l3;
        nArray[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + 1L + l3;
        nArray[3] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[4] = (int)(l3 += (long)nArray[4] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
            nArray[5] = (int)l3;
            l3 = (l3 >> 32) + ((long)nArray[6] & 0xFFFFFFFFL);
            nArray[6] = (int)l3;
            l3 >>= 32;
        }
        nArray[7] = (int)(((long)nArray[7] & 0xFFFFFFFFL) + 1L + l3);
    }

    private static void subPInvFrom(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 >>= 32;
        }
        l3 = ((long)nArray[2] & 0xFFFFFFFFL) + 1L + l3;
        nArray[2] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) - 1L + l3;
        nArray[3] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[4] = (int)(l3 += (long)nArray[4] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
            nArray[5] = (int)l3;
            l3 = (l3 >> 32) + ((long)nArray[6] & 0xFFFFFFFFL);
            nArray[6] = (int)l3;
            l3 >>= 32;
        }
        nArray[7] = (int)(((long)nArray[7] & 0xFFFFFFFFL) - 1L + l3);
    }
}

