/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP128R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP128R1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP128R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat128;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP128R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP128R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP128R1_AFFINE_ZS;
    public SecP128R1Point infinity;

    public SecP128R1Curve() {
        SecP128R1Curve secP128R1Curve = this;
        super(q);
        secP128R1Curve.infinity = new SecP128R1Point(this, null, null);
        secP128R1Curve.a = secP128R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFDFFFFFFFFFFFFFFFFFFFFFFFC")));
        secP128R1Curve.b = secP128R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("E87579C11079F43DD824993C2CEE5ED3")));
        secP128R1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFE0000000075A30D1B9038A115"));
        secP128R1Curve.cofactor = BigInteger.valueOf(1L);
        secP128R1Curve.coord = 2;
    }

    static {
        SecP128R1FieldElement secP128R1FieldElement;
        q = SecP128R1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP128R1FieldElement secP128R1FieldElement2 = secP128R1FieldElement;
        secP128R1FieldElement = new SecP128R1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP128R1FieldElement2;
        SECP128R1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP128R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP128R1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP128R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP128R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final int[] nArray = new int[n4 * 4 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat128.copy(((SecP128R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 4);
            n5 += 4;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP128R1FieldElement secP128R1FieldElement;
                SecP128R1FieldElement secP128R1FieldElement2 = secP128R1FieldElement;
                secP128R1FieldElement = new SecP128R1FieldElement(nArray2);
                return secP128R1FieldElement2.SecP128R1Curve.this.createRawPoint(new SecP128R1FieldElement(nArray3), secP128R1FieldElement2, SECP128R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                int[] nArray4 = Nat128.create();
                int[] nArray2 = Nat128.create();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 4; ++i4) {
                        int[] nArray3 = nArray;
                        nArray4[i4] = nArray4[i4] ^ nArray[n42 + i4] & n5;
                        nArray2[i4] = nArray2[i4] ^ nArray3[n42 + 4 + i4] & n5;
                    }
                    n42 += 8;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                int[] nArray4 = Nat128.create();
                int[] nArray2 = Nat128.create();
                int n42 = n3 * 4 * 2;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int[] nArray3 = nArray;
                    nArray4[i3] = nArray3[n42 + i3];
                    nArray2[i3] = nArray[n42 + 4 + i3];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat128.create();
        Object object = nArray;
        SecP128R1Field.random(secureRandom, nArray);
        return new SecP128R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat128.create();
        Object object = nArray;
        SecP128R1Field.randomMult(secureRandom, nArray);
        return new SecP128R1FieldElement((int[])object);
    }
}

