/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat128;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP128R1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{-1, -1, -1, -3};
    private static final int[] PExt = new int[]{1, 0, 0, 4, -2, -1, 3, -4};
    private static final int[] PExtInv = new int[]{-1, -1, -1, -5, 1, 0, -4, 3};
    private static final int P3s1 = 0x7FFFFFFE;
    private static final int PExt7s1 = 0x7FFFFFFE;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat128.add(nArray, nArray2, nArray3) != 0 || nArray3[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(nArray3, P)) {
            SecP128R1Field.addPInvTo(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.add(nArray, nArray2, nArray3) != 0 || nArray3[7] >>> 1 >= 0x7FFFFFFE && Nat256.gte(nArray3, PExt)) {
            nArray = PExtInv;
            Nat.addTo(PExtInv.length, nArray, nArray3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(4, nArray, nArray2) != 0 || nArray2[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(nArray2, P)) {
            SecP128R1Field.addPInvTo(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat128.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[3] >>> 1 >= 0x7FFFFFFE) {
            int[] nArray2 = P;
            if (Nat128.gte((int[])object, P)) {
                Nat128.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(4, nArray, 0, nArray2);
        } else {
            int n3 = Nat128.add(nArray, P, nArray2);
            Nat.shiftDownBit(4, nArray2, n3);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat128.createExt();
        Nat128.mul(nArray, nArray2, nArray4);
        SecP128R1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat128.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[7] >>> 1 >= 0x7FFFFFFE && Nat256.gte(nArray3, PExt)) {
            nArray = PExtInv;
            Nat.addTo(PExtInv.length, nArray, nArray3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP128R1Field.isZero(nArray) != 0) {
            Nat128.sub(P, P, nArray2);
        } else {
            Nat128.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[16];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 4);
        } while (Nat.lessThan(4, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP128R1Field.random(secureRandom, nArray);
        } while (SecP128R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l3 = (long)nArray[0] & 0xFFFFFFFFL;
        long l4 = (long)nArray[1] & 0xFFFFFFFFL;
        long l5 = (long)nArray[2] & 0xFFFFFFFFL;
        long l6 = (long)nArray[4] & 0xFFFFFFFFL;
        long l7 = (long)nArray[5] & 0xFFFFFFFFL;
        long l8 = (long)nArray[6] & 0xFFFFFFFFL;
        long l9 = (long)nArray[7] & 0xFFFFFFFFL;
        long l10 = l6;
        l6 = l8 + (l9 << 1);
        l5 += l6;
        l6 = l7 + (l6 << 1);
        l4 += l6;
        l6 = l10 + (l6 << 1);
        nArray2[0] = (int)(l3 += l6);
        l3 = l4 + (l3 >>> 32);
        nArray2[1] = (int)l3;
        l3 = l5 + (l3 >>> 32);
        nArray2[2] = (int)l3;
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + l9 + (l6 << 1) + (l3 >>> 32);
        nArray2[3] = (int)l3;
        SecP128R1Field.reduce32((int)(l3 >>> 32), nArray2);
    }

    public static void reduce32(int n3, int[] nArray) {
        while (n3 != 0) {
            long l3 = (long)n3 & 0xFFFFFFFFL;
            long l4 = ((long)nArray[0] & 0xFFFFFFFFL) + l3;
            nArray[0] = (int)l4;
            if ((l4 >>= 32) != 0L) {
                nArray[1] = (int)(l4 += (long)nArray[1] & 0xFFFFFFFFL);
                l4 = (l4 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
                nArray[2] = (int)l4;
                l4 >>= 32;
            }
            l3 = ((long)nArray[3] & 0xFFFFFFFFL) + (l3 << 1) + l4;
            nArray[3] = (int)l3;
            n3 = (int)(l3 >> 32);
        }
        if (nArray[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(nArray, P)) {
            SecP128R1Field.addPInvTo(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat128.createExt();
        Nat128.square(nArray, nArray3);
        SecP128R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat128.createExt();
        Nat128.square(nArray, nArray3);
        SecP128R1Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            Nat128.square(nArray2, nArray3);
            SecP128R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat128.sub(nArray, nArray2, nArray3) != 0) {
            SecP128R1Field.subPInvFrom(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(10, nArray, nArray2, nArray3) != 0) {
            nArray = PExtInv;
            Nat.subFrom(PExtInv.length, nArray, nArray3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(4, nArray, 0, nArray2) != 0 || nArray2[3] >>> 1 >= 0x7FFFFFFE && Nat128.gte(nArray2, P)) {
            SecP128R1Field.addPInvTo(nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l3;
            l3 >>= 32;
        }
        nArray[3] = (int)(((long)nArray[3] & 0xFFFFFFFFL) + 2L + l3);
    }

    private static void subPInvFrom(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l3;
            l3 >>= 32;
        }
        nArray[3] = (int)(((long)nArray[3] & 0xFFFFFFFFL) - 2L + l3);
    }
}

