/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160R2Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP160R2FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat160;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP160K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP160K1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP160K1_AFFINE_ZS;
    public SecP160K1Point infinity;

    public SecP160K1Curve() {
        SecP160K1Curve secP160K1Curve = this;
        super(q);
        secP160K1Curve.infinity = new SecP160K1Point(this, null, null);
        secP160K1Curve.a = secP160K1Curve.fromBigInteger(ECConstants.ZERO);
        secP160K1Curve.b = secP160K1Curve.fromBigInteger(BigInteger.valueOf(7L));
        secP160K1Curve.order = new BigInteger(1, Hex.decodeStrict("0100000000000000000001B8FA16DFAB9ACA16B6B3"));
        secP160K1Curve.cofactor = BigInteger.valueOf(1L);
        secP160K1Curve.coord = 2;
    }

    static {
        SecP160R2FieldElement secP160R2FieldElement;
        q = SecP160R2FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP160R2FieldElement secP160R2FieldElement2 = secP160R2FieldElement;
        secP160R2FieldElement = new SecP160R2FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP160R2FieldElement2;
        SECP160K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP160K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP160R2FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP160K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP160K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final int[] nArray = new int[n4 * 5 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat160.copy(((SecP160R2FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 5);
            n5 += 5;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP160R2FieldElement secP160R2FieldElement;
                SecP160R2FieldElement secP160R2FieldElement2 = secP160R2FieldElement;
                secP160R2FieldElement = new SecP160R2FieldElement(nArray2);
                return secP160R2FieldElement2.SecP160K1Curve.this.createRawPoint(new SecP160R2FieldElement(nArray3), secP160R2FieldElement2, SECP160K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                int[] nArray4 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 5; ++i4) {
                        int[] nArray3 = nArray;
                        nArray4[i4] = nArray4[i4] ^ nArray[n42 + i4] & n5;
                        nArray2[i4] = nArray2[i4] ^ nArray3[n42 + 5 + i4] & n5;
                    }
                    n42 += 10;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                int[] nArray4 = Nat160.create();
                int[] nArray2 = Nat160.create();
                int n42 = n3 * 5 * 2;
                for (int i3 = 0; i3 < 5; ++i3) {
                    int[] nArray3 = nArray;
                    nArray4[i3] = nArray3[n42 + i3];
                    nArray2[i3] = nArray[n42 + 5 + i3];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        Object object = nArray;
        SecP160R2Field.random(secureRandom, nArray);
        return new SecP160R2FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat160.create();
        Object object = nArray;
        SecP160R2Field.randomMult(secureRandom, nArray);
        return new SecP160R2FieldElement((int[])object);
    }
}

