/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat160;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP160R2Field {
    public static final int[] P = new int[]{-21389, -2, -1, -1, -1};
    private static final int[] PExt = new int[]{457489321, 42778, 1, 0, 0, -42778, -3, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-457489321, -42779, -2, -1, -1, 42777, 2};
    private static final int P4 = -1;
    private static final int PExt9 = -1;
    private static final int PInv33 = 21389;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat160.add(nArray, nArray2, nArray3) != 0 || nArray3[4] == -1 && Nat160.gte(nArray3, P)) {
            Nat.add33To(5, 21389, nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(10, nArray, nArray2, nArray3) != 0 || nArray3[9] == -1 && Nat.gte(10, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.incAt(10, nArray3, n3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(5, nArray, nArray2) != 0 || nArray2[4] == -1 && Nat160.gte(nArray2, P)) {
            Nat.add33To(5, 21389, nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat160.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[4] == -1) {
            int[] nArray2 = P;
            if (Nat160.gte((int[])object, P)) {
                Nat160.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(5, nArray, 0, nArray2);
        } else {
            int n3 = Nat160.add(nArray, P, nArray2);
            Nat.shiftDownBit(5, nArray2, n3);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 5; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat160.createExt();
        Nat160.mul(nArray, nArray2, nArray4);
        SecP160R2Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat160.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[9] == -1 && Nat.gte(10, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.incAt(10, nArray3, n3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP160R2Field.isZero(nArray) != 0) {
            Nat160.sub(P, P, nArray2);
        } else {
            Nat160.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[20];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 5);
        } while (Nat.lessThan(5, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP160R2Field.random(secureRandom, nArray);
        } while (SecP160R2Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l3 = Nat160.mul33Add(21389, nArray, 5, nArray, 0, nArray2, 0);
        if (Nat160.mul33DWordAdd(21389, l3, nArray2, 0) != 0 || nArray2[4] == -1 && Nat160.gte(nArray2, P)) {
            Nat.add33To(5, 21389, nArray2);
        }
    }

    public static void reduce32(int n3, int[] nArray) {
        if (n3 != 0 && Nat160.mul33WordAdd(21389, n3, nArray, 0) != 0 || nArray[4] == -1 && Nat160.gte(nArray, P)) {
            Nat.add33To(5, 21389, nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat160.createExt();
        Nat160.square(nArray, nArray3);
        SecP160R2Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat160.createExt();
        Nat160.square(nArray, nArray3);
        SecP160R2Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            Nat160.square(nArray2, nArray3);
            SecP160R2Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat160.sub(nArray, nArray2, nArray3) != 0) {
            Nat.sub33From(5, 21389, nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(10, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.decAt(10, nArray3, n3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(5, nArray, 0, nArray2) != 0 || nArray2[4] == -1 && Nat160.gte(nArray2, P)) {
            Nat.add33To(5, 21389, nArray2);
        }
    }
}

