/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP192K1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP192K1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP192K1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat192;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP192K1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP192K1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP192K1_AFFINE_ZS;
    public SecP192K1Point infinity;

    public SecP192K1Curve() {
        SecP192K1Curve secP192K1Curve = this;
        super(q);
        secP192K1Curve.infinity = new SecP192K1Point(this, null, null);
        secP192K1Curve.a = secP192K1Curve.fromBigInteger(ECConstants.ZERO);
        secP192K1Curve.b = secP192K1Curve.fromBigInteger(BigInteger.valueOf(3L));
        secP192K1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFE26F2FC170F69466A74DEFD8D"));
        secP192K1Curve.cofactor = BigInteger.valueOf(1L);
        secP192K1Curve.coord = 2;
    }

    static {
        SecP192K1FieldElement secP192K1FieldElement;
        q = SecP192K1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP192K1FieldElement secP192K1FieldElement2 = secP192K1FieldElement;
        secP192K1FieldElement = new SecP192K1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP192K1FieldElement2;
        SECP192K1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP192K1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP192K1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP192K1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP192K1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final int[] nArray = new int[n4 * 6 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat192.copy(((SecP192K1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat192.copy(((SecP192K1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 6);
            n5 += 6;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP192K1FieldElement secP192K1FieldElement;
                SecP192K1FieldElement secP192K1FieldElement2 = secP192K1FieldElement;
                secP192K1FieldElement = new SecP192K1FieldElement(nArray2);
                return secP192K1FieldElement2.SecP192K1Curve.this.createRawPoint(new SecP192K1FieldElement(nArray3), secP192K1FieldElement2, SECP192K1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                int[] nArray4 = Nat192.create();
                int[] nArray2 = Nat192.create();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 6; ++i4) {
                        int[] nArray3 = nArray;
                        nArray4[i4] = nArray4[i4] ^ nArray[n42 + i4] & n5;
                        nArray2[i4] = nArray2[i4] ^ nArray3[n42 + 6 + i4] & n5;
                    }
                    n42 += 12;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                int[] nArray4 = Nat192.create();
                int[] nArray2 = Nat192.create();
                int n42 = n3 * 6 * 2;
                for (int i3 = 0; i3 < 6; ++i3) {
                    int[] nArray3 = nArray;
                    nArray4[i3] = nArray3[n42 + i3];
                    nArray2[i3] = nArray[n42 + 6 + i3];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat192.create();
        Object object = nArray;
        SecP192K1Field.random(secureRandom, nArray);
        return new SecP192K1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat192.create();
        Object object = nArray;
        SecP192K1Field.randomMult(secureRandom, nArray);
        return new SecP192K1FieldElement((int[])object);
    }
}

