/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat224;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP224R1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{1, 0, 0, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{1, 0, 0, -2, -1, -1, 0, 2, 0, 0, -2, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-1, -1, -1, 1, 0, 0, -1, -3, -1, -1, 1};
    private static final int P6 = -1;
    private static final int PExt13 = -1;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat224.add(nArray, nArray2, nArray3) != 0 || nArray3[6] == -1 && Nat224.gte(nArray3, P)) {
            SecP224R1Field.addPInvTo(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(14, nArray, nArray2, nArray3) != 0 || nArray3[13] == -1 && Nat.gte(14, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.incAt(14, nArray3, n3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(7, nArray, nArray2) != 0 || nArray2[6] == -1 && Nat224.gte(nArray2, P)) {
            SecP224R1Field.addPInvTo(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat224.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[6] == -1) {
            int[] nArray2 = P;
            if (Nat224.gte((int[])object, P)) {
                Nat224.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(7, nArray, 0, nArray2);
        } else {
            int n3 = Nat224.add(nArray, P, nArray2);
            Nat.shiftDownBit(7, nArray2, n3);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 7; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat224.createExt();
        Nat224.mul(nArray, nArray2, nArray4);
        SecP224R1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat224.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[13] == -1 && Nat.gte(14, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.incAt(14, nArray3, n3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP224R1Field.isZero(nArray) != 0) {
            Nat224.sub(P, P, nArray2);
        } else {
            Nat224.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[28];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 7);
        } while (Nat.lessThan(7, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP224R1Field.random(secureRandom, nArray);
        } while (SecP224R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        int n3;
        int n4;
        long l3 = (long)nArray[10] & 0xFFFFFFFFL;
        long l4 = (long)nArray[11] & 0xFFFFFFFFL;
        long l5 = (long)nArray[12] & 0xFFFFFFFFL;
        long l6 = (long)nArray[13] & 0xFFFFFFFFL;
        long l7 = ((long)nArray[7] & 0xFFFFFFFFL) + l4 - 1L;
        long l8 = ((long)nArray[8] & 0xFFFFFFFFL) + l5;
        long l9 = ((long)nArray[9] & 0xFFFFFFFFL) + l6;
        long l10 = ((long)nArray[0] & 0xFFFFFFFFL) - l7 + 0L;
        long l11 = l10;
        l11 >>= 32;
        l11 = ((long)nArray[1] & 0xFFFFFFFFL) - l8 + l11;
        nArray2[1] = n4 = (int)l11;
        long l12 = l11 >> 32;
        l12 = ((long)nArray[2] & 0xFFFFFFFFL) - l9 + l12;
        nArray2[2] = n3 = (int)l12;
        long l13 = l12 >> 32;
        long l14 = ((long)nArray[3] & 0xFFFFFFFFL) + l7 - l3 + l13;
        l7 = l14;
        l4 = ((long)nArray[4] & 0xFFFFFFFFL) + l8 - l4 + (l7 >>= 32);
        nArray2[4] = (int)l4;
        l4 >>= 32;
        l4 = ((long)nArray[5] & 0xFFFFFFFFL) + l9 - l5 + l4;
        nArray2[5] = (int)l4;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + l3 - l6 + (l4 >>= 32);
        nArray2[6] = (int)l3;
        l3 = (l3 >> 32) + 1L;
        l4 = (l14 & 0xFFFFFFFFL) + l3;
        l3 = (l10 & 0xFFFFFFFFL) - l3;
        nArray2[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray2[1] = (int)(l3 += (long)n4 & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)n3 & 0xFFFFFFFFL);
            nArray2[2] = (int)l3;
            l4 += l3 >> 32;
        }
        nArray2[3] = (int)l4;
        if (l4 >> 32 != 0L && Nat.incAt(7, nArray2, 4) != 0 || nArray2[6] == -1 && Nat224.gte(nArray2, P)) {
            SecP224R1Field.addPInvTo(nArray2);
        }
    }

    public static void reduce32(int n3, int[] nArray) {
        long l3 = 0L;
        if (n3 != 0) {
            long l4 = (long)n3 & 0xFFFFFFFFL;
            l3 = ((long)nArray[0] & 0xFFFFFFFFL) - l4 + l3;
            nArray[0] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
                l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
                nArray[2] = (int)l3;
                l3 >>= 32;
            }
            l3 = ((long)nArray[3] & 0xFFFFFFFFL) + l4 + l3;
            nArray[3] = (int)l3;
            l3 >>= 32;
        }
        if (l3 != 0L && Nat.incAt(7, nArray, 4) != 0 || nArray[6] == -1 && Nat224.gte(nArray, P)) {
            SecP224R1Field.addPInvTo(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat224.createExt();
        Nat224.square(nArray, nArray3);
        SecP224R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat224.createExt();
        Nat224.square(nArray, nArray3);
        SecP224R1Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            Nat224.square(nArray2, nArray3);
            SecP224R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat224.sub(nArray, nArray2, nArray3) != 0) {
            SecP224R1Field.subPInvFrom(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(14, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.decAt(14, nArray3, n3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(7, nArray, 0, nArray2) != 0 || nArray2[6] == -1 && Nat224.gte(nArray2, P)) {
            SecP224R1Field.addPInvTo(nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l3;
            l3 >>= 32;
        }
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + 1L + l3;
        nArray[3] = (int)l3;
        if (l3 >> 32 != 0L) {
            Nat.incAt(7, nArray, 4);
        }
    }

    private static void subPInvFrom(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l3;
            l3 >>= 32;
        }
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) - 1L + l3;
        nArray[3] = (int)l3;
        if (l3 >> 32 != 0L) {
            Nat.decAt(7, nArray, 4);
        }
    }
}

