/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP224R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat224;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Arrays;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;

public class SecP224R1FieldElement
extends ECFieldElement.AbstractFp {
    public static final BigInteger Q = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF000000000000000000000001"));
    public int[] x;

    public SecP224R1FieldElement(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() >= 0 && bigInteger.compareTo(Q) < 0) {
            this.x = SecP224R1Field.fromBigInteger(bigInteger);
            return;
        }
        throw new IllegalArgumentException("x value invalid for SecP224R1FieldElement");
    }

    public SecP224R1FieldElement() {
        this.x = Nat224.create();
    }

    public SecP224R1FieldElement(int[] nArray) {
        this.x = nArray;
    }

    private static boolean isSquare(int[] nArray) {
        int[] nArray2 = nArray;
        nArray = Nat224.create();
        int[] nArray3 = Nat224.create();
        Nat224.copy(nArray2, nArray);
        for (int i3 = 0; i3 < 7; ++i3) {
            Nat224.copy(nArray, nArray3);
            SecP224R1Field.squareN(nArray, 1 << i3, nArray);
            SecP224R1Field.multiply(nArray, nArray3, nArray);
        }
        SecP224R1Field.squareN(nArray, 95, nArray);
        return Nat224.isOne(nArray);
    }

    private static void RM(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7) {
        int[] nArray8 = nArray5;
        SecP224R1Field.multiply(nArray5, nArray3, nArray7);
        SecP224R1Field.multiply(nArray7, nArray, nArray7);
        SecP224R1Field.multiply(nArray4, nArray2, nArray6);
        SecP224R1Field.add(nArray6, nArray7, nArray6);
        SecP224R1Field.multiply(nArray4, nArray3, nArray7);
        Nat224.copy(nArray6, nArray4);
        SecP224R1Field.multiply(nArray8, nArray2, nArray5);
        SecP224R1Field.add(nArray8, nArray7, nArray5);
        SecP224R1Field.square(nArray5, nArray6);
        SecP224R1Field.multiply(nArray6, nArray, nArray6);
    }

    private static void RP(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5) {
        Nat224.copy(nArray, nArray4);
        int[] nArray6 = Nat224.create();
        int[] nArray7 = Nat224.create();
        for (int i3 = 0; i3 < 7; ++i3) {
            Nat224.copy(nArray2, nArray6);
            Nat224.copy(nArray3, nArray7);
            int n3 = 1 << i3;
            while ((n3 += -1) >= 0) {
                SecP224R1FieldElement.RS(nArray2, nArray3, nArray4, nArray5);
            }
            SecP224R1FieldElement.RM(nArray, nArray6, nArray7, nArray2, nArray3, nArray4, nArray5);
        }
    }

    private static void RS(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int[] nArray5 = nArray2;
        SecP224R1Field.multiply(nArray5, nArray, nArray2);
        SecP224R1Field.twice(nArray2, nArray5);
        SecP224R1Field.square(nArray, nArray4);
        SecP224R1Field.add(nArray3, nArray4, nArray);
        SecP224R1Field.multiply(nArray3, nArray4, nArray3);
        SecP224R1Field.reduce32(Nat.shiftUpBits(7, nArray3, 2, 0), nArray3);
    }

    private static boolean trySqrt(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = nArray;
        nArray = Nat224.create();
        Nat224.copy(nArray2, nArray);
        int[] nArray5 = Nat224.create();
        nArray2 = nArray5;
        nArray5[0] = 1;
        int[] nArray6 = Nat224.create();
        SecP224R1FieldElement.RP(nArray4, nArray, nArray2, nArray6, nArray3);
        int[] nArray7 = Nat224.create();
        int[] nArray8 = Nat224.create();
        for (int i3 = 1; i3 < 96; ++i3) {
            Nat224.copy(nArray, nArray7);
            Nat224.copy(nArray2, nArray8);
            SecP224R1FieldElement.RS(nArray, nArray2, nArray6, nArray3);
            if (!Nat224.isZero(nArray)) continue;
            SecP224R1Field.inv(nArray8, nArray3);
            SecP224R1Field.multiply(nArray3, nArray7, nArray3);
            return true;
        }
        return false;
    }

    @Override
    public boolean isZero() {
        return Nat224.isZero(this.x);
    }

    @Override
    public boolean isOne() {
        return Nat224.isOne(this.x);
    }

    @Override
    public boolean testBitZero() {
        return Nat224.getBit(this.x, 0) == 1;
    }

    @Override
    public BigInteger toBigInteger() {
        return Nat224.toBigInteger(this.x);
    }

    @Override
    public String getFieldName() {
        return "SecP224R1Field";
    }

    @Override
    public int getFieldSize() {
        return Q.bitLength();
    }

    @Override
    public ECFieldElement add(ECFieldElement eCFieldElement) {
        SecP224R1FieldElement secP224R1FieldElement = object;
        Object object = Nat224.create();
        SecP224R1Field.add(secP224R1FieldElement.x, ((SecP224R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP224R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement addOne() {
        SecP224R1FieldElement secP224R1FieldElement = object;
        Object object = Nat224.create();
        SecP224R1Field.addOne(secP224R1FieldElement.x, (int[])object);
        return new SecP224R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement subtract(ECFieldElement eCFieldElement) {
        SecP224R1FieldElement secP224R1FieldElement = object;
        Object object = Nat224.create();
        SecP224R1Field.subtract(secP224R1FieldElement.x, ((SecP224R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP224R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement multiply(ECFieldElement eCFieldElement) {
        SecP224R1FieldElement secP224R1FieldElement = object;
        Object object = Nat224.create();
        SecP224R1Field.multiply(secP224R1FieldElement.x, ((SecP224R1FieldElement)eCFieldElement).x, (int[])object);
        return new SecP224R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement divide(ECFieldElement eCFieldElement) {
        int[] nArray = Nat224.create();
        SecP224R1Field.inv(((SecP224R1FieldElement)eCFieldElement).x, nArray);
        SecP224R1Field.multiply(nArray, this.x, nArray);
        return new SecP224R1FieldElement(nArray);
    }

    @Override
    public ECFieldElement negate() {
        SecP224R1FieldElement secP224R1FieldElement = object;
        Object object = Nat224.create();
        SecP224R1Field.negate(secP224R1FieldElement.x, (int[])object);
        return new SecP224R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement square() {
        SecP224R1FieldElement secP224R1FieldElement = object;
        Object object = Nat224.create();
        SecP224R1Field.square(secP224R1FieldElement.x, (int[])object);
        return new SecP224R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement invert() {
        SecP224R1FieldElement secP224R1FieldElement = object;
        Object object = Nat224.create();
        SecP224R1Field.inv(secP224R1FieldElement.x, (int[])object);
        return new SecP224R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement sqrt() {
        int[] nArray = ((SecP224R1FieldElement)object).x;
        if (!Nat224.isZero(((SecP224R1FieldElement)object).x) && !Nat224.isOne(nArray)) {
            int[] nArray2 = Nat224.create();
            Object object = nArray2;
            SecP224R1Field.negate(nArray, nArray2);
            int[] nArray3 = Mod.random(SecP224R1Field.P);
            int[] nArray4 = Nat224.create();
            if (!SecP224R1FieldElement.isSquare(nArray)) {
                return null;
            }
            while (!SecP224R1FieldElement.trySqrt((int[])object, nArray3, nArray4)) {
                SecP224R1Field.addOne(nArray3, nArray3);
            }
            SecP224R1Field.square(nArray4, nArray3);
            if (Nat224.eq(nArray, nArray3)) {
                SecP224R1FieldElement secP224R1FieldElement;
                object = secP224R1FieldElement;
                secP224R1FieldElement = new SecP224R1FieldElement(nArray4);
            } else {
                object = null;
            }
            return object;
        }
        return object;
    }

    public boolean equals(Object object) {
        if (object == secP224R1FieldElement2) {
            return true;
        }
        if (!(object instanceof SecP224R1FieldElement)) {
            return false;
        }
        SecP224R1FieldElement secP224R1FieldElement = secP224R1FieldElement2;
        SecP224R1FieldElement secP224R1FieldElement2 = (SecP224R1FieldElement)object;
        return Nat224.eq(secP224R1FieldElement.x, secP224R1FieldElement2.x);
    }

    public int hashCode() {
        return Q.hashCode() ^ Arrays.hashCode(this.x, 0, 7);
    }
}

