/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256R1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP256R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP256R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP256R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP256R1_AFFINE_ZS;
    public SecP256R1Point infinity;

    public SecP256R1Curve() {
        SecP256R1Curve secP256R1Curve = this;
        super(q);
        secP256R1Curve.infinity = new SecP256R1Point(this, null, null);
        secP256R1Curve.a = secP256R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFF00000001000000000000000000000000FFFFFFFFFFFFFFFFFFFFFFFC")));
        secP256R1Curve.b = secP256R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("5AC635D8AA3A93E7B3EBBD55769886BC651D06B0CC53B0F63BCE3C3E27D2604B")));
        secP256R1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFF00000000FFFFFFFFFFFFFFFFBCE6FAADA7179E84F3B9CAC2FC632551"));
        secP256R1Curve.cofactor = BigInteger.valueOf(1L);
        secP256R1Curve.coord = 2;
    }

    static {
        SecP256R1FieldElement secP256R1FieldElement;
        q = SecP256R1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP256R1FieldElement secP256R1FieldElement2 = secP256R1FieldElement;
        secP256R1FieldElement = new SecP256R1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP256R1FieldElement2;
        SECP256R1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP256R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP256R1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP256R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP256R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final int[] nArray = new int[n4 * 8 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat256.copy(((SecP256R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat256.copy(((SecP256R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 8);
            n5 += 8;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP256R1FieldElement secP256R1FieldElement;
                SecP256R1FieldElement secP256R1FieldElement2 = secP256R1FieldElement;
                secP256R1FieldElement = new SecP256R1FieldElement(nArray2);
                return secP256R1FieldElement2.SecP256R1Curve.this.createRawPoint(new SecP256R1FieldElement(nArray3), secP256R1FieldElement2, SECP256R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 8; ++i4) {
                        int[] nArray3 = nArray;
                        nArray4[i4] = nArray4[i4] ^ nArray[n42 + i4] & n5;
                        nArray2[i4] = nArray2[i4] ^ nArray3[n42 + 8 + i4] & n5;
                    }
                    n42 += 16;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                int[] nArray4 = Nat256.create();
                int[] nArray2 = Nat256.create();
                int n42 = n3 * 8 * 2;
                for (int i3 = 0; i3 < 8; ++i3) {
                    int[] nArray3 = nArray;
                    nArray4[i3] = nArray3[n42 + i3];
                    nArray2[i3] = nArray[n42 + 8 + i3];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SecP256R1Field.random(secureRandom, nArray);
        return new SecP256R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat256.create();
        Object object = nArray;
        SecP256R1Field.randomMult(secureRandom, nArray);
        return new SecP256R1FieldElement((int[])object);
    }
}

