/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat256;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP256R1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{-1, -1, -1, 0, 0, 0, 1, -1};
    private static final int[] PExt = new int[]{1, 0, 0, -2, -1, -1, -2, 1, -2, 1, -2, 1, 1, -2, 2, -2};
    private static final int P7 = -1;
    private static final int PExt15s1 = Integer.MAX_VALUE;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.add(nArray, nArray2, nArray3) != 0 || nArray3[7] == -1 && Nat256.gte(nArray3, P)) {
            SecP256R1Field.addPInvTo(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.add(16, nArray, nArray2, nArray3) != 0 || nArray3[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, nArray3, nArray = PExt)) {
            Nat.subFrom(16, PExt, nArray3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(8, nArray, nArray2) != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            SecP256R1Field.addPInvTo(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray = Nat256.fromBigInteger((BigInteger)object);
        object = nArray;
        if (nArray[7] == -1) {
            int[] nArray2 = P;
            if (Nat256.gte((int[])object, P)) {
                Nat256.subFrom(nArray2, (int[])object);
            }
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(8, nArray, 0, nArray2);
        } else {
            int n3 = Nat256.add(nArray, P, nArray2);
            Nat.shiftDownBit(8, nArray2, n3);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 8; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat256.createExt();
        Nat256.mul(nArray, nArray2, nArray4);
        SecP256R1Field.reduce(nArray4, nArray3);
    }

    public static void multiplyAddToExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.mulAddTo(nArray, nArray2, nArray3) != 0 || nArray3[15] >>> 1 >= Integer.MAX_VALUE && Nat.gte(16, nArray3, nArray = PExt)) {
            Nat.subFrom(16, PExt, nArray3);
        }
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP256R1Field.isZero(nArray) != 0) {
            Nat256.sub(P, P, nArray2);
        } else {
            Nat256.sub(P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[32];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 8);
        } while (Nat.lessThan(8, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP256R1Field.random(secureRandom, nArray);
        } while (SecP256R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l3 = (long)nArray[8] & 0xFFFFFFFFL;
        long l4 = (long)nArray[9] & 0xFFFFFFFFL;
        long l5 = (long)nArray[10] & 0xFFFFFFFFL;
        long l6 = (long)nArray[11] & 0xFFFFFFFFL;
        long l7 = (long)nArray[12] & 0xFFFFFFFFL;
        long l8 = (long)nArray[13] & 0xFFFFFFFFL;
        long l9 = l8;
        long l10 = l7;
        long l11 = l9;
        long l12 = l6;
        long l13 = l7;
        long l14 = l5;
        long l15 = l6;
        long l16 = l4;
        long l17 = l5;
        long l18 = l3;
        l3 = (long)nArray[14] & 0xFFFFFFFFL;
        l5 = (long)nArray[15] & 0xFFFFFFFFL;
        l6 = l18 - 6L;
        l4 = l6 + l4;
        l7 = l16 + l17;
        l9 = l14 + l15 - l5;
        long l19 = l12 + l13;
        long l20 = l10 + l11;
        long l21 = l8 + l3;
        long l22 = l4;
        l4 = l3 + l5;
        long l23 = l21 - l22;
        long l24 = ((long)nArray[0] & 0xFFFFFFFFL) - l19 - l23 + 0L;
        nArray2[0] = (int)l24;
        l24 >>= 32;
        l24 = ((long)nArray[1] & 0xFFFFFFFFL) + l7 - l20 - l4 + l24;
        nArray2[1] = (int)l24;
        l24 >>= 32;
        l24 = ((long)nArray[2] & 0xFFFFFFFFL) + l9 - l21 + l24;
        nArray2[2] = (int)l24;
        l19 = ((long)nArray[3] & 0xFFFFFFFFL) + (l19 << 1) + l23 - l4 + (l24 >>= 32);
        nArray2[3] = (int)l19;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + (l20 << 1) + l3 - l7 + (l19 >>= 32);
        nArray2[4] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[5] & 0xFFFFFFFFL) + (l21 << 1) - l9 + l3;
        nArray2[5] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + (l4 << 1) + l23 + l3;
        nArray2[6] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[7] & 0xFFFFFFFFL) + (l5 << 1) + l6 - l9 - l20 + l3;
        nArray2[7] = (int)l3;
        SecP256R1Field.reduce32((int)((l3 >> 32) + 6L), nArray2);
    }

    public static void reduce32(int n3, int[] nArray) {
        long l3 = 0L;
        if (n3 != 0) {
            long l4 = (long)n3 & 0xFFFFFFFFL;
            l3 = ((long)nArray[0] & 0xFFFFFFFFL) + l4 + l3;
            nArray[0] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
                l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
                nArray[2] = (int)l3;
                l3 >>= 32;
            }
            l3 = ((long)nArray[3] & 0xFFFFFFFFL) - l4 + l3;
            nArray[3] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                nArray[4] = (int)(l3 += (long)nArray[4] & 0xFFFFFFFFL);
                l3 = (l3 >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
                nArray[5] = (int)l3;
                l3 >>= 32;
            }
            l3 = ((long)nArray[6] & 0xFFFFFFFFL) - l4 + l3;
            nArray[6] = (int)l3;
            l3 >>= 32;
            l3 = ((long)nArray[7] & 0xFFFFFFFFL) + l4 + l3;
            nArray[7] = (int)l3;
            l3 >>= 32;
        }
        if (l3 != 0L || nArray[7] == -1 && Nat256.gte(nArray, P)) {
            SecP256R1Field.addPInvTo(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat256.createExt();
        Nat256.square(nArray, nArray3);
        SecP256R1Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            Nat256.square(nArray2, nArray3);
            SecP256R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat256.sub(nArray, nArray2, nArray3) != 0) {
            SecP256R1Field.subPInvFrom(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(16, nArray, nArray2, nArray3) != 0) {
            Nat.addTo(16, PExt, nArray3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(8, nArray, 0, nArray2) != 0 || nArray2[7] == -1 && Nat256.gte(nArray2, P)) {
            SecP256R1Field.addPInvTo(nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l3;
            l3 >>= 32;
        }
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) - 1L + l3;
        nArray[3] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[4] = (int)(l3 += (long)nArray[4] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
            nArray[5] = (int)l3;
            l3 >>= 32;
        }
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) - 1L + l3;
        nArray[6] = (int)l3;
        nArray[7] = (int)(((long)nArray[7] & 0xFFFFFFFFL) + 1L + (l3 >>= 32));
    }

    private static void subPInvFrom(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[1] = (int)(l3 += (long)nArray[1] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[2] & 0xFFFFFFFFL);
            nArray[2] = (int)l3;
            l3 >>= 32;
        }
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + 1L + l3;
        nArray[3] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[4] = (int)(l3 += (long)nArray[4] & 0xFFFFFFFFL);
            l3 = (l3 >> 32) + ((long)nArray[5] & 0xFFFFFFFFL);
            nArray[5] = (int)l3;
            l3 >>= 32;
        }
        l3 = ((long)nArray[6] & 0xFFFFFFFFL) + 1L + l3;
        nArray[6] = (int)l3;
        nArray[7] = (int)(((long)nArray[7] & 0xFFFFFFFFL) - 1L + (l3 >>= 32));
    }
}

