/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.AbstractECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECConstants;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECCurve;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECFieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECLookupTable;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.ECPoint;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP384R1Field;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP384R1FieldElement;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec.SecP384R1Point;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.encoders.Hex;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP384R1Curve
extends ECCurve.AbstractFp {
    public static final BigInteger q;
    private static final int SECP384R1_DEFAULT_COORDS = 2;
    private static final ECFieldElement[] SECP384R1_AFFINE_ZS;
    public SecP384R1Point infinity;

    public SecP384R1Curve() {
        SecP384R1Curve secP384R1Curve = this;
        super(q);
        secP384R1Curve.infinity = new SecP384R1Point(this, null, null);
        secP384R1Curve.a = secP384R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFEFFFFFFFF0000000000000000FFFFFFFC")));
        secP384R1Curve.b = secP384R1Curve.fromBigInteger(new BigInteger(1, Hex.decodeStrict("B3312FA7E23EE7E4988E056BE3F82D19181D9C6EFE8141120314088F5013875AC656398D8A2ED19D2A85C8EDD3EC2AEF")));
        secP384R1Curve.order = new BigInteger(1, Hex.decodeStrict("FFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFC7634D81F4372DDF581A0DB248B0A77AECEC196ACCC52973"));
        secP384R1Curve.cofactor = BigInteger.valueOf(1L);
        secP384R1Curve.coord = 2;
    }

    static {
        SecP384R1FieldElement secP384R1FieldElement;
        q = SecP384R1FieldElement.Q;
        ECFieldElement[] eCFieldElementArray = new ECFieldElement[1];
        SecP384R1FieldElement secP384R1FieldElement2 = secP384R1FieldElement;
        secP384R1FieldElement = new SecP384R1FieldElement(ECConstants.ONE);
        eCFieldElementArray[0] = secP384R1FieldElement2;
        SECP384R1_AFFINE_ZS = eCFieldElementArray;
    }

    @Override
    public ECCurve cloneCurve() {
        return new SecP384R1Curve();
    }

    @Override
    public boolean supportsCoordinateSystem(int n3) {
        return n3 == 2;
    }

    public BigInteger getQ() {
        return q;
    }

    @Override
    public int getFieldSize() {
        return q.bitLength();
    }

    @Override
    public ECFieldElement fromBigInteger(BigInteger bigInteger) {
        return new SecP384R1FieldElement(bigInteger);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        return new SecP384R1Point(this, eCFieldElement, eCFieldElement2);
    }

    @Override
    public ECPoint createRawPoint(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, ECFieldElement[] eCFieldElementArray) {
        return new SecP384R1Point(this, eCFieldElement, eCFieldElement2, eCFieldElementArray);
    }

    @Override
    public ECPoint getInfinity() {
        return this.infinity;
    }

    @Override
    public ECLookupTable createCacheSafeLookupTable(ECPoint[] eCPointArray, int n3, final int n4) {
        final int[] nArray = new int[n4 * 12 * 2];
        int n5 = 0;
        for (int i3 = 0; i3 < n4; ++i3) {
            ECPoint eCPoint = eCPointArray[n3 + i3];
            Nat.copy(12, ((SecP384R1FieldElement)eCPoint.getRawXCoord()).x, 0, nArray, n5);
            Nat.copy(12, ((SecP384R1FieldElement)eCPoint.getRawYCoord()).x, 0, nArray, n5 += 12);
            n5 += 12;
        }
        return new AbstractECLookupTable(){

            private ECPoint createPoint(int[] nArray3, int[] nArray2) {
                SecP384R1FieldElement secP384R1FieldElement;
                SecP384R1FieldElement secP384R1FieldElement2 = secP384R1FieldElement;
                secP384R1FieldElement = new SecP384R1FieldElement(nArray2);
                return secP384R1FieldElement2.SecP384R1Curve.this.createRawPoint(new SecP384R1FieldElement(nArray3), secP384R1FieldElement2, SECP384R1_AFFINE_ZS);
            }

            @Override
            public int getSize() {
                return n4;
            }

            @Override
            public ECPoint lookup(int n3) {
                int[] nArray4 = Nat.create(12);
                int[] nArray2 = Nat.create(12);
                int n42 = 0;
                for (int i3 = 0; i3 < n4; ++i3) {
                    int n5 = (i3 ^ n3) - 1 >> 31;
                    for (int i4 = 0; i4 < 12; ++i4) {
                        int[] nArray3 = nArray;
                        nArray4[i4] = nArray4[i4] ^ nArray[n42 + i4] & n5;
                        nArray2[i4] = nArray2[i4] ^ nArray3[n42 + 12 + i4] & n5;
                    }
                    n42 += 24;
                }
                return this.createPoint(nArray4, nArray2);
            }

            @Override
            public ECPoint lookupVar(int n3) {
                int[] nArray4 = Nat.create(12);
                int[] nArray2 = Nat.create(12);
                int n42 = n3 * 12 * 2;
                for (int i3 = 0; i3 < 12; ++i3) {
                    int[] nArray3 = nArray;
                    nArray4[i3] = nArray3[n42 + i3];
                    nArray2[i3] = nArray[n42 + 12 + i3];
                }
                return this.createPoint(nArray4, nArray2);
            }
        };
    }

    @Override
    public ECFieldElement randomFieldElement(SecureRandom secureRandom) {
        int[] nArray = Nat.create(12);
        Object object = nArray;
        SecP384R1Field.random(secureRandom, nArray);
        return new SecP384R1FieldElement((int[])object);
    }

    @Override
    public ECFieldElement randomFieldElementMult(SecureRandom secureRandom) {
        int[] nArray = Nat.create(12);
        Object object = nArray;
        SecP384R1Field.randomMult(secureRandom, nArray);
        return new SecP384R1FieldElement((int[])object);
    }
}

