/*
 * Decompiled with CFR 0.152.
 */
package com.fis.ekyc.nfc.build_in.bouncycastle.math.ec.custom.sec;

import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Mod;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat;
import com.fis.ekyc.nfc.build_in.bouncycastle.math.raw.Nat384;
import com.fis.ekyc.nfc.build_in.bouncycastle.util.Pack;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SecP384R1Field {
    private static final long M = 0xFFFFFFFFL;
    public static final int[] P = new int[]{-1, 0, 0, -1, -2, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] PExt = new int[]{1, -2, 0, 2, 0, -2, 0, 2, 1, 0, 0, 0, -2, 1, 0, -2, -3, -1, -1, -1, -1, -1, -1, -1};
    private static final int[] PExtInv = new int[]{-1, 1, -1, -3, -1, 1, -1, -3, -2, -1, -1, -1, 1, -2, -1, 1, 2};
    private static final int P11 = -1;
    private static final int PExt23 = -1;

    public static void add(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.add(12, nArray, nArray2, nArray3) != 0 || nArray3[11] == -1 && Nat.gte(12, nArray3, nArray = P)) {
            SecP384R1Field.addPInvTo(nArray3);
        }
    }

    public static void addExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if ((Nat.add(24, nArray, nArray2, nArray3) != 0 || nArray3[23] == -1 && Nat.gte(24, nArray3, nArray = PExt)) && Nat.addTo(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.incAt(24, nArray3, n3);
        }
    }

    public static void addOne(int[] nArray, int[] nArray2) {
        if (Nat.inc(12, nArray, nArray2) != 0 || nArray2[11] == -1 && Nat.gte(12, nArray2, nArray = P)) {
            SecP384R1Field.addPInvTo(nArray2);
        }
    }

    public static int[] fromBigInteger(BigInteger object) {
        int[] nArray;
        int[] nArray2 = Nat.fromBigInteger(384, (BigInteger)object);
        object = nArray2;
        if (nArray2[11] == -1 && Nat.gte(12, (int[])object, nArray = P)) {
            Nat.subFrom(12, nArray, (int[])object);
        }
        return object;
    }

    public static void half(int[] nArray, int[] nArray2) {
        if ((nArray[0] & 1) == 0) {
            Nat.shiftDownBit(12, nArray, 0, nArray2);
        } else {
            int[] nArray3 = P;
            int n3 = Nat.add(12, nArray, nArray3, nArray2);
            Nat.shiftDownBit(12, nArray2, n3);
        }
    }

    public static void inv(int[] nArray, int[] nArray2) {
        Mod.checkedModOddInverse(P, nArray, nArray2);
    }

    public static int isZero(int[] nArray) {
        int n3 = 0;
        for (int i3 = 0; i3 < 12; ++i3) {
            n3 |= nArray[i3];
        }
        return (n3 >>> 1 | n3 & 1) - 1 >> 31;
    }

    public static void multiply(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = Nat.create(24);
        Nat384.mul(nArray, nArray2, nArray4);
        SecP384R1Field.reduce(nArray4, nArray3);
    }

    public static void negate(int[] nArray, int[] nArray2) {
        if (SecP384R1Field.isZero(nArray) != 0) {
            int[] nArray3 = P;
            Nat.sub(12, nArray3, nArray3, nArray2);
        } else {
            Nat.sub(12, P, nArray, nArray2);
        }
    }

    public static void random(SecureRandom secureRandom, int[] nArray) {
        int[] nArray2;
        byte[] byArray = new byte[48];
        do {
            secureRandom.nextBytes(byArray);
            Pack.littleEndianToInt(byArray, 0, nArray, 0, 12);
        } while (Nat.lessThan(12, nArray, nArray2 = P) == 0);
    }

    public static void randomMult(SecureRandom secureRandom, int[] nArray) {
        do {
            SecP384R1Field.random(secureRandom, nArray);
        } while (SecP384R1Field.isZero(nArray) != 0);
    }

    public static void reduce(int[] nArray, int[] nArray2) {
        long l3 = (long)nArray[16] & 0xFFFFFFFFL;
        long l4 = (long)nArray[17] & 0xFFFFFFFFL;
        long l5 = (long)nArray[18] & 0xFFFFFFFFL;
        long l6 = (long)nArray[19] & 0xFFFFFFFFL;
        long l7 = (long)nArray[20] & 0xFFFFFFFFL;
        long l8 = (long)nArray[21] & 0xFFFFFFFFL;
        long l9 = (long)nArray[22] & 0xFFFFFFFFL;
        long l10 = (long)nArray[23] & 0xFFFFFFFFL;
        long l11 = ((long)nArray[12] & 0xFFFFFFFFL) + l7 - 1L;
        long l12 = l9;
        long l13 = ((long)nArray[13] & 0xFFFFFFFFL) + l9;
        l9 = ((long)nArray[14] & 0xFFFFFFFFL) + l9 + l10;
        long l14 = ((long)nArray[15] & 0xFFFFFFFFL) + l10;
        long l15 = l4 + l8;
        long l16 = l8 - l10;
        long l17 = l12 - l10;
        long l18 = l11 + l16;
        long l19 = ((long)nArray[0] & 0xFFFFFFFFL) + l18 + 0L;
        nArray2[0] = (int)l19;
        l10 = ((long)nArray[1] & 0xFFFFFFFFL) + l10 - l11 + l13 + (l19 >>= 32);
        nArray2[1] = (int)l10;
        l10 >>= 32;
        l10 = ((long)nArray[2] & 0xFFFFFFFFL) - l8 - l13 + l9 + l10;
        nArray2[2] = (int)l10;
        l10 >>= 32;
        l10 = ((long)nArray[3] & 0xFFFFFFFFL) - l9 + l14 + l18 + l10;
        nArray2[3] = (int)l10;
        l8 = ((long)nArray[4] & 0xFFFFFFFFL) + l3 + l8 + l13 - l14 + l18 + (l10 >>= 32);
        nArray2[4] = (int)l8;
        l8 >>= 32;
        l8 = ((long)nArray[5] & 0xFFFFFFFFL) - l3 + l13 + l9 + l15 + l8;
        nArray2[5] = (int)l8;
        l8 >>= 32;
        l8 = ((long)nArray[6] & 0xFFFFFFFFL) + l5 - l4 + l9 + l14 + l8;
        nArray2[6] = (int)l8;
        l8 >>= 32;
        l8 = ((long)nArray[7] & 0xFFFFFFFFL) + l3 + l6 - l5 + l14 + l8;
        nArray2[7] = (int)l8;
        l3 = ((long)nArray[8] & 0xFFFFFFFFL) + l3 + l4 + l7 - l6 + (l8 >>= 32);
        nArray2[8] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[9] & 0xFFFFFFFFL) + l5 - l7 + l15 + l3;
        nArray2[9] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[10] & 0xFFFFFFFFL) + l5 + l6 - l16 + l17 + l3;
        nArray2[10] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[11] & 0xFFFFFFFFL) + l6 + l7 - l17 + l3;
        nArray2[11] = (int)l3;
        SecP384R1Field.reduce32((int)((l3 >> 32) + 1L), nArray2);
    }

    public static void reduce32(int n3, int[] nArray) {
        int[] nArray2;
        long l3 = 0L;
        if (n3 != 0) {
            long l4 = (long)n3 & 0xFFFFFFFFL;
            l3 = ((long)nArray[0] & 0xFFFFFFFFL) + l4 + l3;
            nArray[0] = (int)l3;
            l3 >>= 32;
            l3 = ((long)nArray[1] & 0xFFFFFFFFL) - l4 + l3;
            nArray[1] = (int)l3;
            if ((l3 >>= 32) != 0L) {
                nArray[2] = (int)(l3 += (long)nArray[2] & 0xFFFFFFFFL);
                l3 >>= 32;
            }
            l3 = ((long)nArray[3] & 0xFFFFFFFFL) + l4 + l3;
            nArray[3] = (int)l3;
            l3 >>= 32;
            l3 = ((long)nArray[4] & 0xFFFFFFFFL) + l4 + l3;
            nArray[4] = (int)l3;
            l3 >>= 32;
        }
        if (l3 != 0L && Nat.incAt(12, nArray, 5) != 0 || nArray[11] == -1 && Nat.gte(12, nArray, nArray2 = P)) {
            SecP384R1Field.addPInvTo(nArray);
        }
    }

    public static void square(int[] nArray, int[] nArray2) {
        int[] nArray3 = Nat.create(24);
        Nat384.square(nArray, nArray3);
        SecP384R1Field.reduce(nArray3, nArray2);
    }

    public static void squareN(int[] nArray, int n3, int[] nArray2) {
        int[] nArray3 = Nat.create(24);
        Nat384.square(nArray, nArray3);
        SecP384R1Field.reduce(nArray3, nArray2);
        while ((n3 += -1) > 0) {
            Nat384.square(nArray2, nArray3);
            SecP384R1Field.reduce(nArray3, nArray2);
        }
    }

    public static void subtract(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(12, nArray, nArray2, nArray3) != 0) {
            SecP384R1Field.subPInvFrom(nArray3);
        }
    }

    public static void subtractExt(int[] nArray, int[] nArray2, int[] nArray3) {
        if (Nat.sub(24, nArray, nArray2, nArray3) != 0 && Nat.subFrom(PExtInv.length, nArray = PExtInv, nArray3) != 0) {
            int n3 = nArray.length;
            Nat.decAt(24, nArray3, n3);
        }
    }

    public static void twice(int[] nArray, int[] nArray2) {
        if (Nat.shiftUpBit(12, nArray, 0, nArray2) != 0 || nArray2[11] == -1 && Nat.gte(12, nArray2, nArray = P)) {
            SecP384R1Field.addPInvTo(nArray2);
        }
    }

    private static void addPInvTo(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) + 1L;
        nArray[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) - 1L + l3;
        nArray[1] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[2] = (int)(l3 += (long)nArray[2] & 0xFFFFFFFFL);
            l3 >>= 32;
        }
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) + 1L + l3;
        nArray[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) + 1L + l3;
        nArray[4] = (int)l3;
        if (l3 >> 32 != 0L) {
            Nat.incAt(12, nArray, 5);
        }
    }

    private static void subPInvFrom(int[] nArray) {
        long l3 = ((long)nArray[0] & 0xFFFFFFFFL) - 1L;
        nArray[0] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[1] & 0xFFFFFFFFL) + 1L + l3;
        nArray[1] = (int)l3;
        if ((l3 >>= 32) != 0L) {
            nArray[2] = (int)(l3 += (long)nArray[2] & 0xFFFFFFFFL);
            l3 >>= 32;
        }
        l3 = ((long)nArray[3] & 0xFFFFFFFFL) - 1L + l3;
        nArray[3] = (int)l3;
        l3 >>= 32;
        l3 = ((long)nArray[4] & 0xFFFFFFFFL) - 1L + l3;
        nArray[4] = (int)l3;
        if (l3 >> 32 != 0L) {
            Nat.decAt(12, nArray, 5);
        }
    }
}

